#include "relais.h"
#include "main.h"


#define PULS_TIME   50



unsigned int onTimeCounterSET;   //Set Coil
unsigned int onTimeCounterRESET; //Reset Coil
unsigned int relaisState;


void RELAIS_Exec(void)
{
  
  if (onTimeCounterSET > 0)
  {
    onTimeCounterSET--;
    if (onTimeCounterSET == 0)
    {
      HAL_GPIO_WritePin(GPIO_OUTPUT_RELAIS_SET_GPIO_Port, GPIO_OUTPUT_RELAIS_SET_Pin, GPIO_PIN_RESET);
    }
  }



if (onTimeCounterRESET > 0)
  {
    onTimeCounterRESET--;
    if (onTimeCounterRESET == 0)
    {
      HAL_GPIO_WritePin(GPIO_OUTPUT_RELAIS_RESET_GPIO_Port, GPIO_OUTPUT_RELAIS_RESET_Pin, GPIO_PIN_RESET);
    }
  }

}

void RELAIS_SetPuls(void)
{

  //Sicherstellen das nicht noch die Reset Spule aktiv geschaltet ist
  HAL_GPIO_WritePin(GPIO_OUTPUT_RELAIS_RESET_GPIO_Port, GPIO_OUTPUT_RELAIS_RESET_Pin, GPIO_PIN_RESET);

  //Puls starten
  HAL_GPIO_WritePin(GPIO_OUTPUT_RELAIS_SET_GPIO_Port, GPIO_OUTPUT_RELAIS_SET_Pin, GPIO_PIN_SET);
  onTimeCounterSET = PULS_TIME;
  relaisState = 1;

} 

void RELAIS_ResetPuls(void)
{

  //Sicherstellen das nicht noch die Set Spule aktiv geschaltet ist
  HAL_GPIO_WritePin(GPIO_OUTPUT_RELAIS_SET_GPIO_Port, GPIO_OUTPUT_RELAIS_SET_Pin, GPIO_PIN_RESET);

  //Puls starten
  HAL_GPIO_WritePin(GPIO_OUTPUT_RELAIS_RESET_GPIO_Port, GPIO_OUTPUT_RELAIS_RESET_Pin, GPIO_PIN_SET);
  onTimeCounterRESET = PULS_TIME;
  relaisState = 0;

} 


unsigned int RELAIS_GetState(void)
{
  return relaisState;
}