/******************************************************************************
*
* @file    chipTemperature.c
* @author  ECS, Joseph Zimmer
* @version V1.0.0
* @date    24-04-2019
* @brief       
*
******************************************************************************/

//	--- INCLUDES -----------------------------------------------------------------
#include <stdio.h>
#include "sysdata.h"
#include "shunt_voltage.h"
#include "adc.h"
//	--- EXTERNE VARIABLEN -------------------------------------------------------- 

//	--- LOKALE DEFINES - bitte hier dokumentieren --------------------------------
#define ADC_RESOLUTION						  32768 //65536/2 da im differential mode
#define ADC_OFFSET							  32768

#if defined SYSTEM_VOLTAGE_12V
  #define SHUNT_VOLTAGE_DIVIDER       6.0
#elif defined SYSTEM_VOLTAGE_24V
  #define SHUNT_VOLTAGE_DIVIDER       11.0
#elif defined SYSTEM_VOLTAGE_48V
  #define SHUNT_VOLTAGE_DIVIDER       21.0
#else
  #error "System voltage not defined"
#endif



//	--- LOKALE TYPE DEFS - bitte hier dokumentieren-------------------------------

//	--- DEFINITIONEN GLOBALER VARIABLEN - Bitte in Header dokumentieren ----------

//	--- LOKALE VARIABLEN - bitte hier dokumentieren ------------------------------

//	--- LOKALE FUNKTIONS PROTOTYPEN ---------------------------------------------- 

//	--- LOKALE FUNKTIONEN - bitte hier dokumentieren -----------------------------

/*
* @brief
* @param	kein
* @retval	kein
*/

//	--- GLOBALE FUNKTIONEN - bitte in Header dokumentieren------------------------



//#define SHUNT_FILTER            128


void SHUNT_VOLTAGE_Exec(int32_t newval)
{
   sys_data.s.values.shuntVoltage =  ((newval-ADC_OFFSET) * VREF * SHUNT_VOLTAGE_DIVIDER ) / ADC_RESOLUTION;

}



/*************************** End of file ****************************/