/******************************************************************************
*
* @file    fast_current.c
* @author  ECS, Falko Jahn
* @version V1.0.0
* @date    2022-01-16
* @brief       
*
******************************************************************************/

//	--- INCLUDES -----------------------------------------------------------------
#include "fast_current.h"
#include "main.h"
#include "sysdata.h"

//	--- EXTERNE VARIABLEN -------------------------------------------------------- 

//	--- LOKALE DEFINES - bitte hier dokumentieren --------------------------------




//	--- LOKALE TYPE DEFS - bitte hier dokumentieren-------------------------------

//	--- DEFINITIONEN GLOBALER VARIABLEN - Bitte in Header dokumentieren ----------

//	--- LOKALE VARIABLEN - bitte hier dokumentieren ------------------------------

//	--- LOKALE FUNKTIONS PROTOTYPEN ---------------------------------------------- 

//	--- LOKALE FUNKTIONEN - bitte hier dokumentieren -----------------------------

//	--- GLOBALE FUNKTIONEN - bitte in Header dokumentieren------------------------
void CurrentOffsetCal(uint32_t newVal)
{
  sys_data.s.parameter.batteryCurrentOffsetFast = newVal-FAST_CURRENT_ADC_OFFSET;
}

void CurrentGainCal(uint32_t newVal)
{
  double correction;
  double valWithoutGainCorrection;

  valWithoutGainCorrection = ((int32_t) newVal - FAST_CURRENT_ADC_OFFSET - sys_data.s.parameter.batteryCurrentOffsetFast) * VREF ;
  valWithoutGainCorrection = valWithoutGainCorrection / FAST_CURRENT_ADC_RESOLUTION;
  valWithoutGainCorrection = valWithoutGainCorrection / FAST_CURRENT_I_SENSE_GAIN ;
  valWithoutGainCorrection = valWithoutGainCorrection / FAST_CURRENT_SHUNT_RESISTOR ;

  correction = (double)  sys_data.s.parameter.batteryCurrentGainRefCurrent / valWithoutGainCorrection;
  sys_data.s.parameter.batteryCurrentGainCorrectionFaktorFast = correction * 1000000;

}
void FAST_CURRENT_Exec(uint32_t newVal )
{
 
  //Umrechung auf Strom
  double temp_current;
  temp_current = ((int32_t) newVal - FAST_CURRENT_ADC_OFFSET - sys_data.s.parameter.batteryCurrentOffsetFast) * VREF ;
  temp_current = temp_current / FAST_CURRENT_ADC_RESOLUTION;
  temp_current = temp_current / FAST_CURRENT_I_SENSE_GAIN ;
  temp_current = temp_current / FAST_CURRENT_SHUNT_RESISTOR ;
  sys_data.s.values.fast_current = temp_current * (sys_data.s.parameter.batteryCurrentGainCorrectionFaktorFast / 1000000.0);
 
}

/*************************** End of file ****************************/