/******************************************************************************
*
* @file    fast_current.h
* @author  ECS, Falko Jahn
* @version V1.0.0
* @date    2022-01-16
* @brief       
*
******************************************************************************/
#ifndef __FAST_CURRENT_H
#define __FAST_CURRENT_H

//--- INCLUDEs -----------------------------------------------------------------
#include <stdint.h>
//--- GLOBALE TYPE DEFS --------------------------------------------------------       

//--- GLOBALE DEFINES ----------------------------------------------------------
#define FAST_CURRENT_I_SENSE_GAIN						  40.0
#define FAST_CURRENT_ADC_OFFSET							  32768
#define FAST_CURRENT_ADC_RESOLUTION						  32768 //65536/2 da im differential mode


  #if (DEVICETYPE == 500)
    #define FAST_CURRENT_SHUNT_RESISTOR	0.000125	
  #elif (DEVICETYPE == 250)
    #define FAST_CURRENT_SHUNT_RESISTOR	0.000250	
  #elif (DEVICETYPE == 125)
    #define FAST_CURRENT_SHUNT_RESISTOR	0.000500	
  #else
  #error No valid device type
  #endif
  		


//--- GLOBALE VARIABLEN PROTOTYPEN ---------------------------------------------

//--- GLOBALE FUNKTIONS PROTOTYPEN ---------------------------------------------
void FAST_CURRENT_Exec(uint32_t newVal );

#endif //