/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.h
  * @brief          : Header for main.c file.
  *                   This file contains the common defines of the application.
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2025 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32g4xx_hal.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

/* USER CODE END Includes */

/* Exported types ------------------------------------------------------------*/
/* USER CODE BEGIN ET */

/* USER CODE END ET */

/* Exported constants --------------------------------------------------------*/
/* USER CODE BEGIN EC */
#define VREF								  3000.0
/* USER CODE END EC */

/* Exported macro ------------------------------------------------------------*/
/* USER CODE BEGIN EM */

/* USER CODE END EM */

/* Exported functions prototypes ---------------------------------------------*/
void Error_Handler(void);

/* USER CODE BEGIN EFP */

/* USER CODE END EFP */

/* Private defines -----------------------------------------------------------*/
#define AUX_ENABLE_Pin GPIO_PIN_13
#define AUX_ENABLE_GPIO_Port GPIOC
#define ADC_START_CONV_Pin GPIO_PIN_0
#define ADC_START_CONV_GPIO_Port GPIOC
#define ADC_RESET_Pin GPIO_PIN_1
#define ADC_RESET_GPIO_Port GPIOC
#define LED_FUNC_Pin GPIO_PIN_4
#define LED_FUNC_GPIO_Port GPIOA
#define LED_ERROR_Pin GPIO_PIN_5
#define LED_ERROR_GPIO_Port GPIOA
#define ADC2_IN3_UBAT__Pin GPIO_PIN_6
#define ADC2_IN3_UBAT__GPIO_Port GPIOA
#define ADC3_IN12_MOSFET_TEMP_Pin GPIO_PIN_0
#define ADC3_IN12_MOSFET_TEMP_GPIO_Port GPIOB
#define ADC3_IN1_SHUNT_TEMP_Pin GPIO_PIN_1
#define ADC3_IN1_SHUNT_TEMP_GPIO_Port GPIOB
#define BUZZER_Pin GPIO_PIN_10
#define BUZZER_GPIO_Port GPIOB
#define DISCHARGE_ENABLE_Pin GPIO_PIN_11
#define DISCHARGE_ENABLE_GPIO_Port GPIOB
#define CHARGE_ENABLE_Pin GPIO_PIN_12
#define CHARGE_ENABLE_GPIO_Port GPIOB
#define ADC3_IN5_RESERVIERT_Pin GPIO_PIN_13
#define ADC3_IN5_RESERVIERT_GPIO_Port GPIOB
#define ADC4_IN4_U_SHUNT_SENSE__Pin GPIO_PIN_14
#define ADC4_IN4_U_SHUNT_SENSE__GPIO_Port GPIOB
#define ADC4_IN5_U_SHUNT_SENSE__Pin GPIO_PIN_15
#define ADC4_IN5_U_SHUNT_SENSE__GPIO_Port GPIOB
#define LVP_SENSE_Pin GPIO_PIN_8
#define LVP_SENSE_GPIO_Port GPIOA
#define OVP_SENSE_Pin GPIO_PIN_9
#define OVP_SENSE_GPIO_Port GPIOA
#define GPIO_INPUT_BTN_MODE_Pin GPIO_PIN_10
#define GPIO_INPUT_BTN_MODE_GPIO_Port GPIOA
#define ADC_DATA_READY_Pin GPIO_PIN_2
#define ADC_DATA_READY_GPIO_Port GPIOD
#define FAULT_Pin GPIO_PIN_7
#define FAULT_GPIO_Port GPIOB
#define COM_POWERPRO_RES_Pin GPIO_PIN_9
#define COM_POWERPRO_RES_GPIO_Port GPIOB

/* USER CODE BEGIN Private defines */
// mögliche Kommandos für das Command Register
#define COMMAND_STORE_CONFIG								1
#define COMMAND_FULL_RESTORE								2
#define COMMAND_FACTORY_RESTORE								3
#define COMMAND_RESTORE_LAST_SAVED_VALUES					4
#define COMMAND_RESTART										6
#define COMMAND_BATTERY_CURRENT_OFFSET_CAL					7
#define COMMAND_BATTERY_CURRENT_OFFSET_COMMONMODE_CAL		8
#define COMMAND_BATTERY_CURRENT_OFFSET_TEMP_CAL				9
#define COMMAND_BATTERY_CURRENT_GAIN_CAL					10
#define COMMAND_BATTERY_CURRENT_GAIN_TEMP_SHUNT_CAL			11
//#define COMMAND_BATTERY_CURRENT_GAIN_TEMP_CHIP_CAL		12
#define COMMAND_STORE_WITH_SERIAL_NUMBER					1234
#define COMMAND_SET_RDP_LEVEL0								1010
#define COMMAND_SET_RDP_LEVEL1								1011
#define COMMAND_SET_RDP_LEVEL1_AND_BOOTSEL					1012

enum SOC_CALC_MODE{
  SOC_CALC_MODE_AH_RATED,
  SOC_CALC_MODE_AH_AUTO,
  SOC_CALC_MODE_WH_RATED,
  SOC_CALC_MODE_WH_AUTO,
  SOC_CALC_MODE_WH_AUTO_TEMP,
};
/* USER CODE END Private defines */

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */
