/******************************************************************************
*
* @file    fast_current.c
* @author  ECS, Falko Jahn
* @version V1.0.0
* @date    2022-01-16
* @brief       
*
******************************************************************************/

//	--- INCLUDES -----------------------------------------------------------------
#include "fast_current.h"
#include "main.h"
#include "sysdata.h"

//	--- EXTERNE VARIABLEN -------------------------------------------------------- 

//	--- LOKALE DEFINES - bitte hier dokumentieren --------------------------------

#define I_SENSE_GAIN    40.0
#define ADC_OFFSET							  32768
#define ADC_RESOLUTION						  32768 //65536/2 da im differential mode


  #if (DEVICETYPE == 500)
    #define SHUNT_RESISTOR	0.000125	
  #elif (DEVICETYPE == 250)
    #define SHUNT_RESISTOR	0.000250	
  #elif (DEVICETYPE == 125)
    #define SHUNT_RESISTOR	0.000500	
  #else
  #error No valid device type
  #endif
  		




//	--- LOKALE TYPE DEFS - bitte hier dokumentieren-------------------------------

//	--- DEFINITIONEN GLOBALER VARIABLEN - Bitte in Header dokumentieren ----------

//	--- LOKALE VARIABLEN - bitte hier dokumentieren ------------------------------

//	--- LOKALE FUNKTIONS PROTOTYPEN ---------------------------------------------- 

//	--- LOKALE FUNKTIONEN - bitte hier dokumentieren -----------------------------

//	--- GLOBALE FUNKTIONEN - bitte in Header dokumentieren------------------------


void FAST_CURRENT_Exec(uint32_t newVal )
{
 
  //Umrechung auf Strom
  double temp_current;
  temp_current = ((int32_t) newVal - ADC_OFFSET) * VREF ;
  temp_current = temp_current / ADC_RESOLUTION;
  temp_current = temp_current / I_SENSE_GAIN ;
  temp_current = temp_current / SHUNT_RESISTOR ;
  sys_data.s.values.fast_current = temp_current * (sys_data.s.parameter.batteryCurrentGainCorrectionFaktor / 1000000.0);
 
}

/*************************** End of file ****************************/