/******************************************************************************
*
* @file    ads1260.h
* @author  ECS, Joseph Zimmer
* @version V1.0.0
* @date    25-04-2019
* @brief       
*
******************************************************************************/
#ifndef _ADS_1260_H
#define _ADS_1260_H

//--- INCLUDEs -----------------------------------------------------------------
#include "main.h"
#include "sysdata.h"
//--- GLOBALE TYPE DEFS --------------------------------------------------------       
typedef enum 
{
 ADC_STATE_INITIALIZE                 = 0, 
 ADC_STATE_CONVERSION_STOPPED         = 1,
 ADC_STATE_CONVERSION_RUNNING         = 2,
 ADC_STATE_READY_FOR_CONVERSION       = 3,
 ADC_STATE_SELF_OFFSET_CALIBRATION    = 4,
 ADC_STATE_SYSTEM_OFFSET_CALIBRATION  = 5,
 ADC_STATE_GAIN_CALIBRATION           = 6,
 ADC_STATE_ERROR                      = 7
}adc_state_enum_t;

typedef union
{
  uint32_t   w;
   int32_t  sw;
  uint16_t  hw[2];
   int16_t shw[2];
   uint8_t   s[4];
    int8_t  ss[4];
}convert_union_t;
//--- GLOBALE DEFINES ----------------------------------------------------------

//--- GLOBALE VARIABLEN PROTOTYPEN ---------------------------------------------
extern volatile uint32_t newCurrentValue;

//--- GLOBALE FUNKTIONS PROTOTYPEN ---------------------------------------------

/*
* @brief	
* @param	kein
* @retval	kein
*/
void ADS1260_init(void);

/*
* @brief	
* @param	kein
* @retval	kein
*/
void ADS1260_StartConversion(void);


/*
* @brief	
* @param	kein
* @retval	kein
*/
void ADS1260_ReadConversion(void);

/*
* @brief        set conversion state 
* @param	kein
* @retval	kein
*/
void ADS1260_ConversionFinished(void);



/*****************************************Softwarekalibrierung*************************************************/


/*
* @brief Gain Calibration
*        
* Diese Funktion dient zum kalibrieren der Verstärkung.
* Funktion sollte nach Offset Korrektur und Offset Commonmode Korrektur ausgeführt werden
* Für die Kalibrierung muss der Sensor in kalten Zustand gehalten werden, also zunächst Bypass zuschalten, Strom einstellen, warten bis Lasten stabil, dann bypass abschalten und unverzüglich kalibrierung starten
* @param	kein
* @retval	kein
*/
void ADS_1260_BatteryCurrentGainCalibrationStart(sys_data_t * data);


/*
* @brief Offset kalibrieren.
*        
* Nennspannung an Shunt 12V
* Messstrom abschalten, warten bis Sensor kalt und Mittelwertbildung stabil. Dann Starten
* @param	kein
* @retval	kein
*/
void ADS_1260_BatteryCurrentOffsetCalibrationStart(sys_data_t * data);


/*
* @brief Common Mode Error korrektur
*        
* Diese Funktion eliminiert den Common-Mode error.
* Die Spannung am Messwiderstand (also Batteriesspannung, wenn der Shunt in der positiven Leitung eingesetzt wird) ruft einen sogenannten Common Mode Fehler hervor.
* Die Busspannung wird zur Kaibrierung erhöht und damit der Fehler pro mV Busspannung berechnet
* @param	kein
* @retval	kein
*/
void ADS_1260_BatteryCurrentOffsetCommonModeErrorComepensationStart(sys_data_t * data);

/*
* @brief Calibrierung der Offset Temperaturdrift
*   
* Offset Kalibrierung und Commonmode Calibrierung muss bereits ausgeführt sein.     
* Diese Funktion bei erhöter Temperatur. Zum Beispiel 80°C ausführen
* Es darf kein Strom fließen.
* Berechnet Offset Drift mit Temperatur und speichert ein Kompensationswert
* @param	kein
* @retval	kein
*/
void ADS_1260_BatteryCurrentOffsetTemperatureErrorComepensationStart(void);

void ADS_1260_BatteryCurrentGainTemperatureCalibrationShuntStart(void);
/*
* @brief         
* @param	kein
* @retval	kein
*/
void ADS_1260_SetDigitalFilter(SPI_HandleTypeDef * hspi, uint8_t digitalFilter);
/*
* @brief         
* @param	kein
* @retval	kein
*/
void ADS_1260_SetDataRate(SPI_HandleTypeDef * hspi, uint8_t dataRate);

#endif // !_ADS_1260_H