/******************************************************************************
*
* @file    outputs.h
* @author  ECS, Falko Jahn
* @version V1.0.0
* @date    2020-05-26
* @brief   Schalten von LVP und OVP Ausgnge    
*
******************************************************************************/
#ifndef __OUTPUTS_H
#define __OUTPUTS_H

//--- INCLUDEs -----------------------------------------------------------------

//--- GLOBALE TYPE DEFS --------------------------------------------------------       

//--- GLOBALE DEFINES ----------------------------------------------------------
#define OUTPUTS_LVP_UNKNOWN                     -1
#define OUTPUTS_LVP_OK                          0
#define OUTPUTS_LVP_BATTERY_UNDERVOLTAGE        1
#define OUTPUTS_LVP_OVERCURRENT                 2
#define OUTPUTS_LVP_SHUNT_OVERTEMPERATURE       3
#define OUTPUTS_LVP_CHIP_OVERTEMPERATURE        4
#define OUTPUTS_LVP_SHUNT_UNDERTEMPERATURE      5
#define OUTPUTS_LVP_CHIP_UNDERTEMPERATURE       6

#define OUTPUTS_OVP_UNKNOWN                     -1
#define OUTPUTS_OVP_OK                          0
#define OUTPUTS_OVP_BATTERY_OVERVOLTAGE         1
#define OUTPUTS_OVP_OVERCURRENT                 2
#define OUTPUTS_OVP_SHUNT_OVERTEMPERATURE       3
#define OUTPUTS_OVP_CHIP_OVERTEMPERATURE        4
#define OUTPUTS_OVP_SHUNT_UNDERTEMPERATURE      5
#define OUTPUTS_OVP_CHIP_UNDERTEMPERATURE       6
//--- GLOBALE VARIABLEN PROTOTYPEN ---------------------------------------------

//--- GLOBALE FUNKTIONS PROTOTYPEN ---------------------------------------------

void OUTPUTS_Init(void);
/*
* @brief	
* @param	kein
* @retval	kein
*/
void OUTPUTS_CheckLVP(void);


/*
* @brief	
* @param	kein
* @retval	kein
*/
void OUTPUTS_CheckOVP(void);

#endif // __OUTPUTS_H