/******************************************************************************
*
* @file    battery_voltage.c
* @author  ECS, Falko Jahn
* @version V1.0.0
* @date    2020-05-01
* @brief
*
******************************************************************************/

//	--- INCLUDES -----------------------------------------------------------------
#include "battery_voltage.h"
#include "main.h"
#include "sysdata.h"

//	--- EXTERNE VARIABLEN --------------------------------------------------------

//	--- LOKALE DEFINES - bitte hier dokumentieren --------------------------------
#define BATTERY_VOLTAGE_FILTER  256


#define BATTERY_VOLTAGE_VOLTAGE_DIVIDER       6

//	--- LOKALE TYPE DEFS - bitte hier dokumentieren-------------------------------

//	--- DEFINITIONEN GLOBALER VARIABLEN - Bitte in Header dokumentieren ----------

//	--- LOKALE VARIABLEN - bitte hier dokumentieren ------------------------------

//	--- LOKALE FUNKTIONS PROTOTYPEN ----------------------------------------------

//	--- LOKALE FUNKTIONEN - bitte hier dokumentieren -----------------------------

//	--- GLOBALE FUNKTIONEN - bitte in Header dokumentieren------------------------


void BATTERY_VOLTAGE_Exec(uint32_t newvalP )
{
  static int measCounter;
  static unsigned long avgsumP = 0;
  uint32_t avgvalP;

  if (measCounter < INT32_MAX) measCounter++;


  // Filterlängen in 2er-Potenzen --> Compiler optimiert
  avgsumP -= avgsumP / BATTERY_VOLTAGE_FILTER;
  avgsumP += newvalP;
  avgvalP = avgsumP / BATTERY_VOLTAGE_FILTER;

  


  //Umrechung auf Eingangsspannung am Gerät mit Teiler
  sys_data.s.values.batteryVoltage = (avgvalP * (uint64_t)sys_data.s.values.realVdd * BATTERY_VOLTAGE_VOLTAGE_DIVIDER ) / 655360.0;

  


  //Max und Minwert
  if (measCounter > BATTERY_VOLTAGE_FILTER * 10)
  {
    if (sys_data.s.values.batteryVoltage > sys_data.s.values.batteryVoltageMax)
    {
      sys_data.s.values.batteryVoltageMax = sys_data.s.values.batteryVoltage;
    }
    if (sys_data.s.values.batteryVoltage < sys_data.s.values.batteryVoltageMin)
    {
      sys_data.s.values.batteryVoltageMin = sys_data.s.values.batteryVoltage;
    }
  }



  //Berechnung schnellen Wert ohne Glättung:
  //Umrechung auf Eingangsspannung am Gerät mit Teiler
  sys_data.s.values.fast_voltage = (newvalP * (uint64_t)sys_data.s.values.realVdd * BATTERY_VOLTAGE_VOLTAGE_DIVIDER ) / 655360.0;



}

/*************************** End of file ****************************/