#include "stm32g0xx_hal.h"
#include "stdbool.h"
#include "main.h"
#include "sysdata.h"

typedef enum startType_t
{
	FIRST_START_AFTER_ERASE = 0,												// Flash storage with calibration data will be written with the default values
	FIRST_START_AFTER_COMPARTIBLE_UPDATE,										// Calibration data will be preserved, additional configuration data also preserved
	FIRST_START_AFTER_INCOMPARTIBLE_UPDATE,										// Calibration data will be preserved, additional configuration data is set to default
	FIRST_START_ERROR															// Cannot read memory location, where FIRST_START_ID was saved
} startType_t;

HAL_StatusTypeDef EEPROM_readConfig(sys_data_t* data);
HAL_StatusTypeDef EEPROM_storeConfig(sys_data_t* data, uint8_t withSN);
HAL_StatusTypeDef EEPROM_fullRestore(sys_data_t* data);
HAL_StatusTypeDef EEPROM_factoryRestore(sys_data_t* data, int resetToDefault);
startType_t EEPROM_isFirstStart(uint8_t* fsID);