

#include "sysdata.h"
#include "esr.h"
#include <stdlib.h>
#include <stdio.h>


int32_t current_buffer[SAMPLE_ARRAY_SIZE];  
int32_t voltage_buffer[SAMPLE_ARRAY_SIZE];
int32_t current_buffer_fast[SAMPLE_ARRAY_SIZE];  
int32_t voltage_buffer_fast[SAMPLE_ARRAY_SIZE];


int16_t ESR_Exec(void)
{
 

  static int32_t last_refresh;
  int x;

  //Anzeige vor wieviel Sekunden zuletzt aktualisiert wurd.
  sys_data.s.values.esrCalcTime = sys_data.s.values.onTime - last_refresh;

  for (x=SAMPLE_ARRAY_SIZE-1; x>0; x--)
  {
    current_buffer[x] = current_buffer[x-1];
    voltage_buffer[x] = voltage_buffer[x-1];
  }

  // Neue Werte ins array aufnehmen
  current_buffer[0] = sys_data.s.values.batteryCurrent;
  voltage_buffer[0] = sys_data.s.values.batteryVoltage;


  //Suche Min und max werte im Array
  int32_t minU=INT32_MAX;
  int32_t maxU=0;
  int32_t minI=INT32_MAX;
  int32_t maxI=0;
  int32_t minIPos = -1;
  int32_t maxdIPos = -1;
  int32_t minUPos = -1;
  int32_t maxUPos = -1;

  //Suche min und max werte
  for (x=0; x < SAMPLE_ARRAY_SIZE; x++)
  {
     if (abs(current_buffer[x]) < minI)  { minI = abs(current_buffer[x]); minIPos  = x; }
     if (abs(current_buffer[x]) >= maxI) { maxI = abs(current_buffer[x]); maxdIPos = x; } 
     if (abs(voltage_buffer[x]) < minU)  { minU = abs(voltage_buffer[x]); minUPos = x; }
     if (abs(voltage_buffer[x]) > maxU)  { maxU = abs(voltage_buffer[x]); maxUPos = x; }
  }

  
  //Suche Zeitpunkt der größten Änderung in I

  //Delta berechnen
  int32_t dI = abs (maxI - minI);
  int32_t dU = abs (maxU - minU);

  //Minimale Belastung Prüfen ob es genügent Änderungen gab
  // 1/20 des Nennstroms
  // Bei 100Ah Batterie mit 0,5 Std discharge --> 50A --> /20 =2,5 A
  int32_t min_dI;
  min_dI = sys_data.s.parameter.cellCapacity /  sys_data.s.parameter.cellRatedDischargeTime; //Nennlaststrom  in mA
  min_dI = min_dI / 20 ;

  int32_t min_dU = 25;
  
  if( dI < min_dI)
  {
  
    return -1;
  }

  //printf("dI change!\r\n");

  if (dU < min_dU) {
    return -2;
  }

  //printf("dU change!\r\n");

 
  int32_t dIMax=-1;
  int32_t dIx=-1;;
  int32_t dIMaxPos=-1;
 
  for (x=0; x < (SAMPLE_ARRAY_SIZE-1); x++)
  {
    dIx = abs(current_buffer[x+1] - current_buffer[x]); 
    if (dIx > dIMax) { dIMax = dIx; dIMaxPos = x; } 
  }



  if (dIMaxPos == SAMPLE_ARRAY_SIZE / 2)
  {
    //ESR berechnen!
    sys_data.s.values.esr = ( (double)dU / (double) dI) * 1000;
    last_refresh = sys_data.s.values.onTime;


    for (x=0; x < SAMPLE_ARRAY_SIZE; x++)
    {
      sys_data.s.values.current_buffer[(SAMPLE_ARRAY_SIZE-1)-x] = current_buffer[x];
      sys_data.s.values.voltage_buffer[(SAMPLE_ARRAY_SIZE-1)-x] = voltage_buffer[x];
    }


    
  }
  return 0;
}


int16_t ESR_FAST_Exec(void)
{
 
    
  static int32_t last_refresh;
  int x;

  //Anzeige vor wieviel Sekunden zuletzt aktualisiert wurd.
  sys_data.s.values.esrCalcTime = sys_data.s.values.onTime - last_refresh;

  for (x=SAMPLE_ARRAY_SIZE-1; x>0; x--)
  {
    current_buffer_fast[x] = current_buffer_fast[x-1];
    voltage_buffer_fast[x] = voltage_buffer_fast[x-1];
  }

  // Neue Werte ins array aufnehmen
  current_buffer_fast[0] = sys_data.s.values.fast_current;
  voltage_buffer_fast[0] = sys_data.s.values.shuntVoltage;


  //Suche Min und max werte im Array
  int32_t minU=INT32_MAX;
  int32_t maxU=0;
  int32_t minI=INT32_MAX;
  int32_t maxI=0;
  int32_t minIPos = -1;
  int32_t maxdIPos = -1;
  int32_t minUPos = -1;
  int32_t maxUPos = -1;

  //Suche min und max werte
  for (x=0; x < SAMPLE_ARRAY_SIZE; x++)
  {
     if (abs(current_buffer_fast[x]) < minI)  { minI = abs(current_buffer_fast[x]); minIPos  = x; }
     if (abs(current_buffer_fast[x]) >= maxI) { maxI = abs(current_buffer_fast[x]); maxdIPos = x; }  
     if (abs(voltage_buffer_fast[x]) < minU)  { minU = abs(voltage_buffer_fast[x]); minUPos = x; }
     if (abs(voltage_buffer_fast[x]) > maxU)  { maxU = abs(voltage_buffer_fast[x]); maxUPos = x; }
  }

  
  //Suche Zeitpunkt der größten Änderung in I

  //Delta berechnen
  int32_t dI = abs (maxI - minI);
  int32_t dU = abs (maxU - minU);

  //Minimale Belastung Prüfen ob es genügent Änderungen gab
  // 1/20 des Nennstroms
  // Bei 100Ah Batterie mit 0,5 Std discharge --> 50A --> /20 =2,5 A
  int32_t min_dI;
  min_dI = sys_data.s.parameter.cellCapacity /  sys_data.s.parameter.cellRatedDischargeTime; //Nennlaststrom  in mA
  min_dI = min_dI / 4 ;

  int32_t min_dU = 100;
  
  if( dI < min_dI)
  {
  
    return -1;
  }

  //printf("dI change!\r\n");

  if (dU < min_dU) {
    return -2;
  }

  //printf("dU change!\r\n");

 
  int32_t dIMax=-1;
  int32_t dIx=-1;;
  int32_t dIMaxPos=-1;
 
  for (x=0; x < (SAMPLE_ARRAY_SIZE-1); x++)
  {
    dIx = abs(current_buffer_fast[x+1] - current_buffer_fast[x]); 
    if (dIx > dIMax) { dIMax = dIx; dIMaxPos = x; } 
  }



  if (dIMaxPos == SAMPLE_ARRAY_SIZE / 2)
  {
    //ESR berechnen!
    sys_data.s.values.esr_fast = ( (double)dU / (double) dI) * 1000;
    last_refresh = sys_data.s.values.onTime;
      

    for (x=0; x < SAMPLE_ARRAY_SIZE; x++)
    {
      sys_data.s.values.current_buffer_fast[(SAMPLE_ARRAY_SIZE-1)-x] = current_buffer_fast[x];
      sys_data.s.values.voltage_buffer_fast[(SAMPLE_ARRAY_SIZE-1)-x] = voltage_buffer_fast[x];
    }




  }
  return 0;    
}