#include "transform_test_data.h"
#include "arm_const_structs.h"

/*--------------------------------------------------------------------------------*/
/* Input/Output Buffers */
/*--------------------------------------------------------------------------------*/

float32_t transform_fft_output_fut[TRANSFORM_MAX_FFT_LEN * 2] = {0};
float32_t transform_fft_output_ref[TRANSFORM_MAX_FFT_LEN * 2] = {0};
float32_t transform_fft_input_fut[TRANSFORM_MAX_FFT_LEN * 2] = {0};
float32_t transform_fft_input_ref[TRANSFORM_MAX_FFT_LEN * 2] = {0};
float32_t transform_fft_output_f32_fut[TRANSFORM_MAX_FFT_LEN * 2] = {0};
float32_t transform_fft_output_f32_ref[TRANSFORM_MAX_FFT_LEN * 2] = {0};

/* Some of the transform function modify their inputs in-place, so that they
 * become the outputs. */
float32_t * transform_fft_inplace_input_fut = transform_fft_output_fut;
float32_t * transform_fft_inplace_input_ref = transform_fft_output_ref;

q31_t transform_fft_q31_inputs[TRANSFORM_MAX_FFT_LEN * 2] =
{
    0xC14A5524, 0xCCABDA17, 0xAD6F5B56, 0xFDAFCE3B, 0xA9B226EB,
    0x41F6F6A, 0xA5CE38BF, 0x3A978AFA, 0xBA44B82A, 0x855C0F8,
    0x3D060524, 0x93D5E570, 0x97D7791D, 0xFFE0C38C, 0x26749841,
    0xC0A6EE54, 0x218EC386, 0x39FF3726, 0x8DC1F7CA, 0x702F2CF5,
    0xC1142FF1, 0xEC1476AB, 0x15F640DD, 0xE62CCE49, 0x3805DE7E,
    0xF70871FE, 0xCF8BD360, 0x8D19A8A0, 0xD764F821, 0xA58558CF,
    0x8C0CE04D, 0x50A46C19, 0x66D2370D, 0x50FA359A, 0xB646AE24,
    0x6CE00F5C, 0xE6D48948, 0xB55BD831, 0x3B72950A, 0x9EB69530,
    0x73394127, 0x773FA6F4, 0x9805A980, 0x838DE587, 0x9CF597F4,
    0xA2AD1691, 0xFA81A473, 0x7CDC7D7F, 0x4A5190D0, 0xED895BB9,
    0x8FD60F35, 0x1A21D530, 0xA0EB6DDA, 0xBDE6A516, 0x2501A3E1,
    0x5ED893C8, 0xE1E175B1, 0xACBBB2F3, 0xED350907, 0xDB140D7E,
    0xEEAE272D, 0xBE229841, 0xC18BFB88, 0xA6BB9B80, 0xBCF090E4,
    0x24DB166C, 0xF9AB7E42, 0x62DF28D1, 0xC7004665, 0xE3F56FC6,
    0x419E0C75, 0x46BE9F38, 0x2432B9B2, 0x758D83E0, 0xDCE12926,
    0x3F57CB74, 0x1F4458E2, 0xF1DD639, 0x83A1FB49, 0x173AFC76,
    0x86EF7531, 0x48D32F34, 0x7D3E3063, 0x8F2FB549, 0x5C314C9,
    0x18CBEB6D, 0xA6F8B697, 0x447B9E9C, 0x2E32BA33, 0xD074D715,
    0x81ACD746, 0xE55A4E04, 0x4891860F, 0x1DA3EB4F, 0xE0E6A27F,
    0x20BFDEB4, 0xD0B3A25B, 0x40C10544, 0xC15656C, 0x15405EAE,
    0x9858E3E1, 0xA36A9C4E, 0x88BD21F9, 0xAACF7A68, 0x773665E5,
    0xCEDFDF66, 0x617A9610, 0x524FC968, 0xC2D086CD, 0x5F008079,
    0x24DCA447, 0x6A4F5599, 0xB706CD4A, 0x1DE70608, 0xA33A2EE5,
    0x137E488E, 0x98061B7B, 0x4079D69D, 0xA4A897D5, 0xC4CEC8F5,
    0xD75F7883, 0x22406802, 0xF1AD70BB, 0x9D4ADD79, 0xBCBC7CE4,
    0xB358C0D8, 0x85792E47, 0xA7ADAC05, 0x3D19EEAB, 0x331AC0AF,
    0x33035831, 0x13D93987, 0xFC542094, 0x845F317E, 0xDDC4BF8B,
    0x1379E50C, 0x5C20193F, 0xFDD58298, 0x9D482B82, 0x4A6BE062,
    0xDC8A757B, 0x272917C1, 0x90E1EFBC, 0x355AD882, 0xE6F8EA35,
    0x604555A1, 0x7DFFFBB, 0xF58AE216, 0x9A11B463, 0xD3541BAD,
    0xA1576756, 0x483BED8D, 0x1F05AFCC, 0xCEA63DFB, 0x55B84677,
    0xFB2E04F2, 0x787AF96C, 0x84A12CD3, 0x460A9BD, 0x9DB22DD8,
    0x1A8C7F28, 0x861E452E, 0x932D3F78, 0x7652D852, 0x73357BBA,
    0xEBBB0A58, 0x62536AFA, 0x3F6B65EF, 0x6DC57B58, 0x9EB798CE,
    0xE6B0A740, 0xDFF68B47, 0x3247FB8F, 0xFFF3D302, 0xA9FD3E40,
    0x475A43D1, 0x6FF9528A, 0x2018A09D, 0x47E0F9C9, 0x4CF5F6D3,
    0x2807CE34, 0xDD6FD8ED, 0x234045D1, 0x51CEB5F9, 0x25297896,
    0x6443A0FE, 0x8F4449A9, 0xD4C3E1C6, 0xF01D52F1, 0x4E09C820,
    0xF18F0810, 0xE1548689, 0xF9DE5A1F, 0x5286DC23, 0x48AC3A4B,
    0xEA0C1BE0, 0xA1B785DB, 0x7086465D, 0x1CC10929, 0x1E1D716E,
    0xED231D4C, 0x2049D108, 0xB8FF9971, 0x949CF8D4, 0x441F1E8B,
    0xC3D95372, 0x69C324B4, 0xA10BFDC9, 0xC781DE78, 0x82476137,
    0xE163DDF, 0x390DEEC2, 0xAF68CE5B, 0x8E680ABD, 0x8223A615,
    0x92593380, 0x7B1465FE, 0x865AE957, 0x930F53EB, 0xED772EF7,
    0x10E916B6, 0xE3BCFA68, 0x2ACB80BB, 0xE51C5590, 0x994714B5,
    0xF30984EE, 0x59BBE1B4, 0xB4867DBC, 0xB91C706C, 0xBC16C218,
    0xA8931CD0, 0x129A66AB, 0x13171F4D, 0x62882872, 0x4B167FD4,
    0xE6902F4C, 0xFA794932, 0xD4B152C, 0xB0856EA9, 0x39466D55,
    0x3669E451, 0x8F5B9E8C, 0x877A3C6A, 0x51B956B4, 0x367EAD2A,
    0x9D2C662A, 0x78FB6880, 0x4E6D40B6, 0x4070EFDC, 0x4DF9679C,
    0x20306EDB, 0xE381AAE7, 0xA55DA748, 0x9B8B617B, 0x3E036FAD,
    0x84E4C4A7, 0xD5A3F517, 0x669BA988, 0x98FDDE8C, 0x67BD85CE,
    0x34BBB46C, 0x76994800, 0x85B9D8B6, 0x6DFA2FEF, 0x205DB5C,
    0x9F843C4C, 0x72721B52, 0x73EF6B86, 0x5FB98B61, 0xC323DDAC,
    0x31D424B4, 0xF68C0D7E, 0x162FAF9D, 0x7B2A7A99, 0xF9392693,
    0xC42D12C0, 0x8692A73E, 0xD9A1EE80, 0xDD956856, 0x44E7BDAC,
    0x8D874532, 0x5F5C9DD0, 0x5D167858, 0x8559FEA2, 0x9D821476,
    0xD9654ED2, 0x594C0DC7, 0x1A87B506, 0x3F693200, 0x7A651AB5,
    0xA0CCBC8A, 0x9F9E662C, 0x78EF631, 0x2A09DA0, 0xB088C72F,
    0x92EE0D42, 0x360DCD5F, 0xF333FE48, 0x8D63CC06, 0x233A8ACB,
    0x706651ED, 0x7AA5C079, 0x262239D1, 0x3EBBEBB6, 0xA25A4F3D,
    0x32581A06, 0x6E6FD780, 0x5773F7C7, 0x75ED1DDC, 0x90DF2D15,
    0xBC79A9BC, 0xB7175917, 0x354E381C, 0x762AADD7, 0xF643DAC1,
    0xF3BBF49E, 0xD2FECE7E, 0x6C8140F4, 0xD7694875, 0x92D30822,
    0xC742A7CF, 0xB792ED98, 0x121CFE24, 0xA04E1EE7, 0x58CE268,
    0x215A080, 0x316CB323, 0xFAB14A31, 0xE1C13C03, 0xFD8EF4F1,
    0xF3F446D0, 0x6C6CEA0A, 0xBBFDF9FB, 0x67242969, 0xBE55A4EB,
    0x8FF5534, 0x52F0DF1C, 0x9710ADE3, 0xD40F4A21, 0x7984E8E7,
    0x419545EB, 0x993F7880, 0xAB246B20, 0x408AABC4, 0xCBF6EA49,
    0xC0894C55, 0x4CAA6398, 0xA47856E9, 0xAF2AE47D, 0x22F55D33,
    0xF0D37915, 0xD0634C72, 0xD983671, 0x2BCC5AF8, 0x9A77D48,
    0xC11B5CFA, 0xF107CD7E, 0x3A6B3593, 0xE1425F05, 0x6271812A,
    0x5B838310, 0xBD8418CA, 0x10A58792, 0x239F7137, 0xA13D5071,
    0x7F9930D4, 0xA462664F, 0x54180F8E, 0x291585BA, 0xE586B87A,
    0x144B2C12, 0x98E425C7, 0xBAA4B373, 0x18F0D03C, 0x99462AC0,
    0xD8B4D2EF, 0x72473895, 0xA6BF5435, 0xEDAD53B, 0xE0912FA6,
    0x5C33F331, 0x3D93CD7, 0x4D03D752, 0x20699929, 0xB89962F9,
    0x36E781E9, 0xF58B642C, 0x5FCA69E3, 0x5960A7F4, 0xAD5AAFD0,
    0xDF18324A, 0x3DB1E5AA, 0x76BA3876, 0x1BC29AF6, 0xBCC18841,
    0x73A60174, 0x625BFF58, 0x67C57724, 0x4458E53C, 0xE157B095,
    0x2B370837, 0x83DF6CE3, 0xDD08EEFA, 0x3F52A7C2, 0x191B4785,
    0x60843D82, 0xB0DE11F1, 0x105EA26C, 0x6E1C7AA2, 0x47AADD14,
    0xB6676D03, 0x3B8D4DF6, 0x737A694, 0x409521DC, 0x744206A,
    0xC722023F, 0x2BE4EAD5, 0x63E11D76, 0xCA4A09AB, 0x5CF2D2B9,
    0x31586916, 0xCDFD7D84, 0xB203F634, 0xAD7329D4, 0xC524582F,
    0x2E53E6C1, 0xBB0E019B, 0xB8538C6A, 0x6A2542D, 0x8A6A00E5,
    0x119725CC, 0x5406D347, 0x1B6FFAF1, 0xECCF71F1, 0x981117F2,
    0x7167CA76, 0x74F4B880, 0x77A55F47, 0x59EADB62, 0x4A331D95,
    0xBCBBA76F, 0xA45C4D50, 0xC718D5, 0x87CE05D1, 0x60D47AD5,
    0xA5CA9C40, 0xB0061766, 0xE69B39DF, 0xBD5F1320, 0x9930EAD3,
    0xA8B38325, 0x8DD090F, 0x6A6EEF37, 0x2DF16F66, 0xAB514C7E,
    0x31109C58, 0xFD48C7FC, 0x515341CA, 0x77AB8EA6, 0x41328DAF,
    0xBAF8D31E, 0xA4B31611, 0xED37F331, 0x7A832A22, 0xA22591C7,
    0x722D1F89, 0x3B19CF18, 0x261B8A4D, 0xC3F6F6DB, 0xCF8CED61,
    0x990FA250, 0xA02E72A9, 0x560DCEA2, 0xB08E67B4, 0x3674E663,
    0x97CC3852, 0xA7EB2EAC, 0xFFDE0AA8, 0xA64719A, 0x23269EDD,
    0x3C0B339E, 0x86284D40, 0x48D82ECB, 0xA4D4CCF8, 0x43631B91,
    0x4BF0C248, 0xB6497B9B, 0x6827BC58, 0xE30B7AF9, 0xA0CCBF26,
    0x6C3B7B71, 0xD744B3ED, 0xFA25D2F6, 0x4CDE642D, 0xD65B8142,
    0xA6F9207F, 0xE7A207BE, 0xDB506684, 0x44DA4780, 0x9175EA0C,
    0x156104AF, 0x4155E1B0, 0x6E3A6886, 0x9DBA1EA2, 0x5423D9C8,
    0xCC024E22, 0x758F852A, 0x1DD6395, 0x2D19CBAD, 0xE164F5A1,
    0xC2084602, 0x89C274AD, 0x13CB5562, 0xD7FE2D5B, 0xE07A4EE5,
    0x1672BA91, 0x4F624CCF, 0x2E5EA4A3, 0x28FEEFAF, 0xBDDA6EF4,
    0x32AFD40C, 0x99A5FB3B, 0xDD1D73A3, 0xA342CB3E, 0xA78445F5,
    0x53979C3B, 0x427D7943, 0x5221B58C, 0xA6CE9A5E, 0xFB50ECA4,
    0xBB86E36E, 0x60839F6D, 0xC5E1C2F3, 0xA1B7FB04, 0xFBB65E0C,
    0x78B80F5E, 0xFD8D972B, 0x3BF3BA90, 0x2D572D9, 0x2B5BC920,
    0xB6A0DE01, 0xD274D306, 0xC7C6C855, 0x9CAA669B, 0xB04AA641,
    0x4D6B1760, 0x3E17ED79, 0xD23241B0, 0xA4A6F957, 0xCBDE76AF,
    0x4E5F9493, 0x4C215DA5, 0x33A052B, 0x1A4D80C2, 0x40AEEBCA,
    0x390D106B, 0xE9E8E018, 0x5AF3D6CF, 0xE35E1D4, 0xC4FB1C6,
    0x14B6299B, 0x8D2E25F0, 0xCCBF932A, 0xC5AC18B6, 0x2227567D,
    0x86B5CE2F, 0x26344534, 0x22C515EC, 0x2442B70D, 0xEC3721C6,
    0x34EF687D, 0x9C06323A, 0xEAF3EA60, 0x60396F52, 0xEAE78AA1,
    0xC9D06CBC, 0x6F95F6C8, 0x584CC258, 0xBA9A27BB, 0x66DF8D47,
    0x9D4804EA, 0x57DD9E67, 0xF89C7895, 0xF5336111, 0x25C122C8,
    0x62742114, 0xCFBF6D26, 0xBF9F6482, 0xE6F02CD9, 0x11083202,
    0xC99E2618, 0x7EBC9351, 0x440112F1, 0xC9DFFBC1, 0x3BF4DC25,
    0xB1BA7FA0, 0x61AF9AED, 0x6B1F7D29, 0xAD865294, 0xE3E01129,
    0x7E9E77A5, 0x100435D7, 0x9FE3A71, 0x88597C81, 0x722849FA,
    0x31C5A0AF, 0xFBA178DC, 0x7F102D31, 0x5CA07864, 0x950E6F98,
    0x82C34882, 0x5D041F11, 0x8C613C57, 0xD398CFD1, 0x426F38AD,
    0x5599AB1D, 0xFAFA078D, 0xAB25B413, 0xD94B32CF, 0xB288FE38,
    0x2893BB46, 0x9A0B4168, 0xA91BCA94, 0x653A5E8D, 0x2174EBBE,
    0xDEFE6415, 0x30DA429C, 0xD0C5E40C, 0xB4719AA4, 0xD29CE7A6,
    0x905957CD, 0xCD287499, 0x83CA0AA7, 0xA8385832, 0x25A0CA02,
    0xC20D47A4, 0xB562F556, 0x4BC19E4C, 0xD9E215C7, 0x27E838B4,
    0xC58612F4, 0xA2827F6F, 0xC49DCDBA, 0x679B7362, 0x4E495845,
    0xCFD2F0D1, 0x395E76A0, 0x375A655E, 0x92E2058F, 0x73F9F0CA,
    0x61EFF3B3, 0x51FFD362, 0xE7410345, 0x7FDA8B3B, 0xA219E2E8,
    0x17ABE543, 0x26557412, 0x4B30084D, 0xA68E191D, 0xFE0D93DF,
    0x73EF127D, 0x4DECDDB1, 0x77FAF45F, 0xD6002898, 0x92DD0A40,
    0x157F6DDF, 0xC2A55F8E, 0x4359F924, 0xFB630C3F, 0x338B6B58,
    0xB2945F75, 0x4FA23A0E, 0x836EB8C0, 0xB3B18FD, 0x86114337,
    0x24668ACB, 0x99BB82F0, 0x924C8A47, 0xBA959701, 0x81155ABF,
    0x8C612D71, 0x36074CA7, 0xD1668C41, 0xE35F58C7, 0x7FC2802D,
    0x8E6A7CF3, 0x65B07D07, 0x815F6A6B, 0x791BF0DD, 0x6E47D719,
    0xC24394C7, 0xE84A6EB, 0xF194AFEE, 0x464A2F52, 0x677579FD,
    0xEBA775AE, 0x1F6EEFF, 0x9A795237, 0x78D9D45F, 0x9D0B344D,
    0xBBD34AB7, 0x2F85B12A, 0x16C5C2AD, 0x3990985D, 0x88DF3351,
    0x82811AA5, 0x6D351F41, 0x4066A69D, 0x86B660BF, 0x6EDB4768,
    0xDDD78CF0, 0xB5D74F6E, 0xE89E220C, 0x91439687, 0x947CC9C9,
    0x3857E2BD, 0x302F8AE4, 0x1DABE7F8, 0x4832D6C9, 0x37D58FCB,
    0x4EA8A711, 0xCD7BAC98, 0x19DBF8BC, 0xD8DE8DC2, 0xEAFF7E7B,
    0xB7629C93, 0x792C6E19, 0xF7009192, 0xFF88439D, 0x2E196A66,
    0xEC71B78C, 0xEAF4BB3A, 0x7C16225E, 0x668F337, 0xCBEE1608,
    0x6D5B5552, 0x345DC590, 0x681209CC, 0x7B24A819, 0xD08A1416,
    0x99888FE3, 0x9FC7288A, 0x24BD8502, 0xEA1D9678, 0x20EECA0,
    0x59BEA057, 0x5ADE91EB, 0xDEA8E49D, 0xFA200E6F, 0x9149C81D,
    0xF2281E93, 0x8A5B0451, 0x67312D58, 0xE3B849F1, 0xD2217960,
    0x7CDF59F3, 0x33C775C0, 0x9EBA8799, 0x7DF9506, 0xB4E96110,
    0xB8FCF3E3, 0xDEA059B2, 0x8229B6EA, 0x316486F6, 0x43919185,
    0x6C0D90F3, 0x1C6F3DF8, 0x38DB92A9, 0x5CD41244, 0x2C9F0A7B,
    0xDF4A315F, 0xF7CE9C66, 0x4C800860, 0x318D53E0, 0xF105C20D,
    0xD753E1F2, 0x750810BA, 0xA17ECCA5, 0x2010140, 0x4D884763,
    0xC2BB0DA7, 0xB2D5BA74, 0x141CECD4, 0x887FDFC3, 0xC64B53,
    0x2D2A85F6, 0x15532B45, 0x5D5CBCE1, 0xBEB9A16A, 0xA214611B,
    0x9FC5AC5F, 0x11AE5DD7, 0xA0B9A5A9, 0xFC648AF4, 0x740009AC,
    0xED0E0321, 0xB8E6A61, 0x8910C544, 0xC74F26C8, 0x9525CCF3,
    0xB41AEB59, 0xE61984CE, 0x598B2197, 0xA412E59D, 0xE1976DD4,
    0xB29BBE16, 0x88FD9FB0, 0xB04006F3, 0xB45E309, 0xD5CC15F1,
    0xD9DAF630, 0xDC809335, 0x803ED52, 0xB537F5A5, 0xA994F6EB,
    0xF5288568, 0xF66FD264, 0x2EA2B3A6, 0x647619F3, 0xFFB38C7A,
    0x1BC03B9, 0xB6BC3061, 0xBF30596E, 0xBE2AD27B, 0x8AC04220,
    0x641979A3, 0x9ECCBB89, 0xA144FBC1, 0x4E8FAE26, 0x8C5A9D90,
    0x299ED467, 0xD7C9C7E3, 0x1D4865ED, 0x76F31C3D, 0xCEE81CDF,
    0xB479195E, 0x6FFB3AE1, 0xDC8A398, 0x300F7364, 0xC7940AFA,
    0x3B85BE3E, 0xD98CC40D, 0xA24A3D89, 0x3A674204, 0x22888A38,
    0x2E77F2D, 0xA2841C9C, 0xCF0689C3, 0x9FE98922, 0x89335017,
    0x2D6B69A7, 0xFEDB63F9, 0x899AF4EF, 0x9F9F9B40, 0xA4BE97E8,
    0xA51DAF7A, 0x16AC50D3, 0xA8D7ED6, 0xED193443, 0x7615EF1B,
    0xB0DF6A4E, 0x64FFE794, 0xE3DB2C9A, 0x7435B022, 0x556E825C,
    0x23802AF9, 0xC25098A4, 0xE75A18BB, 0x70B2A7B9, 0x7FB81BF,
    0x63EF910, 0x6C669591, 0x6574DD2B, 0xCF6E379D, 0xD2B3AFAC,
    0x1E6A1101, 0x1DE22385, 0x2338191F, 0xC69704B6, 0xCBABC599,
    0x54EB4809, 0x7839BE6D, 0xD50017DD, 0x39B1A0E1, 0x288D52D3,
    0x2D52668C, 0x20D22A68, 0x4E1207D1, 0x3FCC0EFE, 0x47F3FE64,
    0x25177A90, 0xB4BFDD4D, 0xDA8DBDCE, 0x6F7275A8, 0x6BEAA655,
    0xAA1810FC, 0xE4DB593A, 0x8A4D4BC0, 0x2C402E93, 0xF1C0F7F9,
    0x6F0CC577, 0x70412414, 0x752F9DC1, 0xD82E38EA, 0xAC455F7B,
    0x4DCD4EDB, 0x92BC2696, 0xFB03F135, 0x4FCA1F8C, 0xBD5E75F6,
    0x502F41B0, 0x3616D3F1, 0x2E5B8E31, 0x2026EB19, 0x57E783D7,
    0x467BBE00, 0x4703ABA3, 0x1F776B9C, 0xE2570A84, 0xFEC7DB48,
    0x1BD5012, 0xFD0A2D5D, 0x7FCC29F2, 0x291304B6, 0x99D5D8ED,
    0xC7551C8, 0xFD12F38F, 0xBADE8892, 0xDF749997, 0xA5DAE2F,
    0x2B9FA269, 0x5C13CFED, 0x15E9A399, 0x54437F4E, 0xA72DB2AB,
    0x56186AA1, 0xFE4DB55C, 0xA34D7836, 0x2A879760, 0xC63FA94,
    0xAC18B207, 0x5FC78B3, 0x7F10621E, 0xA769E6B2, 0xEC9F4A11,
    0xCE3F982C, 0x62BA2EF5, 0xA5F239CD, 0x73D63FED, 0xE36E9F5E,
    0x8AC1DA0E, 0x3F3DB3EB, 0x738326EA, 0x35C366B1, 0xCD476E86,
    0x82F6B208, 0xF11A9FC1, 0x426AC396, 0x7E4D1B93, 0x75E4EDB7,
    0xAF3C44A7, 0x51A5EF5C, 0xFAD2463D, 0x8A5639CA, 0xC995AC78,
    0xCC4BE4F6, 0x3AFE7F8D, 0x66993D04, 0x4386FF37, 0xCBC1C6C2,
    0x55A8F5EC, 0xE81A9A75, 0x30A67E1B, 0x4A4A7D0C, 0x20F7F993,
    0x1891805, 0x738976AD, 0xD426E7D6, 0x3C5CEEBF, 0x4499187F,
    0xABF17C97, 0x447C317F, 0x68D8419C, 0x7AAB6456, 0x421BCF29,
    0xF6740F9C, 0x8916BB8D, 0x3D72AAB, 0x9AD54DD7, 0x7549C6EE,
    0x7317342B, 0xA18546D4, 0x1056BDA7, 0x54BBCCCE, 0x8CE63E46,
    0x5D146234, 0x33BE6C63, 0xB250C4E5, 0x89D72335, 0x87C36BA,
    0xB65530CC, 0x2DFAC48C, 0x1663D16F, 0x59B80AA, 0x950274EA,
    0x92532D4A, 0x3CEF802D, 0x492FBDA5, 0xA63A2574, 0xEF8005C2,
    0x94A18651, 0xAF627ABA, 0x6829B238, 0xA698F646, 0xD2598516,
    0x10144D36, 0xD9B1D1B9, 0xAB2ACF05, 0x5395B699, 0xA7851C75,
    0x1806C6F3, 0xAE970306, 0x3284B145, 0x98F4FE8F, 0xECDD35CC,
    0xDDC1EE0E, 0xC4848865, 0x925826BD, 0x4078BE39, 0x68A8561A,
    0x323045DC, 0xA933B37F, 0xBA2AEE2E, 0x4F24F65D, 0x349EE246,
    0xF97B9D0E, 0x46DC5759, 0x4529F425, 0x80D17B42, 0x8E16F709,
    0x1B42206A, 0x4934A526, 0x391BB6DE, 0xB52EF45C, 0x26C30290,
    0xCBA23CAA, 0xA501A8C3, 0xD922C4F8, 0xE8824E53, 0x6F4255DC,
    0x5960B544, 0x58BC69D6, 0xCA936323, 0xFDDF053C, 0xC2E002D6,
    0x7D750755, 0x8A3F9CD1, 0x35F8F6F8, 0xFB7BD154, 0x65CFF94F,
    0x390A58DD, 0xD97C4093, 0x501CA2A3, 0x8EA5DEBC, 0xCA93461F,
    0xE02D984C, 0x126F8517, 0x39FDD887, 0x46241AE9, 0x777E854D,
    0xE2B36349, 0x58E3FA9F, 0x971DEF1E, 0x8E156228, 0xC0E14E9,
    0xA9A01BE6, 0xB318C990, 0x971680D6, 0xA1F359CE, 0x487E23F4,
    0x7DE465B0, 0x4E4C905E, 0x2A652959, 0x116FF167, 0x5C74AAB9,
    0x4FEFC920, 0x28DF4EB8, 0x29EBF45A, 0x1E350CF6, 0x7134F224,
    0x22CCF1B6, 0x3890ACCD, 0x9BC304F0, 0x7A37B14E, 0xF3724F9C,
    0xDAC493BE, 0x504692EB, 0x82A56D75, 0x42BC73F0, 0xADA92177,
    0x2D9D9FD2, 0x41D874F, 0xEFCFD8FE, 0x8E83A5A2, 0xB84AF0DA,
    0x65F9B035, 0x6DF4EEE0, 0x7D403714, 0x1CCB8B3A, 0x25B30F14,
    0x5384B044, 0xD21FB429, 0x2C407A2, 0x88622917, 0x92D49C25,
    0x845AA406, 0x532D7675, 0xC0B7713D, 0x30E6933B, 0xD270DE3B,
    0x78771A87, 0x1949A28, 0xAEC00040, 0x10A092F4, 0xBD9D5066,
    0xDE166CB7, 0xE8ECE4D3, 0x867417C9, 0xCF0657E4, 0xD7D550F7,
    0xCD472B6D, 0x8CD0F002, 0xD7D47B7C, 0xA2E5475F, 0x2B66B40,
    0x397A7C9F, 0x6C4BC024, 0x9FDA402, 0xD981917E, 0xA3A6C8E,
    0xC9A42042, 0xCF0D1D5B, 0x1A96C11B, 0x9271030B, 0x4BD5D13C,
    0xCDA08C03, 0x1E4B3256, 0xDBB263E, 0x94B1E758, 0x5CF0232F,
    0xC76F252E, 0x27FF7F55, 0xA55DC287, 0x72886B75, 0x38AA73C2,
    0xA5759CFB, 0xF0A75C8C, 0x7059CBE3, 0x6519FBE2, 0x8C3B4162,
    0x5A19A4DE, 0x9D93E753, 0xA9EDF8B5, 0xD68126CD, 0xEA6A7399,
    0xA73005B4, 0x45BC5168, 0xABD166BA, 0x4D0CC0DF, 0xE1376FF9,
    0x393FB309, 0xE995744E, 0xD5EF71BE, 0x66C2BF35, 0x88D62A85,
    0x14121E08, 0x7006CE98, 0x7F0A7076, 0x7DB9C751, 0xDC7056CD,
    0xC1517CD, 0x65BCE88, 0x1B0F1E71, 0x54C2DA11, 0x101BFDD8,
    0x28096AAD, 0xC365859F, 0xACE13396, 0x7CB432BC, 0xB19EA011,
    0xAD9BC7D2, 0x3AF387B1, 0xCCE30470, 0x5335FC46, 0x40D13C16,
    0xD548B4CC, 0xC476A7BD, 0x66BC0663, 0xB7C6960F, 0x12D1E821,
    0x9A536C48, 0x42641630, 0x740C9A48, 0xF61664E8, 0x3B11E69A,
    0xBD79E1F1, 0x3F930B7D, 0xD98B085D, 0x2151962F, 0xD4D7F80E,
    0x88975123, 0x5302989, 0x12F5CA2B, 0x37C29573, 0xD1D2A3A6,
    0x46DA55DA, 0x2EC8C098, 0x802A42DF, 0xD07A11E5, 0xD5BF4B16,
    0x171BCB96, 0xB5843001, 0x57BDCAA7, 0xDDD36F33, 0x633D0AA0,
    0x313B7064, 0x68BD30CE, 0xC986B6C3, 0x2271824F, 0x9951E552,
    0x15939472, 0xDC668F83, 0x1D98A441, 0xA4A1676, 0x631C444B,
    0x6EB61C7C, 0x8EEE0B5E, 0x23F82C1F, 0x6C4B53C1, 0x41116D6,
    0xEBC1627A, 0xC8839049, 0x7F07A8F6, 0xD1F74661, 0x7D9892DD,
    0xF010EC90, 0x37C8A4F4, 0x6ABA986E, 0x68B1E4F6, 0x8066EE05,
    0x5E964158, 0x88D477A6, 0x776CF1E1, 0xB7AB3B60, 0x183D58C0,
    0xA7E13F2F, 0xDD435AD0, 0xF37DF46E, 0xD3F3F774, 0xB6B24A9A,
    0xC097D9F2, 0x54EE718C, 0x4469BDB, 0x4F20DAC, 0xB4002AD5,
    0x2E7AB56, 0xCDB4B18C, 0xF2ACE62D, 0x54BD40DE, 0x46DCCA2,
    0x5B7F32F9, 0xA8CB257D, 0xB138C149, 0x71474D19, 0x6F71C293,
    0xD88FBC7D, 0x9E0A7F86, 0x14B92605, 0x1CBACDC, 0x29159263,
    0xBB719E18, 0xD41B37EE, 0xA236E27E, 0xE916BAE3, 0xED34D9DA,
    0xFDDE09B6, 0x4FE72C56, 0x16927460, 0x8CFFF9A, 0xA9465741,
    0x2B1CD6E0, 0x6BA277FD, 0xE06F70EC, 0x7CB2715, 0xFEDC13C8,
    0x7049632E, 0xC6448831, 0xF72CA3A, 0x9B2BE231, 0xC16A8438,
    0x948EB7E, 0x64041803, 0x82A43295, 0x226D95CE, 0x84AFC1EE,
    0xB2EF3B82, 0xAC18A45C, 0x74DE3ADE, 0xD0E6FAD4, 0xE10C242E,
    0x797DF7BA, 0x812CD7B8, 0xED45B681, 0x8F6CCDE8, 0xC2376DFF,
    0xCABE35D6, 0xD450395B, 0x13493CE3, 0x870E1BF5, 0x7B0BF341,
    0xEBD572F2, 0xAE22B3F1, 0x7ED22DF8, 0xEFE826ED, 0xF147F4BD,
    0xA12DA6F2, 0xF3871967, 0xE4423B70, 0x298472D9, 0x45E03E3D,
    0x2BE705AC, 0x41E3AE6C, 0xA29DF92C, 0x54B33739, 0x8EA8F7A9,
    0xDEFF7BC9, 0x77D06961, 0x71981BA1, 0xBA5A5647, 0x4A8E0E2E,
    0x9F519F5D, 0x31BBA940, 0x3D3A0532, 0x7090F0AD, 0x8B47D658,
    0x8D198BAF, 0x9ED929B6, 0x323BB81, 0x97210404, 0x7B8790DA,
    0xD8438C25, 0xDFBB1C93, 0x2C3F415B, 0x14738C42, 0xB46C2C7A,
    0xA3627CAB, 0xFC540D08, 0xE8227979, 0x672B87FE, 0xB257C949,
    0x9C2B31FF, 0x97AAACA8, 0xC662B448, 0x5BFEFC7C, 0xC2FDEDDE,
    0xAD306CED, 0x639A2576, 0x9ECC1378, 0xA72D71B3, 0x94E11CDB,
    0x8BF14832, 0x945C1728, 0x49AE595B, 0x526DD500, 0x40A7D344,
    0x8EB1DA34, 0x731E17C5, 0xA7CF41A4, 0xCB068104, 0xC842B8E,
    0x7F5733E1, 0xAC9CB3B, 0x2E3F58C0, 0xFD8BC4F, 0xFFBCBBAA,
    0x620248F9, 0x27AC344D, 0xF2E5958B, 0x773EBC3A, 0xEA6078F7,
    0x6B32D1D7, 0xC00DF984, 0xE73C86AA, 0x712026DB, 0x2CE271FF,
    0x38578573, 0x816605D0, 0x673509A9, 0x8D693AC8, 0x2533C371,
    0x6783E269, 0xC5731F9, 0xF2A8041E, 0xBB3C008F, 0x2B290D9A,
    0x122A4BA4, 0x645A69B, 0xB86CC256, 0x9369B8C3, 0x90CF4CEB,
    0x573005D0, 0x4F7DB793, 0xD6AC972E, 0x178BFB66, 0xC430DCEE,
    0xD1A8138B, 0xBF6EC4C8, 0x693E6FAF, 0x54119B44, 0x9C904669,
    0x4D95F608, 0xDB59E550, 0xD85DDBBC, 0xD15818AE, 0x680778D8,
    0x3B67A234, 0xEBE9DAF3, 0xEB8E049B, 0xDD9E0EB8, 0x5D4FB1FB,
    0xCEA62C1C, 0x948AF719, 0xA7E58E36, 0x800EAD97, 0xCD895A65,
    0x72E63F92, 0xA9A82DD3, 0x8CC07793, 0xE70EBE82, 0x1F69534,
    0xAB727A31, 0x1582EF9, 0x7247F677, 0x5FFD7E2C, 0x950EA9DF,
    0xFF38A172, 0xDD75DB84, 0x3A416207, 0xD6A23DA7, 0x3BBE70D0,
    0x538C25CA, 0x2958DF9, 0xD7B9C83E, 0x61F35964, 0x1E05B36,
    0xDD57CDCF, 0x997335B, 0x3A65762A, 0xC5836CD0, 0x9EF2B7F1,
    0x5094196, 0x6949A654, 0xB7FD3E5D, 0x6070C271, 0x30364C38,
    0xDCAFFFA5, 0xCD4ED281, 0x9865FE7C, 0x75F665AD, 0x6ABADB10,
    0xAB43129, 0x26B7A5B8, 0xA321DDBD, 0x467AD732, 0x153A1AE,
    0xAD6B1842, 0xBE19B6BE, 0xC1E22C82, 0x73372EA5, 0xF9EF4AD7,
    0x24C81977, 0xD8451807, 0xCD10ADC8, 0x8FBD95E2, 0xE0789969,
    0xC77A80F2, 0xF1165BCE, 0x3488C653, 0x16F3E378, 0x8D71B29A,
    0x628EC98A, 0x40963234, 0xF918E028, 0x9A584D33, 0xC174E2FE,
    0x417C5145, 0x1C751175, 0xB21E0C12, 0x30218ECC, 0x9D7731BD,
    0xA07DBA0F, 0xE7504D39, 0x3E37F16B, 0xD3BAB050, 0x6F3DE64,
    0x1998A7BA, 0xA61A6D07, 0x424FBED7, 0xCD6B3236, 0x68E71248,
    0x58CC3DFB, 0x584FA4F5, 0xFFE8E2BD, 0x9F0E3D75, 0x788DD779,
    0x978ED891, 0x7E1BFFC8, 0xB812A1C9, 0x5CCC1A32, 0xF1A47219,
    0xD6BA6E71, 0xAFA86EB5, 0x28D128E2, 0x9EDD53B, 0x9AAB7E9C,
    0x493B76F2, 0x31C5C89, 0xCE5FC3B6, 0x974CC3F5, 0xCBBD90FB,
    0x61DE988E, 0x99B927CB, 0x972EFCCD, 0x2719AD6, 0xE06E4B29,
    0x48215B1, 0x37EDE8E4, 0xABF9F87F, 0x8BC1C626, 0x5B19EC05,
    0x212A2AE1, 0x28446975, 0x20D04126, 0xFC453267, 0x967D9524,
    0xDF1CDF8, 0xFB17DCA3, 0x11E68AC6, 0x3AD7D667, 0xD133EF43,
    0x5EC41DA3, 0x587AA639, 0x17ADAE3, 0x816DF77A, 0x37D0726A,
    0x49DC33D9, 0x6C9737E, 0xA6A2F950, 0xEC5F352C, 0x50D1E06D,
    0xC10009A6, 0x2F70F8BE, 0x382269B1, 0x4C29E7CB, 0xBD474FF3,
    0xD19A4F6, 0xC3CCE458, 0xE09B348, 0xD15A0DC5, 0x1C10D20E,
    0x4AFDED15, 0x3C109DC1, 0xD8C117F5, 0xB501DDF5, 0x39C92B5F,
    0xE76FCA13, 0x76DBAA1B, 0xB0730EBF, 0x67DD1FBC, 0xD8B87AB6,
    0xA826225B, 0xAB2F7089, 0x499FA36D, 0xF26455B, 0xDC79F8EF,
    0x987E765E, 0xA13E60C7, 0x500C7803, 0x492C871D, 0x970DE4EE,
    0xD1423DC1, 0xB66048A3, 0x804895AB, 0xC079A15F, 0x5E6FD682,
    0xE936476E, 0x8DECE38F, 0x76A011D, 0x53575B91, 0xB263D36A,
    0x8F2624C1, 0x26B34937, 0x75A7EC2F, 0xE33ED24, 0xBF1BE7C7,
    0x8D6BA785, 0x1D9FE802, 0xB8F4EC20, 0xD5C714B2, 0xC1326D06,
    0xFCA78B3F, 0xC0065015, 0xA4B9F286, 0x53F92A8B, 0xF4B02DBB,
    0xEC47E64C, 0xA29FFB12, 0xBA94FFB2, 0xB6980EB2, 0x7415C83F,
    0x93F91A24, 0x4C6F7615, 0x34431174, 0xC7D63B4, 0xB1599158,
    0xA3A01FCE, 0xBD477764, 0x6B16EC41, 0x772D8BF5, 0x90F0A785,
    0x8F72672C, 0x7AD22CDC, 0x70824998, 0x1BED16D5, 0x596E84FF,
    0x48B5B4F4, 0xB20D0B81, 0xF00F7AFF, 0x80F618DA, 0xD10AFE11,
    0xA8EA3109, 0x91BA5E43, 0x31345A01, 0xEB0EF0F8, 0xCC6E7FB5,
    0x3348AE52, 0xEBB124D9, 0x447E58B1, 0xF2A3D592, 0x7F3EE5D8,
    0xD3D7B836, 0x9C98DCD4, 0x27F0B7A0, 0xA9655FD9, 0xAB48E5F8,
    0x7F996D8E, 0xAC13B08B, 0x2530AC6D, 0xAA542552, 0xD4E6B42A,
    0x6432AA64, 0xEAC84F76, 0x41D5F959, 0xCDE91DDF, 0xA0AA485A,
    0x6453698, 0x277C18A4, 0x161A497, 0x66FECAE2, 0x1B64683,
    0x948DD228, 0x1F3C5950, 0xFFC271FB, 0x15C4DF12, 0x7C78252B,
    0x9D4EBB89, 0xE6FA1D49, 0x6B032100, 0xB65DD3CC, 0x106BC9B5,
    0xE0223D45, 0xF7779B03, 0x4B0EA0C2, 0x3CB5AAF2, 0x9A458E5F,
    0x524090ED, 0x3BB1F18F, 0xB4DD065E, 0xA8F13E4F, 0xC4949ABB,
    0xD8142D31, 0x99069DE6, 0x989D2A16, 0xC72D929, 0xA2AC5754,
    0x7E29B714, 0x6E25C15F, 0xE8777078, 0x467DDCEA, 0xF94B2ACB,
    0xDF429476, 0x69AE316, 0x363C664D, 0x85D6AA1E, 0xD727E39E,
    0x5AF440A3, 0x2F0BB16D, 0x461D52D, 0x610559B6, 0xC28066D9,
    0x3C13AE61, 0xA965B865, 0x2BCE3D4A, 0x361C4848, 0x46B94657,
    0xF2AE634D, 0xD7FD4B8B, 0x70C175D8, 0x33128DF, 0xB9718A3B,
    0x8EF80C0F, 0xAB12E738, 0x124B8055, 0x43448325, 0x9F05E427,
    0xA0A9F843, 0x57A9A3FA, 0x492EEA32, 0xE73D2B18, 0xF3113C2C,
    0x2BA9B42D, 0xFF0B320, 0x3A18CD71, 0x59804367, 0xC37F9B87,
    0xB8A990, 0xAFE9F267, 0x1892892B, 0x25B9C66D, 0x52D4056E,
    0xCC1508CA, 0xAD213DB2, 0x8B43F743, 0xAA9705AD, 0x9BC756A2,
    0x43F42526, 0x596FEE87, 0x2B8AFF32, 0x46DEDB48, 0xBF06317C,
    0x876D4CF2, 0x16951456, 0x2B051AFD, 0xFD093E9D, 0x2F113180,
    0x77BFC4C0, 0x29200C52, 0x182D384E, 0x54AE29E0, 0xF90961E8,
    0x6072B8F8, 0x3D346F4E, 0x9AA5DBA4, 0xE5E22EC6, 0x392170DA,
    0x40939B9B, 0x65B89151, 0xC54AB94, 0xAD7280BC, 0xA3D4395E,
    0x3B5754D2, 0x9E77A6A2, 0x9A737F56, 0x9B2D432D, 0x8FDDA7E7,
    0x5958516E, 0x7F52CD74, 0xC1761A50, 0x2B80C01F, 0x5AA99F54,
    0x36FAA395, 0x5DB4B3AD, 0x82024C73, 0x988CEFE0, 0xB44498C0,
    0xF9561A4, 0x280470E6, 0x6966F3A0, 0x47E374F4, 0xF00F4CFF,
    0xBC5C4DB2, 0xE287924F, 0x1ED57369, 0x484FE06D, 0xE92E6564,
    0x7429DAD2, 0x1473AF49, 0x9619E0CD, 0xE6EC2B63, 0xF7A983B5,
    0xEC43C28F, 0x4C98EBE7, 0xA61FDF89, 0xA867E5ED, 0x1088A7C,
    0xCF1CEAE8, 0x223AA207, 0x686F4F7B, 0xEBB013E1, 0xDDC01886,
    0x77478D4E, 0x2FFCEAEB, 0xFCA58846, 0x1208668E, 0x32F8252,
    0x65C9F3ED, 0xC7584B2F, 0xF3EB26B2, 0x90890270, 0x5D97ED04,
    0xF5B5B18A, 0xCF415DF9, 0x4CF4683F, 0xE2E3F29F, 0x850E4BEF,
    0xDBABF6E2, 0xBD183286, 0x2F36215C, 0xD8CA1DD3, 0x4309CC6F,
    0x9FA52446, 0xBD94348E, 0x8693D9B6, 0x61E880C2, 0xA1851D5E,
    0xAAB94F80, 0xF8919C00, 0x74D82ECA, 0x4466A1B6, 0xA0A98E8C,
    0x95B6D1D, 0xE5393A4C, 0x5A40CFFB, 0x67013370, 0x571B0FDA,
    0x9E7E805C, 0x15E32653, 0x2CFE7902, 0xA02E0906, 0xA8883783,
    0x7A68B719, 0x3402833A, 0x68BFD324, 0xE0B43DA3, 0xF9DB0F,
    0xC9510610, 0x690D30B, 0xE79AB417, 0xC917E4C0, 0x7B05CE55,
    0xE116EFDB, 0x69E3B158, 0xF91ED58D, 0x1832D16A, 0x91F4EA17,
    0x3D24C408, 0x76A2C6D0, 0x99B19825, 0x2BF52475, 0xAD49289D,
    0x66238CD7, 0xAC1571F5, 0xA2EABC02, 0x889337AE, 0x3219AFFB,
    0x104B8779, 0x810488A8, 0xAC35416A, 0x2C6DEF85, 0x2ED109F5,
    0xCC8C6732, 0x97CD8E90, 0x339F3E81, 0x91486206, 0x2708D41D,
    0x1F2B19A7, 0x51A60303, 0x5E90E440, 0xB63092C8, 0xF1031823,
    0x971A06, 0xB624F6A2, 0x58AC0181, 0xA983D599, 0xA776D877,
    0xB727FE1, 0x55AC01B1, 0x4298EA17, 0x4D6BB9AA, 0x31C55C65,
    0x6A266780, 0x4FD92256, 0x817DB37A, 0x46A14DF1, 0xEC7D9F14,
    0x98D1C1B7, 0x911DF80D, 0xBFBF24E1, 0x9B4DBC6A, 0xE1F71BA4,
    0x9EE5E44A, 0xD1868C4C, 0x6FB45D76, 0x11EC8672, 0x1CED7F0C,
    0x1524A040, 0xA49DE9D3, 0x99FF328A, 0xC392F619, 0x52A856CC,
    0xDB0B0AE6, 0x67F0162E, 0x2C20D410, 0x4E23C4D, 0x828032EA,
    0xC2E7DFFA, 0x908CF524, 0x919F61EE, 0xF001C6F, 0xA81DDF65,
    0x5EC56647, 0x28385ACF, 0xBDD764C0, 0x75C853AB, 0xDF0ADD73,
    0xEEA9C63D, 0x804949F5, 0x658ACD0A, 0xD12F3F50, 0x1FD4F7EE,
    0x7F023D80, 0xD2CB08B5, 0x477EA9A1, 0x872DB719, 0x7B8B6AE9,
    0x84F6AC4, 0x81634EB4, 0xD1A89CF, 0xB3F4F3B9, 0x3A6B024B,
    0xAA2CA2C5, 0x9C902C0C, 0xC40E4135, 0x3C6E612F, 0x11219414,
    0x1F184277, 0x11B6B30C, 0xDD8A6A5A, 0xA0D21C9D, 0x55377022,
    0xD0708FBD, 0x8D761020, 0x54FCFCFC, 0x477801BD, 0xD6919EB8,
    0x9AD29078, 0x36F8D9B8, 0xAE525B8C, 0xCA7ED140, 0x2D8F8B97,
    0xD1B79EAA, 0x2E26FB2A, 0xFB396E32, 0x399129A3, 0x28B55FA1,
    0x2ECB2CF0, 0xDF1CBF7C, 0xDE57A70D, 0x33410B33, 0x7C5759BF,
    0xF534264B, 0x16C8C221, 0x874A3A63, 0xD05808ED, 0x679674BC,
    0x24B060C9, 0x4B162B53, 0xC7D01208, 0xE753DE61, 0xFA9840E4,
    0xA4FEC439, 0x4143E13F, 0x327E9EE8, 0x319D901E, 0xC40FC209,
    0xB1E1FFFC, 0xE737D52B, 0xD074E058, 0xAD8892EE, 0x86B93396,
    0x49C13F4B, 0x60A5721C, 0xD4C4F599, 0x14B38EBB, 0x86BA655,
    0x95F4E0C, 0x4217E99A, 0xD0CA3861, 0xBDD3617B, 0xB0BDBF4D,
    0x99E3389A, 0x8200DCFA, 0xEC22C8AC, 0xBA8DDB32, 0x3F7DDFC8,
    0xC7DDC171, 0x211CF31, 0xCC31A0C7, 0x99A84F32, 0xC9FFD317,
    0x2267733A, 0xFBD05569, 0x306BC05F, 0x6E2685D5, 0x43FBF7D1,
    0x5A2DB2D3, 0xE6491D4B, 0xAD078066, 0x7CAF7AAD, 0x2B1FEBA5,
    0x3418A0EC, 0xC359E9B7, 0xB024E024, 0x58F22A6B, 0x18EEE710,
    0x4755B9C5, 0x528D3273, 0xC8F9255, 0x635E5F9D, 0xABDF5BAD,
    0x8410F054, 0xEA068528, 0x438345EB, 0x56EF340, 0xBD86A7DE,
    0x543A126A, 0x5F259D83, 0x67EDA87A, 0xFF24F98E, 0x684E6504,
    0xE4EB57B, 0xD2D3B758, 0x4474D10F, 0xA94594B7, 0x3E4BEB07,
    0x95C3F257, 0x478B6FA8, 0xBCC7EFD8, 0x1023D258, 0xB4ACD6C0,
    0x36129B10, 0x16D7D9A3, 0xEA63BE7E, 0x25EC12A1, 0x21B95589,
    0x3A673799, 0xB8E04594, 0xAE98693C, 0x9879B8F9, 0x601A3F62,
    0xCF9897C0, 0x87CD1798, 0x629788F1, 0xC1337B31, 0x59D84E67,
    0xF13FA484, 0x5E8C7B3F, 0x7DEDE9F6, 0x9779F496, 0x74C4EE89,
    0xB3D9AC8F, 0x44118EFC, 0xB4FE8E45, 0xC9934560, 0x93D739E8,
    0xCD013773, 0x102411F1, 0x9DB63EFB, 0x63165875, 0xB8B97E98,
    0x6B4223D0, 0x6F34352B, 0xDB038A46, 0xC187163E, 0x17FE20D8,
    0x82A1BC9F, 0xB6860AAF, 0x11D5F9E0, 0x5371E14E, 0x20BC8445,
    0x607589A0, 0x8DDCCF44, 0xCDCD53C2, 0xCBCB32D8, 0xC512E661,
    0x1EB4E6CE, 0x228E99A0, 0x28EE0177, 0x76ED3F3D, 0xA3DA3300,
    0x17C57F91, 0xA1855C6, 0x3531FA3, 0xA93A8241, 0xC45D540C,
    0x365D42EF, 0x2CA39696, 0xE460F7D1, 0xCA32CCB3, 0xA6D9D934,
    0xAD01079C, 0x9B07D89C, 0x226CE0A5, 0x60D67762, 0xD35A4B7B,
    0xFF0A698F, 0xDB73BF89, 0xF41FBA9A, 0xCACDF26D, 0xBF594213,
    0xCD4D3E90, 0xD12F3EB8, 0xE689D238, 0x8CD4C0CA, 0xEB3E841E,
    0xA513EF0F, 0x2DF4B65D, 0x90161625, 0x9C02AC36, 0x208F328D,
    0x12BF5D93, 0x7C8C355C, 0x3CDFCA22, 0x29381080, 0x3FF6CA14,
    0x9F269C74, 0x8A48070B, 0x3BDF51BD, 0x85932156, 0xA7B6F9FF,
    0x80554507, 0x43820D97, 0x59B7214A, 0xFC3ECC27, 0xED39DB19,
    0x2B9BDB43, 0xABD4E298, 0xC2C5953E, 0xD3DB0C09, 0x66EC81DA,
    0x7F41EDE1, 0x5146E8D7, 0x49171DF2, 0xB334BF9A, 0x3AADC9E6,
    0x56E12468, 0xA2D4B032, 0x662B1F49, 0x9C448B1F, 0xA219526C,
    0x56D66A27, 0x41609345, 0x8E685EFA, 0x392DA3A4, 0xDE58C26B,
    0x9C779FC9, 0xCA834F65, 0xA1E34DC4, 0xEC5BE6EA, 0x3737B7AB,
    0x2E9B7D0A, 0x929E96B9, 0xE38B0019, 0xC1E4115B, 0xD8141740,
    0x66977F67, 0x7D4CE4B3, 0x245AB554, 0x26F98B88, 0xEC78F24D,
    0xE1F34C1A, 0x5737AD34, 0xC1A19AC6, 0x3291E363, 0x4E824FF3,
    0xAC42BDF3, 0x7C2DACE8, 0x8D5C97F6, 0xD120875, 0xC4E5C39D,
    0xE22AE85D, 0x290FF39D, 0xD495E52A, 0x95414374, 0xD65757A6,
    0x1E7657F9, 0xF5073D56, 0xC2AA7589, 0xC166A0B3, 0xA0DF8CDE,
    0x4057EAE5, 0xBAC4DD2F, 0xB51F621F, 0xA96F90E3, 0x392B5D6F,
    0xC31E9CA1, 0xCCC02FD3, 0x5181074, 0x7BC15C18, 0xCA9232A4,
    0xD1D104E9, 0x5F0C5D3, 0x4947F6D2, 0x3C923E97, 0x6B486C35,
    0x9C8ADA96, 0x175C4D87, 0x39A1A0FE, 0x417F201B, 0xD080E114,
    0x4847B147, 0xFD634E49, 0xBC0BF4CA, 0xECABB1DF, 0x869B0263,
    0xCD797C28, 0xD2A4683, 0xD50F6A0B, 0x2CA40138, 0x8DA4EB55,
    0x5D198E5A, 0xA98DB40D, 0x96CA0E68, 0xA8D92294, 0xC4813E60,
    0x81CD6B09, 0xEBBEBF80, 0x6777688, 0xCDAF6EC5, 0xEB85653E,
    0x3BB780DD, 0x73718A21, 0x70E8A324, 0x654DE06A, 0x2CB2494A,
    0xFC1DA829, 0x64059A2F, 0x61CE9D0D, 0x5BC51CAB, 0xDF7DE6AE,
    0x1596B477, 0xB0F9EA86, 0x9D87D85B, 0x877620A7, 0x586F3AD6,
    0x96AE645E, 0x65E9D5D7, 0xDB69CEB, 0x2753EF35, 0xC226F633,
    0xBD373F9D, 0xF2A0E198, 0x4372EEC3, 0xA66F7010, 0xD30E1D18,
    0x152C0DFB, 0xEB86FC75, 0xC208FE7E, 0xB36625A4, 0xBBE2DE8,
    0xEC49F9C9, 0xCE724FFE, 0x2D509471, 0xCA6C24B6, 0x1BA93DDF,
    0xEABE9550, 0xB512D359, 0x83F76766, 0xC8267976, 0x7E50802B,
    0xE3EC2199, 0xD3269B8E, 0xC515B0CE, 0xB5752537, 0x70474BD,
    0x7F50EBE, 0xF9FC0B38, 0xD899D19C, 0x317AA41D, 0x6B706374,
    0x66479538, 0x560455A3, 0xD770DD85, 0x55BB61BD, 0x6DE6723A,
    0x3F89034B, 0x9C9650BC, 0xE569992C, 0x7B8F4D95, 0x3FB7C516,
    0x7C28C04B, 0xA12DE6B9, 0x8CFC5AFE, 0xA734A25A, 0xCF1483E8,
    0x1AB22339, 0xAA94F43F, 0x16319A1E, 0x2C9AA4D0, 0xE9D2618,
    0x790B699B, 0x3AD9C3A1, 0x55A778DA, 0x6517152F, 0x2139AB74,
    0x12F762CC, 0x4BE02E6F, 0xE69400F7, 0xDC48DCD0, 0x563DB028,
    0x32299125, 0x7C9145A9, 0xFB88067B, 0xF070F6FF, 0x3D9A42FF,
    0xC5D20DC, 0xF96F7EE1, 0xA9C209A3, 0x9A192F36, 0x3E158AD,
    0x1265DF79, 0x2E49E297, 0x99D3A002, 0xE6AFDDCB, 0x3B56751D,
    0xB248A31F, 0xE6BE0FFD, 0xBBAB635E, 0xB383C45C, 0xA9DC9F2D,
    0x735CE03F, 0x69992E32, 0xD1E6A77, 0xE38A7F46, 0xC1E59620,
    0xFAE7F99A, 0xBDFB440C, 0x9F53F99C, 0x224EA340, 0xAB5D1AF0,
    0x35F3126D, 0x99430549, 0x83E12C62, 0x6403957B, 0x7B119103,
    0xC8382BAB, 0x99A85991, 0x9BF370AF, 0xDFA83CAF, 0xDBEC2CC3,
    0x416D8EBA, 0x774E58FF, 0x29C222F, 0x3DE60561, 0xDF038931,
    0x8297C377, 0x9867C08, 0x58ADEAED, 0xD88F0856, 0x6E4C2A39,
    0x2599DF28, 0xD7A6D06A, 0x433B35BE, 0xDAD3175B, 0xC358D423,
    0x84BF4580, 0xE7D3BE65, 0x9EC8CDBA, 0xCE901946, 0xC4B4D088,
    0x98B1245D, 0xFBB0CC10, 0xE8CB9C76, 0xDE665AF2, 0x28E46D8B,
    0xF7012A56, 0xE29F8C07, 0x8BF87AFB, 0x2907C051, 0x820923CB,
    0xC3E95542, 0x6AB5559E, 0x314BD068, 0x1CEB5637, 0xD1D830D,
    0xC442D6C2, 0x5F6074F4, 0x37F08A2A, 0x21F782BE, 0xF378B1AE,
    0xB7FC74DA, 0x4ACB450F, 0x365F3092, 0xFB0C842C, 0x5DD80554,
    0x741C4F79, 0x290716E0, 0x76E56BA9, 0x10006310, 0x42A183C7,
    0x5F1FB962, 0x8DE2BA39, 0x6176B6D9, 0xFC059A44, 0x9907DE39,
    0x71A5EA7B, 0x42309616, 0x1DDE34DD, 0xF0DFA4BF, 0xF69B5E2F,
    0xD145268, 0x49A3E7B, 0x90508840, 0x861DE564, 0x904730CB,
    0xC844CD6F, 0xD5A2CEB6, 0xCE895F0D, 0x73EEE4D6, 0xEB4565CF,
    0x533ED4ED, 0xF4AAB655, 0x591BC278, 0xBD1D929D, 0x80AD7DA6,
    0x527B3C51, 0x40F627DD, 0xDA420FFD, 0xB9A6F685, 0x5F6D9BC2,
    0x4F67DE58, 0xFB5F87F0, 0x47540936, 0xB2083BC8, 0xAD48DD69,
    0x63F7CA5A, 0x28D5372D, 0x61DA54B0, 0x7DA88170, 0xA2DA7B83,
    0xE1D70E32, 0xA3ADEA46, 0x97026868, 0x60FA4303, 0xA4104416,
    0x3DB4A8CC, 0x72F0F53B, 0xFF270297, 0xD5600E97, 0xD7D25D62,
    0x46DBCAC5, 0xFD61775D, 0x93E100DB, 0xBFE0E0C0, 0x8CE51426,
    0x8216C272, 0xE7300A56, 0x5A61C30E, 0xA7667C78, 0xBD23D39B,
    0xDC425756, 0x7AE9A42B, 0x249E8C42, 0xABB91D5C, 0xBD1334D5,
    0x8BCE967D, 0x5CF89EEA, 0xDB125339, 0x225E3C4C, 0xC5DDA12,
    0xA92903F8, 0xF2F29634, 0xD2AB3419, 0x396DAE59, 0xA02C965E,
    0x450B8DEF, 0x1E4911B2, 0x4F94BA94, 0x6802E7C0, 0x779671B7,
    0xC0B06A93, 0x65BF0119, 0x3D672B7F, 0xE7E68CA, 0xF173FBF,
    0x503C50F4, 0x3D8CA779, 0xD9BC10B2, 0xE6B89F78, 0xFC04B6F2,
    0x74B0E1B4, 0x3BB8594A, 0x5866C0E6, 0x125FBE40, 0x21239465,
    0xC00E2791, 0xD7957B76, 0x331D18CA, 0x87D0C340, 0x8D7347DF,
    0x296D2AA1, 0x8EAA71DF, 0x1D477388, 0x4F666705, 0x211D2B0D,
    0xA41C0741, 0xD8F7CEEC, 0x4C6EDC5E, 0xFE5DC02A, 0xAA83AED3,
    0x9AE501A6, 0xFF82168C, 0xDC638114, 0x4C345BA0, 0xDD7E0F1D,
    0x4C072ABD, 0xFF606768, 0x3CE74279, 0x93DED13D, 0xAB7A9752,
    0xAF27666, 0x784EDE4F, 0x7F4BE8A7, 0x9A45141D, 0x69E507FF,
    0x78BAC3AC, 0xDB2A62AC, 0x52561515, 0xA9DFA9A8, 0xCC51778C,
    0x886CC6A, 0x5246AD23, 0x68A7480, 0xBC267A85, 0x1FF771F4,
    0x5199BC1E, 0xF8CCD05A, 0x7BD65764, 0xC61A33FA, 0xC9F24B8E,
    0xBC0B1D9F, 0xE43E103, 0xBE3D7AAF, 0x39154AD2, 0x941C2098,
    0x1C26174D, 0xC63D21F1, 0xFBC6D732, 0x8C43AE71, 0x1495C044,
    0x9483EE96, 0x909A94F0, 0xC1B02D9E, 0xDF9A2114, 0x2F4883E9,
    0x4806958A, 0x209A2722, 0xFE514205, 0xEB85D85F, 0xC25BED82,
    0xEB2CEABE, 0x8B2A2EDA, 0x68641725, 0x10570304, 0xE53EE68B,
    0xC43FB1C1, 0x8F763232, 0x41ECC1D0, 0xE3E44CBD, 0xA1A68EC0,
    0xDAFA770A, 0x6996A5A8, 0x38407C06, 0x4FAD77B4, 0xE30E2912,
    0x47EE2FD, 0x2CDA167F, 0x88F915F1, 0xF3DF6195, 0x530FBEDE,
    0x2CFC1C0C, 0x47B21171, 0xDEC1A586, 0x2031A43A, 0xDAAD77AD,
    0x8BE637E6, 0xA6AC1EBB, 0x6AB9F2A3, 0xBFB5ED6C, 0x15792C44,
    0xFD3AB89D, 0x27A7E24E, 0x3E76999F, 0x77EE2E6A, 0xE505F3B7,
    0x429839A6, 0x6BEE7B15, 0xF61F0084, 0xFC20752C, 0x4BF79989,
    0xC8B4F8E8, 0x46B33427, 0x9F4BA3E8, 0x41B9354D, 0xEED27E23,
    0xA7FC575F, 0x279180C5, 0x141C3A06, 0x2C2FCEF9, 0x4403AA1F,
    0xD4496B6C, 0x25C33091, 0x452C754, 0x80534A0, 0x80842F72,
    0x3DB756B1, 0xEFD010BD, 0x1DE7F9EA, 0x5F9B1769, 0x55D9839F,
    0xD5B11F46, 0x941D69AE, 0x8C4F3D35, 0xE710E268, 0x2DFBC983,
    0x5D417C19, 0x7C2561F9, 0x25415FCF, 0xF331B119, 0x235B632F,
    0x9B1463A9, 0x8249E513, 0xB6F14826, 0x1005E62C, 0x2B1B4F3E,
    0xEF793550, 0xA90F6AA2, 0x77BFECE6, 0xA6E1C13E, 0xBCB6E143,
    0x2496D0ED, 0xF4A8D5F0, 0x29C27A0C, 0x7D231D55, 0xB8526623,
    0xDDDCB82C, 0x2A18B465, 0xB5FD564D, 0xA9647CB5, 0x4300919B,
    0x9FB2B27A, 0xDB25B0D9, 0xBB5D5711, 0xAA747FC4, 0xAA831194,
    0x9603ED14, 0xAF921A0E, 0xFA1447D7, 0x8B766768, 0xE8F1C89E,
    0xB7985D4, 0x6C5C1AEE, 0x2EA66EF3, 0xD176E7D9, 0x228CD940,
    0xD90C84B4, 0x36253A66, 0xADD7AE4F, 0xF25D5CA5, 0xD34F702F,
    0xA535AA29, 0xFCF10FB, 0x3D075696, 0x63EF7EF3, 0x81554091,
    0xC7EEFC78, 0xE0DCDB21, 0x62EFF001, 0x9ACFD7CD, 0xAEBA43ED,
    0x371BA99B, 0x508B7A31, 0xFF447B05, 0xA239F5D2, 0xA5620A57,
    0xA16B995A, 0xC334401E, 0x535F51AB, 0xAEA26D82, 0x81D72269,
    0x3C0BA1D2, 0x80590850, 0x818A26AA, 0xC43E6B02, 0xF72DFB63,
    0xE7AE3F6A, 0xD31AB683, 0xB99D787A, 0x691FFB53, 0x37EA1E35,
    0xC2C9FFF8, 0x2A13F6D4, 0x4CC79564, 0x6DD5F2DE, 0xC53560B,
    0x5A562B6F, 0x3F2C49F1, 0x6953F4CC, 0x8BA12AF2, 0x98A08428,
    0xA1EF80B3, 0xA977E388, 0x1A3DD9D1, 0x687A3424, 0x2759B568,
    0xC626A765, 0x7887651E, 0xFC9005E1, 0xE84376A4, 0x387BCF66,
    0xF7AA4980, 0xBAEE372C, 0xE89CF460, 0xA275FC1A, 0xA5EF8668,
    0x899F85CE, 0x9CB086A3, 0xF16158AC, 0x4C49EBC0, 0xDCE10FAA,
    0x4B46ABDA, 0x56947FA1, 0xAD4E7245, 0x54C23373, 0x8B0B6C4D,
    0x82590F05, 0x5E292D4C, 0x277B63C5, 0x9D51D8CF, 0x86D379EF,
    0x52CBEF63, 0x7A62AF4C, 0xAC1FA33E, 0x25D454AE, 0x1CDA792D,
    0x17434813, 0x759F50A7, 0xEEB0D38A, 0xB30964A6, 0x941230A0,
    0xA464FA3C, 0x9F8685AF, 0xB9A018F4, 0x8080362, 0x2D565F63,
    0xAB60790A, 0x67252A3C, 0x1715B01D, 0x5384E7F3, 0x79299519,
    0xA9786ABE, 0x1107A1FC, 0xE0D9B037, 0x4DD34883, 0xA7D476E3,
    0x5B194AE9, 0x89E50FB1, 0xA9676565, 0xC77CF621, 0x93612BF2,
    0xE027B80, 0x359C7FBF, 0x39B166FB, 0x1F3B28DF, 0x2848DE70,
    0xFFE261DD, 0xB78D413C, 0xE011DD7B, 0x286F752B, 0x74A8D775,
    0x5E540B67, 0xFAF973F, 0xC0035501, 0xB0F16059, 0x1C981017,
    0xD4871112, 0x9745C0BC, 0x6D85B805, 0xA40253E8, 0x2B0D55CD,
    0x8FF7EDC4, 0x47EB4ECB, 0xC41A2F17, 0x41C9702F, 0x8549DEE0,
    0x865FD46C, 0x64A1F181, 0x24E64D11, 0x13337A33, 0xE8CB0924,
    0x8A2DC003, 0x113C04C7, 0x1CA62E13, 0xC360E708, 0x57DE03AB,
    0x4D8F2BB5, 0x2CE2E2A1, 0x2580C90D, 0xBF162A7C, 0xEB1490A8,
    0xBCABC2A7, 0xFBC4C25C, 0xBC83AB6A, 0x25C47DCB, 0x8FE447A9,
    0x2C0F77CF, 0x6D896845, 0x63CEF5AE, 0xB2FF0326, 0x14D71520,
    0xA1C15C8E, 0xE53550FB, 0x676B299D, 0xC20A5C14, 0xDB3EC54,
    0x359733CE, 0x8A619B1E, 0xCDB53E, 0xD285EED5, 0xA6E0181E,
    0xB81AA3EF, 0x41F8E1A2, 0xE3DEDC6D, 0x4F7CBE5B, 0x24006857,
    0xACB9B719, 0x4E725B2D, 0x8536AF54, 0x329509E7, 0x72E7C0A7,
    0xBA97CC78, 0xD822798F, 0x9DFC6780, 0x63E263CA, 0x7B2397A5,
    0xA42C0C0B, 0x1D5EC588, 0x292F1E7C, 0x2BF5A75, 0xFCD8786B,
    0x14EB1952, 0x84031982, 0xA0800A40, 0x629C9211, 0x3B17F481,
    0x50861D9D, 0x8371A304, 0xB3D21511, 0x720E2C6C, 0x5A07F87E,
    0x868F95BD, 0x8617E7B, 0xD7762105, 0x90707C5A, 0x777473F4,
    0x67737DC4, 0xC4154562, 0x1840CEB3, 0x373635EE, 0x4E6D4EBA,
    0x1736A5EC, 0x4D3E335B, 0x59FDB9A1, 0x9162B39A, 0x3F9E1502,
    0xF661B3DA, 0x77BE0255, 0x65EC8603, 0x21FCA0B, 0x55291C5C,
    0x69F57B1, 0x5DE1E0D6, 0xA6296E1D, 0x595A45F8, 0x90B166DF,
    0x61ABB34E, 0xC6D48B5B, 0xB05EF88F, 0x368B0C6E, 0x94C36250,
    0xB435D440, 0xEFB62847, 0x1473E647, 0x9A101218, 0xC7AA11BF,
    0x80C241E3, 0xAF648F26, 0xDF48753D, 0x7073509A, 0xAB52665F,
    0xD1ECCFC0, 0x7BE293F1, 0x396CA014, 0x84336AB9, 0xF9B7E448,
    0x9566C90E, 0x239F7C25, 0x91A452B3, 0x1E9A4F1C, 0xCCE286F6,
    0xF46520D6, 0x2943A671, 0xAAA30DCF, 0x28D190CE, 0x88E3D0C9,
    0x423944F0, 0x81E6712, 0x2714B6B2, 0xF927748, 0x59A5430F,
    0xCBA530A9, 0x91E12A0E, 0x92598CBE, 0xE61058F5, 0x2604B4B,
    0x4CB7C3A7, 0x43B5812F, 0xFD90660, 0xD73DF50D, 0xAD3AE409,
    0xF74D721B, 0xCC2A88D1, 0xCED79510, 0xE64714DD, 0x3BDF0A8A,
    0xC2C7B689, 0x25B387D8, 0x968DA1A2, 0x8EA5D185, 0xF05F03E1,
    0xFDDC5B50, 0x78AECEF, 0xE32FBBA2, 0xD512F0AD, 0x5410D1B5,
    0xDBFD9FFF, 0xC0F2DD4E, 0xF66F8DBA, 0xF5EBA3C8, 0x65F96FE3,
    0xF7C8962D, 0x8E48A78, 0x255BEDC7, 0xE8FD3698, 0xFD1C4903,
    0xFDE9830, 0xCDBCF434, 0x16540D39, 0x418EF731, 0xB2F80637,
    0xDFCC0C9D, 0xB53DC5BC, 0x5A68B10C, 0xC4DCB3DD, 0x8B3778F4,
    0x7788B194, 0xECBD4903, 0xFD390223, 0x79598BFB, 0xBDECB9D9,
    0x29576BE3, 0x220F82A5, 0xDBB262F6, 0x1876EF0, 0xE2D9C444,
    0x32D5ADEF, 0x5F8739ED, 0xAF427122, 0x171E7D7D, 0xA5468BB4,
    0x94451936, 0x51565032, 0x3CE3CD5, 0xF231F54, 0x98614C6E,
    0xCE18455D, 0x958D2BD2, 0xA5934FE0, 0x3543931E, 0x77D9C2FB,
    0x3D3ED736, 0x6762E077, 0xF1B052A, 0x88AF353B, 0xB2A38925,
    0x8C919686, 0x715EEAAC, 0x34BA46DD, 0xEB486F1C, 0xDF58D7CA,
    0x90B97BE6, 0x37335293, 0x499414CC, 0x7F725BAF, 0x5ABEBF8,
    0xE9344F69, 0x1C110FD, 0xA937AD4C, 0xA7CDD9C0, 0x750FD5FE,
    0x7A7B6D40, 0x41EA948A, 0xA10EE17C, 0x7689C967, 0x9F411C02,
    0x6C40C3FD, 0xA6FFC648, 0xC6D6F914, 0xA100AF92, 0x4CD97ED5,
    0x17D9CCBF, 0x915833F, 0x788D78C0, 0xC81903A3, 0x6DE5BAF0,
    0x3E4D6DCC, 0x98415810, 0xEC23B7AD, 0x822471B0, 0xD2CF5D5A,
    0xA1BACAD5, 0x40843135, 0x430135A, 0xA7655BAD, 0x7A2472BE,
    0xCC3D44CC, 0xD1BC9E10, 0x7C215C92, 0x717FA7DD, 0x7EF7D128,
    0x1BC85798, 0x7C6E19CA, 0xE3FAB7E4, 0xBC884D38, 0x3E220CA,
    0xE7AE4D8, 0xC8EDD021, 0xF3F05D3E, 0xDE302EB8, 0x40CEFF27,
    0x56C0550A, 0x96162C92, 0xC004EA48, 0xE0C29A65, 0x496AE22B,
    0xC7468E6F, 0x8E31BD1F, 0xA53763CF, 0x166CC258, 0x1A2B9CC4,
    0xDBBADE7B, 0xF8D21AC9, 0xB21CA593, 0xB92F0DEE, 0x9A4391F,
    0xCDB4D373, 0xB687B3F5, 0x877BF0A0, 0xFD7395DD, 0x1C56AA87,
    0xCA146BB9, 0x21A2314B, 0x8207A2AC, 0xAA874DC0, 0x4F404E64,
    0xB69FDE48, 0x324FD456, 0x45F19CF, 0xFC7E6D0E, 0xC8A01C04,
    0x76C63378, 0xC526F7B3, 0xFDCD2EEF, 0xFFB2F9B9, 0x2DDE75AF,
    0x5ADF2F86, 0xC9AC84D3, 0x70FF53A0, 0x3FB077C, 0xC2795B30,
    0xF5438170, 0x557D7080, 0xB784684E, 0xCD089E1D, 0x332B71B0,
    0x493C3C2A, 0x1D1DED89, 0x8240E170, 0xA7D17522, 0x48C542AD,
    0xCB357D8F, 0x21E37C1, 0x3B000B34, 0xAAAE4818, 0xCD1EB4B3,
    0x1736CA0E, 0xDDF8EA2B, 0x76E21C4C, 0x6EE99A3C, 0x27F71B20,
    0xF6AE929C, 0x3C9CAF6C, 0x5CA7DA97, 0x8EF033C5, 0x8C7EC36B,
    0x3CB1CFAD, 0x1C5ABBB7, 0xDEF7A78C, 0x9CBC4A73, 0xB3871393,
    0x8C61DF59, 0x54DF941C, 0xCDD23FE8, 0x758EAD7E, 0x49BE795B,
    0xC960C6B, 0xE9B76479, 0xC88843F7, 0x82DC3137, 0xEDEE1A1E,
    0xC6568A7D, 0x42F7F484, 0xA6115655, 0x494779B5, 0xD95FE16A,
    0xB2AB15F4, 0x64C185B3, 0x9A46066E, 0x8BAE077E, 0xBAAE323F,
    0x79A965C6, 0x764B71F0, 0x3654F6D3, 0x96B4B2AB, 0x15C2B523,
    0x720AF416, 0xE6D0F423, 0xFAE44868, 0x6E776BC2, 0x264D41A8,
    0x3FE4BEE, 0x1598B97B, 0x15A70419, 0xA13CD124, 0x751A09E2,
    0xF7F7C12B, 0x718AC211, 0x11D03CD1, 0x2F9247BE, 0x77C210E1,
    0xA2268AAB, 0x2E99F0DD, 0x949D5CC5, 0xA8A309F2, 0x749EC6BE,
    0x5BD5124A, 0x8BF599E9, 0x3919AD4F, 0xA40901C2, 0xA1D4CC03,
    0x6ADCA36F, 0x9D5CCB0F, 0x870E2A58, 0xCEBC6333, 0xB2FA28A4,
    0x579C76A, 0x444849D0, 0x33887308, 0xB3BE3C75, 0x93745501,
    0xC289F137, 0x89739C7, 0x97C73423, 0xD627FB64, 0x6EE36F05,
    0x1F4B4B98, 0xFBB7A8AC, 0x60941E62, 0xC3A8ABDC, 0x4AC5E7C9,
    0x88ACE940, 0x5AA2AE59, 0x9F10C0B7, 0x8F45920B, 0x5FDE21BE,
    0x1D47779A, 0x3ED27D8B, 0x69FF2BB1, 0xCB1409FB, 0xF27F4FFF,
    0xA19E3DDC, 0x206050FD, 0xAD98C2D5, 0x4DA4BC0C, 0x95D9B019,
    0x556ABBFA, 0xBC78B5A, 0xF0F224F8, 0xA9785F8F, 0xED1CE98C,
    0xD368072E, 0xE212ACE5, 0xBB7F76E0, 0xB02F237F, 0x6D85C5AF,
    0x31539988, 0x4312BA19, 0x1D5023A7, 0x7320504B, 0x70563ABD,
    0x2553791A, 0xE9768150, 0xC1B2AF4B, 0x3AF0FD24, 0x3818D0E8,
    0x7F356F58, 0x98A15B0D, 0xAFA943C4, 0xB2B38831, 0x2E411F37,
    0xE3D5AF87, 0x67BEEC5A, 0x825E60CC, 0x1C44D856, 0x1A59493A,
    0x13BAABCF, 0xAEAA4D44, 0x5CFF2A6E, 0xFB47865B, 0xE778E607,
    0x101500E8, 0x2C17E66A, 0xA0B30350, 0xFC649CDF, 0x8B9802D9,
    0xAB87D61A, 0x21F38439, 0xD3D11051, 0x1FDA9955, 0xCB9313B8,
    0x327D1A94, 0x35293099, 0xB803B298, 0x5B8E6883, 0xFA309C3,
    0xDFDA8B2, 0xDF89211F, 0x9918F18E, 0xF0C05CB1, 0x71D8A4B7,
    0xE681031D, 0x537012F6, 0x4DF822F2, 0x34B75C8C, 0x4429F85E,
    0x5D3C4C4D, 0xFB0FC6C7, 0x25F4ECDD, 0xB19D5EFD, 0xD70FD7CF,
    0xD95C45D5, 0xCDAC06B8, 0x9C3B963B, 0xAB2F2A9C, 0x4D3D4F7D,
    0x12692C03, 0xB1AEF97E, 0xF243EFA7, 0x78C4C8DF, 0x182D9C17,
    0x8D2AF450, 0x7596BD9B, 0xE8E7C9C2, 0x86F617F8, 0x1F37A708,
    0x3F648305, 0x27FF6DF6, 0x4D5FF17D, 0xA9541C2D, 0x9773013,
    0x78B2313C, 0x82C0B20F, 0xD36A4F02, 0x8DB2BC4F, 0x9296D8BF,
    0xA983CC7, 0x31AEE908, 0x48CD7E6F, 0x9CB1DD7F, 0xAB89D57,
    0x5156132E, 0x6345AA59, 0x8D2CB12D, 0x94D3AE56, 0xA4E91B27,
    0xEE58338, 0x8620EA15, 0x5454D04E, 0x1142ACF0, 0xCA059044,
    0x31811D8A, 0xD498290, 0xB65F1B67, 0x462745F3, 0xA899191C,
    0xB9C19F48, 0x824659FE, 0x9A257101, 0xC330F34B, 0x42109127,
    0x9DA8504B, 0x6C3A989F, 0x5F426E6C, 0x2B922D32, 0x373C66FD,
    0xAFE3418B, 0xE3788682, 0x83B46626, 0xD0106A4E, 0xFD10B903,
    0xB0F6531C, 0xC65419E0, 0x3963952B, 0xB8799DF9, 0x3EEB8C1D,
    0x5C4D3C08, 0x6DD028A6, 0xA55678A0, 0xB8247141, 0xC1267586,
    0xF6746B19, 0x46C38465, 0x483D24B, 0x99BF79DC, 0x78F778C3,
    0xAFF40193, 0x58872B07, 0x6DA7F4FA, 0x66B5CEA3, 0xDD2D8C79,
    0x2A8D289B, 0xB5789670, 0x66AEFCE3, 0x56FB52B3, 0x20FE3BE1,
    0xCCDFB492, 0xB0F263E8, 0xD0707433, 0x5E58F5DC, 0x4ABEBE63,
    0x8A45CD95, 0x97037830, 0xBDB1F1B5, 0xA1BE2990, 0x57B718FA,
    0xD50EC023, 0x810DD849, 0xE650D43F, 0x3895C77D, 0xE142C382,
    0x35551E5B, 0x3B94330, 0xE92D8A91, 0x50BC837D, 0x61499A8F,
    0x2639B468, 0xF8FF36E1, 0x74956FC6, 0xFF0F4192, 0x6BBA0C53,
    0x5B44FF85, 0xBBE4A1DF, 0x12D6CB14, 0x6C679A10, 0x3C0F554D,
    0xECBADA32, 0x8A99BA10, 0x738C03C4, 0xB8902AC3, 0x7008D470,
    0x49BC2ED9, 0xFBE19B5A, 0xA1E4879A, 0x36129694, 0x94987C3C,
    0xE54B84D8, 0x9CFAEF1E, 0x527127DC, 0xA8FCAE0, 0x8699252C,
    0xDAAD4629, 0xC41F3866, 0x2559C272, 0xB1C25848, 0x3F9B1702,
    0x7C448BF3, 0x8CCEDF5C, 0x3A37F712, 0xFB9E4F83, 0x5754E801,
    0xB38FD367, 0x780F4825, 0x959330C4, 0xF6276BE5, 0xAE3E2018,
    0x182DC907, 0x88E733F9, 0x6FF870A, 0x79EF2D01, 0x3EAC0D6D,
    0x20D4FF88, 0xAE6EB8C1, 0x80810451, 0xC228E035, 0xBD942803,
    0x3F3733F2, 0x9F8F16F6, 0xAAA65031, 0x55E839BC, 0x7EAD3461,
    0x5F5BEE8A, 0x8668BDBA, 0x399366DB, 0x2A54237E, 0x776789E,
    0x7B171AF5, 0x8C9FCB92, 0xD87465F2, 0xFA3CAAB5, 0xBA5B131E,
    0x1FD2D438, 0xDCAA9DA, 0xE1BF0AAA, 0x1EAEA8AE, 0xEB46A646,
    0x989D1EA2, 0x98E8B45F, 0x12A2415B, 0xD107D293, 0x5F54D087,
    0x95AF5C33, 0x2A12BA88, 0x6381D0FF, 0x688EA1E0, 0xACC60CA2,
    0xF19636C6, 0xD4D465E2, 0x2A50DC57, 0xFB595CCF, 0xF5C63674,
    0xB4965626, 0xB903D3D0, 0xD9581548, 0xBBD9E82E, 0xE22BCEF3,
    0x9FE759D, 0x6E8D8F4E, 0x655325D2, 0xE1986814, 0xEA2B93BF,
    0x88085C18, 0xF82BFCB0, 0x3FCF713F, 0xADE03EDC, 0x2D2DDCBC,
    0xEDE2694E, 0xF6DFB11D, 0x5CF35A5A, 0xD38C82D3, 0x52DE32CF,
    0xB88EA70E, 0xF7FB134F, 0xAEC78D1E, 0x58402C66, 0x54CD1763,
    0x78A7EB4, 0x88F49C30, 0xDC17F8C0, 0x9C49A368, 0x926E18EB,
    0x4DD461E1, 0xA6BD8F3C, 0x6D2E4C31, 0x657506D9, 0x445EF83F,
    0x77E28461, 0xF715400F, 0xBB76D1D, 0x9B670CD2, 0xCEB9EB90,
    0x7F297088, 0xD3929A52, 0x9B62909, 0x46474012, 0x3D74DFDF,
    0x46288EF0, 0xF0C51C07, 0xEC642B66, 0x3C76B83C, 0x1E72D08F,
    0x9F95DC1E, 0x106883C5, 0xB6A867BD, 0xA532C423, 0x95076036,
    0xA9DBEA73, 0xA3F8C65D, 0x799CF6BF, 0xA4508346, 0xB37CACB2,
    0xF6A07B5A, 0xA2C24137, 0x2E1D8DEF, 0xD28C26AD, 0xCE745089,
    0x3B7D9638, 0x7189CE82, 0xBC3F7850, 0x5660A9B8, 0x13895B5C,
    0xFA59A643, 0x9B0FF4AF, 0xFD2B4FD3, 0x4C0C4E52, 0x272631DE,
    0xA52FAE47, 0x65850A25, 0xD51ACF2B, 0xD206E6EB, 0x3CDC96EB,
    0xA6FF9E3A, 0xFC601E27, 0x658EF7F0, 0xB45FF508, 0x36A9A571,
    0xCE75E7E9, 0xC4BF9261, 0x3A261099, 0xF1B1CE3E, 0x3D28A165,
    0x3435D2FF, 0x70830AAE, 0x8DFE14F7, 0x3E27CDC1, 0x97BE4BA1,
    0x33F8D0E2, 0x9B2E7BCD, 0x1923B1C, 0xAA248E78, 0xFDA8AEB9,
    0x7825E511, 0xBF20B777, 0x218E4234, 0x7B5D1181, 0xA08988A0,
    0xD9009231, 0xEB15A567, 0x47E045A0, 0x3C515808, 0x35194ACB,
    0xA476304A, 0xEF738BD6, 0xD035FB8C, 0x3B2013F4, 0x4DE60F26,
    0x361431DC, 0x82ECB228, 0xAB22266, 0x4E056EEE, 0x6642D288,
    0x48D851E3, 0xE05D55D9, 0xDC2D6D4F, 0x158F7F48, 0x5D7F7D5A,
    0xC2835158, 0x793509C5, 0x479DF33C, 0xDEF0696A, 0x9FC2BECD,
    0xF4EFC675, 0xF8D1FF02, 0x493D3BD6, 0x7FA1C10F, 0x641B324D,
    0x996DBDDD, 0x24098529, 0x81CCFC35, 0x47F0BE17, 0x5E241815,
    0xF7F62788, 0x261CDAF5, 0x10CBC4B8, 0x5D6C6A7B, 0xD671AE81,
    0xB2C8DCD9, 0xD215CB7E, 0x3403AB1B, 0xA7C5999, 0x4675A50,
    0x369C560C, 0x32C619D9, 0x4FD2E12E, 0xB4A20359, 0x37E93502,
    0x5EC0CE10, 0xB374340, 0xB0DF0419, 0x5960ED4F, 0xF0A7770E,
    0x7F504F30, 0x54A92972, 0x3E9848B8, 0xCD980ABE, 0xDE69D570,
    0xA9FDFFBD, 0x9812C681, 0xDAFCCF4E, 0x2B636CB5, 0xB2B9FF2D,
    0xB9972800, 0x701231C6, 0x2E1108F8, 0x8C323A3E, 0x20A17A77,
    0xF2C6CC7, 0x44C5FD1C, 0x731622D4, 0x9BF0C91E, 0xB61CD1B1,
    0x61FA9CF2, 0x5E460518, 0xF75A1C06, 0x417CCEE2, 0xB45E0FB5,
    0x53DC30E8, 0x500CBD7F, 0xED61DAE3, 0xEFE91818, 0xB56814BA,
    0xD37D84C8, 0xD5DA9ED7, 0x5F40F92, 0xF1507FAD, 0x2CC74A65,
    0x32AA6279, 0x33731317, 0x30E09F03, 0xE1D9C403, 0xC21E638A,
    0xA7394D05, 0x3879F710, 0xDBB52C37, 0xB7780268, 0xE268E178,
    0x9F8072D3, 0x97CC035A, 0xEE65287D, 0xA197441A, 0x21C8AFA4,
    0xB81B50A9, 0xAF6ACC93, 0x7BB55B77, 0x564A0BD4, 0x17F7A6A9,
    0x36627846, 0xDCE746EA, 0xBB9762DE, 0x47B5B8F0, 0xEF5DA4AD,
    0x1922E420, 0x15F9299D, 0x243DAB0D, 0x953C67A3, 0xF3DA71D8,
    0x57122A3E, 0x423A78B, 0xC4A53000, 0xFBE92583, 0x968F3AE,
    0x61629123, 0x792FA07B, 0xBF45729D, 0x99DDD38E, 0xA14565FC,
    0x268E9E3F, 0x7EC9286, 0xCCA1D92A, 0xF06519DA, 0x22396664,
    0xD5DAC24D, 0x71BB4DD5, 0x7D329BB3, 0x401DAB69, 0x19D3E40A,
    0xB6F40F32, 0xE8D1CAF8, 0x5CD5F35D, 0x6F662316, 0xD38D1A6C,
    0xF86E720F, 0xE165D1B9, 0x1BC14E79, 0xC19FB43D, 0x891C013B,
    0x44AED4DC, 0xA7351AAC, 0x5F707A18, 0x3850148, 0x4A425E1,
    0xF7DD6EBD, 0xE0C3FD0E, 0x8266A425, 0x3BA17650, 0x48753ADB,
    0x679FA015, 0x88771712, 0x2174B185, 0x29F9A85A, 0x1560964A,
    0x198E4FCD, 0xD3410A86, 0x9186793D, 0xDAFC5C35, 0x971F4CC8,
    0x1F8F0E8B, 0x11A884F2, 0x66E6D2AC, 0xE85ECDB0, 0x86C76472,
    0xDF3B3320, 0xEEF446A6, 0x834CF19B, 0xECEA602A, 0x46C680AD,
    0x807BA92F, 0x4B3FC42B, 0xEC229845, 0x3FE389C1, 0x63E042D7,
    0x6C855119, 0x7B1ADF33, 0xE1B9CAE0, 0x62C20BAE, 0xEDF0E919,
    0xA50FC7EB, 0x2399262F, 0xD6F88130, 0xE2ADA5DB, 0x7D07BC3C,
    0x36A922F3, 0x7693B84E, 0x3015CD0C, 0x1D1047A7, 0x5D3A75A5,
    0xEE6F1CA9, 0x734BD19F, 0x3308DD73, 0xCEBBC9FA, 0xF79DD5A6,
    0xA41CF168, 0xED762FD8, 0x6642159, 0xA63C5CD6, 0xCB96A282,
    0xA29D9F5C, 0x45CC6CD4, 0x344611EF, 0xC345FE03, 0xC55ADDE0,
    0xB2B8374C, 0x14F730B1, 0x301D9266, 0xA2D98FD8, 0xBC107DF,
    0x59905EE3, 0xDB3560DF, 0x1D49F4F3, 0x785F8E0B, 0x8B116097,
    0x56154F60, 0xE312D829, 0xE0AFAE9B, 0xEAE3692E, 0x95915B8F,
    0x83BEEE75, 0x48C1C92, 0x8166D95E, 0x697FECA8, 0x135DEBF9,
    0xF83E6507, 0x11570809, 0x4862CBDE, 0x820E288D, 0x6CA59B2B,
    0x49DF6AD5, 0x86F41C43, 0xDD128A28, 0x601198A0, 0x3DDD49CB,
    0x95F3ACCE, 0x500CD9D6, 0xF54A50F2, 0x9936957B, 0x7C881875,
    0x743B055D, 0x44FD7934, 0xAF2253BB, 0xA2F4A27C, 0xBA8E1C2B,
    0xCCFA3259, 0x892FC73F, 0x283E74B4, 0x86119027, 0x87961F02,
    0x1D015187, 0xBA83B762, 0x61948B32, 0xAC741667, 0xFA9E0E39,
    0xD440D9CB, 0xED93F9F, 0x5FA97905, 0x2F5F82D8, 0x92EC7646,
    0xC60B3F9, 0xAA28822A, 0x7BA7CD3D, 0x3E41A20B, 0xDE4441A9,
    0xC75E539B, 0xD9D568C2, 0x2DCAE06, 0x7762550, 0x21C2D5EE,
    0x95CB6C94, 0xE31FC800, 0x3C03C172, 0xE166E564, 0x359C5102,
    0x7F717599, 0xBE301B47, 0xB207FA5C, 0x38B8B24B, 0xE6EFF05D,
    0x9F09D305, 0x31A27808, 0xC56D934F, 0xB440BD60, 0x52B1AAC4,
    0x78654045, 0x106A67B8, 0xF2A861E5, 0xC45D72B0, 0xA8FF8296,
    0x97F475A6, 0xDC222733, 0x7A835D7A, 0x45774E9A, 0x9E558C34,
    0x1124605D, 0x1689FED3, 0x70AB9928, 0xADBF8E55, 0x9C09EE27,
    0xF95A8C49, 0x75CD52D7, 0x4FC7275A, 0xA46C29F6, 0x747D788,
    0xA3347E5, 0x5B08AB02, 0x13CDC08C, 0xEDB65176, 0x6B36600A,
    0x26F5AD2A, 0x39949D1, 0xA1C8F6E5, 0xEBF0CEFF, 0xAB60A06B,
    0x10E522E8, 0x80E056D8, 0x1B301392, 0xDC3E0B07, 0xE10174EE,
    0x25DC4733, 0xB4E5A24A, 0x4B569CFE, 0xCCFE9F0D, 0x19BDC038,
    0xF8A0A718, 0x9944E8E0, 0x9591528, 0xBF27BDF1, 0x2C160255,
    0xF9E2F1B, 0xCE4FD96B, 0x703B2A77, 0xDB6EB2A7, 0xBFC2FA6A,
    0x11D00F81, 0x9540FD8D, 0x75849882, 0x183AC87C, 0x91DD1783,
    0xA3A0CC0D, 0x47F1CED1, 0x4DA4EE62, 0x819BA59E, 0xD5DA1DA5,
    0xDC218BF5, 0x899CC3A1, 0x1DECAD82, 0x77E193A5, 0x9F390C10,
    0xF5FCD674, 0x1E43657A, 0x6B61D25E, 0x99B9140E, 0xFEFB9CF9,
    0x6569445D, 0x14C9A2AF, 0x85A33FB1, 0xE4029ADE, 0x4FABD0FB,
    0xDE02379B, 0x65C8311F, 0x3CF60630, 0xC8B179FF, 0x9D83CE64,
    0xFF683C7E, 0x6D796948, 0x249B0AFA, 0xC5A65FDF, 0x252DA26D,
    0xFE92E52E, 0x90D081E5, 0xC5A8E180, 0xEBDB0943, 0xB0E7C78B,
    0xD5A89E4D, 0x684EE280, 0x8AAB613C, 0x6BD1547, 0xD12F7355,
    0x9C5D1363, 0x91E410A4, 0xDC841FBA, 0x703A9371, 0x79F8663,
    0x553650FC, 0x633CA726, 0x20107BD7, 0x2565F252, 0xCDD93830,
    0x3446CF7, 0x92B6B42A, 0xA070B2D1, 0x5E0384D1, 0x7CC5A19C,
    0x6890558F, 0x10D308AA, 0xDFF3016C, 0x1093AA3B, 0x8927683A,
    0x9259502B, 0x2B544B7C, 0x419B1B1A, 0x22D9E939, 0x568ECCEE,
    0x4F3CE09B, 0x8B990521, 0x8D6906A3, 0xC15DEDC4, 0x98384A4A,
    0x8F2F2652, 0xEDB9D614, 0x1D010AC3, 0xA2CDC134, 0xEEE9A9ED,
    0x241DB9A2, 0xE9DB9AE7, 0x7A788F9E, 0xBD0778B7, 0x27373539,
    0x7C6B4A4B, 0x3C7A6B37, 0xDE1C625, 0xC1256E67, 0xB8E69163,
    0xCC05D09B, 0x728A1427, 0xECAC2530, 0x1DD40BC8, 0xEFE42E56,
    0xB4266BE0, 0x9AD3F869, 0xDDFC2F60, 0xEF29B3F7, 0x7C15F90A,
    0x705C2992, 0x99AC7AEA, 0xCF1F09A0, 0xB41F14D9, 0xBF3C252C,
    0xF3483286, 0xD3AC398E, 0xB84BC93D, 0x6B780D11, 0xF682D379,
    0xB8A062C2, 0x9A003A9E, 0xF18F54FC, 0xDE81BB83, 0xE84C5234,
    0x37CB67FA, 0xDB685C6, 0xBF2BF28D, 0x8CDE583, 0x94CCD0BD,
    0x8BCAF516, 0x31BE93C2, 0x3ED4B623, 0xCD23346E, 0x8254E7A0,
    0x6091EF1F, 0x17A42562, 0xC9821677, 0x447B6623, 0x19D9356C,
    0x4A1C1953, 0xD1F3B7F9, 0x99F8388D, 0x62F22304, 0x5EDF1ECA,
    0xB6C9FC2F, 0x42968E22, 0x531BD76E, 0x25E6A95A, 0xA1669784,
    0x8B915BD2, 0xA5E21483, 0x5ABE3226, 0x605C0E15, 0xFDE713CC,
    0xFAC58D3B, 0x44FAF6E8, 0x41E2D699, 0x8EE11E34, 0xB03BE4F6,
    0x75054C0D, 0x1AF2D37, 0xF38E6829, 0xE7F2A519, 0xC9CF2CFF,
    0x996DDE8, 0x395AC493, 0x42AFF184, 0xB380B71C, 0x11AA0B90,
    0x66DC636, 0x56557CA8, 0xCB8CAA43, 0x9EBF806E, 0x63F66159,
    0xA011191D, 0x17B0AED3, 0xB9621251, 0x2B189E3, 0xD45A5D7,
    0x23009D12, 0x5DEB7918, 0xFDFB1FC8, 0x46808A73, 0x91D29330,
    0xF872C15D, 0x7BE90206, 0x257E9FCB, 0x2E52FF67, 0x1852DDF9,
    0x6A2C5C49, 0x6ACF891B, 0x29FFB0E2, 0x76E32CD2, 0x588799,
    0xD71D970E, 0x9B079EC8, 0xEBD25420, 0xDDB60276, 0x761B106F,
    0x871473C4, 0xBC697CE2, 0x5378E0E9, 0x8DAECE28, 0xE5B275FA,
    0x6E6E332, 0x853884E7, 0xD0FFF1A2, 0x722D372, 0xDD5A754D,
    0x87CDDA3C, 0xA9B629C0, 0xAB2E650D, 0x1709413D, 0xDAE63819,
    0xC60DE8CA, 0x9F344BD6, 0x8E651EF9, 0x3B6A8019, 0x95CC1296,
    0xB12DAEAB, 0x8D550156, 0xF14E85AA, 0xD2547469, 0x6336E320,
    0x223B05B9, 0xB88AD493, 0xEE14916F, 0xC78AF1FE, 0x65FC2787,
    0x778FA85F, 0xBA23A57E, 0x957EA954, 0xAE4F9577, 0x47C38D4F,
    0xDB7BCDC9, 0xBA13E42E, 0x46B01094, 0x1A15F5E4, 0x315AB789,
    0x9E44B54F, 0x8C690B2F, 0xDC4954CD, 0xF176F3FF, 0x9B154C06,
    0x112BD6D0, 0xCB120BBC, 0x11101771, 0x1F29A19D, 0xC3F8193A,
    0x805D6739, 0xE3B00ACB, 0x23DD9494, 0x4F88EBA5, 0xE6F32E0E,
    0x4B76F089, 0x43B66BEB, 0xF2420B12, 0x2CFC5E01, 0x1C68D3DC,
    0x30C1BD38, 0xF3A0FCCA, 0x2AF13CD5, 0x13E38185, 0x2DEE2A21,
    0xFC318E26, 0x1954D4B6, 0x3FB86424, 0x24D698F1, 0x4AB76D48,
    0xA9E87BD9, 0xCE1DD2F2, 0xF5904D9F, 0xF614DB18, 0xF83111D,
    0x1FB56EFD, 0x5CBD08D8, 0x2D8D4884, 0xE388C534, 0x413D5BB8,
    0xEB6D14D6, 0xAE54E361, 0xF73D926B, 0x43F27197, 0x7C50A2E5,
    0x10EDBD6C, 0xD151B569, 0x47C50C06, 0x8FD59E74, 0x551C6841,
    0x2EC2B6DC, 0x5CEAB3A9, 0x1E6A1609, 0x3FB07FED, 0xC0D5849A,
    0x6354A21B, 0xEBF18830, 0x2BB3EBBD, 0x9D4DF510, 0xBBBE1103,
    0x918D6DDF, 0x3FEE7A8B, 0x4FC47254, 0xE0E1EA65, 0xF3DDB31A,
    0xADF8DE67, 0xADA31FAF, 0x2BC0B8A2, 0x184B7432, 0xFDB2E733,
    0x236B014, 0x21062C, 0x8FAAD8D7, 0xA1DA7E44, 0x3EF7F42F,
    0xA67AAB82, 0x9238F0D8, 0x42F93C63, 0xEF0F4BA1, 0xE61DC644,
    0x994EF92C, 0x71A58613, 0x371665E5, 0x82E77BA1, 0x2FFA1DAE,
    0xFE19AAA0, 0x95C72A53, 0x6A21395F, 0xC03F853C, 0xBC7B73BC,
    0xED62A949, 0x4F7D3C52, 0xCACFB353, 0xA1629BE9, 0x16255784,
    0xAE465FC4, 0xE7FC2626, 0x5E9B0FC2, 0xD109084D, 0xE30E7B89,
    0x94CD7424, 0x6127AF6E, 0x7D08ED7, 0xFA0B9293, 0x450A112F,
    0xD0D79344, 0xA204F8B0, 0x5F825780, 0xD681148D, 0x71C6AE83,
    0x1DF62587, 0x99ABC8A6, 0xCFEE8131, 0xFCD11719, 0xD0D48B0E,
    0xCC4A710E, 0x7414791C, 0x22167734, 0xD17FE049, 0x5BF15C46,
    0x30B718E0, 0x6E85104E, 0x52F72575, 0xA17F09E1, 0xCDA7B24E,
    0xDAF7D03B, 0x3632D94B, 0xBAF4E9EE, 0x390CD998, 0x168C055E,
    0xBC2D8D0D, 0x35E9F642, 0x89757E1A, 0x2BB98011, 0xC19BCD15,
    0xEEB73587, 0x6A5194EB, 0xC2C1B4BA, 0x3C8F73FC, 0x8F075D29,
    0x42D39406, 0x6674167A, 0xC0904A73, 0x1158FE6B, 0x4CAD2FAD,
    0x9A7EC8A5, 0x651960A6, 0xD0329ECA, 0xF5130525, 0xCC7C40CD,
    0x259AA3D8, 0x9669412D, 0xB92D39A5, 0x29B217D2, 0x27A07E25,
    0x9AFFD359, 0x7E8F5AC9, 0xCF7C0F61, 0x5B4F8D7D, 0x31C4E97E,
    0xBDB9599C, 0xA85BD7E0, 0x87F0BAAB, 0x2852E628, 0x377BD41D,
    0x4B54844, 0xDABF47AE, 0xA1B7AF6B, 0xCCF57165, 0xA90C4348,
    0xDC1CE2FB, 0x42582D37, 0x2892F4E0, 0xB89AC8E9, 0xB2718E40,
    0x93BCCE08, 0x5606C693, 0x1952D10D, 0x96609D8F, 0xEE3BC3C7,
    0x2DFA50E8, 0x5582FD75, 0xBDC2618C, 0xA3D922EE, 0x8F766106,
    0x184ED901, 0xDAABDE09, 0x40CBD4E2, 0x4A9A2A70, 0x9814D393,
    0xE394A090, 0x9EA06A4F, 0x2EC8C8A2, 0xFD2EAFF0, 0x2F6C96B5,
    0xBB17EF37, 0xDA677FE2, 0x2357E330, 0xA8C9DDED, 0x735A7B2C,
    0x41C2B39C, 0x787E099A, 0xFBF8204F, 0xA56A4B69, 0x7DE2860,
    0x34299BB3, 0xD1CAE881, 0x5F452DDC, 0x700904E8, 0xC3B47017,
    0xF7040305, 0x5C42BE94, 0x88AAAE53, 0x9FCAAD72, 0x2774D420,
    0xDD685357, 0x80499592, 0xC5FB26E7, 0x90BA598F, 0x4A13D60A,
    0xC6D5F72, 0x97C35532, 0x6580493F, 0x9D31E266, 0xEF926A38,
    0xF68CF9C6, 0xF770C570, 0xCA18C06A, 0xFA2BB2, 0xFBA375DC,
    0xC2FE76ED, 0xB91611FA, 0x528A8EA5, 0x360A527, 0xF631D04B,
    0xF0C67ECF, 0x4E490A69, 0x19DB46F0, 0x497DFBF4, 0x58E490FC,
    0x24A51378, 0x186BDC14, 0x90E633A3, 0x6D6F8D95, 0x2FDE02DD,
    0x4B2714A6, 0x6FC87FE0, 0x21569667, 0xDCC31F06, 0xC9D9DFD0,
    0x830AA4A4, 0x78FBFE69, 0xDF17CD55, 0x3952AAA7, 0x9A4B5A7D,
    0xB1EBF3EF, 0x4F3BC1C9, 0xDFEEBF40, 0xAB130CC8, 0x1EB84425,
    0x4625E802, 0x20B990D6, 0x4E36869F, 0x5EEC0472, 0x29194460,
    0xCA425ECA, 0xEB0742C, 0x17D07C02, 0xF38BCA14, 0xBC9D555E,
    0xF15822E7, 0x89CF96E0, 0xAA848F9C, 0x90731AC9, 0x86EECBE3,
    0x308F3257, 0x5FF375DC, 0x1E62C041, 0xFDB6A3E7, 0xDFEBED8E,
    0x8FC77E76, 0x6973E542, 0x2AD1616C, 0x99B549C6, 0xD28CF364,
    0x88C87768, 0xECA2CFB, 0xA0D0B060, 0x42DFFD8, 0xAF80A6DE,
    0xFF323760, 0x1CB2DAAA, 0xD11DE4FC, 0xEEBF565A, 0x9C986CAC,
    0xC1C95B3F, 0x6868BF0, 0xF5604930, 0x316DD9EF, 0x1231D331,
    0x95E38E67, 0x7D30C191, 0x354804BA, 0x265EE5E, 0xC6728C70,
    0xD36F32D0, 0xBBEA0ECA, 0xD055ED76, 0x9135E317, 0x8A7B9770,
    0x4D1344B0, 0xE9F29AE3, 0x7BA303B9, 0x2C38AEC, 0x82ABCBA6,
    0x7729F177, 0x71793932, 0x6FE6E38D, 0x1F8416B, 0x147D8310,
    0x6A962FEC, 0xFE2F100E, 0x4FB1D511, 0x3D38AB33, 0x58ADC416,
    0x64B07504, 0x458CC4B4, 0x584BC93E, 0xDE49B6D1, 0x7347876,
    0x4A2C3EB6, 0xDF5DE09C, 0xBFD376DC, 0xC9F451C5, 0x5F793A0,
    0x892952A2, 0x15060767, 0xE1E3B589, 0x4D513C3F, 0xAF3D2CC7,
    0x289DAA2E, 0x8C711417, 0x62E5E006, 0x3BECED98, 0x99E73ACC,
    0xDE156054, 0x1283655B, 0x5123FC41, 0x3DE21841, 0xC032F050,
    0x94B5151F, 0xA5577757, 0xCC0C8DF, 0xBDB52821, 0xD530FAAD,
    0xD070D8FC, 0x46F5BB68, 0xB02DFF88, 0xD4923EA8, 0xC85A5622,
    0x93E834A3, 0x38E84468, 0x79408C75, 0xCCB635, 0xE76BADA2,
    0xC2296DA1, 0x711543BB, 0xF441F4A2, 0xBD18127C, 0x8385BFB9,
    0xD350D4D, 0x90FAF999, 0xABD1A695, 0xFCEE12C7, 0xF428912A,
    0xC9759F80, 0x6DB6491, 0xD1421D30, 0xBC398DC4, 0xB8E0A889,
    0xC854AA72, 0x82CAAF64, 0xBB6A65BC, 0x6DCB2D0B, 0xD215ADB,
    0xF45033DE, 0xC1300029, 0x665C61DF, 0x756D1875, 0xBD2CF722,
    0xC477E3C7, 0xDDD97C9B, 0x89AE48E4, 0x65000FDC, 0x1FD717CD,
    0xBEEA764A, 0x8FC2DCB7, 0xA162EFB3, 0xD4AC2490, 0xCDA9A72A,
    0xBFB4EE17, 0x66C73CBB, 0x6B7CB021, 0xCC5AF099, 0x5389E8B7,
    0x7668286B, 0x31A223BC, 0xA66475FF, 0x9C3DDA93, 0x2F3171FE,
    0xDB89A7DA, 0x1699616B, 0xA380F010, 0xB05D7388, 0xD774EA44,
    0x64D6091C, 0xF23298F8, 0x71C88081, 0xF90C4A04, 0x2FBEEA4F,
    0x2F9178BB, 0xF8723D8A, 0x1C07FCC8, 0x36D24E08, 0xE02A8B61,
    0xFD6312AE, 0xA7DDCE9B, 0xAE45AC52, 0xCA2EC55C, 0xEEC6BE42,
    0x244F3D79, 0x994FB339, 0x8316CC43, 0xE3CEC898, 0x8D37639,
    0x833D21BB, 0x4333A2F7, 0x95F3B0C0, 0x7258174C, 0xBFCF0EF7,
    0x9A7F4883, 0x71F2406B, 0x16B2BA04, 0xE1BCEA70, 0xE3C6798A,
    0x3FBF481C, 0xF5A8D117, 0xB37ED250, 0x49AB5E0D, 0x2793A7EB,
    0x45DF69A7, 0x4EE4B815, 0x98259530, 0xC223CA40, 0xDB7B208A,
    0x4AD3C0F7, 0xE7C33E50, 0x49FD7631, 0xA228021B, 0x2C27FCB2,
    0x5F77BCF4, 0x65D593D4, 0x7C700797, 0x6E67920A, 0xEABAF033,
    0xBFC8B68B, 0x8835B368, 0x90CACC99, 0x6B90E022, 0xF2466D89,
    0x432DED25, 0xEFC94B45, 0x3116C3E, 0x1BBFBC45, 0x8FBC3D21,
    0xFB2039AA, 0x50679156, 0x450F8837, 0x73C7F87D, 0xC27898A7,
    0x7F48E602, 0x5064FCB3, 0x1EB6F58F, 0xE647C845, 0xBC8E84EC,
    0x5C4B8FFC, 0x440A88B7, 0xA490480E, 0x371DC115, 0xE1F236FE,
    0x4D65A2C5, 0xA965B0B7, 0xD05512FB, 0xDFAB9656, 0x191C627C,
    0x56B7FAC3, 0xF304A2E4, 0xC7ED6DF0, 0xD09B8C49, 0x1A1E777B,
    0xE70746BA, 0xEB582E9C, 0xFA6014DD, 0xB3B67784, 0xD3F64D81,
    0x318872EA, 0x4D241611, 0x134DF119, 0x2EA55DFA, 0x71A8D182,
    0x15AFE856, 0xD5CD885A, 0x5EA2B899, 0xF87BC7FC, 0x25DE8D6,
    0x93837315, 0x341C3698, 0x58534F, 0xF10652DF, 0x18C92AA4,
    0x17E969AB, 0xC12D08D, 0x6B0D0FBD, 0x40ACD3E2, 0x8C3AD43C,
    0xFDE55C9D, 0x25A58094, 0xBBCAB168, 0x2F06ECA1, 0x9D23A101,
    0x6F850449, 0x769C743A, 0xB63FD349, 0x3B3C852F, 0x1EC89061,
    0xFE8C7369, 0xA19C0F73, 0xB682F1D3, 0x48DAE3D4, 0x7F9FD390,
    0xEF784A6E, 0xCB23F15, 0x7BEB1E0E, 0xCBE90203, 0x6979F11D,
    0x251C50A4, 0xDAD9C59F, 0x5E4E5BFD, 0xCCD4DF48, 0x72BD66E,
    0xE7FB1B35, 0x75B4B83B, 0x29E9282A, 0x2590317D, 0x7835F9A1,
    0x25D3602C, 0xCFEC2E4F, 0x9CA2B0E7, 0xA4714302, 0x8F3D53C4,
    0xDE00F109, 0xC26D6273, 0x3E8DC623, 0xE3A972E2, 0xF67DF096,
    0x781682A5, 0x6C16F144, 0x49DC8D17, 0xB2EB82EA, 0x3CB93D91,
    0x44D4D3C4, 0x556040F, 0x1406DD74, 0x55FA83ED, 0x91C35357,
    0xF5A1C63, 0xA64E34D0, 0x7DF58C80, 0x62E97E52, 0xFBA1A2FE,
    0x8CB29D60, 0xDC1AEDE5, 0xB260BBF, 0x1AD9C6A6, 0xC60E9788,
    0xAD9DFA42, 0x2E422C17, 0x51CB5E86, 0xEB840466, 0x2666D5D8,
    0x7A0F7C62, 0xDE052A31, 0x6F0330C4, 0x9142D4AD, 0xDC8578C9,
    0x978F3E76, 0xEE43CB4D, 0x14E7EFC7, 0xB50B064B, 0xD7FB2900,
    0x67C4F4A3, 0x4D1193D7, 0x5091FB73, 0x3EB9C846, 0x960BE069,
    0x88250E7E, 0x94503385, 0x1C1F244A, 0xCFD72CE3, 0x8CD5F105,
    0x2B34131F, 0x60D266E2, 0x16BA806A, 0x25C25A42, 0x5FF6C068,
    0xD23A191F, 0x7AB5C53D, 0x9EA37FBB, 0xD1AD4B07, 0x40BCB39C,
    0xF45C8526, 0x80FEF5BF, 0x197D6D43, 0xD56FD4D0, 0xF39E498B,
    0xFB4F6847, 0x84DF289A, 0x2246F5CF, 0xF979B823, 0x42DCD843,
    0x1AB1BB0C, 0xABEC5FCE, 0x6E7EBC1, 0xE013DB54, 0x73BC8A04,
    0x88D0F71E, 0x4D93B6D8, 0x57B0B7CF, 0x99371728, 0x86B129E9,
    0xF4EB3DD2, 0x6956AA9D, 0x4C84AA0, 0xFD22CA10, 0x36E6915F,
    0xC830D7EA, 0x1EE1666, 0x1036A43F, 0x3FC86E7C, 0xF10F9CD2,
    0xEFF5F21B, 0xBF9082E0, 0xDD0DD00C, 0x80524F27, 0xDD5A3222,
    0xEA53B93F, 0x7FDA09AC, 0x89840C97, 0xC3A9BDCF, 0x1EC26899,
    0xEBCAF99C, 0x2EBB3226, 0x936A3254, 0x2E1E1786, 0x57E4CB9C,
    0xE5CDBE5, 0xFBA2458C, 0x48F3D0EF, 0x74FD06AB, 0x96C30795,
    0x14FEF0E9, 0x2F5FBA0C, 0x3CCEA60E, 0x7BA0354A, 0xCD7329FF,
    0xD4169550, 0x5FAA5E66, 0xF0C25CA2, 0xEBCC8065, 0x3F147D8F,
    0x5ED3293E, 0x6457117D, 0xE4CF4B98, 0x11F1E74E, 0xC13F47EC,
    0xBC7E22DC, 0x22512D19, 0x9140ACBB, 0x490D52F, 0x3E2D54C2,
    0x9FCBBC1B, 0x89646A33, 0x9FE4B65F, 0x92CE9ECC, 0xFBD59FB9,
    0xCE95DAD1, 0xBBCDE794, 0x9C0FA1C6, 0xCFD90F8B, 0x494C1770,
    0x21AD2AAE, 0x58EC00A6, 0xB0848A25, 0xEC4FEB5E, 0xFF1517EC,
    0x52871C07, 0x105E05B0, 0x178B1913, 0x18023805, 0xB16BBC6B,
    0xF8522A7F, 0xB17DEC22, 0x3808ACAC, 0xBC5B9043, 0xBEC01BA4,
    0xBC6CDA0B, 0x17906D50, 0x8422829F, 0x51C9AFB9, 0x54F78CEF,
    0x72CEEA16, 0x76A74B94, 0x7EC063E2, 0x51C65B1D, 0xD97ED9B8,
    0xDE89F034, 0xB5AEEFA0, 0xB88D3E9D, 0x9D4C57AE, 0xC8CEA9C1,
    0x941A74D3, 0x8E2FC33, 0xEDCEB551, 0xB91FA3E4, 0x8BA2261F,
    0xE558E0F2, 0xA4E81979, 0xAAE31455, 0x70B62249, 0xD48D1A67,
    0x11767EB6, 0x823DFECA, 0xC815C538, 0x2AB67EE6, 0x22FA86BA,
    0xD7A1F96C, 0xBA96E382, 0xB75B3FB7, 0xCB705FAF, 0xD1B9D3E2,
    0xD4C8DC2F, 0xF954B0A5, 0xDABE493B, 0xCA3FBB37, 0xBBDC387C,
    0xA30C87D6, 0xB5B493D5, 0x584F5615, 0x90FB6370, 0x5544A92D,
    0x980F7FA2, 0xF1459235, 0x130B11BD, 0xC7A44998, 0xFEBCA776,
    0x7943BE84, 0x72C99B04, 0x353F6042, 0x66F5C2F2, 0x9C5B2CC5,
    0x9FF06E41, 0xAC9E5492, 0xFF9A1CC8, 0x4429DE05, 0x97845307,
    0xDBA36668, 0x40BEBB2F, 0x606DBA6A, 0xDE7A4225, 0x9AF7FB71,
    0xE97A0E6C, 0x99C2AA59, 0xE00C525B, 0x5D4F9521, 0x89C5D7BB,
    0x18481C9F, 0xA27A1F59, 0x2A6267A3, 0xC467981A, 0xE04CE94D,
    0xAAB2AC1D, 0x5FD1AC86, 0x8F33E395, 0xE1FBE285, 0x636C2961,
    0xD838584E, 0x2F845D90, 0xAD52A8ED, 0x8F8C841B, 0x829A3861,
    0xAA0FF413, 0xA079F240, 0xB15D507B, 0x93722B10, 0x833AF929,
    0x4FB5B879, 0xEDD3031D, 0xE22CE740, 0x9ADF835A, 0x13A0C7A3,
    0xD5791B98, 0x99D9409F, 0x9F776A0E, 0x8665EC9F, 0x7301EF7C,
    0x9B341035, 0x59EADE7F, 0x242C1ECA, 0x20FD13FD, 0xE22DAF76,
    0x3859E84D, 0x6ED83DA, 0x54ABF391, 0xC43F4740, 0x4661F86,
    0xC6442213, 0x7FEAF294, 0xC0CAC024, 0x38B9FA9C, 0xFFF33259,
    0x1AD86335, 0xB365445F, 0x54B58378, 0xFD7AE96A, 0xE019B245,
    0xCF51C4EC, 0x604D7EE, 0x7B40C023, 0xA5E168B0, 0xD7B8C643,
    0x91C028D3, 0xCB939A6B, 0x169B0123, 0x96FF8CFA, 0xFCB3E126,
    0xB95C01B1, 0x1758BFB6, 0x50F50968, 0xF774D536, 0xC5A8BFE7,
    0xE2496BE, 0x6FB8D434, 0x3F7FEDB9, 0x9BDEE991, 0x1CBD2009,
    0x2CE74DB4, 0x1CB51025, 0xE965ECE6, 0x89100034, 0xA089E8C0,
    0x5860A65B, 0x9C4D349E, 0x54898852, 0xD07C9738, 0xBC677E89,
    0x75B5D0C1, 0xCFD435AF, 0xED550357, 0xAED9301, 0xDCD1734A,
    0xEDCD21D7, 0x69F6A592, 0xEF8009F7, 0x44374358, 0x9405770D,
    0x668AC4FA, 0x50507E61, 0x2DB19DDC, 0xA9BDD137, 0xFB722699,
    0xBC067E88, 0x88740174, 0x717CCEDC, 0x9F7F1E11, 0x389F4CC,
    0xCF4D0018, 0x24588FF1, 0x25C9F951, 0xDA660468, 0x6C09D91C,
    0xC9F788E, 0xDD4DF43F, 0x8B04484A, 0xC7F67DDB, 0xD2939F8B,
    0x96BCFDE5, 0xF6DD10D8, 0x1124A3BC, 0x7C281FBB, 0x5FAFA71B,
    0x58A9C493, 0x4747793C, 0xD3B79E72, 0x357AA675, 0x8E94A74B,
    0x1994025, 0x95D10FB8, 0x5C64AE63, 0x9E37973F, 0xFCE67009,
    0x8480F94E, 0x34DA26F7, 0x126CFB46, 0x206AAA6B, 0xBA0A6200,
    0x8DF3F67F, 0x4936802F, 0x950F62F8, 0x17E64C44, 0xC70E523E,
    0x2F910727, 0xAF7C5BC, 0x9EA24508, 0x1E945729, 0x55E48FBD,
    0x897CB57, 0x8C134FEB, 0x54E68223, 0x91912044, 0x7A461BDB,
    0xCE91309, 0x72135AF, 0xBF94D484, 0xDD752690, 0x32248D12,
    0xEA092355, 0xC24CA220, 0xE8A95D65, 0xE4E2EAE6, 0x664763E9,
    0x71F1AA47, 0x832550FF, 0xFFA73B6B, 0x96F5DFF6, 0x60CB9B66,
    0x75F29F5C, 0xF863AC8F, 0xF16993FC, 0x3503801C, 0x3D1E8B2,
    0x583CDFF6, 0x62AD49F2, 0x8261843F, 0x826EA9B6, 0x5E2EF3,
    0x8D3848EC, 0x7391A581, 0xDFC466FB, 0xB38DCBD1, 0x4145C3C0,
    0x73F322D7, 0x2B55F284, 0x6B19FBA6, 0xD9446AD1, 0x36C330C5,
    0xB71E4B29, 0xF29F504E, 0xB4FA4CFB, 0x290B6941, 0xA2197E21,
    0xF2AAE27F, 0x1A1728B5, 0xAFF5632, 0x6AEE763B, 0x2962A376,
    0x965D67E7, 0x231A8B76, 0xBD3596FC, 0xD4AE3E8D, 0x58D4D740,
    0x4EA3B6DC, 0x5479A7F5, 0x110A4791, 0x9A772A63, 0x728C4794,
    0x6D6A0801, 0x3F89D9E1, 0x326D1BC4, 0x49B3798, 0x5E2B3CA8,
    0x742C385A, 0x89450FE0, 0x24236A74, 0x81AC9891, 0x7BEF3C66,
    0xACECD674, 0x29009073, 0x94D6BDBF, 0xF2C6CDF4, 0xDBC21EE3,
    0xC65C89A4, 0x35DC5337, 0xBA281430, 0x787521B0, 0xADF8317E,
    0xD5739B77, 0x8567F3A2, 0x374E0CAC, 0x5AFFF50F, 0x9654D41,
    0x4A86EDEF, 0xE16C9A62, 0x59D15E49, 0xA69769C8, 0xA9197100,
    0x1E04CB9F, 0xA926CCB8, 0x5047C429, 0xB7E369C, 0x812F5F0A,
    0xA53EA5BA, 0x9AE5C105, 0xD4C7CC5D, 0xC99E02F9, 0x5BCDFE96,
    0xCDBAA854, 0xCF209B89, 0xBE08E9B, 0x5C73AED2, 0xBD959602,
    0x63C309AB, 0xEE289A4, 0xEDA954C9, 0x5C54F616, 0x3BC34487,
    0x47A3C772, 0xAB0084A4, 0x2CFB8D44, 0xF5F8411D, 0x43F6361D,
    0x12B8467F, 0xCDC437A5, 0xAC96A375, 0x7962CD18, 0x5D728EF4,
    0x66B11DEF, 0x73C87A6, 0xA35AEF9A, 0xC84F12F7, 0xB1EDE9B4,
    0x2F6A1752, 0xCF8DA321, 0x2E37F4E0, 0x4985F516, 0x684E49AF,
    0x56287772, 0xF74F95EF, 0xD994FF05, 0xC1D23E99, 0x81214F78,
    0xA5DF2934, 0xC2B686DB, 0xABC54017, 0x6918D067, 0x737A798C,
    0x3904B21C, 0xD4CB6EFF, 0xC256E4F8, 0x38B0CD4D, 0xE2D27089,
    0x75A00DC2, 0xDC1D5E7B, 0xE2295307, 0x2F0A683C, 0xD00AF450,
    0xE45C3252, 0xD86804C8, 0xF9628DB9, 0xEA011DB9, 0x6A67523A,
    0x488B54B3, 0xA292CDEA, 0xB1D1D89A, 0x17415325, 0x3EAD3D80,
    0x5D092525, 0xB5880E29, 0x1104A8AF, 0xBC177790, 0xEC730159,
    0x11B0A1AD, 0xB809FD7C, 0xB23FE31, 0xCCBED7C8, 0x45B7F7BF,
    0x9491B0EB, 0x1B1A90F9, 0xE34F4317, 0xF060A5B3, 0xF795EF1,
    0x8254A941, 0xC6CC30E4, 0x770FC40C, 0x17EC9C1F, 0x20DA83EF,
    0xF9CCBFC9, 0x9D0675AD, 0xACEA7EB3, 0x56326F5C, 0x74D4DF3A,
    0xA8FF9A9, 0x8F55E3E2, 0x5B0D12F1, 0x12DDB28C, 0x95FADBED,
    0x81F48694, 0xABEE8392, 0x90E96B15, 0x2C44972E, 0x4E2D3A4F,
    0xE8D34D14, 0x83C03E59, 0xDC295E2E, 0xDDEA452F, 0xC2A2A33F,
    0x617210DE, 0x69542DB0, 0x1DD96D24, 0x3E3871D0, 0x9DDDAF6C,
    0xBD326CD5, 0xD87CE143, 0xF3C79B3A, 0x7F811CCD, 0xDE1B1502,
    0x8075EA04, 0x9D09F1DC, 0x8CCBD152, 0x669F35C, 0xC9414276,
    0xA2BFFE0E, 0xF8AAE650, 0x190C1AE7, 0x2DBB4A7D, 0x575B247D,
    0x3A599D3E, 0xB09B4DFC, 0xCE4904A0, 0x63C72670, 0x15A3BD05,
    0x799B50CD, 0x19A2718C, 0x4142750D, 0x9013BE74, 0x21288938,
    0x590BD2BB, 0xE4303149, 0x46B308C0, 0xD2BB7D56, 0x1BFB248,
    0x943B2E72, 0xCAB18644, 0xFCC921C4, 0x5308C4D9, 0x9098CEE2,
    0x435B219F, 0x69F1BBE5, 0x155216D4, 0x83F2A4A5, 0xE177744D,
    0x37DF6FDE, 0x9D9EA50A, 0xDFA8D408, 0x6C72E71E, 0xEA617E3E,
    0xDAD6C13B, 0xB83A850D, 0x45F6BEB5, 0x6AFB346D, 0x400B29FB,
    0xBC8E57DE, 0xC6C1081A, 0x4F6A9545, 0xF878303F, 0xB9E519DC,
    0xCCF25FBA, 0xCAE069A5, 0xB79B082E, 0xF70BB7E7, 0xE6A5535C,
    0xB769EA37, 0xE07CCBCE, 0xA9F04406, 0xBB7E5A7A, 0x10C986,
    0x5EB448A0, 0x3B154163, 0xCB832FD3, 0x50100140, 0x6963216B,
    0xEF480040, 0x75B83F45, 0x4A07D8C5, 0xEFDF39B2, 0xDB139034,
    0x5BE9C8C9, 0x1915F818, 0x852ACD9, 0x58BFF825, 0x64AF5C20,
    0x1F13AFAA, 0x8A5A1E9D, 0x57870533, 0x98A418CB, 0xCEBDAD9D,
    0xFA54CB95, 0x707D0BBA, 0x26EE1F10, 0x428CAAC6, 0x33AC77D0,
    0x6879957E, 0x522DCDE5, 0xE29E9579, 0x4AB0C59C, 0xB5FA1395,
    0x4C0BA116, 0x297A0F00, 0x440CD4CD, 0x63BCFEC0, 0xAC14638B,
    0x3C7DF738, 0xC213D3AE, 0x5CA0779D, 0xB49A3458, 0x678D95A9,
    0x281735D2, 0x1911DA83, 0x3A5EA479, 0x2C1090F6, 0x40C0D5E7,
    0x33AD6433, 0x49B076BB, 0xA1C1D333, 0x80474C82, 0xC62FE221,
    0x87F4E57A, 0x4C5C1506, 0xAD5E1E10, 0xE435A8C6, 0x96D7E0E8,
    0x53E54D01, 0x7EECEA8B, 0x699C41E0, 0x181C6479, 0xAE6E687E,
    0x2FD27BB7, 0xDF60DD39, 0xC38A3AC, 0x5AC51EC3, 0x8F1205E1,
    0xBD71109C, 0xCB2CCA62, 0x236D9D16, 0x45ACA6BD, 0xB33BDCE1,
    0xE1D9134F, 0x410F24FB, 0x3BF34DF6, 0xB799F963, 0x1B2D4C07,
    0x8D92C15, 0x9CA0073, 0x76772A47, 0xFBB63B16, 0x78F3C3B7,
    0xF118B4A6, 0x8E86A34A, 0x56693D7E, 0x381EA186, 0xCB9B430D,
    0xAD11DC36, 0x599B3370, 0x7A6B80C0, 0xF2A282DC, 0xF58F96FF,
    0x97AADB3A, 0x5AA06FD, 0x44A43553, 0xBE8097C6, 0x4CF5002D,
    0xBADE20DD, 0xFEC25B7, 0xC8B50C4E, 0xF0C899D4, 0x815F9958,
    0x77772B46, 0x7413F82A, 0x7203A939, 0xF4623F73, 0x35EE625C,
    0x2723BC68, 0x33790B09, 0xA58391E4, 0xA27C7C25, 0xBC032556,
    0x1D812AD4, 0x301BB65D, 0x22FAF223, 0xDCBB79DE, 0x78CE1CBF,
    0x570C796B, 0x17EF8909, 0x8E2C32E5, 0xB54FF82F, 0x7702F70,
    0x1C0A78C2, 0xCB3078DF, 0x7155531A, 0xEAC77450, 0xB9DC2EDF,
    0xA8B6A1A6, 0x57FC52F0, 0x6B5543E4, 0x40679BEA, 0xE46813E7,
    0x65525695, 0x6C9CD43C, 0x5E5BD786, 0x44212626, 0x847A8357,
    0x7E39813D, 0x9FE22F0E, 0x29EC985A, 0xC91CF47C, 0xB31A26AC,
    0xA4C8B43C, 0x8EAB7865, 0xF6F2F67E, 0x3F73A8DC, 0x4FAF5455,
    0xE1253CAD, 0x3001A083, 0x532DEAE4, 0x6A110DF6, 0x585D0FDE,
    0x19071CC0, 0x1A351A69, 0x2FEAD890, 0x33902499, 0xA218C193,
    0x2294A970, 0xB0544EA1, 0xC54B25F0, 0x6C89048C, 0xC8203390,
    0x237F30DA, 0xE8F10E5F, 0x6B57E331, 0x43744B6E, 0x2EEF4BB4,
    0xEBD13AA, 0xA9024B04, 0x22895C31, 0x321C459A, 0xFCEFD3EE,
    0x94772392, 0xA094B3F3, 0xC070FBB2, 0xF30ADCDF, 0x8D294C6E,
    0x89E4C299, 0x47DE058E, 0x841A807E, 0xDEA7608F, 0x3A45D7AE,
    0xFE08A063, 0xF2C65E08, 0x4C653ADB, 0x8E4BED1C, 0xC85C1323,
    0x63DF1750, 0x4EF4B72F, 0x209903A9, 0x3ECCC1C6, 0x4283795A,
    0x205AC943, 0x38B1ABE3, 0x1241AC5D, 0x7C645871, 0x747695BB,
    0x29206570, 0x31BACE6E, 0xFDEEDAC9, 0x4DEFF536, 0xCD6CFDC0,
    0xEB0FAB42, 0x7DFA5EB6, 0x8363D9BA, 0xCFCD2514, 0x69FEB823,
    0x10BDBDCD, 0xE4C27020, 0x56DCF966, 0x9C97BD95, 0xCDAB9269,
    0x8316F55E, 0xC62F7354, 0x5415281A, 0x31EBDCED, 0xCDF7A05D,
    0x5F674F71, 0xF70EE58B, 0x26037964, 0x584174B4, 0xFEA5520C,
    0xD01A8007, 0x7F2772E8, 0xC2FF1456, 0x7B2CA1FB, 0xE938BBD0,
    0xD96CCCF2, 0x9AE8088B, 0xF3A25E6B, 0x3780417E, 0xB9E2917D,
    0x95872990, 0x12D99C68, 0x2FC5DDB0, 0x55437D2B, 0xDB9C14B7,
    0x6BBE6AF9, 0xFBDC9201, 0xDCB32A70, 0x1CABF45D, 0xD8BCBF4F,
    0x271AE6A5, 0xD34B8953, 0x58BBFB3A, 0x537F049A, 0x55B51226,
    0xCD809DC9, 0x846DB4EB, 0xED476D72, 0xEFC8F8AF, 0x6AA3228D,
    0xA363F656, 0x2207127, 0xA1BBE245, 0x2AB58A00, 0x637810C9,
    0x91F61AD, 0x347D333B, 0x1E9598E3, 0x2E7BD8C6, 0x8DCE469F,
    0x73B82620, 0x9257D4E0, 0xD9580F88, 0xE8EF6D53, 0x2D9FAC45,
    0xB56E2C6, 0x9B369045, 0xB50702C6, 0x955D3700, 0x577CC21E,
    0xED02FCBA, 0x73320B99, 0xB55DE16B, 0x7F578129, 0x3F6FD052,
    0xF211A764, 0x9B7F9204, 0xC61EDC01, 0x1363AA4F, 0xEFAF1CF2,
    0xE5AF97EC, 0xEEAD4FB7, 0xF41B649, 0x373087FB, 0xE81355EB,
    0xE04FF410, 0xFD04F4F7, 0xFA269CEE, 0xBE8D7535, 0x5FC007DE,
    0xCF085F76, 0x94D7201F, 0xAF49F41D, 0x8D6E7F, 0x9D63B6ED,
    0x9A2A0877, 0xF06123D9, 0x6624C891, 0x508266E4, 0x6921EAA4,
    0xD6E69A49, 0xCDA0F920, 0xA5870B5E, 0x1A93A2CF, 0xE3A030C6,
    0x6EC03FE5, 0x37FDBDF6, 0xBEFD0BFF, 0x3D3CBD0E, 0x2DDBFD7D,
    0x8B58AE2B, 0xCAD61AF3, 0x624F4677, 0xC402CF5E, 0x431D2CC1,
    0x5C205AE5, 0xFC3B8ED4, 0x501C36DA, 0xBC9217E5, 0x6752573D,
    0x3BE702E, 0x8E06CF12, 0x81494C86, 0xB2DC2F63, 0x792EC845,
    0xC6BDEDB5, 0xB255BA4B, 0x6C66C28D, 0xD1A16904, 0x93ABFF21,
    0x94827FC4, 0x87825689, 0x314D1F33, 0xC0D8B98A, 0xC84AC57D,
    0xEBDB0F92, 0xBA4F473B, 0x61130498, 0xA534064B, 0x3DC04FBD,
    0xD0A701F2, 0xA671765D, 0x17464B7E, 0x4CCCB84, 0xC297BAED,
    0xAAF8C84A, 0x631313F, 0x8E0FD926, 0x1699F616, 0xD9808C9D,
    0x55BF5BC2, 0x27FD10B0, 0xAE975927, 0x92B3F52F, 0x9025C6B3,
    0x95E5E313, 0x4CB83334, 0xE4A1E7B8, 0x74F7D3D5, 0xDDDC42B9,
    0x5A89BEF1, 0xF66A6AE5, 0x33730C23, 0xEB7F079E, 0x742FEF19,
    0x2C68CAC5, 0x2410679F, 0x9D1632DA, 0x458F4AAD, 0x8889E6AE,
    0xA3B48216, 0xC9AF4AEC, 0xA506C8F6, 0xB6AF9E59, 0xC6340436,
    0xA6B294E, 0xF35CF92B, 0xEB3A4113, 0x98070AD1, 0x9E61E01E,
    0x58C2893A, 0xCC1F8C34, 0xCAD665A0, 0xD0414D39, 0x643BDCD8,
    0x8AF801AD, 0x9ADBB106, 0x2BD02351, 0x8F890436, 0x546747D0,
    0x6DC33C48, 0x95FA7FD6, 0x5F12C5A5, 0x5DF2761D, 0x9A9B2F8A,
    0x8C61276B, 0xACCC7F4, 0x37A5829D, 0xF1A0F1, 0xAAED57E0,
    0x180CD2A3, 0xDC393CA7, 0x504E7405, 0x89DE2F7, 0xA4D8C4EA,
    0xD8BECE01, 0xD664017C, 0xF57FA30, 0x6049928D, 0x9832E166,
    0x176AAC31, 0xA793F88A, 0xCFFA8B54, 0xA30DF1EF, 0x3B6C7611,
    0xDEFC961, 0x9BFB79F1, 0x1483D430, 0xC3A77C0C, 0x42AC1FA0,
    0xFA3605B6, 0x9A2EBDF0, 0x684D414E, 0xD9308E10, 0x64D68C19,
    0xA8A9B67B, 0xF5E7B9D4, 0xC7B70ACE, 0xA6EB6DB8, 0x8A22FBE2,
    0x3AFFDDA1, 0xFB61F7D5, 0xE057717B, 0x846D96CB, 0x20A4B400,
    0x574089BB, 0x9F3D2DBD, 0xEEDDDB4B, 0x5E64EA6B, 0x6781DC90,
    0xCFD86A6, 0xA92441CD, 0xAC5DCCD6, 0xE6BB5582, 0x32FA6B3F,
    0x3ABB8A64, 0xA49D2003, 0xA965E430, 0xEC4053BB, 0x95859D40,
    0x2672832, 0xCAC3E608, 0xF8C13A53, 0xB04EC2A3, 0x87F54941,
    0x62A3A924, 0xE0B48702, 0xE8700446, 0x95BD4B11, 0xCFCFDF9A,
    0x19F67E7D, 0x60853AC6, 0x468F963, 0x298066B9, 0xEE53E89A,
    0xFC63E607, 0x6FA101E5, 0x8B2F1F84, 0x24AE7C1C, 0x385008FF,
    0x96E75EB6, 0xF1175277, 0xE5B4A577, 0xB0C97AC, 0xC21CC45A,
    0x5C680DF8, 0xDEB046DC, 0x1487FC03, 0x1D90CE3C, 0x712563BF,
    0x65A26CD9, 0x4D094F62, 0xB5DFE29C, 0xF58B2A62, 0x9420A9DC,
    0xCEC7537F, 0xC46D1FCA, 0xAD5D7B10, 0x68777A24, 0x6C096D2,
    0xD787D72, 0xC7743F50, 0xB3D05F4D, 0x53E0A7E3, 0x9E627C6D,
    0x1AA0959F, 0xD1E00E47, 0x8874BA26, 0xCEAC0958, 0x10F67BBD,
    0x712C6597, 0x3478BD73, 0x4D6F116, 0xD30BC24B, 0xB98C565A,
    0xD7C5B116, 0xA8CDAC4F, 0x4144673, 0x848F37E3, 0xADD946EE,
    0x6F17EAE3, 0xEA0FA265, 0x41DB99E0, 0x6BCFDA5A, 0xB46ECED5,
    0xAF67610E, 0xC7E9DF2C, 0x5CC6F0C6, 0xAB2C2BA, 0x6BCC3881,
    0xE482C243, 0xD8053417, 0xFFDB6E41, 0xF13EEB84, 0xE8292661,
    0xEB9940A6, 0xF0B45F98, 0x1CA82AF4, 0xCCA7771D, 0xDD5F3CFE,
    0x58BD8E91, 0xDF9E3342, 0xA1003957, 0x4621AF52, 0xF926F465,
    0x209925AD, 0xB1C72F09, 0x3FAB8ED, 0xA15C0A17, 0xDBE73D2C,
    0xF917CE51, 0xED047661, 0x7361B752, 0x1AAA57A8, 0x31445667,
    0xFEC0FD81, 0xE3073574, 0x7D36F720, 0xF418181A, 0x1CB8758E,
    0x8E85AFBA, 0x407E9AD9, 0xF724E308, 0xD030D3ED, 0x4610418E,
    0xE799EA4D, 0xF8B68F92, 0xB84B9ACD, 0x4B8168C0, 0x9888977,
    0x216F3B3E, 0x5C49C1DB, 0x759E718D, 0x7C4309FF, 0xBF6DEE2C,
    0xE566F231, 0x774B0A7A, 0xBE55CCFF, 0x3081B8CD, 0x2284369E,
    0x2FDF7473, 0x3AF68AC7, 0x6047E9B8, 0x3743BA0E, 0x691D261,
    0xADC440E1, 0x24150207, 0xFBFE466C, 0xF767E860, 0x8157332E,
    0xFB54D774, 0x1AF34C22, 0x74E05695, 0x2101FD57, 0x2904274C,
    0xA1294E9A, 0xF43CA18F, 0x4FA79EB5, 0xAFD1C9EE, 0x6EB3953F,
    0xDDFCB3AA, 0xDB48F7BA, 0xE1742183, 0x8A78CEBD, 0x225CD669,
    0xD76B771A, 0x3520113, 0x428B2892, 0x3A5CE8DD, 0xAB4AC42C,
    0x2928BE8D, 0xC34E3031, 0x93F0CB9B, 0xB7A6FDB4, 0xEEB2B85E,
    0xC393597B, 0x9D8457EF, 0x91F0F0FA, 0xC54AEA3C, 0xC639521,
    0xB668AFE4, 0xE4CCE3CD, 0x86223A5D, 0x6A51A2EB, 0x4333C505,
    0x3233B8B7, 0x1D01F51E, 0xF0C691A6, 0x699EBC2C, 0x7FEE8DBC,
    0xCC50E42A, 0x7951DB68, 0x8CF01752, 0x33D33841, 0xB46E353A,
    0x700B65B, 0x59ACA844, 0x38631893, 0xC32D0F92, 0x6897EFDD,
    0x3F93BCDD, 0xD50E33C3, 0xD0075F1D, 0xB3CB6096, 0x875896CB,
    0x5DF6651, 0x8E2D197F, 0xCDF68F10, 0xC74018CE, 0x83E6C42A,
    0x994DEA76, 0xF932D8AF, 0x98775C2D, 0xF79CAAE5, 0xF2BEB839,
    0x7318C6DB, 0x3AFD6D85, 0x37F18BDF, 0x10194867, 0xA73B5205,
    0x3F06A1BD, 0xBC8026DF, 0x531CF753, 0xCAFAED74, 0x817C9E70,
    0x32338A3F, 0xA5177C74, 0x9A3C131F, 0x90F9AF0, 0xE9281B62,
    0xEDD87C1E, 0x16577CB0, 0x5E3F7AC3, 0x4E49E1EA, 0x495C1B67,
    0xC282F5FE, 0xF8993B1, 0x47563C68, 0x49FA0716, 0x26A55B80,
    0xDF870F8D, 0xFBB8DDA5, 0x130EA4E3, 0xB0B66F1A, 0xD7B92F0F,
    0x55FD4759, 0x6D11AC86, 0x8AB0B6F8, 0xD8C8C8B0, 0x758DA8A,
    0x9CD589F, 0xB808C0A0, 0xB2C7A3F3, 0xBA40DA44, 0x937532CF,
    0x279CFDB2, 0x545896EA, 0x387A8F38, 0xB2E5F9D0, 0x7566CA0D,
    0x51B45DC4, 0xA93B6EAE, 0x1C22D8D5, 0xEB96BD1D, 0xB8F40750,
    0xCB7DCF85, 0x188F6018, 0x95BA817E, 0xF7C19E4E, 0xAAF97DDA,
    0xE5BD967B, 0x1604352F, 0x3758C3BB, 0xE2FA13D1, 0xE3666F4E,
    0x218059EA, 0x2F4750EA, 0x2F065B46, 0x8FC4F43F, 0x2F45422F,
    0x45928A5E, 0x77055776, 0xBB8103E1, 0x160EFF29, 0xA704F79B,
    0x6655E735, 0x2C19DC79, 0xE407A7CD, 0x9F4AE1F0, 0xBED7DCE5,
    0xA870A304, 0xDC413709, 0x903181E, 0x7C1F6803, 0x44971A01,
    0xF7A81ED1, 0x5DDFB023, 0x2D90CFBB, 0x7F7A432A, 0x35F3F5B0,
    0x7D935FC5, 0x1D99E7BB, 0x8EFC82B0, 0xAB0DEF56, 0x70702FA1,
    0xCF0064DF, 0xDD9DEAA9, 0xF05F927B, 0xB483A6DD, 0x9B7388B8,
    0x2FD82389, 0xAC982F20, 0xC86AD76F, 0x15C6977C, 0xAB10A137,
    0x1433E4A0, 0x2762D44, 0x1CB5399B, 0x310A54D8, 0xD4B8623A,
    0x40FAB5F3, 0xC2D51618, 0xC1F4AF55, 0x17C18E1C, 0x4F37D33F,
    0x2DC9F168, 0xF5BB9754, 0x716FB1F4, 0x7CFB1CE8, 0x1333224D,
    0x344C13B3, 0x7798CB50, 0xB4278C76, 0xD7CC1B03, 0x168B21E5,
    0xF7D77AAB, 0x3B651846, 0x639EB0CD, 0x68EB3E8B, 0xEC82FE45,
    0x622A71DE, 0xAA05B6CB, 0x878B59B1, 0x3E7FB616, 0x1D650408,
    0xF21F8C64, 0x9BF7BF7A, 0xA0874898, 0xFE4E3C6E, 0xFA36122E,
    0x1BCDF4FB, 0xC371B365, 0x8F791BB3, 0x9833AD98, 0xE84887FC,
    0xF8988AB6, 0x180916E2, 0xB587E39C, 0xD5C884C6, 0x27B6BFEB,
    0xD8868D1E, 0x689DA503, 0x936B4EFC, 0xDE0DB3C, 0x7950FDCB,
    0xA61C81C5, 0x9F1C93B2, 0xC983179A, 0x6F847EB0, 0x6F7F899D,
    0xD270412, 0xCC255717, 0x763112A0, 0x8725C96D, 0x48BC2863,
    0x85F13BF0, 0x6D8E0251, 0xB7E66CC3, 0xA4F5829F, 0x8779F381,
    0x16A5E04F, 0x3DF42C14, 0x367F06A3, 0x3BF8666C, 0xC6649CFB,
    0x4DD9808F, 0xB4F9AFD, 0xC2642410, 0x9740E4F6, 0x8FB667BE,
    0x4D4B0D3E, 0xE9B236F7, 0x6E30550C, 0x79DA7B48, 0xE721889D,
    0x79D9B21A, 0xA06B8C2E, 0x997B1696, 0x4383FC27, 0x8B77D293,
    0x6FAE2A9F, 0xB45ED194, 0xF38E2C59, 0xEAA0D05C, 0xA3BC449A,
    0x6EB0BB4B, 0x6B242CFF, 0x7FCA0B8A, 0x47221D33, 0x4E18FE39,
    0xF4691580, 0x6D03D791, 0x3B937AC5, 0x9CB761C3, 0x42812232,
    0xFB987D6C, 0x86AD164E, 0x5D8CED49, 0x22D6D058, 0x42FADF98,
    0x9363A1B3, 0x83C6DB74, 0x7AF44F4E, 0x20086D60, 0x7A37665E,
    0xC4A29C82, 0x330F278B, 0x8750B539, 0xDD2E83D0, 0xB8E002B1,
    0xF2A9323F, 0x91B60885, 0xDE83F01D, 0xACA126, 0x2F0FADA2,
    0xC0E879A6, 0x7C715655, 0x16642BA2, 0x43B9C083, 0x95F6789D,
    0xE6576886, 0x46BEF133, 0x84199FC3, 0xC45BA082, 0x26489AC1,
    0xA4FE268A, 0x633A25B0, 0x4FCD341D, 0x8E7374B3, 0x7F8A3466,
    0xC82B53F7, 0x2E2114DC, 0x59213BE7, 0xE72A2395, 0xAC5F982B,
    0x8F63E9D8, 0xA68BA42E, 0xF0E30E92, 0x580FD13A, 0xB2FCB7EA,
    0xF3E4C077, 0x2C8588B, 0xC31F5E5, 0x104982D9, 0x2C2F03E3,
    0x8F1791C, 0xCE14310F, 0x1696133B, 0x1BC68D6D, 0xFC488B95,
    0xE0E7FC31, 0xBDF0152B, 0x24F78B82, 0x45BD4367, 0xC89AF4B9,
    0x9698650F, 0xFB2E131A, 0x82B7A451, 0x9F6990FE, 0xB6EDE6BB,
    0x68D5D90, 0x51FE559E, 0x9B54ECE, 0xC09D3AB2, 0xD9BA990B,
    0x4CF02BC, 0x70067D7, 0x3568DF20, 0xFF1D7AE4, 0xF1C67DE3,
    0x5ACC7F95, 0x89ED16EB, 0x6EDCDC94, 0xDF367991, 0xF1D48A79,
    0x21AA30FB, 0xADA2B5B3, 0xC40A5761, 0x5769556B, 0x5E1510A2,
    0x5741566A, 0x25B88D83, 0xFD22574E, 0x6E9B2CD2, 0xF5CE960B,
    0x67F938EF, 0x1A1E3672, 0xFBCE5BDB, 0x756BACAB, 0x2F177A71,
    0x31F3EFC6, 0xB8263FBA, 0x9A1F772A, 0x84DC1FB0, 0xC907ED89,
    0xAD3C6092, 0xC225B6C8, 0x37EE4F54, 0x4BDDACF2, 0xB5E944CB,
    0xDC26F39E, 0x3BCE02DC, 0xC01F2632, 0x89AFE3ED, 0x600757F7,
    0x4804A684, 0xC4F3FCB8, 0xEBCAA904, 0xE0069A2E, 0xA2FBD213,
    0xDB736C4, 0xA6930699, 0x71FB43C0, 0xF66C955C, 0xFBD39B5,
    0xC87D1801, 0xE9D2DD1A, 0x78DA23CE, 0xCADBA5C9, 0x77015761,
    0xF5581BDF, 0xDEB4DAA0, 0xAF7E41B0, 0x71347196, 0xF8A29A93,
    0x8DA3BAE6, 0x73396AAD, 0xD4DF7765, 0x326AFF23, 0x27888A0C,
    0xE48AC062, 0xB9F18047, 0xDE9830DA, 0x8EF78C4D, 0xFBC1896E,
    0x9BB566A6, 0xB640ED13, 0x8B0D9D1E, 0xD84B471D, 0x4040EFB4,
    0xF6DF7908, 0xCB8ACF04, 0x253494DD, 0xA85F6D88, 0x1326822,
    0x61EFDFB8, 0x1C78154F, 0xB13866B1, 0x3ABE5DBB, 0xBB5907BF,
    0xA1A57FDF, 0x410549C8, 0xA9A364F4, 0x2A371B73, 0x24AC7296,
    0xA01C035C, 0xE839029C, 0x6E12051E, 0xE6A549FD, 0x345F10FF,
    0x3BB57347, 0xBDBF3A6A, 0x2A41C3C8, 0x6E0232B0, 0xAE66D42E,
    0x3BE90433, 0xE185FBF2, 0x9BCA91FE, 0xF4FFB74E, 0x142B6971,
    0xA75CD7B, 0x9B900DDD, 0xEC56B79, 0x2FE0CD8D, 0x87BE8237,
    0xB38A7226, 0xB5D8B437, 0xAAADC41D, 0x8014E227, 0x38D84DD1,
    0xEDF5294F, 0x862F0F, 0xD69F77F6, 0x409C3B68, 0x2F12B0FC,
    0x32A670B9, 0x5746EE2, 0x96B4901A, 0x57208639, 0xA282A77D,
    0xE9D9F48E, 0x651ADDA6, 0xFF5E974C, 0x37C833C, 0x41F2BD58,
    0xDFE1D009, 0x32222DA6, 0x22201781, 0x64A06BAF, 0x8F188902,
    0xA9C2A07B, 0x617C7DF7, 0x842DA704, 0x40AFDB72, 0x49625110,
    0x72484F13, 0x7340AC89, 0x6C6A2F36, 0x828EF5F9, 0x20344923,
    0x21D3304F, 0xD6EEB7C3, 0x8F99732F, 0xEBA045D5, 0x5C0065D4,
    0xEEB5E899, 0x1B079C47, 0x6198EE3B, 0x946A805F, 0x7C19F966,
    0x75E8F043, 0xFD9880BE, 0x47BF619, 0x9C001ADB, 0x7438184B,
    0xA3787EF2, 0xA461EF4E, 0xEB515D0E, 0x64EFA69D, 0xD41F3145,
    0xD08A900B, 0x495968AC, 0x746639C9, 0x43E85DCB, 0x62E55B3,
    0x6B913D8E, 0x2685D73B, 0xE4F98C19, 0xB404BD4B, 0xFEA327C5,
    0x1E0CC908, 0x71BC53EA, 0x530AAECB, 0xBD2977B, 0xB661A52,
    0x86560EE2, 0x250E2591, 0xDA57D5B3, 0x347D3C22, 0x6CE15221,
    0x6E5288EB, 0xA79875F3, 0xCA89972F, 0x36E93777, 0x257262E1,
    0xD1D4E5A4, 0xF7ED5D52, 0xECE58036, 0x644ACA69, 0xCA36DFB8,
    0x60EAB44D, 0x46FB8AB3, 0x81E6C199, 0xD5AA5C63, 0x4A7CB01D,
    0xFCC109CD, 0xD999C46B, 0x3FA4C688, 0xC95C0FBE, 0xA1E9DD3,
    0xBE9EAEF6, 0x1A3014D7, 0x729A662, 0xDC8178FD, 0x7FCAA1EF,
    0xD4005420, 0x2A904DAD, 0xEE7E52DB, 0x886C0F23, 0x12D49E10,
    0x2B3F3B39, 0x3373A6C6, 0x5D0759F5, 0x8CF5EF25, 0xCE02371C,
    0x2FFEEFDE, 0x5D9CFD69, 0x2B5BB7D0, 0x5A378EA9, 0x5BED8331,
    0x9C1A37CA, 0x702799F, 0x4D37A8EB, 0x370CEDF8, 0x43B95BE0,
    0xA0C1E534, 0x204130B2, 0x8E4995AC, 0xCF1C3C28, 0x3E901F78,
    0xB0F43C57, 0xED4B7492, 0xABD3C5CD, 0xEA95ABC4, 0xE03B739A,
    0x58388E80, 0xFDF22044, 0xF4379C7E, 0x87CFA0C, 0xAE9CA79E,
    0x41DCB004, 0x8F69512D, 0x73ED4756, 0xE215297A, 0xD931A6AD,
    0x59866B3D, 0x61825B1D, 0x4F5099E1, 0x25AE168B, 0x1272D5C6,
    0xBE071035, 0x24314F71, 0x82F4B23F, 0x6C7F3385, 0x36CF0505,
    0xB71C0E3D, 0xE9F881D0, 0x27F0C290, 0xF4BE30D7, 0x88315CE8,
    0x9E04FD20, 0xDE197591, 0xCF0D2FF4, 0x67A4C473, 0x158447BF,
    0xA4B37C88, 0x27918292, 0x5FDE3DF0, 0xE8A93C3D, 0x886287E8,
    0x746E199B, 0x9A894103, 0x7A529374, 0xA195E2AF, 0xAA3EB0C6,
    0xF70788A9, 0xCE2B7F30, 0x9C4724AA, 0x902EB7A8, 0x2CBBB407,
    0x3799651F, 0x9016E9D0, 0xD1C0ABC8, 0xC7684FDD, 0xE4670051,
    0x25B69E83, 0x1CEC9BBF, 0xD066D2B4, 0x2AD4BF14, 0x7AFBD3CF,
    0xCB8E5EFA, 0x63B67572, 0x89F7E3F3, 0x8E8D39E6, 0x60617ECD,
    0x9EECEA31, 0x59E57FAB, 0x807AFCD6, 0xFD0397B8, 0x3C57D963,
    0x9A972CF5, 0xFC47B628, 0x9CCFAA8B, 0x405869C3, 0x3CC128C1,
    0xE154C33E, 0xBE53F87D, 0xD23C7947, 0x4CBEB3BB, 0x1F068FFA,
    0x8A7D350A, 0xB822F33E, 0xFB3BB431, 0x741D2D0F, 0x81FAFE09,
    0x80B8BA3C, 0x30B4BE94, 0x4B2A2909, 0x31740925, 0xE68C0BC9,
    0x8E7F31D4, 0x29DA2599, 0xB9D267C9, 0xEDE811D2, 0x8BC7CBC3,
    0x69DDA8B6, 0x879E1212, 0xF915F0F1, 0xBBCDB1AD, 0x3A01011A,
    0x7CD005C4, 0x475FC718, 0xF03F454B, 0x7457F264, 0xB22D9DFD,
    0x569DE931, 0xB585EFEB, 0x9A183445, 0x9CB353AC, 0xE3AA9817,
    0x32E0722, 0xF0C7595E, 0x316DBD6A, 0x96D0F65C, 0xA6F0ECCE,
    0xCB8A9494, 0x5B077241, 0xD36BBC7, 0x9C4CD0F9, 0x108F5B32,
    0xC43C599A, 0x7B10108A, 0xA4106EE9, 0x3860CF99, 0x87B782C,
    0xF667524C, 0x129929C, 0xEA85C1D5, 0x1A07973E, 0xB9524891,
    0xBC02BD1F, 0xF378D7F, 0xD0BED4D7, 0x5B782DE2, 0x738681A,
    0x4BA1192C, 0x46DF1224, 0x4529AED7, 0x9B1DB01D, 0x810AA334,
    0x661982C8, 0xD3B32F94, 0xF50AC9D6, 0xCE9107C4, 0x203078BF,
    0x6B0F3B2B, 0xCF63520C, 0xACA9E5BF, 0x7FBE448E, 0x51BD1E2F,
    0xDF958295, 0x114A9693, 0x60FCBB39, 0x6669B642, 0xC490D54,
    0xD19C8DBC, 0x14CC7B2A, 0x7106D506, 0xAFDADD98, 0xAF398DF4,
    0x88AC5400, 0x1912BF0A, 0x5389D050, 0x5AF6233, 0xF10842A3,
    0x94DD7008, 0x93812804, 0xD8111DFD, 0xB7C97490, 0x7748A45E,
    0xE70A47A0, 0xC29B718E, 0x55783AEC, 0xA2789E21, 0x97488EBC,
    0xD9222F6A, 0xBF74BDD2, 0x9A983E5C, 0x6CC067D5, 0xBCFDD3B2,
    0xD7A2A5FE, 0x4733F2F5, 0xC7AA3556, 0x1CDB485D, 0x31755CA0,
    0xB9F8E9A7, 0x1346410D, 0x7D885AD7, 0xA30030D8, 0x9813B41C,
    0x8A64EFD4, 0x273F4CED, 0xFEDDC3FD, 0xF34D9687, 0x6B67F2DC,
    0x13F72B5A, 0x96445DDB, 0xAC94658B, 0x8FBF54BC, 0xA7C13389,
    0x95814EA3, 0x7823E5BC, 0x544C27DB, 0xECE6439B, 0xD1141B27,
    0x7A95ACF4, 0x806E58E7, 0xD07B5422, 0xFD0353AE, 0xC1840431,
    0x1DD89E9, 0xA102016D, 0x3730505, 0x1F91E46A, 0x3279C793,
    0xA060010D, 0x9BF86C80, 0xD0C35484, 0x33E81EF7, 0x1C4D3EA7,
    0x6C2A9935, 0xD65E2FB1, 0xBB1CA42E, 0xEA3E3609, 0x7B478C84,
    0x70C1DF93, 0xA872CA92, 0x7C025178, 0xF3B19C7D, 0x6F2BD89B,
    0x1AD7BBDC, 0x39A48FCC, 0xAB5B72E1, 0x821761B9, 0xD2368C1,
    0x20ABB349, 0x29A3F960, 0xFDB18DF1, 0xC4118A52, 0x5E28E88A,
    0x549A3386, 0xD81024CE, 0x82DAD5E0, 0xB20BCD42, 0x9DEA0D36,
    0x49A4992D, 0xAFCB2026, 0xCE7536E8, 0x2C191A65, 0x24FEE0D6,
    0xA769AB6D, 0xF47E292E, 0xCB501191, 0x6DE13907, 0xF1343277,
    0xB32AA746, 0xB055DB9E, 0x87CB8583, 0xA546A4C3, 0xF06F809C,
    0x8FE7A8AA, 0xD0E4037F, 0xD81FCF88, 0xF85830C2, 0x3D6F4840,
    0x5A43700E, 0xCD300C58, 0x3B81C27C, 0x8AF86EA8, 0xF65935FC,
    0x46367D7, 0x7FB75E63, 0xBB28A406, 0x173F982, 0xCB92DD14,
    0xAAA0B1D1, 0x1BCA8892, 0x64D21, 0xFF081A44, 0x8706E93B,
    0xB7DEFAD9, 0x4A6DEF76, 0xDA1670DF, 0x94ABCEBA, 0x465DA4C6,
    0x2484496C, 0x97BB3321, 0xEFB09CB, 0x2988AA2E, 0x2722344E,
    0x5301B744, 0xC5E16C47, 0xF7E05D01, 0xCBE7C20F, 0x4882A6EA,
    0x7168CF40, 0xA98A2747, 0x35F8E15A, 0x5FAF49F9, 0xD2008D24,
    0xCC45A63, 0x858A3255, 0xE4C095B6, 0x7074F7A5, 0x699C98FD,
    0xF0BFE2EA, 0xBDA35C64, 0xE83B891D, 0x7CD09FEA, 0xE8735FDD,
    0xFEA27F06, 0x631D71D3, 0xA08136CD, 0x42395363, 0xDCBA6E41,
    0x1562897, 0x4B1061A9, 0xB4F9640B, 0x38D24E3E, 0x76DF4423,
    0x94B5ED97, 0xFE6AB3B6, 0x6B329B8B, 0x37AFD275, 0xC9ABA12A,
    0xEC9693B, 0xD49B5585, 0xE0C2BEF7, 0x315D40A8, 0x34FBE3A,
    0xEBE81550, 0x569F6FC8, 0x5A9C8404, 0x9DBA0090, 0xFE985DE8,
    0xFF4209AE, 0x89F9E7AF, 0xF841164C, 0x6B4B8F5D, 0x95CB1085,
    0x1990660C, 0x31263B36, 0xCF8F435C, 0xDEBCF88A, 0xD1EE25C2,
    0x53D80B69, 0x9EB8F01C, 0xD682EA3C, 0xEEE79205, 0xA7EFAC65,
    0xE9AA6899, 0x3C1E197E, 0xC8ABE1E9, 0x7BEFE9CA, 0xE792E7D4,
    0xA955D60F, 0x3FE8A02F, 0xC963FDC1, 0xB3D53E43, 0xE28FFC12,
    0x7D5BECCC, 0x18E9F223, 0xBC8B0465, 0x7ED8EEFE, 0xBB90FFEE,
    0x904A9F3A, 0xBC467FF, 0x8AD43A15, 0xF3FC404A, 0x2492D5F4,
    0xBB3F5025, 0xBED0B8BF, 0x467FE6C2, 0x36E55C77, 0x8E2CAC4F,
    0xD12D325F, 0x68A4D268, 0xB1AA0895, 0x755B98FC, 0x2314C4FF,
    0xC3667346, 0x8003B9E8, 0x1185476D, 0x227B69D8, 0x5BADD019,
    0xB06567BF, 0x2B837581, 0x9E11F7, 0x158E67AE, 0x339AA6FC,
    0x8FE50AD9, 0x65902A97, 0x42917220, 0xF9AD39C, 0x2DAAD225,
    0x9673B896, 0xFAE150D6, 0xBEDE3417, 0xD233D722, 0x7E67F33C,
    0x6E150E30, 0xC856792A, 0x28EF69BA, 0xE2AC7866, 0x928D0A4A,
    0x8032C4A9, 0x3D413533, 0xC1BA5CCA, 0xD2BDAC83, 0x94198A14,
    0x3A25972F, 0x253EC030, 0x42D7A1F5, 0x97C28C1C, 0xBE4D0710,
    0x92F31B62, 0x73CA2F55, 0x15FC5417, 0xEF76B1C6, 0x655A963D,
    0xBC17C3FD, 0xD5BED3BC, 0xAB0E4857, 0x38BAD61A, 0x8C17E47F,
    0xE3C27887, 0x45D2A34, 0x6D48333A, 0xF400B767, 0x6ACF41B0,
    0x88DA15A9, 0x3FA0EAB1, 0xAF7B3786, 0x87F182FF, 0x4112A079,
    0x53360864, 0xDB5CE625, 0x630678D7, 0x63E01F17, 0x7BF658F1,
    0xB5E4F1A3, 0xB30E4393, 0x27454C31, 0x8E7E0E2, 0x2151A5F,
    0x2892E2B2, 0x92B53840, 0x1EB3D483, 0xA4273A65, 0xF0CC632,
    0x99AC2694, 0xE0A19111, 0xC7FBA613, 0x46C8F873, 0x88A27741,
    0x7E9A5972, 0xC2E76F79, 0xA5CA8180, 0xA28FF0EE, 0x2A1F7DE1,
    0xCC130B22, 0x50ECFD8A, 0xF5BAA999, 0x5FA2EC9C, 0xC1B5C5C4,
    0x90EC0E5D, 0x9C26620A, 0xA97D2935, 0xE1C08B89, 0xCB574B80,
    0xB3DE8B61, 0x1AF89CA0, 0xFD4A77DC, 0xED9485E1, 0xAF804C92,
    0x6B8EB167, 0xDCC836B6, 0x85A7FFFD, 0xD4E9A94A, 0x77DDCC31,
    0x8897B5F9, 0xA4FA88D3, 0x8ECB3E82, 0xBC175E89, 0x963A073E,
    0x547520C7, 0xEEB81BFB, 0x1D8B1867, 0x78833A4, 0xE40A0CCB,
    0xF8D5452F, 0x954BDCF6, 0xAC228FFA, 0xE6B32DF3, 0x181ED541,
    0xACE26A73, 0xF1C1440D, 0xA1B93EDD, 0xE90FF70A, 0xF6741843,
    0x4DF581AC, 0xBE785B32, 0x751509B5, 0xC30AD864, 0xC18D8A72,
    0x3BF07FD4, 0x827B4CBA, 0x7DD39A4F, 0x2CFEFE25, 0xE071F371,
    0xC0C3F6CB, 0x1FD70F85, 0xFDABDA88, 0x8F308991, 0x4CD794F9,
    0x5D18B022, 0xC13D5FC2, 0xD84337F, 0xED868BB8, 0x9904CD2,
    0x7551499C, 0x124B262, 0x5139C2A5, 0xEF56F59B, 0xE8B87B40,
    0x2F030010, 0x42D2E271, 0x4E344F3F, 0xC87CDFE1, 0x44A615C7,
    0xC32DB543, 0xCFC889E4, 0x60078825, 0x786F5917, 0x2DF9E82,
    0xEE26DA93, 0x48D0C94, 0xE97D5456, 0xF487F2EB, 0x35A47D65,
    0x183DA0CA, 0x1A7E1218, 0x8D2674C5, 0xB38D0910, 0x5D9C871C,
    0x7B463ED1, 0xBBC90FFD, 0x31DED99F, 0x5171DCFA, 0xF9413D0B,
    0x632A00FD, 0x7B6DA34C, 0xA475C597, 0x8E157360, 0x5911736B,
    0xCA19D544, 0xF487D465, 0x6E749BB9, 0x888BFB52, 0x3FDAD497,
    0xDB5D401A, 0x7015A4EC, 0xC1F571, 0xB2D7671A, 0x8203032F,
    0x5A755E9, 0x24F25BF5, 0x4D2AC51B, 0xE5950FA7, 0x20196F5B,
    0x68E90D90, 0x5D24196C, 0x9CFCD1C0, 0x745C0318, 0xEEB977E8,
    0x14AA16D, 0x80662EE1, 0x7BD55DE3, 0x35EE2B08, 0xD3E8051F,
    0x3D0EA4B5, 0xD551399E, 0x8FF94435, 0xDD4E34ED, 0x9139E4A3,
    0xE6AF7E5E, 0xE1ED4EAF, 0x638D2846, 0x7084F7EB, 0xF9705E17,
    0x2E7A89DC, 0x45855252, 0xBA8E51C7, 0x8510425C, 0xA97AF6D,
    0xF0C27DA, 0x9E00CA15, 0x3BCC0651, 0xEEC38CA9, 0x19597B08,
    0x4C68AB5D, 0x16CA41DB, 0x35EFBEF9, 0x1E441529, 0x25131FA1,
    0xC3D8483C, 0xD8650832, 0x60D271E3, 0x47C92A47, 0x9EFBB554,
    0xBF5DBFBF, 0xFF421FA2, 0x3A38F28, 0xAE4EE06B, 0x819945D1,
    0xC43101, 0xA3EE9278, 0x5BAE3EE4, 0x57ACE55E, 0xC3D95551,
    0xC00717B0, 0x38EC1B28, 0x123597, 0x6314F3F7, 0xB3F99DAB,
    0x7226CE1E, 0xE8350DE6, 0xD7C582CA, 0xBB1D38D, 0x54E656FE,
    0x400B60BD, 0x48291A06, 0x97819179, 0x850BF937, 0x93888A87,
    0xF51E684F, 0x4B111E, 0xC6B37E02, 0x6C923547, 0xEF25AF3B,
    0x8C12CE8E, 0x89296F4F, 0x3BE2C3DA, 0x8A29A35B, 0xBBE2E80C,
    0x79D0188D, 0xBD4320BC, 0xAFF4F0A9, 0x7FAE6C37, 0xCCA1777E,
    0xB06D2AE1, 0x26B6398C, 0x5A3E5876, 0xE814DF4E, 0xC43E9677,
    0x4C962CE8, 0x6C274FF8, 0x8B5A1A03, 0x963E1401, 0xD8CE0DF7,
    0x659190E7, 0x3AD63330, 0x894BFEDB, 0xEB4CF73A, 0x3731BC86,
    0x30FE0433, 0x94F5FD2, 0x8417999C, 0x337E86B8, 0xAFE08EF6,
    0x5B5F05DC, 0x8001C95F, 0x8C8092DC, 0x5EBC7995, 0xDCBE88EE,
    0x9C602950, 0xE3376596, 0x5D80E318, 0xAF3AC8C3, 0x8C7EDCC6,
    0x3E795E7, 0xDA8987AB, 0x7B7B4E3C, 0x3239CD40, 0x1B527DED,
    0xC95DEF29, 0xE40D047D, 0xE53C10C5, 0x5BAF528B, 0xA47921F9,
    0x6DCB9B0A, 0x7EA11040, 0xBBEFCCD5, 0x502F33FA, 0xAB5EBE8F,
    0xD59C448, 0x8C34FF3D, 0x4A3255A2, 0x4CFFDCB1, 0x3880A182,
    0x3499DAAF, 0xA1319450, 0xC550CCE5, 0x51026E2C, 0x73C4F05D,
    0x21F5FAAC, 0xE1C31B7D, 0xA390E6E6, 0x7B1582ED, 0xB92B4C3B,
    0x41C1128E, 0xF728F655, 0x3BC8AE16, 0x8A2A4E57, 0x9A8A7DE,
    0x86065598, 0x4328A574, 0xDBDAFC7D, 0x2C5EE98, 0xEAB5CE80,
    0xF7E8F60C, 0x7B4C3C0E, 0xE4A2F720, 0x90330B1D, 0xB6783BF2,
    0x48A8C26B, 0x847F1AAC, 0x351DB247, 0x43E84AC5, 0xAF726AA3,
    0x5CB4C059, 0x2C5784DE, 0xBA1111FB, 0x9F427968, 0xE41D29D1,
    0x2CAA8CA7, 0x764C8B63, 0xBDAA6F10, 0x280277B6, 0xE4A908B6,
    0xA6A9783, 0xD0643B01, 0x44FE52AD, 0x60B04A5, 0x194C190E,
    0xF73DA669, 0x12EE11C8, 0x2C769D96, 0x694787A4, 0x9FB03623,
    0xAC6F837C, 0xFC1E5935, 0x16246787, 0x4F94B817, 0xA3A4281F,
    0x1535252D, 0x13F8F1CB, 0xAAF6A508, 0xB38E10E, 0x7A4B238,
    0xC6A47410, 0xC864256, 0xF3C25E27, 0x94CE51D4, 0xF4ECAEEA,
    0x32684D74, 0x1AC8765, 0xDE6F6313, 0xF8C09409, 0xFB21FD21,
    0x6DB586BA, 0x241894B5, 0x65806E1F, 0x4B9D0DE7, 0x32DDDD16,
    0x3B16F0B0, 0xB56CAAF0, 0xC533ED5C, 0xADE48431, 0xB5893123,
    0xE977699C, 0xB295808B, 0x7A252898, 0xE3748392, 0x687A8ACD,
    0xB792504E, 0xBF4E2D8A, 0xB5EC4376, 0x754D9C34, 0x17BE53CC,
    0xC817A127, 0x732346E2, 0x29593976, 0x41D6AF89, 0x9072FAEC,
    0xC2B22666, 0x16A150DF, 0x4D379A36, 0xE732017F, 0xA6D12516,
    0xEA3DB9B5, 0x6E4C766B, 0xCA0ADEF5, 0x75E98F68, 0xC31687C3,
    0x62F16F66, 0x6486B129, 0xE237231B, 0xC6653007, 0x2BE06DFC,
    0x2BC32DC4, 0x9E3DD054, 0x47AA701E, 0x7741E537, 0xA09F9CD8,
    0x9D40881, 0x4F02F58, 0x6A5F31BB, 0x32BBBD23, 0x4520EB05,
    0x1DBFDD00, 0x6CCEC7D, 0x48CFC70C, 0xB41FBC13, 0x5B377E90,
    0x3B87923D, 0xC09F6D28, 0xC1CF24FB, 0xDD6BE459, 0x8B8BDD37,
    0xF7B103C8, 0xC1611360, 0xA8B8FCC8, 0xC16D4E2, 0x6AD23606,
    0x951A051, 0x6FC3B984, 0x95876867, 0xA0E1A04C, 0x8267F62C,
    0xC4B69588, 0xF53421DF, 0xC348685B, 0x59769E2B, 0x21F0FF90,
    0x2B978BB4, 0x3FDA987B, 0x216F4FFF, 0x95C68589, 0x2286F5D8,
    0x81E2702D, 0x88E2D01F, 0xE6F6B356, 0x2EA0C31, 0xA5E11CAF,
    0xE17DC578, 0x2115A0EA, 0x8DC2B323, 0xEB86957, 0xF3C7BECB,
    0xBCD805EC, 0x1121C3F5, 0xE6DEF224, 0x8EA2EE24, 0x2703D7B7,
    0x24D73574, 0x4068552C, 0xA85F5B6A, 0x65B563E, 0x4050954C,
    0xC7043820, 0x91E4A088, 0x19084C84, 0x7250FB54, 0xC1EC72,
    0x9FDB2412, 0x3B78E4E9, 0x588C2D17, 0x345C3232, 0xBC7CCB29,
    0xCB5F1F0A, 0x24EDD656, 0x7A9F0605, 0xC2EDB0E5, 0x7F01D20D,
    0x8EB211A2, 0x74AC4C1A, 0x37EDEDDB, 0x55B9AFF2, 0x100C4193,
    0x43CDF2C3, 0x9C75E7C1, 0xC43ABEFF, 0xB9704827, 0xDD4E6376,
    0xEA5FA0D3, 0xC6E14A66, 0xCB163673, 0x9515389, 0x5D3D30C5,
    0xD1FF8777, 0xC1347921, 0x21A5BAC, 0xD6CB5F87, 0xC6CE680B,
    0x46D1E5FB, 0x9B98BC15, 0x8D1446D6, 0x184659E7, 0xAAC79D5A,
    0x773E019E, 0xA1B9F814, 0x933D3D0B, 0x11DB7615, 0xC206A22A,
    0xE4EF5BA1, 0xF0EFA194, 0xDE0E6C2B, 0xBE185B42, 0xC28FDE0C,
    0xE416DD8A, 0xC636753F, 0xAFD119E, 0xB0198B17, 0x94C4115C,
    0x76EDF82A, 0x66818700, 0x6F003485, 0x993DFB2B, 0xF5A1F91E,
    0xDAB0080C, 0x7DF290D2, 0x72F65E9B, 0xBC126473, 0xF6050B10,
    0xB7380CA, 0x3352530, 0x9A403054, 0xB12581C1, 0x6F8E0370,
    0xBB5C1ED1, 0xCE738AFF, 0xE9F605DB, 0xA976BFE4, 0x68C9D107,
    0xA2BD1833, 0x545ACCE2, 0x965FBAF, 0x12D998F, 0x2C16B1CD,
    0xB20788BF, 0x96AADE36, 0xDF821415, 0xF1EBD654, 0x33F3C413,
    0xF2F2A6BF, 0x2DFB0ABA, 0x96845EC5, 0xB24622DD, 0xA83EEE5F,
    0x49DF9AF8, 0xB8DCFB8A, 0x16F7643, 0x436EFD30, 0xD90C9F8,
    0x9C10CD4E, 0x600CB15B, 0xE686606A, 0x5EC0502C, 0x23B2DCE5,
    0xDD5DE18D, 0x235A755C, 0xCB58A693, 0xACBEAFDE, 0xCA201FB5,
    0x2AE90380, 0x4F7455EC, 0xCA923312, 0x1BD202DD, 0x2D92B9E3,
    0xA2670F18, 0x831728C, 0x77D33D8C, 0x12400BDA, 0x9508A626,
    0x9253042B, 0x63C70C8C, 0x5496452F, 0x9237D610, 0x10448F3A,
    0x9303C709, 0x660D7EC, 0xDF6750F0, 0xBC4F14F2, 0x8F59720C,
    0xEE5AB051, 0xD5EC1228, 0xCC3E04CE, 0xE9E4D3B9, 0x8676FA58,
    0xF523860E, 0xF87D9BED, 0x4A6D02C9, 0xC5AD6CF0, 0x65F09045,
    0x8C620984, 0xDC40B4CD, 0x4216C291, 0x7A44C04B, 0x1E2B5D31,
    0xA0E77B7D, 0x12076C51, 0x22262FA1, 0x483B54F1, 0x2A7EF465,
    0xD1395E25, 0xB564369F, 0xC94A47A4, 0xFD678BAA, 0xECEE926A,
    0xE41A06AE, 0xE8F293C1, 0x3EB052BE, 0xD0959EF1, 0x93FF1935,
    0x4D65E4F1, 0xE87FC1F9, 0x3BD4BB2B, 0xD5F24F5B, 0x54FF70D4,
    0x968C7B60, 0x44F9BDE4, 0xF4894BDF, 0x3CFDDF7B, 0xD5CC3F10,
    0xD7F952C2, 0xEA3DCB60, 0xEFDAC96A, 0xBBF8F5EB, 0x41526813,
    0x714E3D51, 0x5E15A386, 0x1286AF4F, 0x5E1E5A3E, 0x676C9938,
    0xA716071B, 0x14D79998, 0x5CB794ED, 0xD815EDED, 0xCB1CA55A,
    0x9D6D74FD, 0xBE032C25, 0xF3FE1425, 0xC0CB5217, 0x3931A93F,
    0x82DB8222, 0xD8FF587F, 0x5AD4E8AC, 0xBCF00442, 0x4298A961,
    0x9F8CC3C2, 0x60E2347F, 0x7E090E, 0x691B735, 0x3D4C4D83,
    0x5612B097, 0x7B8DA321, 0x2C28A057, 0xF8FE8901, 0xDA39D0DD,
    0x465CE561, 0xA78756, 0x3B771E01, 0xE638B09, 0x201853B5,
    0xF934D7D2, 0xBD515A83, 0xC1B5C34E, 0x89159FA9, 0x2DDE3EBE,
    0xE27771DB, 0xB5983F05, 0xA3FD869D, 0x8ABA53CB, 0x55C8606C,
    0xDAB769C3, 0x4C4C2EAC, 0x18EE2A56, 0x88452A07, 0x9767C386,
    0x5C0418D6, 0xF79CA785, 0xF291195D, 0x9B0C286F, 0x68460BED,
    0xBF0079E5, 0x9906D932, 0x2F9E5535, 0x2A3C4947, 0xF0E240C3,
    0xE835A264, 0x43F38C0, 0x82DAADD8, 0x313612B1, 0x560D56FB,
    0x61BD734A, 0x58FD6B36, 0x2C45C40B, 0x55F70159, 0xA21A817D,
    0xAAA6FCE, 0x85BFDFB9, 0x1C71DE25, 0x56CB4C2C, 0x50FD91E5,
    0xF2340E88, 0x72BD5702, 0xB4FFBD3A, 0x1B35B171, 0xE94A34BD,
    0xC4C77575, 0x95B10420, 0x2471BC3F, 0xCB429841, 0x6DC5347F,
    0xC93CF782, 0xF1D26B2C, 0xEB2A260F, 0x67C3AE9, 0x34A56A4,
    0xF1F3D01B, 0xD8295F22, 0x7F9E5D4A, 0xE4DB3DEA, 0xE1531DCB,
    0x2C5FF857, 0x73622A7C, 0xC2691F1, 0xBC622B61, 0xE6A08C89,
    0xBA1807D4, 0x43ADBE43, 0xD90D427C, 0xC7A5C24, 0x613ED316,
    0xEC810B10, 0x1049BF74, 0x9A14C123, 0xA7B24E7E, 0x73254165,
    0x2C54081E, 0x14FF25AA, 0x7A12F3B4, 0xB4DF7C56, 0x89BFE8FC,
    0x5D5A04A6, 0xBE007173, 0x829DF863, 0x63E5E57D, 0x58F64C28,
    0x31A38144, 0xE843289B, 0xB48DFAF1, 0x2B335C2A, 0xEC3C96CE,
    0x255543F6, 0x33F17311, 0x3C60C51A, 0xE5D0D660, 0x5E162559,
    0xA2D9416, 0x9DDE4967, 0x28156A65, 0x71650796, 0x74EE54D1,
    0x3E8C19F7, 0x797C1E42, 0x2C536DFD, 0x2F3EED4D, 0x3BFC7C95,
    0x8EAEF87D, 0x18F5B02A, 0xA3532651, 0x24508E13, 0x280B9049,
    0xE4FC61CB, 0x388BA30F, 0xEC180A43, 0xBFDE77A4, 0x98CDB399,
    0xF82B586D, 0x38525AE7, 0x9D857BE8, 0xDD939D18, 0xD5CA6EBA,
    0xB70DDBA, 0xDFF43867, 0xD06AB2D0, 0xD8C78BB, 0x78F6AE4F,
    0x4C9A58CC, 0x9F9AA50E, 0x7D6A3912, 0xD897C7E4, 0x82F5939D,
    0xA4A9FFF5, 0x2CB56FDE, 0x3E082D4B, 0xB829DC58, 0xE4515CEB,
    0xCE585A33, 0x27901244, 0x68860E95, 0xE156A451, 0x9E351FE0,
    0xC69BD757, 0x4B2C4A2B, 0xD5DE5A91, 0x3557B0DE, 0x99E910B0,
    0x975BE470, 0xDB4DE130, 0xE4C6DA1D, 0xC2BC058F, 0x37544906,
    0x12CC200E, 0x54569133, 0x6586FC03, 0xF183C0CF, 0x642583E,
    0xFBE882CD, 0x8A098C35, 0xE8300988, 0xFE835E55, 0xEA74FD24,
    0xF3127AB2, 0xEE8379F2, 0x3F136FD2, 0x472AA942, 0x3BC1A7D7,
    0x5B6A8A98, 0xF039CCF3, 0x5E55425B, 0x3F801B4, 0x44556FB4,
    0xCC966D37, 0x56E32B90, 0x2BCDA2E5, 0xC70F1125, 0x8C2A015C,
    0x3D37FCA7, 0x2118A4EF, 0xCE051A9C, 0xCB84DCB9, 0x8451C9E0,
    0x4BDB1900, 0x8FC71D5D, 0xF61FD749, 0xA696D2E0, 0x6EED502A,
    0xB345CE8B, 0x76FCDA8E, 0xBE4A45F8, 0x8375E9E7, 0x625FF29B,
    0xCEC61240, 0x3876B21D, 0xBA8C8F59, 0x8CD169C6, 0x9F82251F,
    0x2E6EC495, 0x99319E, 0xB0160B46, 0x8B77EDD8, 0x6217902B,
    0x76FA6AD0, 0xB541F2BC, 0x961EA91C, 0x6F554C1F, 0xBD92328D,
    0xA9C077FD, 0x90A5311C, 0xEFE9B1FB, 0x9C84AA8C, 0x812517C3,
    0xFE71D7F4, 0xC4F6A5BF, 0x8B75A262, 0xC726EB36, 0x5F803035,
    0xCECDE2B7, 0xF61152A8, 0x78557ED1, 0x50F3BB55, 0xDD830290,
    0xB125B524, 0xC8683B0D, 0xE5FD573B, 0x48B13066, 0x62AE556E,
    0x5A637C89, 0x498D69F, 0x3F3A5BE5, 0xB98B86D7, 0x20CF4AF4,
    0xA3E55E7D, 0xEE93FC6F, 0xCCA95763, 0x5B3C5706, 0x8342B013,
    0xA0C7BDB9, 0x83D686E4, 0x6934B64, 0x324D75C3, 0x9A100C81,
    0x72E7E9AE, 0xC729A8AC, 0x9E8489E0, 0xFE5BC233, 0x64709AE9,
    0x113437BC, 0x296DEBC0, 0xC4376603, 0x9F0CD7EE, 0x6412AB97,
    0x3EECEFCD, 0x62DCD50, 0x15DFF1, 0xEEFDCF8E, 0x119849C1,
    0xDAAC93FF, 0xD531AF57, 0x82A10F47, 0xD55B7A97, 0x2F3A268B,
    0x4F1CC181, 0xAE01C1AC, 0xF3CF6F61, 0xE8BDAED5, 0x7397FD99,
    0xDD36A03C, 0x9BAED7C3, 0x51404903, 0xB9867B61, 0x3880A4FD,
    0x42B90A49, 0xA94696C1, 0x546DEA1D, 0xEE73A3DE, 0x1A4BAC37,
    0xBC6AF7AE, 0x7DD5B57B, 0xD2F121F, 0xD2BCCA1E, 0xD5DC4753,
    0xA135C08C, 0x78E97831, 0x9B91C00B, 0xFFF2C044, 0x147B797F,
    0x299CFB60, 0x71083BB, 0xB39A6C4F, 0x4814E3E1, 0xBD246AB0,
    0xBCD61250, 0x2D0870, 0xC660435C, 0xCA11681E, 0xADA4C80E,
    0x790C8875, 0x8C4F0D08, 0x48D90C74, 0xE874E9AA, 0xA8013EE8,
    0xB2D23A7A, 0xAF73A16E, 0x2485512C, 0x698E0CB2, 0x2FF566C9,
    0xC1B0C3C6, 0x2BE17C0E, 0xC42C3907, 0xD8A2EA94, 0x8991D24C,
    0x19B939F1, 0xF936F8B3, 0xA72D7EF1, 0x97EED001, 0xBF9C5156,
    0x75F08A67, 0x9AFD5756, 0x5D9D359C, 0xF905B7EC, 0x2B1553E1,
    0x9E0FD4E1, 0x8DC4814C, 0x89F28E6D, 0x14174915, 0x1F3A4217,
    0xA8F367F9, 0x93EE87C5, 0xAD70C6D8, 0xF04D465C, 0xE403D72B,
    0xA686EC0F, 0xCD3A5728, 0xA1BD007, 0x9E21E401, 0xAE8517CF,
    0x6DDB79FC, 0x8CB2C475, 0x6F71544, 0xBEAC91CF, 0x4739DC4E,
    0x6CF4F788, 0x36BAD9AC, 0xF23568D4, 0x250BAB0A, 0x4633384F,
    0x54F6F251, 0x454F9605, 0xCB1A346, 0x632E207F, 0x3017539C,
    0x174A33ED, 0xBDCFD2DE, 0xC17F3D39, 0x17B8A9A2, 0xC267FB51,
    0x9322387D, 0x348760C, 0x3C14D7E0, 0xE4E4254E, 0xCA72AA41,
    0xB6102ED3, 0x6317A3F, 0xD3B6B9F7, 0xA8C71BB7, 0x6E452957,
    0x3F896E32, 0xE38A4A58, 0x9893F432, 0x110A21D4, 0xE835FEBE,
    0x90F51080, 0xD0AC5AF, 0x4FCB9903, 0xFE547785, 0x144B285D,
    0xD0ECC753, 0xAE503BA4, 0x57CEAABC, 0x95713FE6, 0x5B0F4F86,
    0xD94BD751, 0x4017F139, 0xF60F5E1D, 0xB9A63351, 0xF7F94F6A,
    0x7E556ECC, 0xBFDB8642, 0xB70D07D, 0x351BEA77, 0xD1F3CAD,
    0xA3D7EF4D, 0x1EAA28E3, 0x98A2EA79, 0xD8647392, 0x1B896804,
    0x35CA6A08, 0x305258F, 0xE58BD955, 0xABCB6278, 0x87CF1146,
    0x13145966, 0x45BB55CD, 0x818AA368, 0xA027F11F, 0x64C427A3,
    0xEC831B99, 0xF2BD53F9, 0x7FDA7301, 0x35BE80D4, 0x5256E6FB,
    0xC97D33AE, 0x30921709, 0xC2724BEC, 0x78F5436F, 0x4F5749CD,
    0x9007F551, 0x327C31C0, 0x89782D13, 0x119AD125, 0xB1071A01,
    0x63100C70, 0x83120035, 0xA8E2E403, 0x7E213FA3, 0xBF06AAC4,
    0xBA68C4D9, 0x4B568927, 0x1DDD40F, 0x10FC10E8, 0xBBD7230A,
    0x96475640, 0x8C8E6EC1, 0x44A1134A, 0xEF0F40F0, 0x51E2A5E0,
    0x61AE6D65, 0x9DE72FD6, 0xB1711336, 0x90BEB84, 0xD610EFC6,
    0x3D231F91, 0xB5885164, 0x2CB2112C, 0x36F50789, 0x3DEF2AB9,
    0x1D9DC1DA, 0xA37DB070, 0x2AA92EB, 0x2D57ED6E, 0xD6E2C2CD,
    0xB78FC54C, 0x767A565E, 0x1D1F5AAE, 0x89F256DB, 0x716A97D,
    0x1344431D, 0xFAF015FB, 0xFED59649, 0xC479882A, 0xEEFC3D1E,
    0x840AE162, 0xD963A347, 0x75462C25, 0xDA990E07, 0x9A57DE31,
    0x74A35F20, 0x91852CD6, 0x3F16DE14, 0x5FA6A255, 0x47D00F85,
    0x1B4836C9, 0xC73D0290, 0xE301026B, 0x592068D6, 0x7C32A301,
    0x3A3C04C4, 0xB5BD3BAF, 0xB8C3BF60, 0x76723A1B, 0xD05BC35E,
    0x7679021C, 0x6298096, 0x590BA59C, 0xBB30A2F6, 0xE5F6B06C,
    0x21BD2A9E, 0xAC68D7DA, 0xEDA2ED5A, 0xA10E60FA, 0xABDBF569,
    0x17F5868E, 0x82AA8505, 0x384BD8FC, 0x68DC2746, 0x8F029C0D,
    0x3755EB11, 0xAEF4BB79, 0x453B87BA, 0x9926977F, 0x1FA1B806,
    0xC905618, 0x9BFE8E92, 0xF6F68A5A, 0xAA955D92, 0x44F57A4A,
    0x2186E272, 0x62EB01DA, 0x85A2D502, 0xB087955D, 0x26FF2BA0,
    0x8D462C04, 0xE024573B, 0x609CDBD7, 0xA99B9D19, 0xFEEB3F60,
    0x12903A0D, 0x46480C6, 0xDD0BD1B9, 0x6C60C43, 0x5E11A4FE,
    0x935E9E58, 0x8A7F6D33, 0xA505132D, 0xBB2E3E12, 0xF48633F4,
    0xF3BA8CF7, 0xC25D4EDD, 0x788672B8, 0xB2812608, 0xACB3A62,
    0x2EEB679A, 0x443A71B9, 0xC42F4B12, 0xD28B3482, 0x5571FA8A,
    0x5C0B3D55, 0x8B8619C6, 0xF564F10C, 0xD9A7C914, 0xFBD1EF46,
    0xCEABC573, 0xEC609D28, 0x5839413B, 0x5019E901, 0x248FFF30,
    0x7BFFB801, 0x7FD46584, 0x43702812, 0x3A5A0880, 0x7E3E9EDA,
    0xCA4623E3, 0x2FB87A70, 0xFE70D956, 0xCE9EB3E6, 0x9A2CD2F1,
    0x92EFB0C8, 0xC7E23873, 0x53B63A86, 0xB9D93548, 0x3C022B2,
    0xCF4F22A6, 0x981E70BC, 0x4A05F3AB, 0xD763E93B, 0x6EAF767D,
    0x4162629D, 0xD82A25E7, 0x6CDD19A3, 0x13524F68, 0xE5F23FDC,
    0xB37F311F, 0x35FD43B6, 0x36626469, 0x1E409CF6, 0xE4C04F9D,
    0xC1B58001, 0xD131078F, 0x9DE279A, 0x80B62212, 0x526405DD,
    0xC17777C1, 0x7045FCDC, 0x53862AEC, 0x5D583056, 0xEB532222,
    0x5837EA32, 0x719C06A4, 0x43D4F131, 0x577C6DDB, 0x9E5815A7,
    0x8189DDD9, 0x170F154F, 0xEF813B20, 0x4DD83A53, 0xB09A28FD,
    0x8D0DBED5, 0x1836596D, 0xC5BB2696, 0xA69FC859, 0xD6FF5E0D,
    0xCCC65761, 0xC818C6F7, 0x7A25F980, 0xF949133, 0xC515C093,
    0xA8AD04B5, 0x6768AC1C, 0xB5BE2C4A, 0x4F04616F, 0xBD28E4E3,
    0x4CCA6347, 0x5F61C031
};

/* The source data is random across the q31_t range. Accessing it by word should
   remain random. */
q15_t * transform_fft_q15_inputs = (q15_t *) transform_fft_q31_inputs;

q15_t dct4_transform_fft_q15_inputs[TRANSFORM_MAX_FFT_LEN * 2] =
{
   0x0000, 0x2d5c, 0x54d5, 0x714b, 0x7f0d, 0x7c51, 0x6972, 0x48e4, 
   0x1edf, 0xf0da, 0xc4cb, 0xa06c, 0x8874, 0x8001, 0x882a, 0x9fe2, 
   0xc413, 0xf00c, 0x1e16, 0x4839, 0x68fc, 0x7c1f, 0x7f25, 0x71ab, 
   0x5570, 0x2e1e, 0x00cf, 0xd367, 0xabc7, 0x8f16, 0x810d, 0x837e, 
   0x9619, 0xb672, 0xe057, 0x0e58, 0x3a7c, 0x5f0a, 0x7741, 0x7ffe, 
   0x781e, 0x60a7, 0x3ca4, 0x10c2, 0xe2b4, 0xb873, 0x977b, 0x8415, 
   0x80c3, 0x8df6, 0xa9f6, 0xd121, 0xfe61, 0x2bd6, 0x539c, 0x7087, 
   0x7ed8, 0x7cb1, 0x6a5c, 0x4a38, 0x2072, 0xf277, 0xc63d, 0xa182, 
   0x890b, 0x8005, 0x879b, 0x9ed2, 0xc2a6, 0xee70, 0x1c81, 0x46e0, 
   0x680c, 0x7bb7, 0x7f53, 0x7268, 0x56a3, 0x2fa0, 0x026f, 0xd4ed, 
   0xad02, 0x8fdc, 0x8145, 0x8321, 0x9531, 0xb51f, 0xdec5, 0x0cba, 
   0x390a, 0x5df1, 0x76a8, 0x7ff7, 0x78ab, 0x61b5, 0x3e10, 0x125e, 
   0xe449, 0xb9cd, 0x986d, 0x847f, 0x8099, 0x8d3c, 0xa8c4, 0xcf9f, 
   0xfcc2, 0x2a4f, 0x5260, 0x6fbf, 0x7e9d, 0x7d0c, 0x6b40, 0x4b89, 
   0x2203, 0xf414, 0xc7b1, 0xa29c, 0x89a7, 0x800e, 0x8710, 0x9dc5, 
   0xc13a, 0xecd5, 0x1aec, 0x4585, 0x6718, 0x7b4a, 0x7f7b, 0x7320, 
   0x57d3, 0x3121, 0x040e, 0xd675, 0xae40, 0x90a7, 0x8182, 0x82c8, 
   0x944f, 0xb3d0, 0xdd35, 0x0b1d, 0x3795, 0x5cd5, 0x760a, 0x7fec, 
   0x7933, 0x62bf, 0x3f7a, 0x13f8, 0xe5df, 0xbb2a, 0x9964, 0x84ef, 
   0x8073, 0x8c86, 0xa796, 0xce20, 0xfb23, 0x28c6, 0x5120, 0x6ef2, 
   0x7e5e, 0x7d63, 0x6c21, 0x4cd7, 0x2393, 0xf5b2, 0xc927, 0xa3ba, 
   0x8a47, 0x801c, 0x868b, 0x9cbd, 0xbfd1, 0xeb3b, 0x1955, 0x4427, 
   0x6620, 0x7ad7, 0x7f9d, 0x73d3, 0x5900, 0x329f, 0x05ad, 0xd7ff, 
   0xaf81, 0x9176, 0x81c4, 0x8274, 0x9370, 0xb284, 0xdba6, 0x097f, 
   0x361d, 0x5bb5, 0x7566, 0x7fda, 0x79b6, 0x63c6, 0x40e2, 0x1592, 
   0xe777, 0xbc8a, 0x9a5e, 0x8564, 0x8053, 0x8bd5, 0xa66b, 0xcca2, 
   0xf983, 0x273c, 0x4fdd, 0x6e21, 0x7e19, 0x7db3, 0x6cfd, 0x4e21, 
   0x2521, 0xf750, 0xca9f, 0xa4dc, 0x8aed, 0x8030, 0x860a, 0x9bb9, 
   0xbe6b, 0xe9a1, 0x17bd, 0x42c6, 0x6523, 0x7a60, 0x7fbb, 0x7481, 
   0x5a29, 0x341c, 0x074c, 0xd98a, 0xb0c6, 0x924a, 0x820b, 0x8226, 
   0x9297, 0xb13b, 0xda18, 0x07e0, 0x34a4, 0x5a92, 0x74bf, 0x7fc4, 
   0x7a34, 0x64c8, 0x4247, 0x172b, 0xe90f, 0xbdec, 0x9b5d, 0x85dd, 
   0x8038, 0x8b29, 0xa544, 0xcb27, 0xf7e5, 0x25af, 0x4e97, 0x6d4b, 
   0x7dcf, 0x7dff, 0x6dd5, 0x4f69, 0x26ae, 0xf8ef, 0xcc1a, 0xa601, 
   0x8b97, 0x8049, 0x858f, 0x9ab9, 0xbd08, 0xe809, 0x1625, 0x4162, 
   0x6422, 0x79e4, 0x7fd3, 0x752b, 0x5b4e, 0x3596, 0x08eb, 0xdb17, 
   0xb20e, 0x9322, 0x8258, 0x81dd, 0x91c1, 0xaff5, 0xd88c, 0x0641, 
   0x3328, 0x596a, 0x7412, 0x7fa8, 0x7aad, 0x65c6, 0x43a9, 0x18c3, 
   0xeaa8, 0xbf51, 0x9c5f, 0x865c, 0x8023, 0x8a82, 0xa421, 0xc9ad, 
   0xf646, 0x2422, 0x4d4d, 0x6c70, 0x7d80, 0x7e46, 0x6ea8, 0x50ad, 
   0x2839, 0xfa8e, 0xcd97, 0xa72b, 0x8c46, 0x8067, 0x8518, 0x99bd, 
   0xbba7, 0xe671, 0x148b, 0x3ffb, 0x631e, 0x7963, 0x7fe6, 0x75d0, 
   0x5c6f, 0x370f, 0x0a89, 0xdca6, 0xb359, 0x93ff, 0x82a9, 0x8199, 
   0x90f0, 0xaeb2, 0xd702, 0x04a2, 0x31aa, 0x583f, 0x7360, 0x7f88, 
   0x7b21, 0x66c0, 0x4508, 0x1a5a, 0xec42, 0xc0b9, 0x9d66, 0x86e0, 
   0x8012, 0x89e0, 0xa302, 0xc836, 0xf4a8, 0x2292, 0x4c01, 0x6b91, 
   0x7d2c, 0x7e87, 0x6f76, 0x51ee, 0x29c3, 0xfc2d, 0xcf16, 0xa858, 
   0x8cfa, 0x808b, 0x84a7, 0x98c5, 0xba4a, 0xe4da, 0x12f1, 0x3e92, 
   0x6215, 0x78dc, 0x7ff4, 0x7670, 0x5d8c, 0x3884, 0x0c27, 0xde36, 
   0xb4a7, 0x94e0, 0x8300, 0x815a, 0x9024, 0xad73, 0xd579, 0x0303, 
   0x302a, 0x5711, 0x72aa, 0x7f61, 0x7b90, 0x67b5, 0x4664, 0x1bf0, 
   0xeddd, 0xc223, 0x9e71, 0x8769, 0x8007, 0x8942, 0xa1e6, 0xc6c2, 
   0xf30b, 0x2102, 0x4ab1, 0x6aae, 0x7cd2, 0x7ec3, 0x7040, 0x532b, 
   0x2b4b, 0xfdcc, 0xd097, 0xa988, 0x8db3, 0x80b4, 0x843a, 0x97d1, 
   0xb8ef, 0xe345, 0x1155, 0x3d27, 0x6108, 0x7851, 0x7ffc, 0x770b, 
   0x5ea6, 0x39f8, 0x0dc4, 0xdfc7, 0xb5f8, 0x95c5, 0x835c, 0x8120, 
   0x8f5d, 0xac37, 0xd3f2, 0x0164, 0x2ea8, 0x55de, 0x71ef, 0x7f36, 
   0x7bfa, 0x68a7, 0x47be, 0x1d85, 0xef79, 0xc390, 0x9f80, 0x87f6, 
   0x8001, 0x88a9, 0xa0cf, 0xc54f, 0xf16e, 0x1f70, 0x495e, 0x69c6, 
   0x7c74, 0x7efa, 0x7106, 0x5465, 0x2cd1, 0xff6c, 0xd219, 0xaabc, 
   0x8e70, 0x80e2, 0x83d3, 0x96e2, 0xb796, 0xe1b1, 0x0fb9, 0x3bb8, 
   0x5ff7, 0x77c1, 0x7fff, 0x77a1, 0x5fbc, 0x3b69, 0x0f61, 0xe15a, 
   0xb74d, 0x96af, 0x83bd, 0x80ec, 0x8e9a, 0xaaff, 0xd26d, 0xffc5, 
   0x2d24, 0x54a8, 0x712f, 0x7f05, 0x7c5f, 0x6994, 0x4914, 0x1f19, 
   0xf115, 0xc500, 0xa093, 0x8889, 0x8001, 0x8816, 0x9fbb, 0xc3df, 
   0xefd1, 0x1ddc, 0x4808, 0x68da, 0x7c10, 0x7f2c, 0x71c6, 0x559c, 
   0x2e55, 0x010a, 0xd39e, 0xabf4, 0x8f32, 0x8115, 0x8371, 0x95f7, 
   0xb641, 0xe01e, 0x0e1d, 0x3a48, 0x5ee2, 0x772c, 0x7ffd, 0x7832, 
   0x60cd, 0x3cd8, 0x10fd, 0xe2ee, 0xb8a4, 0x979e, 0x8423, 0x80bd, 
   0x8ddb, 0xa9ca, 0xd0ea, 0xfe26, 0x2b9f, 0x536f, 0x706b, 0x7ed0, 
   0x7cbf, 0x6a7c, 0x4a68, 0x20ab, 0xf2b2, 0xc672, 0xa1aa, 0x8921, 
   0x8006, 0x8787, 0x9eab, 0xc272, 0xee36, 0x1c48, 0x46af, 0x67ea, 
   0x7ba8, 0x7f59, 0x7282, 0x56cf, 0x2fd7, 0x02aa, 0xd525, 0xad2f, 
   0x8ff9, 0x814d, 0x8314, 0x9511, 0xb4ef, 0xde8c, 0x0c80, 0x38d5, 
   0x5dc9, 0x7692, 0x7ff6, 0x78bf, 0x61db, 0x3e44, 0x1298, 0xe483, 
   0xb9ff, 0x9890, 0x848f, 0x8093, 0x8d22, 0xa899, 0xcf68, 0xfc87, 
   0x2a17, 0x5232, 0x6fa2, 0x7e95, 0x7d19, 0x6b61, 0x4bb8, 0x223c, 
   0xf44f, 0xc7e6, 0xa2c5, 0x89bd, 0x8010, 0x86fd, 0x9d9f, 0xc107, 
   0xec9b, 0x1ab2, 0x4553, 0x66f5, 0x7b3a, 0x7f80, 0x7339, 0x57fe, 
   0x3157, 0x0449, 0xd6ad, 0xae6d, 0x90c4, 0x818b, 0x82bc, 0x942f, 
   0xb3a0, 0xdcfc, 0x0ae2, 0x375f, 0x5cad, 0x75f3, 0x7fe9, 0x7946, 
   0x62e5, 0x3fae, 0x1433, 0xe619, 0xbb5c, 0x9987, 0x84ff, 0x806f, 
   0x8c6d, 0xa76b, 0xcde9, 0xfae7, 0x288e, 0x50f2, 0x6ed5, 0x7e54, 
   0x7d6e, 0x6c41, 0x4d06, 0x23cc, 0xf5ed, 0xc95c, 0xa3e3, 0x8a5f, 
   0x801f, 0x8678, 0x9c98, 0xbf9e, 0xeb00, 0x191b, 0x43f5, 0x65fc, 
   0x7ac7, 0x7fa2, 0x73ec, 0x592a, 0x32d6, 0x05e8, 0xd837, 0xafaf, 
   0x9194, 0x81ce, 0x8269, 0x9351, 0xb255, 0xdb6d, 0x0944, 0x35e8, 
   0x5b8c, 0x754f, 0x7fd8, 0x79c8, 0x63eb, 0x4115, 0x15cc, 0xe7b1, 
   0xbcbc, 0x9a82, 0x8575, 0x804f, 0x8bbd, 0xa641, 0xcc6c, 0xf948, 
   0x2703, 0x4faf, 0x6e03, 0x7e0f, 0x7dbf, 0x6d1c, 0x4e50, 0x255a, 
   0xf78b, 0xcad5, 0xa505, 0x8b05, 0x8033, 0x85f8, 0x9b94, 0xbe39, 
   0xe967, 0x1783, 0x4293, 0x64ff, 0x7a4f, 0x7fbf, 0x749a, 0x5a52, 
   0x3452, 0x0787, 0xd9c3, 0xb0f4, 0x9268, 0x8216, 0x821b, 0x9278, 
   0xb10c, 0xd9e0, 0x07a5, 0x346e, 0x5a68, 0x74a6, 0x7fc0, 0x7a46, 
   0x64ec, 0x4279, 0x1765, 0xe949, 0xbe1f, 0x9b81, 0x85ef, 0x8035, 
   0x8b11, 0xa51b, 0xcaf1, 0xf7aa, 0x2577, 0x4e68, 0x6d2c, 0x7dc4, 
   0x7e0a, 0x6df3, 0x4f97, 0x26e6, 0xf92a, 0xcc50, 0xa62c, 0x8bb0, 
   0x804d, 0x857d, 0x9a95, 0xbcd6, 0xe7cf, 0x15ea, 0x412f, 0x63fe, 
   0x79d2, 0x7fd6, 0x7543, 0x5b77, 0x35cc, 0x0925, 0xdb50, 0xb23d, 
   0x9341, 0x8263, 0x81d3, 0x91a3, 0xafc7, 0xd854, 0x0606, 0x32f2, 
   0x5940, 0x73f9, 0x7fa4, 0x7abe, 0x65ea, 0x43db, 0x18fd, 0xeae2, 
   0xbf84, 0x9c85, 0x866f, 0x8020, 0x8a6b, 0xa3f8, 0xc978, 0xf60b, 
   0x23e9, 0x4d1e, 0x6c51, 0x7d74, 0x7e4f, 0x6ec5, 0x50db, 0x2871, 
   0xfac9, 0xcdcd, 0xa755, 0x8c60, 0x806c, 0x8508, 0x9999, 0xbb75, 
   0xe637, 0x1451, 0x3fc8, 0x62f8, 0x7950, 0x7fe8, 0x75e7, 0x5c98, 
   0x3744, 0x0ac4, 0xdcdf, 0xb388, 0x941e, 0x82b5, 0x8190, 0x90d3, 
   0xae85, 0xd6ca, 0x0467, 0x3173, 0x5814, 0x7347, 0x7f82, 0x7b31, 
   0x66e3, 0x453a, 0x1a94, 0xec7d, 0xc0ec, 0x9d8c, 0x86f3, 0x8011, 
   0x89c9, 0xa2d9, 0xc801, 0xf46d, 0x2259, 0x4bd1, 0x6b71, 0x7d1f, 
   0x7e90, 0x6f93, 0x521b, 0x29fb, 0xfc68, 0xcf4c, 0xa883, 0x8d14, 
   0x8090, 0x8497, 0x98a2, 0xba18, 0xe4a1, 0x12b6, 0x3e5f, 0x61ef, 
   0x78c9, 0x7ff5, 0x7686, 0x5db5, 0x38b9, 0x0c61, 0xde6f, 0xb4d7, 
   0x9500, 0x830d, 0x8152, 0x9007, 0xad46, 0xd541, 0x02c8, 0x2ff3, 
   0x56e5, 0x7290, 0x7f5c, 0x7ba0, 0x67d8, 0x4696, 0x1c2a, 0xee17, 
   0xc257, 0x9e97, 0x877d, 0x8006, 0x892c, 0xa1be, 0xc68d, 0xf2d0, 
   0x20c8, 0x4a81, 0x6a8d, 0x7cc5, 0x7ecc, 0x705d, 0x5358, 0x2b82, 
   0xfe08, 0xd0ce, 0xa9b4, 0x8dce, 0x80ba, 0x842b, 0x97af, 0xb8bd, 
   0xe30b, 0x111b, 0x3cf3, 0x60e1, 0x783d, 0x7ffd, 0x7721, 0x5ece, 
   0x3a2d, 0x0dff, 0xe000, 0xb629, 0x95e6, 0x836a, 0x8119, 0x8f41, 
   0xac0b, 0xd3bb, 0x0129, 0x2e71, 0x55b2, 0x71d4, 0x7f2f, 0x7c09, 
   0x68c9, 0x47ef, 0x1dbf, 0xefb3, 0xc3c4, 0x9fa7, 0x880b, 0x8001, 
   0x8894, 0xa0a7, 0xc51b, 0xf133, 0x1f36, 0x492d, 0x69a5, 0x7c66, 
   0x7f02, 0x7121, 0x5492, 0x2d08, 0xffa7, 0xd251, 0xaae8, 0x8e8b, 
   0x80e9, 0x83c5, 0x96c1, 0xb766, 0xe177, 0x0f7f, 0x3b84, 0x5fd0, 
   0x77ac, 0x7fff, 0x77b6, 0x5fe3, 0x3b9d, 0x0f9b, 0xe193, 0xb77d, 
   0x96d1, 0x83cc, 0x80e5, 0x8e7e, 0xaad3, 0xd236, 0xff8a, 0x2ced, 
   0x547c, 0x7114, 0x7efe, 0x7c6d, 0x69b5, 0x4945, 0x1f52, 0xf150, 
   0xc534, 0xa0ba, 0x889e, 0x8001, 0x8801, 0x9f94, 0xc3ab, 0xef97, 
   0x1da3, 0x47d7, 0x68b8, 0x7c02, 0x7f33, 0x71e1, 0x55c8, 0x2e8c, 
   0x0145, 0xd3d6, 0xac20, 0x8f4e, 0x811c, 0x8363, 0x95d6, 0xb611, 
   0xdfe5, 0x0de2, 0x3a13, 0x5eba, 0x7716, 0x7ffd, 0x7847, 0x60f4, 
   0x3d0c, 0x1137, 0xe327, 0xb8d5, 0x97c0, 0x8432, 0x80b7, 0x8dc1, 
   0xa99f, 0xd0b3, 0xfdeb, 0x2b67, 0x5342, 0x704f, 0x7ec8, 0x7ccc, 
   0x6a9d, 0x4a98, 0x20e4, 0xf2ed, 0xc6a6, 0xa1d2, 0x8937, 0x8007, 
   0x8773, 0x9e85, 0xc23e, 0xedfb, 0x1c0e, 0x467e, 0x67c7, 0x7b98, 
   0x7f5e, 0x729d, 0x56fa, 0x300e, 0x02e5, 0xd55c, 0xad5c, 0x9015, 
   0x8156, 0x8307, 0x94f0, 0xb4c0, 0xde53, 0x0c45, 0x38a0, 0x5da1, 
   0x767b, 0x7ff5, 0x78d2, 0x6201, 0x3e78, 0x12d3, 0xe4bd, 0xba30, 
   0x98b3, 0x849e, 0x808e, 0x8d08, 0xa86e, 0xcf32, 0xfc4c, 0x29df, 
   0x5205, 0x6f85, 0x7e8c, 0x7d25, 0x6b81, 0x4be8, 0x2275, 0xf48a, 
   0xc81b, 0xa2ed, 0x89d4, 0x8011, 0x86ea, 0x9d7a, 0xc0d3, 0xec60, 
   0x1a78, 0x4522, 0x66d2, 0x7b2a, 0x7f85, 0x7353, 0x5829, 0x318e, 
   0x0484, 0xd6e5, 0xae9b, 0x90e1, 0x8194, 0x82b0, 0x940f, 0xb371, 
   0xdcc3, 0x0aa7, 0x372a, 0x5c84, 0x75dc, 0x7fe7, 0x7959, 0x630a, 
   0x3fe1, 0x146d, 0xe653, 0xbb8e, 0x99aa, 0x8510, 0x806a, 0x8c53, 
   0xa741, 0xcdb3, 0xfaac, 0x2856, 0x50c4, 0x6eb7, 0x7e4b, 0x7d7a, 
   0x6c60, 0x4d35, 0x2404, 0xf628, 0xc992, 0xa40c, 0x8a76, 0x8021, 
   0x8666, 0x9c72, 0xbf6b, 0xeac6, 0x18e1, 0x43c2, 0x65d8, 0x7ab6, 
   0x7fa6, 0x7405, 0x5955, 0x330c, 0x0623, 0xd86f, 0xafdd, 0x91b2, 
   0x81d8, 0x825e, 0x9332, 0xb226, 0xdb34, 0x0909, 0x35b2, 0x5b63, 
   0x7537, 0x7fd5, 0x79db, 0x6410, 0x4148, 0x1607, 0xe7eb, 0xbcee, 
   0x9aa6, 0x8586, 0x804b, 0x8ba4, 0xa617, 0xcc36, 0xf90d, 0x26cb, 
   0x4f80, 0x6de4, 0x7e05, 0x7dca, 0x6d3b, 0x4e7f, 0x2592, 0xf7c6, 
   0xcb0b, 0xa52f, 0x8b1d, 0x8037, 0x85e6, 0x9b6f, 0xbe06, 0xe92d, 
   0x1749, 0x4261, 0x64db, 0x7a3d, 0x7fc2, 0x74b2, 0x5a7c, 0x3488, 
   0x07c2, 0xd9fb, 0xb123, 0x9287, 0x8220, 0x8211, 0x9259, 0xb0de, 
   0xd9a7, 0x076a, 0x3438, 0x5a3e, 0x748e, 0x7fbd, 0x7a57, 0x6511, 
   0x42ac, 0x179f, 0xe983, 0xbe51, 0x9ba6, 0x8601, 0x8032, 0x8af9, 
   0xa4f1, 0xcabb, 0xf76f, 0x253e, 0x4e39, 0x6d0d, 0x7db9, 0x7e14, 
   0x6e11, 0x4fc5, 0x271f, 0xf965, 0xcc86, 0xa656, 0x8bc9, 0x8051, 
   0x856c, 0x9a70, 0xbca3, 0xe795, 0x15b0, 0x40fc, 0x63d9, 0x79c0, 
   0x7fd9, 0x755a, 0x5ba0, 0x3602, 0x0960, 0xdb89, 0xb26c, 0x9360, 
   0x826e, 0x81c9, 0x9185, 0xaf99, 0xd81c, 0x05cb, 0x32bb, 0x5916, 
   0x73e0, 0x7fa0, 0x7acf, 0x660d, 0x440d, 0x1937, 0xeb1d, 0xbfb7, 
   0x9caa, 0x8681, 0x801e, 0x8a53, 0xa3cf, 0xc942, 0xf5d0, 0x23b0, 
   0x4cef, 0x6c31, 0x7d69, 0x7e59, 0x6ee3, 0x5108, 0x28a9, 0xfb04, 
   0xce04, 0xa780, 0x8c79, 0x8071, 0x84f7, 0x9976, 0xbb43, 0xe5fd, 
   0x1416, 0x3f95, 0x62d3, 0x793d, 0x7feb, 0x75fe, 0x5cc0, 0x3779, 
   0x0aff, 0xdd18, 0xb3b8, 0x943e, 0x82c2, 0x8186, 0x90b6, 0xae57, 
   0xd692, 0x042c, 0x313d, 0x57ea, 0x732d, 0x7f7d, 0x7b41, 0x6706, 
   0x456b, 0x1ace, 0xecb7, 0xc120, 0x9db2, 0x8706, 0x800f, 0x89b2, 
   0xa2b1, 0xc7cc, 0xf433, 0x2220, 0x4ba1, 0x6b51, 0x7d13, 0x7e99, 
   0x6fb0, 0x5248, 0x2a32, 0xfca3, 0xcf83, 0xa8ae, 0x8d2e, 0x8096, 
   0x8487, 0x987f, 0xb9e6, 0xe467, 0x127c, 0x3e2b, 0x61c9, 0x78b5, 
   0x7ff7, 0x769c, 0x5ddd, 0x38ee, 0x0c9c, 0xdea8, 0xb507, 0x9521, 
   0x831a, 0x8149, 0x8feb, 0xad19, 0xd50a, 0x028d, 0x2fbc, 0x56ba, 
   0x7275, 0x7f56, 0x7baf, 0x67fa, 0x46c7, 0x1c64, 0xee52, 0xc28b, 
   0x9ebe, 0x8791, 0x8005, 0x8916, 0xa196, 0xc658, 0xf295, 0x208f, 
   0x4a51, 0x6a6c, 0x7cb8, 0x7ed4, 0x7079, 0x5385, 0x2bba, 0xfe43, 
   0xd104, 0xa9df, 0x8de8, 0x80c0, 0x841c, 0x978d, 0xb88c, 0xe2d2, 
   0x10e0, 0x3cbf, 0x60bb, 0x7828, 0x7ffe, 0x7736, 0x5ef5, 0x3a61, 
   0x0e39, 0xe03a, 0xb659, 0x9608, 0x8377, 0x8111, 0x8f25, 0xabde, 
   0xd383, 0x00ee, 0x2e3a, 0x5586, 0x71b9, 0x7f29, 0x7c17, 0x68eb, 
   0x4820, 0x1df8, 0xefee, 0xc3f9, 0x9fce, 0x8820, 0x8001, 0x887f, 
   0xa080, 0xc4e6, 0xf0f8, 0x1efd, 0x48fd, 0x6983, 0x7c58, 0x7f09, 
   0x713d, 0x54be, 0x2d3f, 0xffe2, 0xd288, 0xab15, 0x8ea7, 0x80f0, 
   0x83b6, 0x969f, 0xb735, 0xe13e, 0x0f44, 0x3b50, 0x5fa9, 0x7797, 
   0x7fff, 0x77cb, 0x600a, 0x3bd2, 0x0fd6, 0xe1cd, 0xb7ae, 0x96f3, 
   0x83da, 0x80de, 0x8e63, 0xaaa7, 0xd1ff, 0xff4f, 0x2cb6, 0x5450, 
   0x70f8, 0x7ef7, 0x7c7b, 0x69d6, 0x4975, 0x1f8b, 0xf18a, 0xc569, 
   0xa0e2, 0x88b4, 0x8002, 0x87ed, 0x9f6d, 0xc377, 0xef5c, 0x1d69, 
   0x47a6, 0x6896, 0x7bf3, 0x7f39, 0x71fc, 0x55f4, 0x2ec3, 0x0181, 
   0xd40d, 0xac4d, 0x8f6a, 0x8124, 0x8356, 0x95b5, 0xb5e1, 0xdfab, 
   0x0da7, 0x39de, 0x5e93, 0x7700, 0x7ffc, 0x785b, 0x611b, 0x3d40, 
   0x1172, 0xe361, 0xb906, 0x97e2, 0x8441, 0x80b1, 0x8da6, 0xa973, 
   0xd07c, 0xfdb0, 0x2b30, 0x5315, 0x7032, 0x7ebf, 0x7cd9, 0x6abe, 
   0x4ac8, 0x211d, 0xf327, 0xc6db, 0xa1fa, 0x894d, 0x8008, 0x875f, 
   0x9e5f, 0xc20a, 0xedc1, 0x1bd4, 0x464c, 0x67a4, 0x7b89, 0x7f64, 
   0x72b7, 0x5726, 0x3045, 0x0320, 0xd594, 0xad89, 0x9032, 0x815e, 
   0x82fa, 0x94d0, 0xb490, 0xde1a, 0x0c0a, 0x386b, 0x5d79, 0x7665, 
   0x7ff3, 0x78e6, 0x6227, 0x3eab, 0x130d, 0xe4f7, 0xba62, 0x98d6, 
   0x84ae, 0x8088, 0x8cee, 0xa843, 0xcefb, 0xfc10, 0x29a8, 0x51d8, 
   0x6f68, 0x7e83, 0x7d32, 0x6ba1, 0x4c18, 0x22ae, 0xf4c5, 0xc850, 
   0xa316, 0x89eb, 0x8013, 0x86d7, 0x9d54, 0xc0a0, 0xec26, 0x1a3e, 
   0x44f0, 0x66af, 0x7b19, 0x7f8a, 0x736d, 0x5854, 0x31c4, 0x04bf, 
   0xd71d, 0xaec9, 0x90ff, 0x819d, 0x82a4, 0x93ef, 0xb342, 0xdc8a, 
   0x0a6c, 0x36f5, 0x5c5b, 0x75c5, 0x7fe5, 0x796c, 0x6330, 0x4014, 
   0x14a7, 0xe68d, 0xbbc0, 0x99ce, 0x8520, 0x8065, 0x8c3a, 0xa716, 
   0xcd7c, 0xfa71, 0x281e, 0x5097, 0x6e99, 0x7e41, 0x7d86, 0x6c80, 
   0x4d64, 0x243d, 0xf663, 0xc9c7, 0xa435, 0x8a8d, 0x8024, 0x8653, 
   0x9c4d, 0xbf38, 0xea8c, 0x18a7, 0x4390, 0x65b4, 0x7aa5, 0x7fab, 
   0x741e, 0x597f, 0x3342, 0x065e, 0xd8a8, 0xb00b, 0x91d0, 0x81e2, 
   0x8252, 0x9313, 0xb1f7, 0xdafc, 0x08ce, 0x357c, 0x5b39, 0x751f, 
   0x7fd2, 0x79ed, 0x6434, 0x417b, 0x1641, 0xe825, 0xbd20, 0x9aca, 
   0x8597, 0x8047, 0x8b8b, 0xa5ed, 0xcc00, 0xf8d2, 0x2693, 0x4f52, 
   0x6dc6, 0x7dfa, 0x7dd4, 0x6d5a, 0x4ead, 0x25cb, 0xf801, 0xcb41, 
   0xa559, 0x8b35, 0x803a, 0x85d5, 0x9b4b, 0xbdd3, 0xe8f3, 0x170f, 
   0x422e, 0x64b6, 0x7a2c, 0x7fc6, 0x74ca, 0x5aa6, 0x34be, 0x07fd, 
   0xda34, 0xb151, 0x92a5, 0x822b, 0x8206, 0x923b, 0xb0af, 0xd96f, 
   0x072f, 0x3402, 0x5a14, 0x7475, 0x7fb9, 0x7a69, 0x6535, 0x42de, 
   0x17da, 0xe9bd, 0xbe84, 0x9bcb, 0x8613, 0x802f, 0x8ae1, 0xa4c8, 
   0xca85, 0xf734, 0x2506, 0x4e0a, 0x6cee, 0x7dae, 0x7e1e, 0x6e2f, 
   0x4ff3, 0x2757, 0xf9a0, 0xccbc, 0xa680, 0x8be1, 0x8055, 0x855b, 
   0x9a4d, 0xbc71, 0xe75a, 0x1576, 0x40c9, 0x63b4, 0x79ad, 0x7fdc, 
   0x7572, 0x5bca, 0x3637, 0x099b, 0xdbc1, 0xb29b, 0x9380, 0x827a, 
   0x81bf, 0x9168, 0xaf6b, 0xd7e4, 0x0590, 0x3285, 0x58eb, 0x73c7, 
   0x7f9b, 0x7adf, 0x6631, 0x443f, 0x1971, 0xeb57, 0xbfea, 0x9ccf, 
   0x8694, 0x801b, 0x8a3c, 0xa3a6, 0xc90d, 0xf596, 0x2377, 0x4cc0, 
   0x6c12, 0x7d5d, 0x7e62, 0x6f00, 0x5136, 0x28e1, 0xfb3f, 0xce3a, 
   0xa7ab, 0x8c93, 0x8076, 0x84e7, 0x9952, 0xbb12, 0xe5c3, 0x13dc, 
   0x3f62, 0x62ad, 0x792a, 0x7fed, 0x7615, 0x5ce9, 0x37ae, 0x0b39, 
   0xdd50, 0xb3e7, 0x945e, 0x82ce, 0x817d, 0x9099, 0xae2a, 0xd65a, 
   0x03f1, 0x3106, 0x57bf, 0x7313, 0x7f78, 0x7b51, 0x6729, 0x459d, 
   0x1b08, 0xecf1, 0xc153, 0x9dd8, 0x871a, 0x800d, 0x899c, 0xa288, 
   0xc797, 0xf3f8, 0x21e7, 0x4b72, 0x6b31, 0x7d06, 0x7ea2, 0x6fcd, 
   0x5276, 0x2a6a, 0xfcde, 0xcfba, 0xa8d9, 0x8d48, 0x809c, 0x8478, 
   0x985c, 0xb9b5, 0xe42d, 0x1241, 0x3df7, 0x61a2, 0x78a1, 0x7ff8, 
   0x76b3, 0x5e05, 0x3923, 0x0cd7, 0xdee1, 0xb537, 0x9541, 0x8327, 
   0x8141, 0x8fce, 0xacec, 0xd4d2, 0x0252, 0x2f86, 0x568e, 0x725b, 
   0x7f50, 0x7bbe, 0x681d, 0x46f8, 0x1c9d, 0xee8d, 0xc2bf, 0x9ee4, 
   0x87a5, 0x8004, 0x8900, 0xa16f, 0xc623, 0xf25a, 0x2056, 0x4a20, 
   0x6a4c, 0x7cab, 0x7edb, 0x7095, 0x53b2, 0x2bf1, 0xfe7e, 0xd13c, 
   0xaa0b, 0x8e03, 0x80c7, 0x840d, 0x976b, 0xb85b, 0xe298, 0x10a6, 
   0x3c8b, 0x6094, 0x7814, 0x7ffe, 0x774c, 0x5f1d, 0x3a96, 0x0e74, 
   0xe073, 0xb689, 0x9629, 0x8385, 0x810a, 0x8f09, 0xabb2, 0xd34c, 
   0x00b2, 0x2e03, 0x555a, 0x719e, 0x7f22, 0x7c26, 0x690c, 0x4850, 
   0x1e32, 0xf028, 0xc42d, 0x9ff5, 0x8835, 0x8001, 0x886a, 0xa059, 
   0xc4b2, 0xf0be, 0x1ec4, 0x48cc, 0x6962, 0x7c4a, 0x7f10, 0x7158, 
   0x54ea, 0x2d77, 0x001c, 0xd2bf, 0xab41, 0x8ec2, 0x80f7, 0x83a8, 
   0x967d, 0xb705, 0xe105, 0x0f09, 0x3b1b, 0x5f81, 0x7782, 0x7fff, 
   0x77e0, 0x6031, 0x3c06, 0x1011, 0xe206, 0xb7df, 0x9715, 0x83e8, 
   0x80d7, 0x8e48, 0xaa7b, 0xd1c7, 0xff14, 0x2c7e, 0x5423, 0x70dc, 
   0x7eef, 0x7c88, 0x69f8, 0x49a6, 0x1fc5, 0xf1c5, 0xc59d, 0xa10a, 
   0x88c9, 0x8002, 0x87d8, 0x9f46, 0xc343, 0xef21, 0x1d30, 0x4775, 
   0x6874, 0x7be4, 0x7f40, 0x7217, 0x561f, 0x2efa, 0x01bc, 0xd445, 
   0xac7a, 0x8f86, 0x812c, 0x8348, 0x9594, 0xb5b1, 0xdf72, 0x0d6c, 
   0x39aa, 0x5e6b, 0x76ea, 0x7ffb, 0x786f, 0x6141, 0x3d74, 0x11ac, 
   0xe39b, 0xb938, 0x9805, 0x8451, 0x80ab, 0x8d8b, 0xa947, 0xd045, 
   0xfd75, 0x2af8, 0x52e8, 0x7016, 0x7eb7, 0x7ce6, 0x6ade, 0x4af8, 
   0x2156, 0xf362, 0xc710, 0xa222, 0x8963, 0x8009, 0x874b, 0x9e38, 
   0xc1d6, 0xed86, 0x1b9b, 0x461b, 0x6782, 0x7b79, 0x7f6a, 0x72d1, 
   0x5751, 0x307b, 0x035b, 0xd5cc, 0xadb6, 0x904f, 0x8167, 0x82ed, 
   0x94b0, 0xb460, 0xdde1, 0x0bcf, 0x3836, 0x5d50, 0x764e, 0x7ff1, 
   0x78f9, 0x624d, 0x3edf, 0x1347, 0xe530, 0xba93, 0x98f9, 0x84be, 
   0x8083, 0x8cd4, 0xa818, 0xcec5, 0xfbd5, 0x2970, 0x51aa, 0x6f4b, 
   0x7e7a, 0x7d3e, 0x6bc1, 0x4c47, 0x22e7, 0xf500, 0xc885, 0xa33e, 
   0x8a02, 0x8015, 0x86c4, 0x9d2e, 0xc06d, 0xebeb, 0x1a04, 0x44be, 
   0x668b, 0x7b09, 0x7f8f, 0x7386, 0x587f, 0x31fb, 0x04fa, 0xd755, 
   0xaef6, 0x911c, 0x81a7, 0x8298, 0x93d0, 0xb312, 0xdc51, 0x0a31, 
   0x36bf, 0x5c32, 0x75ad, 0x7fe2, 0x797e, 0x6355, 0x4047, 0x14e2, 
   0xe6c7, 0xbbf2, 0x99f2, 0x8531, 0x8060, 0x8c21, 0xa6ec, 0xcd46, 
   0xfa36, 0x27e6, 0x5069, 0x6e7b, 0x7e37, 0x7d91, 0x6c9f, 0x4d93, 
   0x2476, 0xf69e, 0xc9fd, 0xa45f, 0x8aa5, 0x8027, 0x8641, 0x9c28, 
   0xbf05, 0xea51, 0x186d, 0x435e, 0x6590, 0x7a94, 0x7faf, 0x7437, 
   0x59a9, 0x3378, 0x0699, 0xd8e0, 0xb039, 0x91ee, 0x81ec, 0x8247, 
   0x92f4, 0xb1c8, 0xdac3, 0x0893, 0x3547, 0x5b10, 0x7507, 0x7fce, 
   0x79ff, 0x6459, 0x41ad, 0x167b, 0xe85f, 0xbd53, 0x9aee, 0x85a8, 
   0x8043, 0x8b73, 0xa5c3, 0xcbca, 0xf897, 0x265a, 0x4f24, 0x6da7, 
   0x7df0, 0x7ddf, 0x6d78, 0x4edc, 0x2603, 0xf83c, 0xcb77, 0xa583, 
   0x8b4d, 0x803e, 0x85c3, 0x9b26, 0xbda1, 0xe8b8, 0x16d5, 0x41fb, 
   0x6492, 0x7a1a, 0x7fc9, 0x74e2, 0x5ad0, 0x34f4, 0x0838, 0xda6c, 
   0xb180, 0x92c4, 0x8236, 0x81fc, 0x921d, 0xb081, 0xd937, 0x06f4, 
   0x33cc, 0x59ea, 0x745d, 0x7fb5, 0x7a7a, 0x6559, 0x4311, 0x1814, 
   0xe9f8, 0xbeb7, 0x9bef, 0x8625, 0x802b, 0x8ac9, 0xa49e, 0xca50, 
   0xf6f9, 0x24cd, 0x4ddc, 0x6ccf, 0x7da3, 0x7e28, 0x6e4d, 0x5022, 
   0x278f, 0xf9db, 0xccf3, 0xa6aa, 0x8bfa, 0x805a, 0x854a, 0x9a29, 
   0xbc3f, 0xe720, 0x153c, 0x4096, 0x638f, 0x799b, 0x7fdf, 0x7589, 
   0x5bf3, 0x366d, 0x09d6, 0xdbfa, 0xb2ca, 0x939f, 0x8286, 0x81b5, 
   0x914a, 0xaf3d, 0xd7ab, 0x0555, 0x324f, 0x58c1, 0x73ad, 0x7f96, 
   0x7af0, 0x6655, 0x4471, 0x19ab, 0xeb91, 0xc01e, 0x9cf5, 0x86a7, 
   0x8019, 0x8a25, 0xa37d, 0xc8d8, 0xf55b, 0x233e, 0x4c90, 0x6bf2, 
   0x7d51, 0x7e6c, 0x6f1e, 0x5164, 0x2919, 0xfb7a, 0xce71, 0xa7d6, 
   0x8cac, 0x807b, 0x84d7, 0x992f, 0xbae0, 0xe589, 0x13a1, 0x3f2e, 
   0x6287, 0x7917, 0x7fef, 0x762b, 0x5d12, 0x37e4, 0x0b74, 0xdd89, 
   0xb417, 0x947e, 0x82da, 0x8174, 0x907c, 0xadfc, 0xd622, 0x03b6, 
   0x30d0, 0x5793, 0x72f9, 0x7f73, 0x7b61, 0x674c, 0x45cf, 0x1b42, 
   0xed2c, 0xc187, 0x9dfe, 0x872d, 0x800b, 0x8985, 0xa260, 0xc762, 
   0xf3bd, 0x21ae, 0x4b42, 0x6b10, 0x7cfa, 0x7eaa, 0x6fea, 0x52a3, 
   0x2aa2, 0xfd1a, 0xcff1, 0xa905, 0x8d63, 0x80a1, 0x8468, 0x983a, 
   0xb984, 0xe3f4, 0x1207, 0x3dc4, 0x617c, 0x788e, 0x7ff9, 0x76c9, 
   0x5e2d, 0x3958, 0x0d12, 0xdf1a, 0xb567, 0x9562, 0x8334, 0x8139, 
   0x8fb2, 0xacbf, 0xd49a, 0x0217, 0x2f4f, 0x5663, 0x7240, 0x7f49, 
   0x7bcd, 0x683f, 0x4729, 0x1cd7, 0xeec7, 0xc2f3, 0x9f0b, 0x87b9, 
   0x8003, 0x88eb, 0xa147, 0xc5ee, 0xf220, 0x201d, 0x49f0, 0x6a2b, 
   0x7c9d, 0x7ee3, 0x70b1, 0x53de, 0x2c29, 0xfeb9, 0xd173, 0xaa37, 
   0x8e1e, 0x80cd, 0x83ff, 0x9749, 0xb82a, 0xe25f, 0x106b, 0x3c56, 
   0x606d, 0x7800, 0x7fff, 0x7761, 0x5f44, 0x3aca, 0x0eaf, 0xe0ac, 
   0xb6ba, 0x964a, 0x8393, 0x8102, 0x8eed, 0xab85, 0xd314, 0x0077, 
   0x2dcc, 0x552e, 0x7183, 0x7f1b, 0x7c34, 0x692e, 0x4881, 0x1e6b, 
   0xf063, 0xc461, 0xa01c, 0x8849, 0x8001, 0x8855, 0xa031, 0xc47d, 
   0xf083, 0x1e8a, 0x489c, 0x6940, 0x7c3c, 0x7f17, 0x7174, 0x5516, 
   0x2dae, 0x0057, 0xd2f6, 0xab6d, 0x8ede, 0x80fe, 0x839a, 0x965c, 
   0xb6d4, 0xe0cb, 0x0ecf, 0x3ae7, 0x5f5a, 0x776c, 0x7fff, 0x77f4, 
   0x6058, 0x3c3a, 0x104b, 0xe240, 0xb810, 0x9736, 0x83f7, 0x80d1, 
   0x8e2d, 0xaa4f, 0xd190, 0xfed9, 0x2c47, 0x53f7, 0x70c0, 0x7ee7, 
   0x7c96, 0x6a19, 0x49d6, 0x1ffe, 0xf200, 0xc5d2, 0xa131, 0x88df, 
   0x8003, 0x87c4, 0x9f20, 0xc30f, 0xeee7, 0x1cf6, 0x4744, 0x6852, 
   0x7bd5, 0x7f46, 0x7232, 0x564b, 0x2f31, 0x01f7, 0xd47c, 0xaca7, 
   0x8fa3, 0x8134, 0x833b, 0x9574, 0xb581, 0xdf39, 0x0d32, 0x3975, 
   0x5e43, 0x76d5, 0x7ffa, 0x7883, 0x6167, 0x3da8, 0x11e7, 0xe3d4, 
   0xb969, 0x9827, 0x8460, 0x80a5, 0x8d71, 0xa91c, 0xd00e, 0xfd3a, 
   0x2ac0, 0x52bb, 0x6ff9, 0x7eaf, 0x7cf3, 0x6aff, 0x4b28, 0x2190, 
   0xf39d, 0xc745, 0xa24a, 0x8979, 0x800b, 0x8738, 0x9e12, 0xc1a3, 
   0xed4c, 0x1b61, 0x45e9, 0x675f, 0x7b6a, 0x7f70, 0x72eb, 0x577c, 
   0x30b2, 0x0396, 0xd604, 0xade4, 0x906c, 0x8170, 0x82e1, 0x9490, 
   0xb430, 0xdda8, 0x0b94, 0x3800, 0x5d28, 0x7638, 0x7ff0, 0x790c, 
   0x6273, 0x3f12, 0x1382, 0xe56a, 0xbac5, 0x991c, 0x84ce, 0x807e, 
   0x8cba, 0xa7ed, 0xce8e, 0xfb9a, 0x2938, 0x517d, 0x6f2e, 0x7e71, 
   0x7d4a, 0x6be1, 0x4c77, 0x2320, 0xf53b, 0xc8bb, 0xa367, 0x8a19, 
   0x8018, 0x86b1, 0x9d09, 0xc039, 0xebb1, 0x19ca, 0x448c, 0x6668, 
   0x7af9, 0x7f94, 0x73a0, 0x58aa, 0x3231, 0x0535, 0xd78d, 0xaf24, 
   0x913a, 0x81b0, 0x828c, 0x93b0, 0xb2e3, 0xdc19, 0x09f6, 0x368a, 
   0x5c09, 0x7596, 0x7fe0, 0x7991, 0x637a, 0x407a, 0x151c, 0xe701, 
   0xbc24, 0x9a15, 0x8541, 0x805c, 0x8c08, 0xa6c1, 0xcd10, 0xf9fb, 
   0x27ae, 0x503b, 0x6e5e, 0x7e2d, 0x7d9d, 0x6cbe, 0x4dc2, 0x24ae, 
   0xf6d9, 0xca33, 0xa488, 0x8abd, 0x802a, 0x862f, 0x9c03, 0xbed2, 
   0xea17, 0x1833, 0x432c, 0x656c, 0x7a83, 0x7fb3, 0x744f, 0x59d3, 
   0x33ae, 0x06d4, 0xd918, 0xb068, 0x920c, 0x81f6, 0x823c, 0x92d5, 
   0xb199, 0xda8b, 0x0858, 0x3511, 0x5ae6, 0x74ef, 0x7fcb, 0x7a10, 
   0x647e, 0x41e0, 0x16b5, 0xe899, 0xbd85, 0x9b13, 0x85ba, 0x8040, 
   0x8b5a, 0xa599, 0xcb94, 0xf85c, 0x2622, 0x4ef5, 0x6d89, 0x7de5, 
   0x7dea, 0x6d97, 0x4f0b, 0x263c, 0xf877, 0xcbad, 0xa5ac, 0x8b66, 
   0x8041, 0x85b2, 0x9b02, 0xbd6e, 0xe87e, 0x169b, 0x41c9, 0x646d, 
   0x7a08, 0x7fcd, 0x74fa, 0x5af9, 0x3529, 0x0873, 0xdaa5, 0xb1af, 
   0x92e3, 0x8241, 0x81f1, 0x91fe, 0xb053, 0xd8fe, 0x06b9, 0x3396, 
   0x59c0, 0x7444, 0x7fb1, 0x7a8b, 0x657d, 0x4343, 0x184e, 0xea32, 
   0xbeea, 0x9c14, 0x8637, 0x8028, 0x8ab2, 0xa475, 0xca1a, 0xf6be, 
   0x2494, 0x4dad, 0x6cb0, 0x7d97, 0x7e32, 0x6e6b, 0x5050, 0x27c7, 
   0xfa16, 0xcd29, 0xa6d5, 0x8c13, 0x805e, 0x853a, 0x9a05, 0xbc0d, 
   0xe6e7, 0x1501, 0x4063, 0x6369, 0x7988, 0x7fe1, 0x75a1, 0x5c1c, 
   0x36a2, 0x0a11, 0xdc33, 0xb2f9, 0x93bf, 0x8291, 0x81ac, 0x912c, 
   0xaf0f, 0xd773, 0x051a, 0x3218, 0x5896, 0x7394, 0x7f92, 0x7b00, 
   0x6678, 0x44a3, 0x19e5, 0xebcc, 0xc051, 0x9d1a, 0x86b9, 0x8017, 
   0x8a0e, 0xa354, 0xc8a2, 0xf520, 0x2306, 0x4c61, 0x6bd2, 0x7d45, 
   0x7e75, 0x6f3b, 0x5191, 0x2951, 0xfbb5, 0xcea7, 0xa800, 0x8cc6, 
   0x8080, 0x84c7, 0x990c, 0xbaae, 0xe550, 0x1367, 0x3efb, 0x6262, 
   0x7904, 0x7ff0, 0x7642, 0x5d3a, 0x3819, 0x0baf, 0xddc2, 0xb446, 
   0x949e, 0x82e7, 0x816c, 0x905f, 0xadcf, 0xd5ea, 0x037b, 0x3099, 
   0x5768, 0x72df, 0x7f6d, 0x7b71, 0x676f, 0x4600, 0x1b7b, 0xed66, 
   0xc1ba, 0x9e24, 0x8741, 0x800a, 0x896f, 0xa238, 0xc72d, 0xf382, 
   0x2175, 0x4b12, 0x6af0, 0x7ced, 0x7eb3, 0x7006, 0x52d0, 0x2ada, 
   0xfd55, 0xd027, 0xa930, 0x8d7d, 0x80a7, 0x8459, 0x9817, 0xb952, 
   0xe3ba, 0x11cc, 0x3d90, 0x6156, 0x787a, 0x7ffa, 0x76df, 0x5e55, 
   0x398d, 0x0d4d, 0xdf53, 0xb597, 0x9583, 0x8341, 0x8131, 0x8f96, 
   0xac92, 0xd463, 0x01dc, 0x2f18, 0x5637, 0x7226, 0x7f43, 0x7bdc, 
   0x6861, 0x475a, 0x1d11, 0xef02, 0xc327, 0x9f32, 0x87cd, 0x8003, 
   0x88d5, 0xa11f, 0xc5ba, 0xf1e5, 0x1fe4, 0x49c0, 0x6a0a, 0x7c90, 
   0x7eeb, 0x70cd, 0x540b, 0x2c60, 0xfef4, 0xd1aa, 0xaa63, 0x8e39, 
   0x80d4, 0x83f0, 0x9727, 0xb7f9, 0xe225, 0x1030, 0x3c22, 0x6046, 
   0x77eb, 0x7fff, 0x7776, 0x5f6c, 0x3aff, 0x0eea, 0xe0e6, 0xb6ea, 
   0x966b, 0x83a1, 0x80fb, 0x8ed1, 0xab59, 0xd2dd, 0x003c, 0x2d95, 
   0x5502, 0x7167, 0x7f14, 0x7c42, 0x6950, 0x48b2, 0x1ea4, 0xf09e, 
   0xc495, 0xa043, 0x885e, 0x8001, 0x8840, 0xa00a, 0xc449, 0xf048, 
   0x1e51, 0x486b, 0x691f, 0x7c2e, 0x7f1e, 0x718f, 0x5543, 0x2de5, 
   0x0092, 0xd32e, 0xab9a, 0x8efa, 0x8105, 0x838c, 0x963b, 0xb6a4, 
   0xe092, 0x0e94, 0x3ab2, 0x5f32, 0x7757, 0x7fff, 0x7809, 0x607f, 
   0x3c6e, 0x1086, 0xe279, 0xb841, 0x9758, 0x8405, 0x80ca, 0x8e12, 
   0xaa23, 0xd159, 0xfe9e, 0x2c0f, 0x53ca, 0x70a4, 0x7ee0, 0x7ca3, 
   0x6a3a, 0x4a06, 0x2037, 0xf23b, 0xc607, 0xa159, 0x88f5, 0x8004, 
   0x87b0, 0x9ef9, 0xc2db, 0xeeac, 0x1cbd, 0x4713, 0x682f, 0x7bc6, 
   0x7f4c, 0x724c, 0x5677, 0x2f68, 0x0232, 0xd4b4, 0xacd4, 0x8fbf, 
   0x813c, 0x832e, 0x9553, 0xb551, 0xdf00, 0x0cf7, 0x3940, 0x5e1b, 
   0x76bf, 0x7ff9, 0x7897, 0x618e, 0x3ddb, 0x1221, 0xe40e, 0xb99a, 
   0x984a, 0x846f, 0x809f, 0x8d57, 0xa8f1, 0xcfd7, 0xfcfe, 0x2a88, 
   0x528e, 0x6fdd, 0x7ea6, 0x7cff, 0x6b1f, 0x4b58, 0x21c9, 0xf3d8, 
   0xc77a, 0xa273, 0x8990, 0x800c, 0x8724, 0x9dec, 0xc16f, 0xed11, 
   0x1b27, 0x45b8, 0x673c, 0x7b5a, 0x7f75, 0x7305, 0x57a7, 0x30e9, 
   0x03d1, 0xd63c, 0xae11, 0x9089, 0x8179, 0x82d4, 0x9470, 0xb401, 
   0xdd6f, 0x0b59, 0x37cb, 0x5cff, 0x7621, 0x7fee, 0x7920, 0x6299, 
   0x3f46, 0x13bc, 0xe5a4, 0xbaf7, 0x993f, 0x84de, 0x8079, 0x8ca0, 
   0xa7c2, 0xce58, 0xfb5f, 0x2900, 0x514f, 0x6f10, 0x7e67, 0x7d56, 
   0x6c00, 0x4ca6, 0x2359, 0xf576, 0xc8f0, 0xa390, 0x8a30, 0x801a, 
   0x869e, 0x9ce3, 0xc006, 0xeb77, 0x1991, 0x445a, 0x6644, 0x7ae8, 
   0x7f99, 0x73b9, 0x58d4, 0x3268, 0x0570, 0xd7c5, 0xaf52, 0x9157, 
   0x81ba, 0x8280, 0x9391, 0xb2b4, 0xdbe0, 0x09bb, 0x3654, 0x5be0, 
   0x757f, 0x7fdd, 0x79a3, 0x63a0, 0x40ae, 0x1556, 0xe73b, 0xbc56, 
   0x9a39, 0x8552, 0x8058, 0x8bef, 0xa697, 0xccda, 0xf9c0, 0x2775, 
   0x500c, 0x6e40, 0x7e23, 0x7da8, 0x6cdd, 0x4df1, 0x24e7, 0xf714, 
   0xca68, 0xa4b1, 0x8ad4, 0x802d, 0x861d, 0x9bdf, 0xbea0, 0xe9dd, 
   0x17f9, 0x42f9, 0x6548, 0x7a72, 0x7fb7, 0x7468, 0x59fd, 0x33e4, 
   0x070f, 0xd950, 0xb096, 0x922a, 0x8200, 0x8231, 0x92b6, 0xb16b, 
   0xda52, 0x081d, 0x34db, 0x5abd, 0x74d7, 0x7fc8, 0x7a22, 0x64a2, 
   0x4213, 0x16ef, 0xe8d3, 0xbdb8, 0x9b37, 0x85cb, 0x803c, 0x8b42, 
   0xa56f, 0xcb5e, 0xf821, 0x25e9, 0x4ec7, 0x6d6a, 0x7dda, 0x7df4, 
   0x6db5, 0x4f39, 0x2674, 0xf8b2, 0xcbe3, 0xa5d6, 0x8b7e, 0x8045, 
   0x85a0, 0x9ade, 0xbd3c, 0xe844, 0x1660, 0x4196, 0x6448, 0x79f6, 
   0x7fd0, 0x7512, 0x5b23, 0x355f, 0x08ae, 0xdadd, 0xb1dd, 0x9302, 
   0x824c, 0x81e7, 0x91e0, 0xb024, 0xd8c6, 0x067e, 0x3360, 0x5996, 
   0x742b, 0x7fad, 0x7a9c, 0x65a1, 0x4375, 0x1888, 0xea6c, 0xbf1d, 
   0x9c39, 0x8649, 0x8026, 0x8a9a, 0xa44c, 0xc9e4, 0xf683, 0x245c, 
   0x4d7e, 0x6c90, 0x7d8c, 0x7e3c, 0x6e89, 0x507e, 0x2800, 0xfa51, 
   0xcd5f, 0xa6ff, 0x8c2c, 0x8063, 0x8529, 0x99e1, 0xbbdb, 0xe6ad, 
   0x14c7, 0x4030, 0x6344, 0x7976, 0x7fe4, 0x75b8, 0x5c45, 0x36d8, 
   0x0a4c, 0xdc6c, 0xb328, 0x93de, 0x829d, 0x81a2, 0x910f, 0xaee1, 
   0xd73b, 0x04df, 0x31e2, 0x586b, 0x737b, 0x7f8d, 0x7b11, 0x669b, 
   0x44d5, 0x1a1f, 0xec06, 0xc084, 0x9d40, 0x86cc, 0x8014, 0x89f7, 
   0xa32c, 0xc86d, 0xf4e5, 0x22cd, 0x4c31, 0x6bb2, 0x7d38, 0x7e7e, 
   0x6f58, 0x51bf, 0x2989, 0xfbf0, 0xcede, 0xa82b, 0x8ce0, 0x8085, 
   0x84b7, 0x98e9, 0xba7c, 0xe516, 0x132d, 0x3ec7, 0x623c, 0x78f0, 
   0x7ff2, 0x7659, 0x5d63, 0x384e, 0x0bea, 0xddfb, 0xb476, 0x94bf, 
   0x82f3, 0x8163, 0x9042, 0xada2, 0xd5b2, 0x0340, 0x3062, 0x573d, 
   0x72c5, 0x7f67, 0x7b80, 0x6792, 0x4632, 0x1bb5, 0xeda1, 0xc1ee, 
   0x9e4a, 0x8754, 0x8009, 0x8959, 0xa210, 0xc6f8, 0xf347, 0x213c, 
   0x4ae2, 0x6acf, 0x7ce0, 0x7ebb, 0x7023, 0x52fd, 0x2b11, 0xfd90, 
   0xd05e, 0xa95b, 0x8d98, 0x80ad, 0x844a, 0x97f5, 0xb921, 0xe380, 
   0x1191, 0x3d5c, 0x612f, 0x7866, 0x7ffb, 0x76f4, 0x5e7d, 0x39c2, 
   0x0d87, 0xdf8c, 0xb5c7, 0x95a4, 0x834e, 0x8129, 0x8f79, 0xac65, 
   0xd42b, 0x01a1, 0x2ee1, 0x560b, 0x720b, 0x7f3d, 0x7beb, 0x6884, 
   0x478c, 0x1d4a, 0xef3c, 0xc35b, 0x9f58, 0x87e1, 0x8002, 0x88bf, 
   0xa0f7, 0xc585, 0xf1aa, 0x1faa, 0x4990, 0x69e8, 0x7c82, 0x7ef3, 
   0x70e9, 0x5438, 0x2c98, 0xff2f, 0xd1e1, 0xaa8f, 0x8e54, 0x80db, 
   0x83e2, 0x9705, 0xb7c9, 0xe1ec, 0x0ff6, 0x3bee, 0x601f, 0x77d6, 
   0x7fff, 0x778b, 0x5f93, 0x3b33, 0x0f24, 0xe11f, 0xb71b, 0x968d, 
   0x83af, 0x80f3, 0x8eb6, 0xab2c, 0xd2a6, 0x0001, 0x2d5d, 0x54d6, 
   0x714c, 0x7f0d, 0x7c50, 0x6971, 0x48e3, 0x1ede, 0xf0d9, 0xc4ca, 
   0xa06b, 0x8873, 0x8001, 0x882b, 0x9fe3, 0xc415, 0xf00e, 0x1e17, 
   0x483a, 0x68fd, 0x7c1f, 0x7f25, 0x71aa, 0x556f, 0x2e1c, 0x00ce, 
   0xd365, 0xabc6, 0x8f16, 0x810d, 0x837f, 0x9619, 0xb673, 0xe059, 
   0x0e59, 0x3a7e, 0x5f0b, 0x7742, 0x7ffe, 0x781d, 0x60a6, 0x3ca2, 
   0x10c0, 0xe2b3, 0xb872, 0x977a, 0x8414, 0x80c4, 0x8df7, 0xa9f7, 
   0xd122, 0xfe63, 0x2bd8, 0x539d, 0x7088, 0x7ed8, 0x7cb1, 0x6a5b, 
   0x4a36, 0x2070, 0xf275, 0xc63b, 0xa181, 0x890a, 0x8005, 0x879b, 
   0x9ed3, 0xc2a7, 0xee72, 0x1c83, 0x46e2, 0x680d, 0x7bb7, 0x7f52, 
   0x7267, 0x56a2, 0x2f9f, 0x026d, 0xd4ec, 0xad01, 0x8fdb, 0x8145, 
   0x8321, 0x9532, 0xb521, 0xdec7, 0x0cbc, 0x390b, 0x5df3, 0x76a8, 
   0x7ff7, 0x78aa, 0x61b4, 0x3e0f, 0x125c, 0xe448, 0xb9cc, 0x986c, 
   0x847f, 0x8099, 0x8d3c, 0xa8c5, 0xcfa1, 0xfcc3, 0x2a51, 0x5261, 
   0x6fc0, 0x7e9e, 0x7d0c, 0x6b40, 0x4b87, 0x2202, 0xf413, 0xc7af, 
   0xa29b, 0x89a6, 0x800e, 0x8711, 0x9dc6, 0xc13c, 0xecd7, 0x1aed, 
   0x4586, 0x6719, 0x7b4a, 0x7f7a, 0x731f, 0x57d2, 0x311f, 0x040c, 
   0xd674, 0xae3f, 0x90a6, 0x8182, 0x82c8, 0x9450, 0xb3d1, 0xdd36, 
   0x0b1e, 0x3796, 0x5cd7, 0x760a, 0x7fec, 0x7933, 0x62be, 0x3f79, 
   0x13f7, 0xe5de, 0xbb28, 0x9963, 0x84ee, 0x8074, 0x8c87, 0xa797, 
   0xce21, 0xfb24, 0x28c8, 0x5121, 0x6ef3, 0x7e5e, 0x7d62, 0x6c20, 
   0x4cd5, 0x2391, 0xf5b1, 0xc925, 0xa3b9, 0x8a47, 0x801c, 0x868b, 
   0x9cbe, 0xbfd3, 0xeb3c, 0x1957, 0x4428, 0x6621, 0x7ad8, 0x7f9d, 
   0x73d2, 0x58ff, 0x329e, 0x05ab, 0xd7fd, 0xaf80, 0x9175, 0x81c4, 
   0x8275, 0x9371, 0xb285, 0xdba7, 0x0980, 0x361f, 0x5bb7, 0x7567, 
   0x7fdb, 0x79b6, 0x63c5, 0x40e1, 0x1591, 0xe775, 0xbc88, 0x9a5d, 
   0x8563, 0x8053, 0x8bd6, 0xa66d, 0xcca3, 0xf985, 0x273d, 0x4fde, 
   0x6e22, 0x7e19, 0x7db3, 0x6cfc, 0x4e20, 0x2520, 0xf74f, 0xca9e, 
   0xa4db, 0x8aec, 0x8030, 0x860b, 0x9bba, 0xbe6d, 0xe9a3, 0x17bf, 
   0x42c7, 0x6524, 0x7a61, 0x7fbb, 0x7481, 0x5a27, 0x341b, 0x074a, 
   0xd989, 0xb0c4, 0x9249, 0x820b, 0x8226, 0x9297, 0xb13c, 0xda1a, 
   0x07e2, 0x34a5, 0x5a93, 0x74bf, 0x7fc4, 0x7a34, 0x64c7, 0x4245, 
   0x172a, 0xe90d, 0xbdeb, 0x9b5c, 0x85dd, 0x8038, 0x8b2a, 0xa546, 
   0xcb28, 0xf7e6, 0x25b1, 0x4e98, 0x6d4c, 0x7dcf, 0x7dff, 0x6dd4, 
   0x4f67, 0x26ac, 0xf8ed, 0xcc19, 0xa600, 0x8b97, 0x8049, 0x858f, 
   0x9aba, 0xbd09, 0xe80a, 0x1626, 0x4163, 0x6424, 0x79e4, 0x7fd3, 
   0x752a, 0x5b4c, 0x3595, 0x08e9, 0xdb16, 0xb20c, 0x9321, 0x8257, 
   0x81dd, 0x91c2, 0xaff6, 0xd88e, 0x0643, 0x3329, 0x596c, 0x7412, 
   0x7fa9, 0x7aad, 0x65c5, 0x43a7, 0x18c2, 0xeaa6, 0xbf50, 0x9c5e, 
   0x865c, 0x8023, 0x8a83, 0xa422, 0xc9af, 0xf648, 0x2423, 0x4d4f, 
   0x6c71, 0x7d80, 0x7e46, 0x6ea7, 0x50ac, 0x2838, 0xfa8c, 0xcd95, 
   0xa72a, 0x8c46, 0x8067, 0x8518, 0x99be, 0xbba9, 0xe673, 0x148d, 
   0x3ffd, 0x631f, 0x7963, 0x7fe6, 0x75cf, 0x5c6e, 0x370d, 0x0a87, 
   0xdca4, 0xb357, 0x93fe, 0x82a9, 0x8199, 0x90f1, 0xaeb4, 0xd703, 
   0x04a4, 0x31ab, 0x5840, 0x7361, 0x7f88, 0x7b21, 0x66bf, 0x4507, 
   0x1a59, 0xec41, 0xc0b7, 0x9d65, 0x86df, 0x8012, 0x89e0, 0xa303, 
   0xc838, 0xf4aa, 0x2294, 0x4c02, 0x6b92, 0x7d2c, 0x7e87, 0x6f75, 
   0x51ec, 0x29c1, 0xfc2c, 0xcf14, 0xa856, 0x8cfa, 0x808b, 0x84a7, 
   0x98c6, 0xba4b, 0xe4dc, 0x12f2, 0x3e94, 0x6216, 0x78dd, 0x7ff4, 
   0x766f, 0x5d8b, 0x3883, 0x0c25, 0xde34, 0xb4a6, 0x94df, 0x8300, 
   0x815a, 0x9025, 0xad74, 0xd57b, 0x0305, 0x302c, 0x5712, 0x72ab, 
   0x7f62, 0x7b90, 0x67b4, 0x4663, 0x1bef, 0xeddb, 0xc222, 0x9e70, 
   0x8768, 0x8007, 0x8943, 0xa1e8, 0xc6c3, 0xf30c, 0x2103, 0x4ab2, 
   0x6aaf, 0x7cd3, 0x7ec3, 0x703f, 0x532a, 0x2b49, 0xfdcb, 0xd095, 
   0xa987, 0x8db2, 0x80b3, 0x843b, 0x97d2, 0xb8f0, 0xe347, 0x1157, 
   0x3d28, 0x6109, 0x7852, 0x7ffc, 0x770a, 0x5ea5, 0x39f7, 0x0dc2, 
   0xdfc6, 0xb5f7, 0x95c4, 0x835c, 0x8121, 0x8f5d, 0xac39, 0xd3f4, 
   0x0165, 0x2eaa, 0x55df, 0x71f0, 0x7f36, 0x7bfa, 0x68a6, 0x47bd, 
   0x1d84, 0xef77, 0xc38f, 0x9f7f, 0x87f6, 0x8001, 0x88aa, 0xa0d0, 
   0xc551, 0xf16f, 0x1f71, 0x495f, 0x69c7, 0x7c74, 0x7efa, 0x7105, 
   0x5464, 0x2ccf, 0xff6a, 0xd218, 0xaabb, 0x8e6f, 0x80e1, 0x83d3, 
   0x96e3, 0xb798, 0xe1b2, 0x0fbb, 0x3bba, 0x5ff8, 0x77c1, 0x7fff, 
   0x77a0, 0x5fbb, 0x3b68, 0x0f5f, 0xe158, 0xb74b, 0x96ae, 0x83bd, 
   0x80ec, 0x8e9a, 0xab00, 0xd26f, 0xffc7, 0x2d26, 0x54aa, 0x7130, 
   0x7f06, 0x7c5e, 0x6993, 0x4913, 0x1f17, 0xf113, 0xc4fe, 0xa092, 
   0x8889, 0x8001, 0x8816, 0x9fbc, 0xc3e1, 0xefd3, 0x1dde, 0x4809, 
   0x68db, 0x7c11, 0x7f2c, 0x71c5, 0x559b, 0x2e53, 0x0109, 0xd39d, 
   0xabf3, 0x8f31, 0x8115, 0x8371, 0x95f8, 0xb643, 0xe01f, 0x0e1e, 
   0x3a49, 0x5ee3, 0x772c, 0x7ffd, 0x7832, 0x60cc, 0x3cd6, 0x10fb, 
   0xe2ec, 0xb8a3, 0x979d, 0x8423, 0x80bd, 0x8ddc, 0xa9cb, 0xd0eb, 
   0xfe28, 0x2ba0, 0x5370, 0x706c, 0x7ed0, 0x7cbe, 0x6a7b, 0x4a67, 
   0x20aa, 0xf2b0, 0xc670, 0xa1a9, 0x8920, 0x8006, 0x8787, 0x9eac, 
   0xc273, 0xee37, 0x1c49, 0x46b0, 0x67eb, 0x7ba8, 0x7f58, 0x7281, 
   0x56ce, 0x2fd6, 0x02a8, 0xd523, 0xad2e, 0x8ff8, 0x814d, 0x8314, 
   0x9512, 0xb4f1, 0xde8e, 0x0c81, 0x38d6, 0x5dca, 0x7692, 0x7ff6, 
   0x78be, 0x61da, 0x3e43, 0x1296, 0xe481, 0xb9fd, 0x988f, 0x848e, 
   0x8093, 0x8d22, 0xa89a, 0xcf6a, 0xfc88, 0x2a19, 0x5234, 0x6fa3, 
   0x7e95, 0x7d19, 0x6b60, 0x4bb7, 0x223b, 0xf44e, 0xc7e4, 0xa2c3, 
   0x89bd, 0x8010, 0x86fe, 0x9da0, 0xc108, 0xec9c, 0x1ab4, 0x4555
};
   
float32_t transform_fft_f32_inputs[TRANSFORM_MAX_FFT_LEN * 2] =
{
    43.0264275639,	-17.0525215570,	-94.8488973910,	-8.1924989580,	7.2830326091,	66.8368719314,	33.9778190671,	117.8652289772,	
    -129.6077797465,	-14.6420815368,	18.0239223278,	20.6760530292,	55.0375037651,	1.8674609862,	-85.6534302408,	-33.5750364909,	
    29.2110949614,	110.4727049460,	-94.1914619387,	-1.4084169343,	83.5181653041,	47.3073514127,	-13.3420621181,	30.3389699104,	
    12.1188124277,	100.9730921941,	-114.0146362390,	-77.5823200409,	37.2019034618,	40.0026301128,	-58.3387276630,	-34.9472398600,	
    -5.1169678311,	-87.7660091118,	-150.5888601131,	56.0349370503,	50.2168884079,	-74.2313236767,	22.3648603560,	-6.8676387051,	
    74.8957303680,	-90.1292012823,	-55.1436241586,	-66.6732976100,	-6.7918147615,	7.7612697081,	35.7892605979,	-20.0470508830,	
    41.8369017546,	-143.7378056984,	-41.9127158600,	-108.3531841158,	-57.1917422289,	-124.2808828105,	38.9316388820,	-77.9212517405,	
    37.1990818377,	-28.9545952748,	-155.6371057564,	45.8088886393,	36.2537018275,	-6.5727656016,	-104.2070491921,	45.5583813729,	
    -19.7674717059,	-80.4802190947,	-1.4444563441,	-42.2142256438,	36.6546339194,	-57.0866498590,	44.4677067511,	65.7285753407,	
    -103.8158864647,	25.4348723711,	-153.5419639389,	39.3608409474,	49.1658103436,	79.5570602275,	75.2944095996,	58.9394700746,	
    -53.1018534392,	33.4172444014,	35.6224682287,	-64.4353396418,	-125.8464291251,	-47.6072111617,	-26.2177687594,	-12.0061322096,	
    -17.7887967585,	-28.2926175090,	-62.0691715749,	40.5098573604,	-191.1123732593,	119.6750713043,	19.6182375803,	-26.7615252921,	
    2.2957847015,	-108.3436451287,	-50.5906164995,	-5.6360985100,	-11.6772204201,	-84.2765293757,	-60.9317810068,	82.0446350218,	
    -70.2048296348,	72.8738253222,	60.2450218115,	114.2741231228,	46.8180775285,	6.9915412654,	-8.9909197429,	-78.9165936808,	
    66.4731535459,	-68.4235455651,	-79.8254597080,	-10.6308477115,	-62.6161569330,	-55.7744410292,	-11.8408366528,	98.1034940997,	
    35.8213741877,	-54.4694482732,	86.9631830044,	-53.0343838122,	-47.4898642865,	-47.2010929590,	-31.3312639685,	-23.0908245172,	
    12.0258009869,	-5.1098204703,	-9.8420230737,	-107.3328761158,	44.6810431959,	-17.9083820345,	-60.9753512872,	-7.5915088994,	
    17.2250813329,	57.9176125648,	124.3004161362,	-63.1950908493,	120.5788885640,	-44.1734238117,	-91.7408095116,	-43.5696066595,	
    -49.9560710099,	-167.8513443296,	-70.9437505499,	-46.4109705355,	-64.2264526456,	-13.9995803916,	-100.9548186356,	9.9101010575,	
    -50.0615130815,	-55.7590145012,	-60.3195153388,	61.7913378549,	-102.0850899209,	53.2360193126,	-25.8997883369,	75.1445512333,	
    -113.8148602310,	17.8027281119,	-19.5006822722,	-44.2169628471,	107.5017084384,	-113.7909124666,	-43.9735396033,	7.6880981388,	
    46.7384653508,	9.9047443751,	81.8646964362,	132.3812863877,	-95.6959050236,	-68.5015813484,	65.8586404494,	18.5039353889,	
    -30.1786166621,	-90.3098515667,	-22.9356228552,	-20.5778272423,	-2.2127786675,	-35.4418447703,	-51.8722915974,	-107.9024439078,	
    -51.5940748232,	-51.7463262677,	74.2795485984,	94.2205022462,	9.7016384049,	-47.3556083155,	-36.7822314478,	-151.6455525363,	
    -15.7183814485,	78.2063383182,	0.1516414969,	37.9304181609,	20.6185902740,	-22.2164106778,	6.1160554677,	2.4061326953,	
    -111.6681824598,	-60.0858917090,	75.1698614693,	-76.5787410444,	28.3391655715,	-2.4946186443,	-68.0378899682,	104.0893199171,	
    -51.8319647254,	38.8521710524,	75.9114239564,	73.9206172905,	-103.2533029987,	6.9002718274,	-36.6346436319,	-25.1990926265,	
    1.5852145953,	-50.6438436795,	21.5018844428,	-151.9305562846,	-51.7326681814,	21.4475994143,	42.2564011921,	-74.0520586926,	
    49.7370635809,	-13.2957534126,	36.6746826778,	-31.7005492589,	148.4894964268,	79.7890632353,	16.8856024809,	16.1690460177,	
    39.2665169484,	117.2461167794,	-37.4827984831,	-47.8387803604,	-95.7025286193,	34.3058214285,	-124.9536456028,	56.1640195764,	
    94.3636873606,	35.3992852810,	-38.3920852159,	-100.5738062016,	-29.7837022314,	42.9133913996,	-34.2715618187,	-14.3589115627,	
    -16.5935468750,	20.4574192236,	-88.7897972666,	-38.6285080386,	53.3203422726,	98.5991486746,	122.7305462474,	67.7902817187,	
    5.1764117389,	5.0632821624,	21.9288789574,	-78.3140512638,	-21.2069682335,	23.6342010925,	34.4445769455,	59.1346766615,	
    28.9978778000,	39.8121180845,	-17.1650033520,	-56.9174900874,	17.8157086148,	-112.8801457350,	-122.4019040408,	140.8669393157,	
    -65.4664329639,	40.6952775518,	32.7260891658,	-43.2565155866,	19.3945751928,	-20.1815002000,	-67.6601711640,	-18.1921178207,	
    -35.6802153684,	49.9550290306,	131.4925251016,	-31.2940938167,	-5.2848453344,	-109.5580577933,	20.2437599390,	-8.8782958734,	
    54.1836717264,	7.2555852190,	-3.5698316137,	-51.9236786262,	6.7861547980,	-104.4814551670,	45.8458629668,	70.0890876844,	
    38.3572837740,	61.8024165129,	68.0176962024,	-12.8193934080,	-21.4661610917,	-0.9377108815,	-74.2100679061,	71.0490808147,	
    91.9813889497,	-14.5797640164,	3.5036749129,	-138.3605478356,	-48.1501349794,	-16.0636922482,	-12.1334197606,	15.0562207637,	
    -34.0878176054,	55.1075126157,	97.3829871877,	0.2053358099,	-94.8713267382,	51.5460954054,	21.2966946363,	58.1331025047,	
    -23.4599044132,	-19.3315856528,	-8.4497193577,	-1.9594679356,	-33.1906549336,	-144.6825417978,	-57.1218958072,	35.7353406097,	
    61.4666549819,	14.6536253128,	82.1632196866,	-44.6230161723,	-91.1022589278,	-18.5737673927,	-136.8975612334,	56.9606788003,	
    70.7059960183,	-68.2829345081,	-10.2629800455,	-53.6385325047,	-68.7928766204,	88.2444688302,	83.1412324801,	-102.9206928160,	
    -68.2329763159,	-69.7552955469,	108.2132269009,	-28.2582329307,	5.6685898328,	-36.0392956840,	43.3269513128,	-8.6436416796,	
    -16.5054886972,	11.5008791788,	39.6923606683,	-28.9039554061,	13.5938214364,	-23.6296332202,	49.1171161163,	53.1636857935,	
    -62.9672053166,	-54.2594757384,	48.3838956696,	8.0469071555,	-33.6472086213,	-120.5381752144,	55.0880453111,	17.8990740563,	
    144.9402232336,	101.7886229203,	-73.3666393712,	-16.4721379138,	-12.7447935685,	101.8245160983,	-49.7026860415,	-15.1227790364,	
    65.7430288442,	-131.8695390036,	10.2750933946,	90.9752774838,	-26.5859990591,	-95.6962772568,	76.2174589344,	24.8796848060,	
    -38.8938223046,	54.1687774852,	-37.3585968996,	-34.6848570502,	33.0151011570,	-55.8345877671,	-3.9009101671,	-31.5024971691,	
    -9.6863895491,	91.8719195957,	-58.9993249744,	-25.6887030614,	-8.0829472205,	4.6386491741,	-71.4019697167,	-21.3734669095,	
    86.2079144404,	79.6823974266,	-0.0910915997,	44.8067718095,	58.7204020766,	72.6856808976,	-50.3373732478,	-116.1175365534,	
    -15.0884909384,	5.4593772059,	-63.6553527905,	37.3460388205,	-32.2399421679,	95.7569350513,	-7.3700141964,	-56.0370832967,	
    -41.7377150439,	-42.0042856519,	12.5134312941,	93.7845584531,	-32.4801087157,	-33.3976050318,	-24.2252126001,	-46.3199064467,	
    -20.3704610276,	15.8571376404,	88.9127217235,	-33.1132582267,	-1.0005675836,	-28.1780471904,	150.9349379135,	38.0600520828,	
    36.4338677563,	-3.3709201641,	29.7709773016,	16.5064119077,	21.3147729463,	110.6714300904,	18.8406036507,	14.8963298097,	
    50.9975960392,	16.3991140350,	-194.0805845907,	-41.6723945839,	-74.8991127408,	-6.4587655805,	-0.6883628218,	-49.8709647175,	
    194.2265120473,	64.3043624521,	16.0040882780,	68.4032551772,	-43.4050313128,	84.6826289824,	-28.1357565943,	134.6895584120,	
    -7.9746152680,	-95.6692886462,	-48.9444370342,	79.4479343188,	-50.5345228122,	52.4800633307,	-14.7735051703,	-20.1510237050,	
    22.5049816980,	64.4191999102,	24.8385648232,	99.4265041360,	62.0189508473,	-28.3892600378,	-109.8842008564,	-79.0407483407,	
    18.3408112020,	49.1650536089,	31.5419844924,	-36.1160722679,	-132.9148081329,	10.4053531567,	-129.2463715470,	-43.4602207151,	
    -24.2420653292,	91.5388317556,	21.4762248190,	-44.3810909139,	18.4098011282,	-45.8691164539,	-20.9831197962,	16.2076792914,	
    66.0224147666,	-13.6794615513,	101.2163279622,	-62.4462618603,	22.2040981785,	-52.3208382802,	-24.7909079016,	58.5150375093,	
    18.8569705105,	-55.6083430939,	131.0273367422,	-34.5209015065,	121.4357296573,	-77.2590299593,	-51.5929566898,	5.0247131098,	
    -23.8451707592,	-4.5912313547,	31.1387246821,	61.7019310824,	49.1912429744,	-50.5836913031,	-74.8182600630,	-21.6209317022,	
    20.9409464654,	-72.7870824583,	-28.3530746820,	-45.0794425434,	-13.4910629905,	-62.0158772255,	-34.1421181246,	44.2844972784,	
    8.4213193211,	79.9349022793,	60.0160502260,	32.2272994080,	-72.2893887746,	17.3063698247,	-134.6335742431,	64.6499736261,	
    7.1411921919,	-37.5517577873,	6.2405670930,	117.1920927305,	128.7420689815,	-3.1556854963,	-13.4100422909,	-11.9336372907,	
    -8.6022400553,	-102.0033506666,	-78.4696575074,	15.0765861403,	-111.5219718576,	-13.4162786508,	38.2437013694,	61.1637732561,	
    -34.4804160003,	107.4438003830,	-79.4193067813,	-81.1842853968,	-26.2622970331,	132.3205425408,	-119.1464268477,	67.3048866598,	
    103.3266736715,	-58.1865815617,	27.6231908601,	-11.2004371750,	26.0340617206,	12.5696123916,	0.6442714420,	-30.7393043544,	
    1.5314955897,	49.9110088250,	-106.1358721920,	51.1608329944,	-32.8684239794,	-27.7215905745,	-11.6450303367,	-36.7731678028,	
    59.9383486599,	-4.6301990580,	5.0361682939,	-10.5669407980,	124.0908762205,	35.8305364082,	-123.6216777114,	-74.2569079167,	
    -56.7651776816,	16.0736385582,	23.5030632215,	-110.6764295938,	44.3086821806,	9.4452708243,	5.3300080251,	39.0483916714,	
    151.4550562868,	62.8957092621,	-116.8103461233,	5.1129927759,	-33.2252515135,	-9.4522506046,	22.7026048372,	-15.5264414569,	
    71.2087620034,	19.1191568332,	50.3019546809,	-5.6096922409,	22.9344126462,	-7.7591876203,	31.8949515564,	-58.4253952381,	
    66.4341297173,	-19.0583083044,	96.7695087855,	20.4934280047,	4.9544603116,	-20.8288135920,	-173.2659655408,	-62.4883621640,	
    -48.5528422703,	12.1437504278,	60.2482234666,	-19.6072312919,	-34.6320214291,	129.0089698963,	-50.9042160618,	98.3952661477,	
    -4.7051792479,	-13.1768910826,	69.5138802139,	58.5748201565,	-45.9385652563,	151.7952104306,	34.2541941013,	-58.0417838381,	
    28.1480473670,	46.4006562684,	97.7001828545,	4.0855607626,	-32.6097018162,	16.8913949959,	105.7266202978,	-89.3978374651,	
    -60.9338593128,	-41.2220734230,	49.9393070783,	95.0974764854,	49.2498366456,	58.6214364590,	34.1113830569,	45.6634098874,	
    -22.5356086770,	-97.1978653617,	86.5565049535,	70.6118545777,	-30.6978082909,	118.7238621666,	14.5922386932,	11.3449652072,	
    65.6007783405,	82.6369678204,	-52.0390492248,	-47.0160551227,	-95.5142448634,	99.7162626888,	-36.5523815090,	-42.8042935534,	
    68.3566199798,	-13.8451547552,	-71.1629911780,	36.2989433752,	-32.4867163365,	112.4079947071,	-75.6295117422,	47.5276421639,	
    51.8078250755,	-26.8715188457,	-9.6291144797,	40.1999849640,	-38.4634033246,	40.9764960915,	-26.1715730268,	36.5996396515,	
    -26.9924731886,	53.7879986570,	-83.1658398348,	23.6381378489,	43.8794937753,	-55.4133836419,	90.0266130838,	14.1036181982,	
    -18.1225736715,	85.1363181151,	-62.5970846379,	-18.5291947838,	-25.7341986703,	-49.7061342931,	-59.0442763971,	50.8960636803,	
    -87.6471123430,	-36.7217762531,	22.5952364054,	11.1107885650,	-0.5377327229,	160.8145792630,	73.3103441505,	10.1656872354,	
    -50.4554350397,	-57.3478171016,	-15.4201715357,	-26.9135446491,	-4.9891264771,	-37.0226770057,	-80.9919535641,	50.4418660876,	
    -25.8517575250,	-69.9538258421,	-17.5730160671,	15.9405836751,	113.9545230349,	-46.1040379057,	-94.2458635014,	-69.0338522452,	
    43.5813790265,	107.1836101171,	-55.1012654323,	-77.1529555887,	-33.1530320656,	-94.5582659641,	-53.6837586872,	27.0680381378,	
    93.9385415207,	-61.0955216188,	18.0530957225,	7.9150142320,	-12.1218191587,	34.0173961457,	40.0084937565,	9.8119275580,	
    44.2065861274,	-1.8718514394,	67.4740024215,	46.7391150131,	207.2404815875,	45.1635364462,	43.3580102761,	-44.0244218674,	
    83.2387206007,	-8.6441851856,	12.3993902588,	-22.5091685270,	-19.8332981376,	97.9196509289,	-76.6720306234,	28.9740705859,	
    121.9415248016,	9.6656982611,	-51.0996453694,	37.3704374740,	74.7589840907,	-113.4066752631,	120.0029566342,	-105.3786221360,	
    81.8152755619,	-13.4979932982,	-21.4680758393,	-85.1088235539,	-65.3610798409,	-35.0444139470,	-48.0220794487,	-41.6210317362,	
    33.1212995259,	-82.1480936443,	-10.5479715135,	76.4601917004,	42.1983651157,	92.6104239912,	-42.3536237955,	-24.5644182272,	
    30.4446637772,	-90.2899420489,	63.6723540422,	103.0895811428,	64.1706769263,	-10.7069812309,	21.8927240409,	6.3571071738,	
    57.1457649358,	-52.9866276448,	66.0981829072,	-29.5372056881,	-79.2252039810,	-136.2440652798,	-57.0106422562,	86.8203548141,	
    66.4244149837,	53.3230426111,	-66.1283059222,	-131.0402660353,	8.0548411081,	122.9088988100,	1.2626894208,	-60.5059112373,	
    -68.8707203082,	-6.4747987200,	85.8411327244,	99.9624156733,	90.4197864338,	-35.9630441182,	-22.9158275507,	-17.3660128776,	
    16.7845345761,	34.7219749782,	-39.3513765878,	1.0460702756,	-60.9494500182,	20.0900333387,	-85.9636743832,	88.4400782168,	
    15.0729628728,	61.5499846243,	11.8579871757,	107.8617581581,	-42.9393027864,	-62.8422307621,	-19.0589600542,	4.0750325807,	
    -36.0651825425,	55.7638724501,	-10.4691736080,	-55.5672537178,	-61.2061519915,	-21.1885348576,	-131.2535612498,	24.7463552676,	
    22.9426321237,	14.3038202264,	-138.0926317438,	-59.0892900856,	-162.5416439986,	7.1307658250,	-141.1236672256,	-4.7173618068,	
    -16.7741532807,	-68.2615451173,	-2.6608701102,	84.1978109826,	-11.3446202072,	59.9630033088,	-1.8994925010,	-37.9301641959,	
    -119.4435600954,	-11.4587491646,	12.2423215240,	-7.3169898616,	-67.0373621128,	36.0198843055,	53.9791315249,	-134.5885680695,	
    -83.8330811965,	-16.6714816463,	-8.8498552035,	-24.0513088196,	-22.9444328877,	-37.7961441531,	25.1975736186,	-136.1611637464,	
    -5.0843464033,	-10.3939554694,	20.7422826935,	75.6854136623,	46.4179626736,	-57.0052830175,	7.3457235521,	-51.5504447254,	
    -158.4375751701,	-200.2426967181,	-48.1234996261,	1.6623945527,	21.1746524375,	99.4092980367,	-2.3206772903,	45.7989166757,	
    2.0181548348,	-88.0556010969,	-59.1527212096,	47.3607925077,	-10.4181140309,	56.3558125650,	-8.9799125560,	-30.0376711812,	
    -36.7132904688,	35.7785050392,	-13.0763909369,	-2.1855594714,	18.1550954005,	-28.6711803575,	-55.4495172398,	-2.8812973198,	
    -59.9575059158,	40.0588875786,	57.4713686602,	-3.2835144853,	-36.7193552111,	-64.9415131516,	-166.9555466445,	-23.5556853844,	
    -54.9408569587,	-35.2310451959,	21.3345143458,	65.7590671151,	51.2214538168,	46.1271939944,	-42.2235267919,	127.2329928299,	
    105.2391778600,	17.6726845966,	-129.9021148044,	8.7065613044,	-94.0987112511,	-3.5375742950,	-23.1385452379,	60.6219530633,	
    92.5445564235,	48.5111974469,	-52.5699309159,	-60.0634811685,	25.9034368684,	140.0249495491,	1.5918852392,	38.0266038291,	
    17.5588710703,	3.4294066089,	-27.6748782173,	59.6182974489,	-35.2924781853,	-38.6198576115,	-13.6119803198,	7.8375587489,	
    22.7250686519,	-28.3524510951,	-34.4269062817,	22.6464817325,	-61.6528147860,	-5.9782002429,	61.4730771294,	43.5582379527,	
    55.6862408270,	87.8745651631,	46.3401042715,	-19.8780979663,	74.1272633369,	29.8590452377,	-12.8665765140,	34.2931401219,	
    53.9279617551,	-16.9017895140,	-70.1527553166,	-79.6367897992,	109.3728271017,	-129.2214826835,	-53.4644539730,	-51.5654458993,	
    17.6062148433,	3.5090251835,	74.2615941204,	-109.3431097845,	40.1403465151,	28.8714561280,	94.0868659302,	-19.0047033845,	
    -60.0967410050,	-19.0998457619,	-67.2027075128,	72.0711434846,	-17.8737851232,	123.7050551274,	132.6331504104,	25.5018761009,	
    -36.7817189239,	-29.1580893235,	-6.5848563828,	90.2868948516,	-35.7017258498,	-68.5675432955,	-52.4888589786,	47.1377730021,	
    -7.4546621940,	-52.0657517138,	-49.0404829633,	-114.6910280126,	-117.6819819437,	-32.7856729408,	31.8232065591,	12.1192973039,	
    35.2678513420,	-1.0336778293,	30.7021249679,	127.0442906046,	-84.8457819393,	28.9862843096,	-47.3524701726,	-126.1094998460,	
    -2.9700276582,	-2.4956545870,	-53.8624121141,	-85.2114117637,	76.9057985618,	137.1205201755,	-19.0830817212,	14.3407526579,	
    -56.5921994449,	-25.6084873186,	-44.9470801106,	-133.3139496090,	0.3487447576,	33.4499716730,	34.7126257844,	-9.3307383323,	
    27.2996276947,	10.8765676134,	-91.1032360444,	-90.9584216222,	1.6981490570,	96.8557438791,	56.7726390913,	-44.3246449237,	
    52.3260643361,	21.5551140465,	27.4535327381,	2.0072717479,	7.4823125629,	77.1185863870,	16.1372262663,	-10.7206012957,	
    66.8830091413,	49.3523828287,	54.0855375598,	30.8570349345,	-10.9255375390,	62.3910624674,	30.9238561381,	0.3352881853,	
    72.1022806197,	-28.8319885008,	23.3335288806,	46.8999035980,	-67.0984424822,	-164.7917209112,	42.5767681360,	-92.4668227688,	
    43.8491734282,	-17.1126540408,	37.4819594334,	69.0774409673,	-39.3530526854,	-14.0693747124,	-60.2520781215,	-80.3860105519,	
    32.6689956840,	15.3393042576,	-18.5529761307,	97.3942151573,	-4.4462855745,	13.7614349817,	158.3358780719,	-44.7258299667,	
    -17.7741912819,	116.5136962268,	-33.6261057820,	22.8344441288,	-155.1423976144,	5.7070117893,	-22.7906543902,	-45.0633909283,	
    -13.9329987929,	-66.0848932507,	1.1383038109,	123.8386958483,	67.6662401589,	45.9152963554,	-27.4397697462,	97.9596747354,	
    -6.3544655181,	29.0832146722,	96.3468162499,	32.4535976137,	-91.0650399301,	2.7293262791,	70.7853483111,	-92.3655274571,	
    69.0359217256,	83.1530567979,	35.8375091111,	7.3393552348,	-95.1770165365,	76.4905790891,	55.6253140577,	-29.5315327050,	
    -19.6571455162,	-65.5631159968,	-16.1022064890,	105.8715375468,	-51.8381429466,	120.1887801783,	-12.7792505862,	45.9625293061,	
    5.2249771246,	-44.2522411781,	-49.9151046218,	58.9294840166,	-39.5237729290,	7.7590557538,	-36.9036719322,	-13.3726971638,	
    54.3809777660,	71.3070336679,	-51.0631236639,	-10.0694214486,	15.9743446435,	-49.4179644909,	118.7626471706,	-53.3128484840,	
    13.5615377463,	-109.8892656203,	-42.4445411536,	-66.3623671033,	-14.8179688320,	76.6614429072,	11.1173310385,	-44.0756061917,	
    -31.6081137549,	-112.6622817309,	32.5091400724,	33.0802101919,	-57.4339078738,	56.3466203876,	-17.0577340891,	-95.3692048341,	
    -67.3434566840,	13.8207460717,	48.9375767823,	7.9881518802,	-33.7163627475,	38.5685408163,	12.1465400224,	-107.6320581108,	
    4.0618423016,	-78.4521092994,	-86.1605081811,	76.0528521785,	-7.4505556232,	-32.6671595550,	28.1668313458,	-44.3982773094,	
    -17.6420279051,	-31.0505367972,	21.8444018590,	29.2596019459,	-15.0890859227,	-13.1393295693,	2.8101074170,	-17.7888538827,	
    32.0378687652,	-74.5375953900,	135.2497294704,	-28.0677270675,	73.5721900551,	-66.6873287357,	-25.1872324027,	66.2043845748,	
    -94.9847220021,	51.0053667797,	125.6199200698,	-97.2966230203,	-100.0987757765,	38.7851883798,	20.5509402780,	91.2789361356,	
    -23.6347319001,	53.4814037964,	-27.8226699628,	-4.2998301656,	-49.0060086613,	57.7107938724,	73.8228091191,	39.2104809606,	
    -27.3049570759,	78.3558930717,	-39.1465109393,	-59.6714099634,	-71.7254332281,	44.0304489875,	62.4610534699,	-47.5531388302,	
    62.3692165629,	6.4426089142,	9.0422858718,	23.1735394482,	-47.2878667545,	44.2020612249,	109.3032846597,	11.6805260558,	
    -30.4758154602,	-82.4704834090,	38.6561095453,	-55.4482370852,	8.5232602822,	133.2611664825,	100.1432731096,	22.9595423699,	
    -100.1659221126,	38.8223174175,	27.7691674207,	126.7418939874,	-91.4494781699,	141.2081002115,	39.0632821221,	63.2623914663,	
    -30.0221078403,	-33.5477169622,	29.1082028625,	-3.3848571660,	61.5724672364,	-34.9602677014,	110.9349405045,	102.6143795477,	
    -57.9940910047,	-35.2709261901,	16.7143230992,	-40.5324218543,	53.9355486697,	-64.2634715959,	-54.9387762268,	-42.9168088882,	
    -57.5562950128,	37.9068250889,	-12.1446003699,	-60.1702164080,	-20.6508515440,	-98.5324628329,	101.4072369572,	129.5400369054,	
    -81.3566359702,	50.6071670655,	-120.4768679404,	-42.4978466545,	-8.7364843153,	49.6150365421,	122.5389217747,	-17.0756316445,	
    -62.3577228096,	-45.0934187476,	-32.0622747717,	-30.5522096168,	28.4509994932,	-38.2485520772,	-50.1501458954,	33.6999850082,	
    -53.8053116265,	5.7733509059,	-34.6589594313,	126.1617129527,	20.7567771895,	172.0372861812,	89.0892733767,	100.7503861649,	
    7.3378103261,	98.5906415363,	32.0129761463,	-41.8886119031,	41.2269067119,	68.3876187817,	138.4871996142,	11.3975797943,	
    77.7316432733,	-158.5764699010,	-73.0154932162,	4.7811847147,	-23.2377092445,	-15.8949240362,	-11.9056513173,	-152.0900719578,	
    18.2632385344,	-54.1998869586,	-181.7000796389,	48.1068217262,	-32.5550981417,	-28.0507229974,	-31.8419308387,	-25.6072993087,	
    19.9544408703,	9.3745877673,	-83.7112773954,	69.9469812476,	103.7806121094,	7.5661034347,	19.3961679774,	-33.6734450687,	
    145.2662801261,	84.6823084936,	3.8883005529,	16.9248666945,	-16.9581909221,	-89.4228081883,	16.2888634344,	11.1954888184,	
    2.5472628157,	18.3389344143,	-151.4283735338,	-34.4147990116,	-25.9480238152,	-25.5347276158,	-64.8106533195,	50.6575131879,	
    -7.3028646826,	-32.2126924117,	18.1267061221,	-16.2075818210,	-45.6339941841,	-33.6697120217,	49.2624187554,	77.8687058107,	
    73.6069588809,	-40.8028084671,	18.9768190808,	-30.7579639537,	42.1813346527,	-83.5367163130,	-107.9332971302,	7.6029737222,	
    26.9032374575,	49.3843590700,	-46.3813865337,	9.1625140590,	-66.2444573706,	-81.6335790942,	38.1352819102,	-26.9099106066,	
    -73.7453409821,	120.4931605467,	10.3564307049,	-106.6178964489,	95.7043175624,	33.5246942332,	47.6828732088,	88.3229069791,	
    -15.5217019654,	-19.5431169450,	-3.8342503054,	57.2251891575,	-48.5444916144,	71.5434047188,	12.4489765266,	-11.7576981068,	
    -55.3127919285,	17.8351394582,	-103.4011502717,	-4.0445991564,	15.2952711643,	136.5345440142,	-63.7492382166,	36.9305043452,	
    -1.5952862211,	16.2532277000,	-8.2697982122,	59.2373828733,	-114.7747262875,	-10.3140845306,	-30.5291082162,	-109.5521180147,	
    0.0880047356,	-26.2704646488,	-5.8324862328,	51.9555476050,	179.0193630333,	35.7565163112,	-25.6830342083,	-38.6240101524,	
    7.1156497155,	-38.9184661158,	-44.0206559654,	-61.9671745846,	49.0909411685,	30.5438751442,	61.5412933030,	-24.2114612829,	
    5.7471838440,	-18.0880708776,	71.7203646740,	86.4088528992,	-58.7737324960,	-57.5055785792,	-95.3936802143,	116.1138906258,	
    60.1792035622,	56.3771096083,	49.7396983038,	38.3766351111,	69.8500772704,	-49.1498577356,	70.3558567877,	8.6780858427,	
    34.1723731409,	15.4734742852,	109.0630331552,	-121.1548202826,	-48.3994829024,	30.5337026074,	24.7828521521,	42.0584760304,	
    75.1343090013,	129.5812051166,	48.4270407054,	26.4055953415,	14.0152471956,	-95.9222273011,	90.6485095604,	-14.3202487407,	
    -67.2852187582,	-166.6666517028,	40.3833373200,	-36.1005828038,	95.8066175560,	-35.7716615894,	-49.1292761932,	-129.7066955214,	
    103.7802140124,	1.3540192035,	-11.7154031368,	-33.6798122030,	38.8567068892,	-13.4661723261,	27.7129532179,	11.5232210014,	
    23.1346883982,	-31.8376649712,	43.7429902892,	-6.7521035668,	9.2376550661,	49.7442294743,	-11.0442544230,	86.0728321584,	
    83.9184836462,	-16.1275908347,	-18.4328902788,	29.0599791766,	-119.8140170048,	6.1015865800,	8.3430418870,	-26.4676140800,	
    -54.4170405827,	65.9500246661,	-68.2589172652,	-67.8087618276,	-32.2785464329,	15.5784741177,	-40.7911512889,	-30.4549351749,	
    65.3973162901,	-88.7812378733,	-100.7984347025,	33.8660362781,	-29.6824618124,	43.1980425632,	28.3570049344,	-53.0517620662,	
    77.8517167497,	-197.3149986900,	39.9412966213,	64.7267960844,	9.0985185643,	-48.2516330353,	-25.2702193655,	43.5324967389,	
    25.2174278973,	-143.4955124244,	97.6996202090,	-6.8156183641,	-24.7105412789,	-82.1407130477,	-84.2647074618,	-31.8474816146,	
    -18.8364319750,	-39.5505715225,	-54.5495977905,	17.7158231401,	-3.7065472234,	57.0344653317,	-88.5539921734,	19.3061972587,	
    -71.7736386745,	-41.9757523004,	44.0839025453,	93.6350283513,	23.9985071911,	-82.1811236502,	-109.4369907962,	63.5407415232,	
    8.4092298502,	28.4295805746,	18.6411321700,	-5.3460515491,	-67.8392754185,	38.2413165851,	-48.3890309482,	-84.8999016731,	
    -96.8897430524,	-108.9709380233,	12.6763008215,	0.6495692893,	42.5729352890,	-45.4201114101,	178.6503517211,	32.3364256219,	
    -0.5018953239,	85.4524577539,	31.3821199920,	-77.2752461536,	-22.5276539124,	-73.5513316548,	39.4443099153,	-85.5453904099,	
    -92.8231923388,	-40.3971881753,	-58.4187011919,	43.8859268482,	8.6368900854,	36.7106300359,	46.0279473438,	98.0046308108,	
    141.8908992398,	99.5148913015,	-117.8125705364,	-39.1830583755,	-7.7274169732,	-48.2601982254,	62.7987036515,	-214.3028855312,	
    -63.1561162569,	-16.8220689219,	25.8725009221,	122.4301600524,	-14.0054049372,	34.6312211243,	-80.1152116439,	19.5089176613,	
    -55.4531957952,	50.2925094566,	-34.9023849044,	96.5932330242,	-23.3903984041,	18.8379347047,	-142.5109851060,	-26.3638740038,	
    -45.2635268905,	10.4556800933,	-67.2064627051,	-82.5693793971,	-61.2994401437,	-60.8623342608,	-49.5256808732,	-67.5095279686,	
    109.7221898389,	30.3565964773,	-3.9295411009,	-13.3243471006,	31.5325109517,	-42.7881917663,	-62.3012601651,	12.8902122674,	
    -72.4707062966,	-1.1385459373,	31.9714183017,	25.4392014670,	5.2034169158,	7.4078411122,	3.9210252522,	5.6054243531,	
    -13.9283618935,	62.6605467523,	106.2229553720,	-108.0346097164,	45.8846468124,	63.6694544818,	-10.1426865266,	-101.2125032732,	
    84.7788854892,	-74.9877442652,	-90.4102888654,	82.3491489235,	13.4299871406,	8.6923780794,	21.7402751068,	1.3078400943,	
    -5.3323741070,	-40.3811284623,	-2.8868770078,	160.0268532699,	-25.4997503943,	-89.7351898498,	47.6695601274,	134.7207474765,	
    -28.8772848263,	43.7271906311,	7.3228230169,	-96.1850462320,	35.8869106751,	-11.4777855539,	-25.7781856921,	48.9895273966,	
    13.8032764481,	14.5942766183,	5.8336013315,	87.6897796695,	-13.6765032835,	3.3883927453,	-158.3668079137,	42.2382326860,	
    21.2461344076,	15.6945936663,	9.6604677279,	-9.5678778930,	123.3597739656,	22.1167117074,	-74.9824011460,	-95.9807585582,	
    63.4915942695,	94.2011376357,	9.1392063086,	11.0696792396,	-61.7781744244,	32.4342673236,	47.9943613167,	-144.1319767603,	
    -72.7895423040,	-51.0997685900,	-1.7995707656,	-94.9206104086,	72.7211674226,	58.6708314320,	-20.8389738301,	-21.1038399946,	
    -16.3313082354,	-9.9622712842,	25.1381713884,	-43.3630408732,	95.4208180249,	4.9957713162,	139.7419301257,	-78.8102530942,	
    18.4468841849,	-36.6529768792,	32.8656605850,	-13.9061010905,	25.3836067009,	29.3018838146,	-3.3243716283,	19.1868542168,	
    -24.3576227747,	35.5704128749,	9.7305659636,	-28.0698496733,	80.9991737110,	44.1711909705,	67.2428623477,	-51.3139105230,	
    -84.1430177559,	48.3068887430,	9.0115749848,	14.7342922983,	69.3129475126,	15.3916339055,	19.1526114590,	-36.2384578425,	
    36.3072041758,	-2.7831098993,	-79.5517384898,	2.4496975564,	14.7441805304,	168.3353222077,	6.4042017907,	-94.1108499663,	
    -96.4470728057,	93.2974672034,	-25.8910707915,	-109.8714867373,	19.6739537972,	-25.7283734173,	-63.5666504767,	-13.2751224909,	
    -6.8369303742,	-44.9757631953,	59.5220216584,	-36.6656623877,	100.4234528842,	39.7179675926,	100.4793677526,	-86.2364278236,	
    -92.0288292261,	-103.2337376347,	44.2981800782,	19.1367051770,	13.8984402872,	58.8220815831,	-77.2361735490,	-114.4879467592,	
    89.1682762205,	51.2266997372,	81.3502982945,	-21.5959593928,	-11.6326571964,	8.8353642779,	-12.3913359429,	-23.1216638844,	
    0.3575351650,	-18.2903762351,	45.8302612836,	80.6428162262,	59.7892572555,	60.1876610526,	-145.2533267974,	106.2800108239,	
    -18.1569484863,	78.3937893751,	-85.6984739674,	25.2366777542,	61.5343531109,	140.8219730338,	47.9603484021,	-66.9887369929,	
    -30.6392044667,	52.9963805955,	62.4415105078,	-90.2869564132,	-24.2283129464,	-99.9584280390,	-43.1587468514,	34.3760232029,	
    89.0356907077,	22.0053768451,	-53.9159785951,	-25.1650972100,	8.0202661814,	-53.6342885367,	-7.1736148465,	109.3934027137,	
    33.3102237776,	-81.7593644113,	-31.4758286552,	37.4778685110,	-22.7494345710,	2.0108643659,	46.8251888594,	55.2739450714,	
    25.5904497373,	80.2180417943,	60.0712983927,	5.1023725171,	-55.3981506793,	92.0411889173,	-151.8431761496,	-17.8889138320,	
    13.8369339480,	-98.9537744078,	-69.4129195296,	-9.4399479020,	-4.5486917569,	3.8311487140,	17.2656994939,	-25.4507802631,	
    -42.3325354568,	-16.6440745458,	-133.8308014681,	-25.5109360172,	-23.1019754685,	-113.2804091682,	-14.3636580071,	87.9235056149,	
    72.6206212879,	-58.7137643393,	167.9006741193,	39.5232107063,	-6.3630485808,	71.6621087431,	-114.1539708322,	101.7815598753,	
    27.2475470378,	-54.1505303371,	30.1111783717,	-11.9959488516,	19.4405070791,	-108.4745463396,	71.0642431926,	-19.8129431719,	
    -15.2954756654,	14.3561030921,	-16.5356371988,	52.7783287094,	28.8939941206,	-17.2842243626,	-133.2248386977,	-83.3404111930,	
    -7.0104157691,	22.1756809435,	3.2730114916,	-32.2394014930,	20.3115837303,	-17.1488805354,	-42.1049764681,	64.9096377499,	
    7.1989366097,	-54.9327048635,	27.4112784568,	12.8647289850,	-47.9584681630,	28.1940916618,	-77.7181004478,	-39.0254847210,	
    14.6762624107,	32.0630508538,	73.0143676987,	-22.1015540909,	41.9874345585,	-2.8858853990,	-88.0645760668,	-90.5936909394,	
    -17.7732180284,	118.5661779332,	-66.7797486036,	50.5937256974,	-21.9300412969,	32.8513839567,	9.2389232325,	7.6133233529,	
    11.4306872743,	86.1899246751,	-14.8265560191,	14.3516516628,	-81.0949021047,	-14.0165322751,	6.4193008532,	91.1325356747,	
    136.3161040384,	-79.8056934391,	48.3720074062,	184.1908593323,	-1.2350224948,	104.8017124353,	-70.7660168596,	59.8117635799,	
    38.9768188797,	-92.6445519451,	38.4757633507,	-43.8909508451,	-68.7430495433,	-33.5503051820,	-45.7745564558,	23.1582292853,	
    -53.0556301244,	-84.2076950671,	-11.0754062672,	59.8325332450,	115.3577555552,	6.0322991520,	-27.2020584628,	-11.6601684536,	
    -19.6192551137,	63.6069935939,	-90.5530529832,	-65.9660360514,	-17.4108821433,	-32.2870508580,	-18.8912458596,	-13.0325547618,	
    15.6951179243,	52.5832125410,	-5.3522907337,	-17.8679842370,	-29.6421416058,	54.8215269985,	-33.6000150970,	-17.9637151319,	
    38.7672649613,	15.9768537914,	-36.5384968894,	-25.8899064866,	143.3564174538,	-16.7027387067,	112.4635318759,	60.9380860218,	
    -12.5989262156,	65.1545135722,	68.4448023234,	-26.7853957961,	93.3277464713,	103.6052678753,	-67.2083365675,	17.5708362440,	
    54.8826954360,	18.1508430942,	-39.3842844795,	37.1447880280,	57.6547054454,	9.2814912808,	108.2432242472,	32.8556189396,	
    94.3226005359,	5.8586602054,	-110.9028458371,	-51.1302011664,	-16.0219070131,	-7.0598649579,	-176.6996383318,	-49.6407750992,	
    -66.9977026952,	-89.9496950726,	-53.1942620674,	34.9304683629,	30.7056949448,	-64.8309845749,	73.0371656315,	-13.2113288868,	
    -58.9585474923,	-49.8700242642,	-6.1582020634,	-145.9633036671,	46.6807699026,	-9.8057958623,	45.5962806826,	17.8413742472,	
    -45.1844288752,	51.6533061953,	-18.3891326987,	86.2944939973,	-88.4475541046,	109.7385814010,	80.2606871510,	-6.8687112951,	
    -40.4305300274,	-68.8038418728,	98.8182955892,	45.0578128678,	-17.9270836619,	-58.9964717416,	11.5983932225,	9.3557201268,	
    40.2977049475,	138.6920714505,	-107.0950700047,	-8.5417944988,	76.5742734827,	99.7719961192,	33.2465872494,	-130.9955599444,	
    -29.2255022084,	35.8580665719,	35.2949239487,	47.8913285775,	-23.4340430256,	-20.2468230117,	-129.2315852983,	-43.7204390811,	
    18.6427890127,	-14.5256762331,	-114.5390628737,	83.3822028084,	-3.5819486705,	-30.4441161689,	-112.7352247162,	-109.1237973030,	
    -1.2881432609,	102.3673365896,	-56.6529958750,	-17.8832422128,	-83.7875095740,	27.3286576586,	28.2690336934,	11.4666255287,	
    52.7806502871,	-32.3964403795,	-11.7703336362,	-26.4802375579,	1.4830249909,	-46.7745447418,	-179.0106845682,	-46.4060214919,	
    13.0495006806,	-15.7093018033,	-23.0652411102,	-46.8891647861,	-11.2767379154,	54.4284213870,	61.0257369233,	25.9537772478,	
    32.1447676269,	-55.7565993845,	16.1980837538,	39.7108201653,	57.5494093425,	25.4753658982,	-82.6747317912,	32.8120846114,	
    94.3963947400,	115.4928024657,	-103.8033683890,	0.5505661357,	17.6017067223,	0.3340989298,	11.4554380855,	60.7715773549,	
    47.6023333479,	8.7147095957,	-12.4689201501,	-38.3317139365,	-70.8372336044,	19.8454635262,	-32.5311981944,	16.6656528545,	
    -99.4051451760,	52.1836216170,	-36.3751695538,	-168.5804600081,	-12.4503257083,	20.3254098853,	-115.3933821008,	99.5221568068,	
    -65.3861194417,	28.8829913431,	180.5755173101,	-52.4724526473,	-17.6810674060,	-36.4748431538,	-0.5256538571,	-55.6217233478,	
    -21.4129350702,	-62.6552175024,	43.7806633668,	68.9822663027,	-103.7310445758,	24.8680657731,	-23.1804371879,	-19.6865562980,	
    86.1256756588,	43.1915528025,	64.5202069909,	11.9433963783,	59.3956955884,	-136.0065807072,	54.2444425795,	-28.2438980841,	
    27.6881277816,	3.3966585075,	-23.2714416081,	56.2708787997,	-104.6936674005,	-56.2472159428,	-66.3373352615,	-79.0727896373,	
    -19.4338276833,	-81.4066241391,	-7.2994007916,	104.0111560011,	19.2521825910,	39.6171092266,	8.3114594881,	-18.6024599138,	
    -55.8404695603,	28.7502170881,	-35.9621183078,	-83.4040376758,	100.9786890719,	43.7353110787,	58.0923223162,	158.0571243490,	
    -89.5270222788,	35.7263973066,	-85.7794526924,	-44.9442606374,	52.4649663641,	-16.2400821703,	-137.0501146883,	33.4104950855,	
    -66.4055049018,	20.4444710408,	-58.9392047771,	93.1083108145,	30.4506487034,	110.0306666973,	9.2409143811,	-24.4812544449,	
    74.6860947628,	40.3769192483,	-16.9497053699,	14.5576684325,	52.3350907389,	-25.2007169663,	-125.4063020221,	62.8691359335,	
    12.3811488011,	-49.4397264264,	-45.2008829472,	-45.9893935646,	-51.0423101211,	-13.5776298651,	-117.3962715914,	20.9725891298,	
    -31.2377986416,	-66.8022452921,	-52.2545297076,	36.1808304465,	105.2804289847,	-29.7408485717,	35.4936891096,	-44.1058624503,	
    -7.4267543746,	45.9626674865,	43.2586644116,	-84.9652227215,	52.2598894211,	-27.7731305158,	79.4055411705,	134.9211049595,	
    -77.7683897577,	38.9772600887,	-42.4478182670,	35.7767677279,	120.4883485663,	40.9080290988,	-52.2908368677,	10.8332681424,	
    103.8755744034,	-69.4025590672,	63.1667239359,	51.1565115511,	30.4688205979,	-7.2886782047,	-18.0942283768,	31.5953801065,	
    -34.9573251248,	-43.3238802424,	-20.2265574149,	-41.4045853426,	-156.8022185924,	-20.3378496469,	5.4144969666,	-49.4467840461,	
    -27.8246258947,	-36.1553394393,	-40.4493178373,	13.5989840626,	69.9757376469,	-60.0443280971,	3.4638171519,	-141.4361514658,	
    93.4118114115,	-7.3645097888,	2.0470465032,	-54.6478723026,	7.3294655198,	-6.8416716006,	9.0045502006,	19.8489919128,	
    -6.4702933570,	16.4343253942,	-10.3891055517,	100.4561542312,	29.1536913142,	53.8464057947,	-16.7143417688,	-153.3024265390,	
    45.0496791201,	-0.9943534787,	-20.6269990550,	-50.6212419282,	-24.6576988474,	59.6066172704,	10.2122652005,	-40.4195486296,	
    -29.2714128060,	62.6802622802,	-47.4202386064,	-34.8309723516,	79.5197299960,	-20.0749434197,	169.8665850989,	98.4267485076,	
    31.7347164541,	37.2604966566,	6.7605021281,	-50.6903490963,	6.6127852698,	151.3469256096,	-70.3184827662,	164.9601379841,	
    92.6205263551,	69.9026079183,	-31.0866155998,	-34.9956145613,	-9.6578985782,	-32.6789267529,	80.3319506579,	91.7685176440,	
    5.8995239218,	-82.0636944263,	29.2086774264,	14.7724289401,	66.8988379781,	-24.7460191895,	-114.7525174298,	-32.9732857706,	
    -51.4321208184,	-66.2382282862,	21.2981329623,	9.1062826547,	125.8754077125,	51.0615189986,	-96.7297998983,	64.9965050494,	
    -71.5111010300,	-180.4535252581,	-56.1041777677,	-3.3591726481,	-74.8271358166,	-28.4281456554,	-70.1818488305,	35.6835607015,	
    -13.9275123287,	-83.1043490068,	22.2289783248,	-95.1448030958,	-40.5966123003,	11.8470675380,	106.6983680147,	52.7565554571,	
    -50.5809140712,	62.1951780988,	92.8998044629,	-110.2770489118,	-5.7088922157,	13.3095896843,	-34.0434382314,	41.5967680846,	
    7.1406890165,	49.0800572858,	-4.8661130870,	50.1732411845,	21.8791360144,	-20.6230498949,	33.2629053316,	34.8156585726,	
    7.7974775850,	85.5360926916,	-19.6603301120,	-13.8088176043,	77.2247366741,	81.7615386790,	29.5025756045,	-202.4477185665,	
    -31.0440373761,	119.6975128752,	46.8351618237,	-36.0825651455,	52.3228058699,	-61.7212902449,	-37.0009190140,	-111.1411485112,	
    119.3548750790,	7.5570310830,	6.2657871086,	49.2259611245,	49.9691348215,	-30.7394519018,	-60.1418076104,	-59.4870457446,	
    -111.9152565690,	124.6406880479,	-47.4604425483,	13.0533325061,	-76.5307924698,	-60.2632649204,	-28.0947702114,	5.4878397959,	
    -83.0541772262,	-3.3172056420,	20.2732863285,	29.4076349749,	47.3392948241,	55.3208777615,	-32.1444489144,	-23.6019236678,	
    61.9602080076,	41.6812616408,	30.8111928268,	21.8108462337,	-24.6948175247,	16.1446229981,	-15.8735793778,	-24.1870889577,	
    27.1864566801,	-50.6435004599,	-145.1098728714,	-75.7531085939,	-4.9397756888,	74.0940849050,	-53.5740454881,	28.4600455809,	
    -64.1804054310,	-56.5695284341,	45.7257738714,	27.3208227413,	-87.4969438966,	96.9999840115,	26.5098283187,	75.3671956291,	
    -39.9875814398,	-71.8080566179,	-64.7909433975,	112.6208244120,	-57.5455840916,	-9.0666084922,	36.9334781097,	69.7260235716,	
    -47.6511701810,	48.9455812098,	-19.7303239899,	34.4780933174,	-24.8188130996,	1.7918733164,	-51.1027083896,	-8.0414842387,	
    -69.6904961677,	91.4021012418,	143.3158713687,	127.8431865361,	-76.2463415340,	77.1863865583,	-104.8165933906,	-82.0491770730,	
    -4.2452881018,	-29.8857354449,	39.4203383204,	-78.4428804183,	-67.3737881273,	45.7774162557,	43.1510666403,	-38.1227007212,	
    48.0367915577,	-2.2796749550,	-147.5309258951,	59.4609063787,	-94.5201743634,	-90.2713711080,	83.9499629394,	-44.4267785769,	
    66.2311395310,	-19.8654393787,	-40.9657871591,	-7.6100345494,	-153.4687135715,	-24.0528389453,	-43.0977703429,	-32.4544558717,	
    27.4626014725,	61.8263048101,	8.4949142219,	-120.4489043103,	9.2738852281,	65.3309688121,	44.8133466197,	-37.4373241359,	
    -83.9640842471,	23.4059670119,	-93.9143209007,	-55.4183425033,	-93.7449781980,	74.3227981579,	-11.7471950643,	84.3803942002,	
    -31.4489037424,	-1.8363204298,	-55.3456417353,	-95.1228021775,	-55.4637768242,	-17.5611590555,	8.6597790424,	19.5417857682,	
    -17.2507716259,	-5.7889755948,	70.5139270183,	-26.9177828140,	39.6037632634,	4.0845034879,	-59.7156630403,	-55.4689095772,	
    -58.7669735168,	62.5057414231,	50.1807875376,	-49.3189045747,	15.4287355682,	-8.0824504769,	-47.6198199719,	15.7657690255,	
    24.1207871994,	27.9173027164,	-12.5261250855,	-19.0257872712,	-82.0154379577,	76.9194034147,	-14.6695769647,	1.4844193915,	
    -7.9956835409,	-55.6156194033,	39.9952855598,	51.1083969228,	48.8829532142,	62.7988625371,	51.9432398511,	2.8722062155,	
    156.1476408615,	37.5905889544,	54.7112433550,	80.2943943272,	-6.5627640190,	88.6335213431,	112.2792767414,	21.0878200837,	
    5.8741152139,	-19.6667337723,	33.7905147067,	-34.2798965801,	-26.4594706418,	-15.0765526773,	91.5802201722,	85.4145356413,	
    -36.4818922051,	-147.9028534383,	-42.1412753623,	-27.3632859684,	44.0453194249,	-19.1027467398,	14.3157309983,	4.1768734004,	
    -68.3022440228,	34.2186781120,	-10.1854692365,	-173.8586421151,	56.7091031998,	2.6538298634,	-93.3821299316,	45.9499799668,	
    -11.8122305624,	26.1216815300,	-61.0880687199,	73.1945783047,	28.9339417573,	42.3531539412,	-71.3262502743,	85.4828937399,	
    -66.7918044637,	5.4192940999,	-81.2977956585,	88.4998783552,	-8.8973642437,	18.0257683389,	0.2933847454,	-87.7509230128,	
    1.4360726567,	57.2432970677,	103.3736004675,	-33.8595106764,	36.4856625370,	87.6767927437,	45.9257522623,	-91.4882358338,	
    -43.9564432991,	36.8048295224,	-155.8735354347,	78.5839166200,	21.7365316114,	2.8251251119,	-0.5016069183,	50.9050618615,	
    14.1865751800,	53.6974572195,	-47.3239324031,	-62.3187399635,	-109.6783459490,	10.6742758459,	3.0633856847,	170.8292829026,	
    22.7107314592,	-115.6997421721,	179.4541315127,	36.6353212025,	-46.8173506792,	104.9377352185,	-62.3839485230,	84.2161407106,	
    136.1327139029,	-1.7544748630,	-86.9030562131,	15.4259753671,	2.5663369046,	-116.9292434949,	64.2129157660,	78.7964806182,	
    49.6087028507,	-23.1282134104,	-37.4278940992,	-67.9769820701,	-32.7546299170,	103.2337703853,	59.7504223629,	147.3485484359,	
    -3.2598723366,	116.2635358555,	-4.3105783057,	99.2160004729,	18.7288916095,	78.2186271384,	-32.7460615054,	26.6048168237,	
    54.4099899967,	-126.6518025639,	17.8377885986,	-98.5074167624,	83.5842655157,	63.5608049079,	124.1282700584,	25.0506382513,	
    9.0974612270,	10.2387616470,	31.1629214422,	-24.4182834051,	-15.9351308181,	-32.8438279677,	8.8571103031,	3.0977533207,	
    -23.0359569441,	-85.1033133185,	1.2922811622,	-69.5278720344,	25.7444385081,	-92.0141253702,	35.4374183520,	6.7043276497,	
    -0.7451513477,	6.4338102885,	-75.9673321161,	-91.6026967981,	34.9987265356,	-83.2890589702,	-47.9531745920,	142.7844807861,	
    114.2435566703,	-26.6531368807,	-16.5029393959,	14.8125488050,	16.9592532170,	12.9147547847,	59.7887418020,	-39.2528866593,	
    -15.3658342458,	-74.4590980998,	74.3475628113,	-48.1780064666,	-11.0564355396,	70.9519213138,	110.0516331927,	36.4575879060,	
    91.1281495181,	-103.0201029342,	-58.9865587379,	-87.3023951029,	-25.5889474724,	-80.1022425592,	7.1308546919,	42.2966419390,	
    28.1034227718,	-110.4992975497,	52.3250451635,	-22.1535855498,	12.7339036777,	34.0415435152,	-39.0750294825,	-30.4963132547,	
    -53.1808531221,	17.7255575164,	-10.9535616620,	-95.2135221101,	100.4987819707,	-68.9493118541,	-82.6099501128,	-18.0285171027,	
    -21.9761772415,	-27.5932967659,	91.8124465044,	5.8338598129,	-7.0338759021,	-45.7406241732,	12.9215890948,	-0.0753638964,	
    44.7159304680,	26.4654167590,	-40.1423667648,	-8.7426397748,	31.4700501616,	-38.5847107897,	-17.3446717482,	33.6461097548,	
    -107.3520493912,	117.4675224001,	40.6606607876,	7.9719714143,	27.8264722603,	38.7179679154,	1.7705195429,	25.5111272928,	
    -100.4419129176,	12.0673509113,	83.8410184425,	29.5781971450,	8.1040630143,	4.6727315335,	64.7847825199,	82.6216823615,	
    -15.1627242063,	-22.6182310171,	13.1330997407,	49.5724583221,	-46.1716475780,	47.7331801575,	49.7204543255,	-85.3529225637,	
    44.2195291098,	14.5616345667,	25.1355891397,	40.3146174825,	28.9423346884,	-75.1582368771,	57.1913980615,	-65.6984554165,	
    -40.7664709143,	66.4827050221,	-37.4060644320,	22.4137979914,	-40.0020443101,	-50.0281409167,	4.8184431368,	62.4290842324,	
    -40.0926566688,	44.5774651507,	-21.1028032780,	15.1185206565,	-16.5265077365,	50.9848497205,	-1.0692090929,	-10.2392281457,	
    -73.6134935055,	-58.7604124292,	-78.9611342584,	-22.1438277580,	38.5664728303,	39.8041438227,	-43.2409994985,	-37.9352795857,	
    -10.0448204868,	-23.8371815139,	3.2897249640,	-80.2885168342,	37.9525301994,	-75.0706497208,	83.5246116221,	-72.9921720117,	
    -8.2686558506,	3.9598212380,	-88.0878393938,	14.7857207938,	37.3105932736,	-25.5786314639,	-14.2401437401,	-131.8844485523,	
    -83.2051874645,	-48.7402478144,	-47.1392081390,	-140.1935235859,	-110.9171286805,	5.6067034386,	-61.3508997640,	-153.0780126325,	
    20.9763880517,	36.9388874884,	-0.5023108098,	109.2764166186,	-64.7679763308,	27.5264562598,	12.7297402644,	135.9094145156,	
    28.8725261600,	107.1985003559,	-17.0333242428,	14.6472316711,	79.6550390697,	76.3253602754,	-42.1106361443,	101.2937610145,	
    29.1345513275,	-81.3710305821,	-51.6367882642,	-75.6657420025,	67.6127817208,	-143.1235134075,	63.4083371887,	20.2771663953,	
    -39.6962975349,	35.4904122251,	-21.1761177463,	36.6827629732,	30.2533761253,	-100.8244394079,	42.0562320416,	-117.0985134680,	
    86.9313959966,	-68.5862263897,	39.2349791859,	-62.0712807646,	-4.7999897806,	157.2184386950,	40.1651596554,	-130.2861272594,	
    -21.2745075974,	96.2019047346,	130.4626031799,	47.8121736864,	67.8619386636,	-88.5169139565,	-15.5429762844,	46.7375894206,	
    -19.9234556464,	74.2075824091,	-146.2816301611,	-27.5190709903,	-105.4977126735,	82.7567139636,	-63.4005073458,	-97.8585647602,	
    70.7163936702,	40.3196085322,	-92.6325452663,	-65.4906649632,	14.2362768591,	-40.1848110012,	-27.7039695490,	-100.7942890248,	
    31.7082105399,	-25.9115041943,	-37.2685165720,	12.4301141470,	-86.2349812607,	85.4288388492,	61.4326022560,	-52.6450593109,	
    -78.4043996861,	32.7052974812,	1.1786814775,	65.3401420354,	8.4364632653,	148.3052078011,	-83.0828330696,	106.6354843068,	
    -4.3121195655,	-44.5526178638,	-2.9317305696,	109.9935497492,	-18.4045116767,	23.1613955078,	15.6972686340,	128.8746575438,	
    29.0629973213,	-10.2922631539,	-26.9225268881,	78.3939184322,	-13.9891592847,	-14.3955545921,	56.2259353432,	-106.9719383698,	
    -69.4541718556,	83.7959262767,	118.0020136833,	-76.6757480506,	53.0531323252,	20.3374814219,	-45.9339005486,	46.3861511953,	
    -82.7185926581,	-51.9983813997,	-11.1149096121,	-15.7796335925,	-14.9611867369,	-55.5963996752,	3.4778394189,	-63.4371998633,	
    28.8327087658,	12.5198672129,	87.7380213704,	18.4911159408,	56.8889056171,	-21.9589217680,	-93.4663445471,	55.1183878788,	
    0.6449948853,	28.6533319776,	-14.8059318368,	113.5439226734,	54.8995357737,	109.0924325068,	38.7922835723,	-0.1180981319,	
    157.7915336564,	81.6839158496,	11.8100964756,	-22.1691332044,	9.1777753259,	-58.6991331163,	121.9143128888,	123.2714985637,	
    28.7886850251,	-73.5910923730,	-128.7124920003,	55.3579340152,	-103.0285920820,	-68.0360814429,	-41.1894325447,	61.1418052767,	
    9.1032579737,	-114.7074592848,	-35.4778656303,	-56.5732437789,	87.7236911508,	-34.1313499403,	62.2620712971,	-52.3364100999,	
    -108.5676552169,	-88.3757117464,	-19.3248782556,	-10.6333977657,	11.1531439202,	117.9042736262,	-59.5405468137,	-29.0685166095,	
    84.9970950178,	-27.4738785887,	-49.4301782076,	-23.7375836298,	123.1572277910,	-30.7874739051,	20.0070113012,	92.6375682898,	
    -151.2677413660,	-64.5993124352,	-6.1931938222,	56.2980662344,	-51.0667271974,	3.2590148897,	94.2279629570,	-81.3680192851,	
    -58.2441470779,	136.3043204550,	-65.1682000377,	-11.6204578273,	82.5051730406,	-20.7566312389,	12.9732577973,	-3.6631681566,	
    5.8870959981,	-15.0765851320,	82.0878455090,	-35.8669226696,	12.3547961199,	-187.4160833910,	134.7486191161,	68.4591403436,	
    -10.0461433931,	59.1539319574,	43.7723616252,	79.1999168985,	-24.1914155320,	38.0293798436,	4.5268241580,	32.8861446301,	
    26.8134396608,	-32.8357678171,	75.5315658240,	-98.3994598766,	27.4380255469,	-18.2567928813,	-53.8692115445,	43.6445077874,	
    41.8403964980,	145.5446940894,	-45.1527793517,	36.2478163862,	-23.4791069949,	12.4999105154,	-39.0947731515,	-94.0528129824,	
    58.3030733328,	-45.3491781120,	73.6529605858,	59.5823230864,	-47.4741019188,	16.0307838051,	76.0140317071,	35.1546855136,	
    -5.8237741703,	8.3668861475,	125.3567506875,	55.2422644949,	22.2611352600,	-33.7548647520,	22.9568910221,	-35.1162490171,	
    34.5901055588,	-28.0490543019,	-15.6322113695,	23.3610785957,	95.0831229094,	-54.6273674257,	89.1750392621,	40.0225575612,	
    -14.4413587278,	97.6869759465,	14.7675464371,	-37.4004765161,	119.4568961628,	-26.1920161265,	-58.0012410134,	-28.7350340564,	
    -4.7796929865,	-19.7344028715,	-8.6437248253,	103.9809164360,	11.0043740394,	-32.6092633210,	-80.6443486297,	49.9986715363,	
    105.5490975322,	104.0899701063,	59.5660092301,	-17.9484147791,	-55.4356343687,	5.6176664765,	147.8940936440,	42.5217478147,	
    -33.7007685862,	76.2702328206,	17.7168869112,	29.8692838033,	47.9156001099,	78.0087519225,	-10.9663921228,	108.3826416455,	
    -12.7724638181,	-84.5882451872,	19.6390498449,	50.9452521435,	-10.4676220676,	-59.5812635820,	-165.2174342507,	52.9034909048,	
    4.5103428162,	28.6714188830,	151.2376493891,	-15.6519597742,	54.5244070834,	40.6356686042,	-51.3633558110,	39.9915724858,	
    1.7184423265,	-4.3510464817,	6.8579282212,	-37.7467707598,	37.4199831388,	-44.1415061320,	7.9715921178,	80.9137854559,	
    -93.3883447881,	-70.4226479003,	-5.9804507221,	-12.7588185792,	-12.7748179660,	-44.8489354744,	-27.7084595447,	-9.4696608732,	
    57.0454576802,	-137.5411295173,	34.0807152122,	-82.8428997163,	36.3720183240,	117.5741160380,	91.0621096220,	16.9215804561,	
    82.5046757105,	-16.3941226525,	21.6412310432,	9.9347818503,	94.4637136289,	40.3883996184,	-79.0927933462,	-74.1126629254,	
    -1.8463008698,	-11.7303452181,	51.4819690412,	-40.9029132628,	79.5478142926,	37.3467151745,	119.3061300476,	81.7656373311,	
    40.9995493552,	-18.8267671804,	-109.2814037436,	110.5826225324,	3.9090047179,	-12.7311846356,	50.2434808607,	-78.9987938122,	
    -48.9383950748,	-23.2509396875,	-67.8816298850,	46.0043667633,	-79.5062435328,	3.7149881510,	28.8345576966,	-2.4062068420,	
    111.7203117517,	0.4410205414,	-38.3832527193,	-61.3416288539,	-102.7939248826,	67.9533675166,	58.2475592529,	10.6035422626,	
    37.5730234873,	49.4994673002,	-82.1647604961,	65.7885201078,	92.2097983704,	-37.3226143066,	135.8561958349,	-49.4816302910,	
    10.8193370693,	-8.1591216625,	-124.7982308726,	-14.8282684728,	90.0927717376,	33.5256881620,	-59.8703916309,	21.7176330197,	
    2.1782551834,	114.1382737688,	-88.1597739240,	6.5361543045,	97.9695862766,	-39.4694065867,	11.5962132886,	33.7697466356,	
    58.9764174727,	-4.3190513332,	45.4357110166,	-39.8718237733,	101.6682995218,	16.6389670713,	0.3598261204,	-29.7440968058,	
    -31.6482054502,	-43.8553776977,	67.0772865832,	-54.5098535835,	30.0974211944,	45.0867818944,	8.8681839790,	-27.6698123459,	
    32.5238939056,	115.1771763945,	1.0297629680,	-0.1277281381,	53.5989816709,	-15.6940765735,	214.0039494923,	-3.9607957468,	
    -28.2459062295,	-78.4309884274,	-45.1615660948,	-56.8373512425,	-14.9182469466,	-46.6359981712,	10.2436473643,	49.6796044695,	
    -68.2156643693,	-73.6736376702,	-25.8482309017,	79.6432993680,	39.8430177404,	-48.6865340771,	-4.9554892261,	-10.8103852199,	
    -163.6398049355,	34.8129987597,	43.1988001177,	4.6425367549,	71.5136740040,	5.7449295065,	-129.5178610564,	23.2851316100,	
    -28.9856348679,	72.2878496468,	65.5641757637,	-22.6995529120,	90.6678161988,	31.9503079809,	-38.7957396135,	-29.8167763909,	
    -127.0682245355,	-114.5912946274,	95.8998971324,	14.6842186073,	38.6817470857,	53.4220170000,	30.9640386035,	-8.7681524726,	
    93.2374647164,	167.2548470938,	-110.0113841742,	60.7832491969,	-10.6378768861,	-12.9541979766,	50.4311478762,	14.8581364205,	
    36.2771855577,	16.0289680028,	-27.1211553672,	-27.6119525599,	-64.3782858077,	-30.6836783175,	-11.3104575592,	46.6583470371,	
    43.2576688462,	106.2483647125,	35.4221002374,	38.7051612461,	55.2640723227,	-64.1159659536,	57.0032601941,	-44.6269768244,	
    53.7789820032,	-157.3514759280,	9.5791816275,	6.2806945793,	18.6705185038,	153.1320561669,	-5.5671006976,	-3.2946321773,	
    -13.2024369589,	-21.6449448269,	-22.1412657716,	70.9673800953,	-7.9864874901,	41.7239378937,	71.5984356144,	87.1584519164,	
    71.0575050315,	-38.5112900717,	41.0828370864,	-97.7913314993,	24.9443056744,	71.6995496139,	-116.3501231153,	67.3823850840,	
    94.1851944844,	-41.7993332022,	55.6783133892,	47.5180232694,	-25.4261377746,	-16.5909249978,	-16.5035403522,	-31.2504616568,	
    38.1070466320,	0.3163573698,	36.1965564905,	54.8579811585,	-54.0608838266,	-112.2426667925,	184.8017345857,	49.4559933628,	
    97.2753525540,	-127.3976019425,	56.7945066844,	105.9924251837,	-9.7156760373,	44.4969751065,	-37.0888563276,	-26.7522105798,	
    -40.8300149353,	52.5243354843,	-19.8943377495,	51.1416695022,	-70.0108248826,	15.6121585850,	32.5217684217,	-90.1820508578,	
    39.2513383879,	-47.3412998909,	-31.3055181623,	-56.8173595829,	-50.8924569276,	-7.5435701646,	64.3413557990,	9.7281927789,	
    48.9305305599,	56.5372975126,	26.7417330296,	89.0738343693,	-48.5280725684,	-31.0853481463,	-9.6358615936,	51.4311918344,	
    -33.9718242925,	-15.7470007951,	51.2850467492,	-51.4187903682,	33.5815172911,	-71.5483298410,	-74.6635317137,	-82.6284293355,	
    -19.3084129904,	-58.4258965628,	-7.7220084872,	-50.0589600666,	-35.4767663181,	113.1079148915,	-10.8113655056,	6.6819361958,	
    -58.5734954218,	-83.7627866065,	26.5302830531,	-99.8288161852,	70.6577997609,	105.1602805436,	-26.9709761883,	16.7715250364,	
    100.4598899749,	-12.8354110399,	31.2835111044,	-28.1999286002,	-71.8821977449,	-43.8649368179,	-24.4752744590,	-13.8122643365,	
    -13.2937561135,	86.7641539982,	-45.7159093571,	-13.0092431337,	71.1728457692,	-47.6143967182,	-18.9549445122,	-52.6530519413,	
    -36.3758751689,	95.3593012050,	-13.8106918472,	-47.9731072201,	-42.5698690212,	-33.2874699499,	74.6397905712,	13.2248699532,	
    10.5705384630,	53.1572412508,	11.5799356215,	40.3743911825,	-30.1315085582,	-32.5536377528,	-63.4740422506,	-8.1108698232,	
    -39.7653559069,	-61.9123876789,	30.2050339534,	-13.4902607567,	-49.0742542298,	88.5722862352,	-22.0924973356,	-43.2051228512,	
    23.1418263846,	-52.0531638851,	61.7042537346,	62.2206170738,	89.7321026525,	16.2048654039,	-69.2890753423,	14.8548152449,	
    -44.7911045647,	-2.5487807022,	-25.2382987671,	-73.1162478241,	-6.5637044361,	-62.4609072239,	50.2645328426,	-127.1218373352,	
    35.9901816641,	-13.2427957988,	-19.1139418128,	11.5763910792,	42.0967727508,	93.8373969941,	48.7578089767,	116.6192984420,	
    29.2111912926,	58.1960409947,	45.8425638147,	72.1773323399,	83.8891643331,	17.1974768083,	-78.1227071776,	-76.1533486330,	
    -37.0312632710,	25.0291081414,	-104.8734413579,	19.7434765416,	-23.3082565679,	-21.2852819234,	-25.2235835223,	-93.6817252275,	
    2.7146982161,	-17.4896953310,	71.2109780985,	-59.2294931409,	-84.0666862918,	-65.3056520242,	120.9838686800,	74.4971556879,	
    -9.5684703908,	64.8377948685,	-66.6770366247,	38.8265471508,	-79.6623440265,	-39.6171150046,	68.0022918215,	64.9078337860,	
    19.6121887994,	7.2244101173,	-23.1854400590,	30.4614578804,	46.9242283532,	-1.0747268647,	49.2189640668,	44.6411673048,	
    86.9687811173,	22.6744479392,	-48.5360769344,	-66.6164589196,	43.6822611836,	0.0803667092,	22.1251605426,	84.5472356977,	
    23.3682917569,	-119.0004161504,	-77.5731290127,	-8.1237991059,	-9.8574787289,	8.0923731288,	11.6312746189,	48.8042209908,	
    -91.5385965138,	-51.9417178439,	-93.4017678039,	-7.6902800177,	42.8038592146,	208.1745748115,	-40.2269989314,	35.9946432857,	
    14.8799963031,	72.5512530025,	-33.4277806899,	-3.2314305870,	-66.9052809329,	99.7368956670,	19.5081727184,	-29.1990516772,	
    114.5317858084,	-154.9703729745,	-14.9584650353,	5.6179621219,	28.6224091068,	33.0426197666,	147.4892869040,	-67.9739211942,	
    -71.7894315626,	-107.3389637620,	-95.5814122043,	-16.2209528572,	-32.6673756107,	-24.6641235582,	-96.2759765479,	42.9819639376,	
    -45.0775031344,	26.9177278735,	87.2353637167,	58.4214280318,	-37.6862314706,	-27.9660896146,	-16.9115875649,	-16.1061688951,	
    -28.9055343700,	58.1888376313,	-38.1213943166,	-4.7623621285,	33.9409953615,	-85.9445074362,	3.1450686264,	-88.4878703313,	
    -50.0848195592,	-22.4167501243,	21.0397901669,	11.4240588629,	-16.0956576256,	2.8322646297,	-77.6952409905,	38.2576382396,	
    -53.6616605614,	-26.4231916298,	-26.3358464547,	81.4694985453,	-50.3033670023,	-8.2053965822,	19.9636273501,	-10.4302918812,	
    9.6629338686,	26.0903202845,	-37.8068628176,	9.2638853986,	-9.6752622225,	-55.1704616516,	-182.0875653530,	-116.3887933434,	
    8.5457908424,	-29.0590636102,	-52.1712423322,	-84.2194156867,	-17.3343644788,	-69.9177944994,	98.4410912043,	-5.8653773568,	
    14.8287039959,	-37.2315894188,	-15.8744801467,	55.8855979582,	82.6374695897,	-10.3491623457,	-13.1871637112,	-59.8321884846,	
    -13.6406794918,	-90.9144246870,	-39.5280425915,	-21.9758399218,	-21.0648164072,	-37.2225695620,	179.7142651659,	-1.6184261744,	
    -48.1631682332,	83.2309613815,	48.6367549372,	-30.7160958486,	-133.8419652482,	74.7583916606,	97.1026557281,	49.5481525536,	
    33.9337592438,	-48.6489706540,	-74.5656495945,	11.2027589435,	2.2601440520,	-26.1480067313,	14.1051697860,	104.3412840234,	
    -25.6567602627,	57.3314373931,	6.3330980799,	-55.2666198655,	-25.4971449454,	12.5333375030,	29.8117352747,	-92.8414244156,	
    -143.2454500203,	-7.5931354464,	1.8606525257,	-9.6143470754,	-56.0408726209,	-26.0595448033,	37.1855765550,	-21.2097936957,	
    40.1996970371,	-41.3351177032,	34.1834444638,	-186.6269086563,	-18.3614205839,	-37.9357021641,	135.6670379673,	127.6586855975,	
    23.6471207301,	73.4502163408,	-73.9251876551,	47.5332209105,	50.1140713450,	-5.8704801353,	12.9804536200,	46.7639885850,	
    -36.7458561449,	-33.4506904080,	36.4941161678,	3.4199906571,	-41.0407898239,	-9.8181030415,	4.7245112428,	96.3687030689,	
    -28.2365241736,	-17.4276379002,	-65.7706653413,	-96.5485126192,	46.4790636261,	32.1379379931,	-70.2471563731,	52.3768573029,	
    44.4162811009,	-74.8951342613,	5.7318009676,	-42.1108472837,	-131.1371125092,	121.7221178589,	40.1216742680,	6.4128170610,	
    -32.2753329082,	36.3368525229,	-30.2548033001,	72.6541502245,	-33.4706909702,	15.8356670629,	-50.4602392965,	-4.4743341580,	
    46.2418862356,	79.9973168669,	-111.2430552953,	-41.8285332332,	25.3359175319,	83.0841533978,	-16.9581589718,	-51.9200860092,	
    77.9429675613,	-100.4955466280,	-16.9528387572,	-63.4657485782,	-14.2913689634,	20.8998480157,	-98.7512394038,	175.0497111959,	
    47.0357236193,	137.1821799965,	75.4859204931,	102.0896754000,	-74.4319389528,	55.8710604661,	138.7844756707,	-23.0214452064,	
    -44.0374225169,	-39.5194006283,	17.6585042519,	-83.7726310797,	-40.9221184784,	66.2446785328,	61.9460848477,	-26.5717761182,	
    128.9173728445,	-90.0154125585,	30.7220887905,	19.6211869212,	91.6137623259,	31.9401330791,	-12.2054969481,	-173.4012681649,	
    -37.8843684762,	2.3280971615,	58.8027265021,	39.6103768351,	45.9231885572,	-21.2457868614,	-56.1950724310,	93.8767608958,	
    -20.5075317720,	81.2860077414,	-82.0982682957,	-17.2313104276,	-36.3367685204,	146.3298759474,	83.5645188769,	-95.7871128855,	
    -41.4691805243,	-4.4610514276,	76.4605569574,	-18.7164073238,	60.5960801248,	-55.1266248358,	-49.3982202577,	163.4790300050,	
    138.0264616472,	-15.2636421738,	36.7895684788,	83.0702148363,	-93.3437893057,	32.5989066039,	-49.2049731278,	117.1479217209,	
    -35.4644848480,	-44.5015630679,	31.3859706395,	5.8693717755,	17.3746859058,	9.9311131323,	6.1022018377,	-121.9841205723,	
    48.0645606148,	-103.1127755426,	20.0433058006,	-134.2922130039,	28.5016581997,	101.8535712259,	76.4518488086,	-9.2802004844,	
    78.1358057662,	3.3099138954,	69.8587685844,	110.6444273503,	-59.6931547724,	-51.7268303246,	64.0193271761,	-15.1660919639,	
    78.7207187414,	-51.4776928138,	30.8703273062,	67.4488362333,	-95.4561768870,	-100.0161430296,	198.1825455394,	131.1359211305,	
    3.8645077188,	-19.1178912788,	30.3260202103,	-19.7430200798,	12.7734912557,	74.1885333495,	-67.8364659684,	-80.8926661663,	
    12.2720397333,	-22.8440467871,	-42.1377912025,	22.2591508655,	-94.9559790816,	116.4053256024,	52.9759527067,	108.1630429012,	
    -82.6415576638,	107.0506710689,	-32.4925050747,	-134.7178668343,	125.0907581204,	-33.0460380391,	-37.8115604172,	13.4036941541,	
    27.9798939995,	-59.6965877877,	54.1339455110,	32.0538788400,	24.4020907468,	-74.2815166253,	8.4464964158,	-20.3601523468,	
    28.5216426135,	54.3051140070,	91.5671757124,	44.5687804478,	-50.8430812549,	-15.1985800847,	72.6230011188,	-63.3817304557,	
    31.1651064018,	50.5057736622,	-111.8897385947,	-2.9491865484,	80.1135762676,	-14.0696654619,	52.3521392147,	88.3353740728,	
    87.0542702718,	44.9528879964,	24.2675410208,	-47.3556425676,	23.6195853690,	61.7358141399,	-39.8446197794,	-28.6054825449,	
    -36.0836012134,	-73.9089369029,	95.5989535672,	7.9458092374,	21.8693430561,	-10.5751898940,	-16.1045252653,	44.4127909167,	
    18.0851707496,	-46.7345019239,	-92.6347568314,	-15.6603448228,	39.6519674060,	29.9629332247,	-24.9622443586,	-47.2975561701,	
    -17.7780218654,	71.7346558516,	1.8999680118,	-98.4624329314,	98.2614298645,	15.6787428700,	45.4912030123,	28.2495734475,	
    65.7419427030,	-99.5295634165,	27.2786047010,	77.8875001753,	16.3977450032,	10.2037888065,	60.8912178592,	82.1708628016,	
    48.2506800969,	-26.2756011209,	-57.2019501999,	-91.8180165526,	-47.2336309942,	-42.1121454516,	68.7279348832,	92.7832491188,	
    17.6280339107,	6.7251426316,	25.0819097881,	-59.7146158445,	-65.8513175770,	-41.0602910259,	4.5838916831,	38.8846775235,	
    19.3473841098,	-105.1434354654,	-13.7765844991,	24.1616037866,	93.0893862826,	-107.6082978084,	-58.7977319447,	58.0759414185,	
    -89.7901093790,	16.1918835625,	-37.2172665357,	123.6960140670,	114.2205895053,	8.7980887529,	22.1354877733,	52.2713979482,	
    22.2246402930,	36.6257130653,	74.2884386832,	39.9288008601,	113.0416245079,	26.8047584467,	58.7266876251,	-6.4680422666,	
    -26.7509331673,	-38.6312732122,	-145.0208923168,	-35.9684264419,	-117.5381191845,	29.8488196638,	-51.1247043830,	112.6915937071,	
    31.5277658506,	-24.1454178026,	24.0572867542,	-15.3632719912,	-44.2556311042,	58.2449714174,	-76.1363396817,	46.3749067777,	
    3.4852275006,	-104.6231553696,	30.1977700745,	7.0441446610,	-10.0102536523,	120.6615291011,	188.0249410917,	44.3295887206,	
    -39.4106227621,	-42.4924838463,	-28.9316859978,	103.0113316106,	51.7061135184,	-18.2169052015,	21.6066648209,	50.1453569033,	
    12.7421867528,	-8.1356008640,	75.2454422748,	64.8694058804,	-161.7997182567,	-17.1915039219,	-41.2383269408,	0.8946812357,	
    55.0533498639,	46.8242610223,	-5.3780848566,	-46.8156157192,	64.2205137708,	-25.1479872711,	-54.8298550608,	73.6823422266,	
    41.9888520352,	-83.9419623261,	-41.0305214865,	-47.4087035362,	33.2268582543,	-38.7414663450,	-104.9255474057,	38.2157988361,	
    -22.3790617016,	-31.5426215850,	14.8891733573,	-64.9019662116,	-44.3044057867,	-92.3281371013,	63.6669819235,	-18.2425819417,	
    -49.5109487403,	-64.0201431562,	-70.3061633619,	-147.3930233046,	128.8254864954,	7.6978217230,	-56.3987238261,	95.5962971177,	
    24.9319849141,	-1.8305826630,	63.7414243665,	-49.9852779582,	-25.7389331291,	25.2700519583,	170.5603890165,	9.5266276922,	
    13.5399442827,	0.7663023156,	144.5140143737,	75.6602313295,	44.5345480965,	35.8927901197,	59.9952333199,	64.3016125781,	
    59.7518716703,	15.8739554628,	57.5686758914,	58.5866845774,	43.8356058096,	7.1335337346,	27.6439212874,	-30.0398764928,	
    6.2065364457,	-79.6476847939,	-80.1779260414,	-52.2408711631,	9.9023027662,	10.3789070887,	-46.6717275791,	57.2822267955,	
    73.5763019279,	-71.4639042142,	-52.0323289026,	-80.3692311543,	8.8431925427,	-40.3750957204,	12.8573997402,	-112.0129690473,	
    -67.5403575455,	-4.9929337525,	131.9313839610,	-108.2934624601,	17.2672219445,	48.9942839871,	-90.7089806183,	114.9850344553,	
    31.5988734490,	59.7636253519,	-33.9764105756,	20.7915341567,	94.3558278877,	4.9570378129,	75.5601876581,	33.8799007373,	
    -90.7302419365,	1.0494275291,	-33.5814817284,	-50.4328011162,	-52.6438122254,	10.3630633870,	-90.7790260582,	-60.4947106306,	
    56.5127910083,	32.1019449106,	-8.8885657127,	22.6481300860,	-74.6992587301,	-137.1086103933,	-35.3402671515,	52.0032440119,	
    14.9769109018,	-23.0406615521,	-41.8971596726,	-77.3413472134,	-46.9910623823,	-107.4957490524,	-86.8794002198,	52.2329975546,	
    72.9424340427,	-74.3244971184,	85.7023745145,	60.8778950641,	-31.5903542844,	-78.0533202133,	-73.1733800101,	53.2034137779,	
    83.0498994257,	30.2580271740,	-56.1035163750,	16.6579677161,	0.2073439761,	-5.7906867906,	-66.8711603748,	74.0261467640,	
    -62.2989478643,	107.8399681550,	160.1626153730,	-27.1263316346,	-79.7784413411,	-10.8403444789,	-37.3887634955,	5.9808867714,	
    -10.1978150670,	-53.9468869673,	-38.2970373675,	16.3168988370,	-1.0483342304,	-63.6173233903,	87.0866029730,	26.3862156999,	
    -21.4053546455,	-7.8216446996,	90.5994689064,	44.6928873902,	-146.7075228500,	-62.8122471300,	-121.7119840134,	-32.8992273432,	
    -11.9106565965,	-104.6076313473,	127.3823687195,	2.4852952522,	8.9975686284,	45.5738431227,	16.8209391951,	26.7216521497,	
    -54.8776022226,	-68.4194899925,	20.3925320149,	4.3453071650,	49.9988757708,	-8.6636385971,	0.1191776713,	-64.1528259747,	
    16.0849193094,	-24.1120788064,	40.7655203071,	-23.7853262362,	91.6933164270,	-54.3376676772,	69.7309190298,	113.1324293560,	
    16.9278536871,	123.2439408123,	5.9934209089,	-45.6409119369,	17.1842607385,	83.6522464227,	-174.5484916836,	-4.9414325022,	
    52.8768375216,	15.6132102239,	41.1192572000,	-81.3594721245,	28.8255333085,	-2.0603766865,	6.4061712949,	82.1547586637,	
    -36.3679383103,	-1.0390408940,	-13.8483417281,	37.2231178393,	-2.5777964710,	-157.8382079085,	-60.7910508762,	48.7258486830,	
    33.1256641954,	-54.6346845809,	88.2192196002,	39.9956402036,	3.2010617529,	88.1693658284,	11.7277451767,	32.7636165636,	
    -68.1591305748,	43.2699890762,	107.2828531104,	-36.8225650893,	1.4407313695,	53.5742622795,	103.7597203839,	-96.8481119045,	
    -70.2987605549,	-55.2783713624,	-6.9864094662,	-40.3280834509,	16.8072891922,	24.3756993403,	-84.6501745052,	-45.3961429485,	
    -53.9237387431,	29.1708008262,	1.0498758638,	34.2610169651,	-9.7905112911,	-35.2443111357,	99.4574100554,	-82.7243314274,	
    -12.3112078341,	-13.4935295204,	-65.0441169373,	-1.5707942158,	-8.0237289199,	49.5507868185,	-13.4811149250,	-3.9030733772,	
    -75.6220602476,	-74.1596322041,	-5.7789561939,	73.6177769297,	-98.9485291892,	117.7192585235,	-79.3791252579,	11.3447373614,	
    -24.5743979438,	33.7169431880,	39.8633765496,	-149.5617929692,	141.9104918620,	-55.0577810810,	37.2052313138,	6.4852281207,	
    -51.9122252169,	-31.2592720321,	-69.3547398856,	-78.1122747852,	66.6338044220,	8.6865150501,	-67.8354186666,	-202.1226264943,	
    -31.1645341579,	18.2037364021,	-64.8577486822,	32.5502423750,	26.0251882844,	5.0986012605,	-47.2026094332,	-13.9009556603,	
    59.4152148554,	101.0702523560,	-35.6013874662,	22.1677959258,	-26.0857605492,	14.4754773923,	-0.6780897798,	-25.6530120006,	
    -25.4546641639,	35.7707567857,	24.5314489446,	20.0344481593,	-18.3207572649,	-9.7912924757,	-11.9552594910,	106.8966283008,	
    80.2653334386,	-3.6056009570,	77.5441202535,	37.7136483336,	-2.3165569778,	-15.1111584239,	-21.3047579337,	63.3629898072,	
    15.4217847395,	-48.6546027271,	33.3996963722,	-87.5423526700,	-18.8955709453,	-85.0736444599,	-55.2290313813,	37.6993014695,	
    -1.9420172920,	143.1251237972,	-55.5771775185,	-41.0289639463,	-82.6515627688,	48.5420105013,	10.2288031648,	-56.3379070490,	
    20.0143954586,	-84.8968512309,	127.0283241701,	-79.6996444881,	-52.6134879057,	22.0561680431,	60.7355377150,	15.4017379435,	
    -103.3924328801,	54.8459420743,	-75.9157921311,	-18.5478645340,	-120.2337715192,	19.3119533190,	14.2354651926,	49.2411155276,	
    178.0946722971,	-75.1044338856,	-17.7857687140,	-44.5847020456,	-90.1973261616,	21.4416495288,	51.9825060227,	-66.7420817203,	
    7.5764658958,	-70.5144035274,	-58.0645913437,	-108.7601823595,	11.3207059592,	-71.0204300166,	-71.9141786835,	-41.1119761277,	
    -63.1487461134,	-7.1948924612,	37.4257273157,	-0.3096640281,	22.3859391424,	37.4791977942,	4.7298794262,	-33.2974745191,	
    31.2867641674,	-32.5753321154,	66.5419169580,	-60.5202504180,	17.4192217276,	-50.5317834280,	95.8748766870,	-31.5464032969,	
    44.7045552306,	64.5521928874,	-23.1461700992,	118.1095509083,	35.1065388893,	-27.9857316442,	8.2912382315,	39.7446781812,	
    3.3485245256,	56.6810611812,	-22.8994983441,	80.3970810489,	22.3086957726,	128.6454657339,	22.4798757743,	49.8362059423,	
    22.4019441476,	27.1059712406,	11.4540686475,	-10.0764491110,	28.4803668412,	94.7776130875,	-36.8737987939,	-88.8666428850,	
    141.5495956917,	-46.9343244046,	-58.9586661150,	23.3890221338,	72.3692845286,	-27.6356117882,	-41.8318324842,	70.9559999727,	
    -8.0897813375,	-78.2950183802,	87.8658917396,	-70.5715383399,	22.1972033651,	47.8069266963,	131.7707915958,	-23.8938128672,	
    -33.2047798206,	-40.7583820499,	27.0405050078,	19.6445061622,	-19.3891108700,	-136.1942182249,	8.5255159178,	-42.8234719503,	
    -70.4814202849,	-41.0662321022,	-9.3910777305,	136.7254609331,	-6.7391967243,	-68.4796734994,	-27.6933664361,	118.5680907562,	
    7.1623426945,	6.8386734240,	75.2481710418,	33.2280590090,	50.6011222647,	-2.6551190091,	-54.6429379954,	-15.6441827245,	
    34.8192824650,	41.1519964665,	-95.5213521044,	-7.1466152035,	-23.1705143065,	21.8243235569,	-26.6493944983,	44.3948925119,	
    -0.2695887637,	-115.9753822388,	10.0551835964,	41.6343978371,	17.7354401036,	3.3862359071,	-107.5692389700,	110.8538665943,	
    -77.0898864044,	-18.5513096154,	87.7377015326,	-89.7201205553,	-21.4828890020,	12.6716787713,	71.2019960218,	37.7530110511,	
    -111.0886809644,	28.0083327042,	11.6412229475,	-14.9061811373,	78.9633564364,	-17.2424064978,	78.6411356878,	31.5888916445,	
    -52.2057754767,	-51.8187552856,	12.8069170133,	-44.4192811197,	-29.6758641711,	-39.2862559158,	90.7444415817,	9.9897923810,	
    -33.0089291278,	-79.7506824464,	51.5840713006,	-15.3414477161,	55.8773639416,	10.4014931469,	-12.0825624913,	30.2487218486,	
    13.4626458507,	-41.6078761320,	-99.0036616160,	97.2413199943,	16.2571104823,	-106.6994082721,	-42.5507290539,	-30.6273488892,	
    -65.9180047092,	-61.6996048814,	57.0455325157,	103.2653865169,	116.3758447306,	-74.5041275207,	-0.1164162789,	-14.3978018054,	
    38.0218224919,	127.8971402721,	5.4463615012,	78.8192543895,	-25.6140607422,	-9.2485898035,	-48.8769533605,	34.5460968716,	
    -75.8820751325,	93.8969485430,	-38.5976860109,	7.9177115766,	-80.5122708885,	21.2658351542,	67.4252739338,	2.3783155124,	
    83.9115322121,	-75.0252790111,	37.9405478207,	14.4346316538,	-109.9157163206,	108.9078208323,	15.7162891141,	-82.1261022291,	
    -76.1782289525,	74.4747265412,	-46.6029184986,	-41.2456137340,	-80.3895294383,	-8.4118305522,	-0.1933892651,	-145.1576077775,	
    -15.4312649597,	39.2200199533,	-13.6364330998,	-25.8182203562,	48.1591475229,	125.4840761759,	15.9990051973,	76.3197750584,	
    -191.2988456723,	38.9117045838,	-115.8653769258,	81.9245653626,	-10.1602378212,	54.8635932256,	-62.0258658391,	83.1033610875,	
    -4.8490223558,	-54.6097329099,	-10.9477363598,	33.0862207616,	52.7148056029,	35.4875411655,	49.1104822038,	55.9764111036,	
    19.3458408685,	89.0606670761,	-85.0457542002,	-78.1726308870,	93.6580344148,	-26.7125037520,	15.0835782513,	45.3860435621,	
    12.4384130680,	70.5409358400,	9.8929034782,	-23.4934005067,	40.6776169075,	-65.7911681154,	-167.1217168499,	-19.4434798044,	
    12.5047333259,	-106.4886582913,	-22.0096224479,	-51.4306080664,	70.4101816964,	0.0684774882,	-76.2887185579,	75.2064469835,	
    -63.0584107912,	78.4585282303,	-20.2508456707,	-55.6679838569,	27.4321350947,	84.1834097135,	-10.3659243385,	-48.4070302399,	
    92.8062051508,	-25.5124355326,	-84.0473681678,	71.0714983360,	25.6083325312,	-45.0808082818,	-155.1967735998,	10.6420814804,	
    151.0278845436,	-44.2955308501,	29.5425559978,	-113.6663161729,	-36.5169042517,	-72.3071551232,	-26.8471044056,	15.6848246843,	
    -34.5750914935,	-198.1775254215,	25.4131251136,	-21.2604011481,	-1.0414028296,	-46.7191360308,	2.7446655943,	54.9295292750,	
    92.4228624473,	54.8526054625,	-58.0708705172,	-17.5872514429,	-107.1263606314,	3.8705217560,	8.9778481619,	-6.0018700075,	
    93.9938778953,	20.8072064757,	24.1862680085,	-36.6869801034,	80.8573435056,	5.0571862502,	4.9644714449,	47.8862765669,	
    35.1164783949,	-43.2306708209,	-70.4784884015,	-22.9691864018,	-13.9209248410,	-47.9058355842,	69.2014224885,	36.4205028832,	
    -41.7969907806,	19.3910242176,	46.8411651043,	-101.1964790621,	1.7651827600,	2.7058301870,	-23.9427647032,	-29.9388425668,	
    -85.3458953742,	-28.9877302845,	-56.3025916174,	-20.8442568667,	52.2658233674,	16.2060641337,	4.4319659648,	114.0813888914,	
    -28.7002125175,	49.5308227691,	-30.0766397744,	-61.6828255791,	-49.3247835301,	-26.4413883089,	5.0971297500,	-28.0554103014,	
    42.0857897882,	-47.9552784036,	-42.7903198462,	87.8376670399,	-140.5238322306,	101.5731331285,	52.2212327660,	-22.4010751415,	
    14.4300378085,	-51.6886150508,	6.6829221172,	115.9640673493,	0.8066647921,	79.2442610587,	-18.0322597688,	-93.1043520771,	
    -72.1150120989,	87.2886742511,	-25.4133998112,	-7.4831361426,	33.0287073819,	-23.1984191566,	-23.8078728472,	59.7504642008,	
    -0.6923320155,	-12.4892802407,	38.4436035475,	100.2867176437,	-99.6305730687,	-108.5810851604,	9.7451186318,	-43.0333845061,	
    -101.8397764566,	-50.5229450341,	-23.5177624889,	-64.5537003712,	174.8259413987,	80.6820828046,	156.0492701171,	-28.0432391315,	
    54.5458337882,	-9.7039186394,	0.3967891057,	37.2171179706,	53.0918819026,	95.5734474731,	-0.1572821866,	35.9295265728,	
    52.6110638216,	65.4681244336,	-58.8893064188,	33.3094740223,	23.7248112965,	-86.1001662411,	-124.2990486005,	-53.0143407367,	
    60.7137702328,	16.7099000008,	-16.8984625777,	92.9154007512,	19.0020902188,	-60.8943449371,	19.8803437206,	-45.4933609435,	
    -37.9759751454,	38.9546342412,	112.6564725638,	-20.6282048911,	-82.6461566213,	33.1634895891,	-14.6466202774,	70.8258934983,	
    22.7763755890,	-23.8551537513,	38.0027621248,	13.1891619540,	-0.2512849813,	-22.0294650280,	-3.6017925014,	-80.9408522816,	
    2.1581228675,	35.0316749727,	1.4313916959,	7.6662501879,	95.6789578890,	-25.3147779279,	-11.1001968711,	133.3263412000,	
    57.3919237887,	-114.5247973399,	97.7159374781,	-25.1589170064,	-28.2795559691,	-78.0626694271,	-25.2625001068,	59.6669532190,	
    -24.8854138846,	15.9627092698,	52.0951356726,	-49.4931272094,	32.2981549802,	-45.2155042278,	-117.7954359551,	71.9214384433,	
    -12.0100960200,	-85.8922139632,	44.5277402755,	45.7283733108,	153.5133743833,	-12.2908386291,	-16.7857892861,	-34.6184196532,	
    -56.8327470259,	-5.4780874150,	-38.8725168650,	4.6060525978,	20.3207039309,	-3.0993047411,	10.1132085358,	-37.8257661018,	
    -5.5665784625,	-69.5263241776,	-38.3990002707,	55.5634953442,	34.1515898646,	25.6046582443,	49.9096070185,	23.8082590350,	
    -59.5259871997,	53.0128767406,	-14.6534382681,	25.3901141454,	-20.2689398092,	112.6721308068,	-44.3928586231,	-46.9200544069,	
    -102.6597110918,	-35.1087345365,	-16.4476118027,	-56.5493022087,	-19.8752899545,	112.5790185345,	13.1594262867,	-98.3712667207,	
    84.7454129819,	-32.0001239970,	33.2615003229,	-70.2186017880,	129.5580075545,	14.3022334321,	53.5329352657,	165.1115533783,	
    42.9337492453,	3.3467665656,	5.6916538476,	30.9878624742,	43.0083773411,	83.1082949362,	-68.6733601131,	129.7158774740,	
    0.9829430504,	-73.5779156249,	-0.2190628113,	-66.4832285128,	-18.1621332482,	59.5591274811,	-47.9030207223,	-33.0134331016,	
    8.2663047608,	13.5843595697,	-124.6750162116,	-119.5553229429,	6.7914845141,	17.7380901732,	-133.7630184698,	33.7185572623,	
    -31.1975924142,	-55.1798482215,	-72.6025491416,	-65.3245960982,	-8.7224630378,	27.6488501343,	-79.6246723592,	-12.1515699989,	
    84.6626846949,	-53.8044373764,	-47.3237819756,	58.7153917563,	23.8284036126,	18.5922606945,	-41.5094930442,	7.4798082503,	
    -117.3348631592,	28.0374584580,	17.7205965437,	37.6075060837,	10.5295050958,	-10.2113391455,	-25.4289536763,	80.7158011723,	
    134.2497737713,	107.8649950212,	-8.7918461736,	-99.0628159937,	-28.4975407702,	-2.4658161692,	-1.0354059017,	3.5152634039,	
    34.3665501560,	-87.6859371958,	33.3653060530,	-45.7175591636,	-65.4175088722,	-39.9650581770,	-57.8964432706,	-74.5229831900,	
    38.4192570282,	-93.0015200930,	102.6189889638,	-15.2156059788,	8.6020521359,	-40.6649198594,	19.2140495475,	68.7122869639,	
    43.8544891050,	31.8559705108,	-56.5147934081,	-76.4182242061,	-20.7528009745,	122.9729619714,	19.3412487106,	119.2231188878,	
    -61.6916564137,	19.7466881922,	1.9628648319,	-30.1476626231,	26.0368611826,	-25.8750640673,	126.2461067518,	-38.3759348959,	
    -21.1488548859,	9.5896772329,	60.6570721102,	-27.1555851824,	-82.6629073502,	104.2859535395,	-17.1669088713,	-104.6106452933,	
    -45.0398334945,	43.2080892320,	-87.3425077484,	0.2033770682,	-25.6876572199,	79.3659499889,	29.0973624285,	-23.8554325099,	
    25.8594825320,	-65.7761031112,	-3.5831773610,	-7.5912426740,	98.1472561219,	13.1498139916,	-13.6564623410,	56.9471294530,	
    3.7663518315,	-75.6123083481,	44.5806865445,	-17.4609911479,	-55.6387091480,	44.2177387420,	34.3752520512,	91.9930112408,	
    -102.4716789145,	-40.4480770016,	-14.7542706842,	80.9321121716,	-67.9012532377,	74.2022584642,	-39.2995936367,	95.8528505885,	
    107.5716319470,	8.1259867727,	114.9534060173,	96.1080490303,	-30.6405288182,	27.3131447051,	-22.5066083621,	-7.9447818944,	
    25.6505787602,	-67.1523588791,	65.7872616460,	-3.3285011027,	-1.1041085569,	74.8921702514,	-25.1084011697,	-9.7589516985,	
    126.3993857146,	-70.7299876677,	-22.4069284847,	15.4150555050,	6.0494312782,	14.7172132463,	-36.2348351724,	-63.4858079910,	
    8.2207526905,	-101.4967633400,	12.1832438786,	49.7125534112,	-99.3127122046,	49.9528617888,	-7.3125598688,	-22.6006580462,	
    -31.8424104370,	18.8121241410,	-89.2005207726,	-89.5613310067,	37.7746014303,	-33.8940703850,	98.1050260145,	132.6754622940,	
    91.4832076657,	48.9724771421,	-52.3241324047,	73.9850811745,	-139.5294058433,	-14.1985477071,	10.6320943394,	32.9842589505,	
    -117.2355637537,	-149.0942826923,	118.8257377105,	78.6561766800,	1.8467003036,	76.7457523519,	35.0575934280,	35.0405067972,	
    46.3433191288,	51.5391456892,	43.1210412216,	21.6828221089,	-24.7058117089,	-83.9863281328,	7.1502359525,	-66.4432335170,	
    -11.8942947461,	27.6420249691,	101.5285396899,	-168.7093966612,	38.1892453170,	55.9668521894,	64.4854368465,	-32.3167099392,	
    -37.5824582463,	-25.5064561372,	107.2513163415,	9.6344685960,	-44.9269370404,	10.4288908869,	46.7640176210,	33.7300219820,	
    19.9212664361,	70.0213390428,	-62.5237740415,	-81.5465118244,	-44.0793815204,	92.2566857417,	-51.2000490212,	6.0091571611,	
    30.8037109068,	-44.7595662927,	-69.6108606342,	64.6862483343,	33.1742048387,	55.9059849044,	66.4985799238,	-48.2816133661,	
    -22.7185185172,	-114.1511261421,	147.5147842854,	9.9781895463,	8.0732325157,	-35.8047978931,	75.9079000901,	-6.3144641143,	
    13.1307658403,	17.7593379387,	-68.0746602967,	81.4962779846,	-21.2130737883,	4.1881456029,	-53.3976620104,	73.0143978370,	
    -131.1048524173,	-34.4396004841,	-48.7367342675,	97.0896245872,	-153.8743591626,	146.4347629539,	-23.2984615872,	62.8412359714,	
    12.5390587557,	-3.5600971161,	-6.8863206565,	-43.5270424219,	32.9707655033,	-103.0889331877,	-64.0535042805,	106.9215904598,	
    -46.9078727795,	-18.2192480137,	-8.6225312780,	-75.0230233110,	33.5402016456,	63.6373276750,	-35.3286634556,	-9.7322691960,	
    -104.9070709198,	-44.8063768563,	-10.2396474262,	-141.5682333490,	-41.9856066191,	-64.5568181205,	-105.7644577258,	-34.3266130311,	
    18.7442551407,	-6.1736131415,	-25.1300038952,	45.1470563965,	74.1676313724,	-21.5064254542,	70.6267797692,	54.4904113618,	
    -35.0016926163,	-36.8626539144,	-36.1085281705,	126.4456731006,	-53.4352000664,	-42.3833008015,	80.0205785607,	-5.8395042605,	
    -3.7163929006,	99.0418697430,	67.5450923850,	-71.2740732169,	-57.7639750215,	28.3495782004,	-14.9114371149,	68.2395578146,	
    19.9391412722,	0.3981730821,	-67.6429500835,	99.3355729015,	16.5267218873,	-63.2226829304,	-18.9357631878,	-2.8614372915,	
    181.1332468568,	34.7347222636,	-16.1060495743,	-2.8148621786,	-45.8170675798,	43.3943251920,	28.6117124005,	-33.2361768688,	
    -38.5248849741,	49.6677439095,	-220.2210251040,	39.4305879349,	66.5483442468,	-53.8217192052,	67.6757901350,	33.4240885070,	
    85.1809128375,	14.6803329701,	-35.7116442076,	-45.9462851452,	142.0722968061,	7.3538820438,	-74.1993826074,	-47.7693348567,	
    -3.3338017336,	41.8589920225,	-27.7802513358,	81.0798842587,	-35.2219569758,	-22.2714108513,	20.5772883573,	68.4758687172,	
    51.7089964364,	25.7997568352,	-75.1742154071,	50.1290455164,	14.2169709710,	115.3455403147,	3.0734091132,	-24.0080167664,	
    -30.0430862767,	-85.1846499745,	19.4251899965,	66.7660313085,	10.4964191964,	191.8810766140,	44.1684279713,	75.7858859863,	
    19.2241630741,	-16.1074277656,	30.9051369625,	-103.4147225746,	-9.9194221597,	-13.0669809072,	-14.3302540445,	49.1519159556,	
    -27.2523237365,	127.6868804216,	-85.5747904513,	-40.1209192492,	178.0522707351,	-73.6864713410,	-36.6342055327,	-99.8126854419,	
    -41.0696248653,	42.1245867015,	-4.3161823048,	-13.2747008746,	119.6002869940,	-17.1335931288,	62.5993425061,	28.9992320778,	
    -4.5368180858,	1.2779053761,	27.7084888678,	34.8899603537,	-30.6048794059,	-93.8465401416,	3.3778313360,	13.8864217937,	
    -62.3784185879,	27.6165516418,	6.1885364328,	-45.2772604479,	-56.8928574665,	-7.8629078173,	47.5072063672,	-47.7279779449,	
    116.3659358841,	-108.7063603401,	6.8435296791,	-4.2310899521,	-48.8520623760,	-42.6788172675,	28.7598264712,	-45.5725981159,	
    5.3364646966,	-8.8259790870,	53.5478850699,	-93.0251963014,	37.5833785601,	-5.7207089841,	-36.3899380994,	21.9593949993,	
    27.8919793663,	50.0242670536,	38.7060750441,	13.4383538753,	24.3284938604,	-66.6706972814,	-75.0556788531,	46.8080800007,	
    -76.7685518979,	-110.1823907916,	117.3556114385,	-11.8794346783,	-100.5931552045,	-81.1814329321,	-11.1946927034,	65.9117165560,	
    -35.0871947675,	68.9890931402,	-10.8170265109,	-76.6397320929,	40.0628004769,	-13.8876229441,	-47.6413458333,	-82.9301597006,	
    35.3601089866,	-27.9439892787,	93.1557477015,	-43.0973522277,	-28.5635146727,	-12.8419650369,	-19.2552737753,	-104.4730738934,	
    51.2133027222,	-80.4713372457,	82.8904666296,	-32.8693411980,	-55.1514350588,	-32.3215790447,	15.3586714150,	56.6281953096,	
    -4.1845768663,	-21.6039139687,	37.2300232632,	41.1966104813,	-18.1197213904,	-43.3281929812,	-39.4358705806,	-68.0037577582,	
    102.7052778200,	1.1074295163,	148.3224324741,	-139.1640107475,	-33.1782275394,	-49.4813361135,	33.6935341991,	57.7540768190,	
    -50.1484966873,	25.5452659987,	-58.4535765464,	-124.3028152080,	46.5749355946,	88.3984919306,	18.6343901041,	27.7237147347,	
    7.4621558601,	-45.2696342528,	6.2181991419,	-124.4793150492,	-34.3600196858,	-17.2893599431,	10.3880081085,	-34.6584762030,	
    80.4621681009,	42.6698890316,	41.0028635312,	40.4584805162,	12.2993857558,	-2.3438124814,	-49.4434262439,	67.7382058590,	
    -172.5728037457,	78.5681808033,	93.0200717559,	-34.3893038739,	25.4332764674,	-0.3084790746,	-47.0942986345,	67.8054627172,	
    122.2738316110,	-84.4716788862,	-15.1596922578,	73.4104827953,	-26.5231401219,	53.5433793756,	121.1802722337,	-24.9087077008,	
    65.6955157778,	-100.0325133938,	-5.4645525511,	38.8338919462,	38.6764256003,	7.4857563167,	-84.0517801108,	-38.0837770598,	
    -35.8795970303,	42.8800471728,	166.4026567891,	-45.2596493921,	88.1539836076,	-84.1569136898,	-44.8705239205,	-112.3135915515,	
    76.9816499152,	53.5768624176,	-106.3408650991,	-17.9979586956,	81.7718580719,	144.1648782825,	45.2239065385,	-50.2094826104,	
    -14.6605194110,	57.1970152560,	-23.4826391767,	-27.1562674435,	110.9001894435,	20.1915788307,	12.1467090660,	16.7983072789,	
    -34.1257273005,	129.1575417206,	71.4391384766,	32.9596044485,	-41.1052127849,	-48.0458686558,	0.8731114023,	-34.4439480200,	
    29.9076993320,	68.5240097999,	78.8047480081,	10.3252970915,	0.3515809390,	73.8823954039,	44.2008862678,	72.6737200450,	
    -13.3069689810,	-25.8971947295,	16.9120909673,	53.2843809510,	49.1074875555,	-68.1235965933,	13.6903318056,	-14.7046510890,	
    1.6746416299,	-108.5007545621,	-83.0295464360,	-3.7524687555,	-14.4088682542,	-138.1935697707,	-19.3679003715,	38.9142288940,	
    15.4764570005,	-2.9192486908,	43.9598275111,	-34.5312517096,	35.8385011650,	4.4981476232,	-1.4454488029,	71.1184852411,	
    41.7476890934,	37.3368072067,	57.4916368307,	-32.2735282446,	-27.5080391474,	95.6899861001,	3.3351685514,	-111.9822940053,	
    -12.5463248694,	39.8668835259,	-14.9822708781,	66.9305141224,	-197.7731587893,	27.4387742251,	-25.6710982597,	13.5207634746,	
    50.2848552534,	-30.0418256053,	-14.1615451430,	68.0658302876,	-62.0642327357,	4.6615575342,	-26.7572433532,	11.5079596851,	
    -57.9473530742,	-26.1405191819,	70.4111692091,	-95.7407842078,	11.2517762488,	100.2275069926,	85.3653529140,	-24.6494053691,	
    123.2413542720,	21.3040690490,	-192.3747625981,	215.7057282840,	-29.9835524152,	-44.6302014167,	-66.7559203920,	25.3479943282,	
    126.6443711753,	-36.7355336011,	29.0095532019,	-73.2298015066,	-5.8223869363,	11.9451128557,	-17.3486371102,	50.0400958000,	
    74.7145985867,	-5.6976135921,	-73.1829497279,	-41.0455578170,	-3.6001825808,	87.1662509692,	-39.1602156793,	-41.5727119025,	
    -18.2071856447,	-3.5383471563,	28.3732842092,	-39.9931298054,	-100.6902365532,	130.2869328357,	3.2473773399,	16.8387727072,	
    62.0055283576,	97.3165730637,	-40.8530624130,	-12.0491532592,	88.5164060609,	71.9344891420,	-69.7440181255,	-51.2866033193,	
    -18.4687017548,	55.7346964760,	4.4872782938,	-6.8942183136,	8.4263132246,	18.9149616636,	58.8710265459,	-17.7415034047,	
    5.2927869482,	-20.1947447871,	-36.6005304743,	-67.2193634013,	-72.8315856033,	139.7216799221,	-2.1966369437,	83.5189402317,	
    56.0625496338,	57.0100118287,	-9.0542670182,	58.3126231383,	-27.9316577822,	-125.8146267036,	77.1179593561,	99.1690581411,	
    7.9703321651,	77.3501770612,	32.2815633360,	-22.9643212257,	-19.8653554993,	55.4837678464,	10.8929872542,	-1.2452363726,	
    83.8477026208,	-88.9116003335,	-44.6537617432,	11.0099195187,	-33.7736999447,	44.2766753802,	-27.9436876110,	16.3088473703,	
    45.6564921145,	18.9199921114,	77.9125802822,	11.2795611793,	42.8571148149,	32.4846418196,	-2.4014655924,	38.0598657284,	
    86.5222537258,	-3.1333316838,	11.9141807475,	-2.4712869557,	47.8938116812,	35.4899843246,	42.7527497689,	-31.3225362175,	
    -6.6842304948,	-133.5691427053,	-58.7043550030,	73.3503470631,	-21.8739658759,	70.3809855428,	54.6113598087,	9.7384709498,	
    -141.2343505501,	27.9788413890,	-11.7574685128,	43.1029141674,	-52.0045609619,	-83.4803133516,	-57.2548505744,	52.8114424452,	
    -30.3458066567,	39.2081027670,	-49.8609769923,	68.8871987820,	45.2005862545,	21.6377482234,	-9.7576398020,	6.4878505019,	
    32.1853134925,	-25.1448500950,	-67.2234044003,	103.2446765175,	80.2584971166,	-68.8710032588,	-4.2141933840,	23.7223935599,	
    -35.1939439880,	63.5237841071,	-34.7833780059,	74.4175406287,	83.0373073374,	-28.9674699605,	-55.2233708526,	64.2239365944,	
    6.0025041292,	-22.2149197781,	29.1954442931,	-35.5058495139,	-76.9452133862,	34.6912996871,	-51.1833830895,	-49.5201882461,	
    -7.6144484864,	116.8549382108,	-51.5005710672,	-20.6783396225,	-97.1232859994,	-6.8466290384,	59.0410141864,	-58.4613374526,	
    74.8248237895,	75.2714612487,	23.1797286361,	-2.7866665487,	56.4240759131,	60.2417537402,	-73.0762506733,	-136.8520754748,	
    27.3836498800,	-29.4294016791,	58.2863141991,	-15.7937240880,	12.9792729458,	-28.5369095369,	-179.3559659693,	-99.4879434608,	
    -61.2402838269,	-24.4763496292,	-22.6643525306,	24.4590321501,	98.4299041736,	-4.5624798871,	-59.3191765161,	139.6951240672,	
    27.1672202072,	-70.9192843433,	-18.1408458038,	-71.0174628677,	-94.0725395768,	36.1985844031,	-3.4636448040,	-39.1453082944,	
    40.5244522827,	-70.0489070024,	-63.9181488122,	-4.7099187837,	-33.0844286599,	31.8161456785,	10.7843286816,	10.6387816259,	
    -76.2043252282,	57.0254136124,	151.4166547223,	-50.6728456416,	-82.4408455004,	-55.4932097322,	15.9101565878,	15.2777050730,	
    25.0235583008,	44.4425994137,	36.1343164402,	-24.3058262644,	17.6630395266,	-62.6364549232,	-40.1045046999,	-3.8451609954,	
    -107.1141779059,	-50.7347331775,	90.5704587068,	-59.5674315899,	-23.9371281478,	-59.3738147851,	-29.5056040676,	26.2990433281,	
    -33.2953407976,	-92.2663237623,	-25.5442696217,	-81.4532880743,	42.7268859073,	75.7986045911,	-31.6772573595,	86.8684653590,	
    -61.5786934151,	32.6176822340,	-23.2321244436,	64.9301578846,	-6.9691761031,	-51.6553861957,	-35.7877314260,	-41.7444743167,	
    108.3757802905,	-29.4164640263,	-18.4714648512,	-82.4131988957,	-52.9499171074,	-35.7687451877,	-80.5212521683,	40.1558185933,	
    80.9139882507,	0.4170638335,	-52.4487435334,	-69.0227900586,	55.0806458770,	120.0318572894,	-11.5435935376,	-19.2791170530,	
    -3.0257623065,	99.3958103659,	-19.4539047939,	-54.6600691116,	0.3603986276,	9.7863628822,	-6.2358897021,	-17.1143829423,	
    7.9650683489,	-27.0465697723,	-45.9436029022,	-36.3352947671,	138.6511673472,	47.8115852675,	-10.9612291181,	3.6500932948,	
    -19.3477824988,	28.7386285394,	36.0065971791,	-43.0822654618,	-43.9342369010,	-32.1210042559,	-70.4441432492,	-94.9421856551,	
    -120.0449164046,	-65.9803176675,	-55.4329926958,	-19.2914305328,	-89.4078846739,	-30.1962221428,	61.2293835442,	93.7229961578,	
    -8.3020564344,	-6.8386266801,	21.4975406760,	-15.0903918291,	94.1044891682,	-57.6380884034,	16.2327931770,	1.7957525957,	
    74.7073719610,	26.8908104028,	76.5155513347,	-9.6822139478,	-8.0655893270,	-48.1277441855,	9.8408952157,	-58.8121626519,	
    -80.9751650730,	-48.3302191201,	-27.8207839032,	-46.1625778067,	-33.5567739103,	-109.4477338693,	-168.5366005131,	156.7874587017,	
    8.5940307118,	-21.7826451231,	12.4113841726,	86.7850811554,	-77.1019195511,	32.3109085681,	86.8849726762,	-41.2571797820,	
    19.6006773321,	31.2507123002,	41.8106047980,	101.5445768198,	51.5335715773,	-185.1354355374,	-11.0825031251,	-20.9631685642,	
    111.1640505949,	162.0618916128,	3.4498453592,	44.3198102843,	0.3505982148,	21.3783009799,	24.6853218910,	-20.3399016930,	
    59.5923416012,	79.4334110932,	-78.7723219668,	-47.0670061218,	-128.3114982420,	92.4340029556,	69.1584534808,	114.9437583487,	
    -64.6124706594,	-10.2486262273,	-1.6622261589,	50.9747480555,	-8.1203432808,	32.4414442459,	84.9091411511,	-17.9846748341,	
    -14.7172591486,	-27.4203006303,	167.1594042893,	-25.3372000386,	-27.9888042652,	-3.6956600039,	117.9111608126,	-25.4132038904,	
    -42.2923300579,	-95.1602974120,	19.2625367900,	-15.8766055664,	-8.8117613783,	1.1964763941,	-111.4791843369,	81.5745053342,	
    8.7527287102,	34.5972180603,	83.9461794412,	50.2350993915,	-19.7720255327,	53.8516694944,	-104.4119088056,	30.4513918056,	
    -62.7649123620,	-29.9513577664,	7.5719075796,	61.4944149393,	70.5737863978,	-40.0358428522,	-17.3629194898,	-10.7304848224,	
    -60.1358805635,	46.5402792333,	-77.1330673251,	-86.7606311649,	22.2000151841,	-33.7006112473,	-139.9917432329,	138.1567785372,	
    18.7396823616,	28.7669927272,	28.4680008506,	7.6199316893,	121.9175024680,	32.1111318802,	-58.2808504609,	-30.6563801124,	
    44.2365370915,	-83.4728239003,	64.0531120026,	128.0019381122,	-40.3205961091,	-62.8035436979,	-15.6689887241,	-6.6975189783,	
    -46.1591606362,	-42.4253060115,	-71.6473279718,	-75.5337463898,	87.5058573621,	-66.6145644703,	87.4635891068,	123.2852237793,	
    -0.9887550633,	-9.6307226422,	-67.4478350330,	-86.5892204275,	-79.0537798176,	-107.7863332665,	-8.8330234138,	38.9605563706,	
    15.3133829507,	-54.4231514572,	26.7406100788,	48.7962706395,	27.1443310148,	-2.7894277223,	7.1469114703,	-57.1657209995,	
    -90.4215183139,	76.7797176290,	-19.2239853483,	-26.6041739391,	139.0298606143,	-36.8837362822,	-57.7952841108,	-135.9897057237,	
    4.3453829113,	-5.1660378716,	-58.7046205842,	58.4176557979,	-120.5866252228,	34.2409281832,	105.6219016158,	-28.5323871865,	
    11.0598518159,	-26.3069115094,	87.6681723683,	70.9393661419,	54.7982850455,	4.0477327154,	-89.5568838538,	-32.8993562613,	
    -45.6708773935,	-52.9428269719,	14.4126898406,	39.2142079784,	-92.9447367684,	-23.6977408094,	8.2507547267,	77.1071852874,	
    24.1675316234,	-159.7349628761,	-13.9551749672,	-67.9761692092,	-30.0410317845,	-24.6060572570,	52.6662467162,	53.1957816963,	
    16.7992222346,	51.7621999618,	-9.2959681635,	-22.0395789118,	63.9887836127,	-15.4794522124,	-59.9041019732,	0.5489176194,	
    78.6395685166,	134.5366929272,	-6.8712023878,	-25.4182816023,	-94.3014920612,	-120.7349462621,	15.0267811895,	64.1156824538,	
    72.0730568718,	36.1969392849,	37.8409183719,	23.2904067106,	-65.2310984397,	-174.2644489990,	-19.2228520790,	27.4717232382,	
    -59.1645079992,	-37.9473607579,	49.8799507321,	-79.0510884528,	-28.3803465367,	20.3721781567,	-0.4261835910,	-35.8489167205,	
    105.4583901558,	59.5722685004,	-61.0197468314,	31.9348090719,	-71.9443219028,	58.1935525762,	24.2368907755,	11.3281193558,	
    73.7442066031,	-58.2463274873,	62.2364089748,	-22.1662416753,	80.8054311590,	1.1123457543,	65.0742762981,	34.9247990206,	
    104.0897515469,	-17.1726872127,	-55.1967923359,	-17.3070263921,	-113.2466807440,	-34.0273063199,	6.0065175641,	-73.2050951521,	
    -46.9298900117,	42.5522795079,	89.6038769626,	-13.3758161339,	20.0379230047,	44.3053936382,	38.7871513797,	-96.5643124661,	
    -164.2750976118,	-37.6742328774,	-20.7444978754,	-57.5075374112,	-82.3747950875,	-148.0525559565,	23.1385046849,	6.3810748790,	
    26.2079771260,	-76.0359611120,	49.8590173195,	-55.6975098542,	63.1577456002,	131.5982420723,	46.7778921481,	-60.9806982634,	
    71.7495044841,	4.3127212188,	-17.6552774593,	-32.8038637189,	-77.8751385740,	-38.0621029989,	-10.6340276560,	16.6596173712,	
    -67.3032141305,	-8.7994716202,	50.9412272541,	49.9717453353,	-43.5703597564,	-49.6853674924,	-95.7205166501,	40.8765465419,	
    14.2287448407,	-27.0614166095,	38.0714114583,	-35.8412172130,	-78.5197707657,	-25.6825367235,	-0.3120778923,	-13.1591053910,	
    -13.3423425539,	-88.8689993653,	-141.9490353220,	15.3348435554,	-1.2351271212,	-12.5689032236,	63.2692606259,	92.6940600989,	
    30.9761753348,	-14.6354581107,	50.0664499041,	22.2230304376,	-128.4011635209,	26.1869851104,	8.3304256738,	-46.1344839419,	
    68.3461812478,	143.4759863425,	163.6742650341,	55.1856555010,	-60.1365810845,	74.3895957960,	40.2227984754,	-11.7394255168,	
    55.5453683738,	15.9202002202,	-113.1213822368,	-85.7280046039,	-39.7263088573,	-2.5339105246,	41.0492866970,	45.3079876954,	
    -99.6701239491,	-29.6980232319,	18.5340063985,	51.1922973890,	-79.7372970167,	-13.2393250851,	14.7419728226,	-4.8211133780,	
    -35.5172595564,	99.3966537203,	20.0590181900,	-12.1081446475,	-61.9594867060,	-72.2256752476,	-13.2936631274,	128.5345002108,	
    -71.9401693778,	31.6533870911,	50.8594991278,	25.1808453324,	-33.5538293275,	-42.3935228996,	-20.8053274690,	16.2131527996,	
    118.9172555234,	89.5930952748,	-65.8274795934,	47.3384633282,	122.5406901256,	-66.7549348343,	-54.9185037426,	-68.6601805746,	
    34.4675543582,	104.9323617738,	-57.0880010038,	-43.1248502597,	-2.0601370211,	44.1682882967,	-89.1023577428,	-35.5506312941,	
    -10.5170036504,	9.6779403375,	78.9291026934,	-31.5855420521,	92.7949646880,	31.3559964123,	12.3617000392,	69.2326522660,	
    3.9119449943,	-36.5330788106,	-44.5936841393,	45.7052258609,	10.6224387668,	-24.1159570162,	-21.0651270325,	-84.0415379963,	
    -130.5857682422,	13.6064059568,	-33.6699927959,	-26.0082360265,	29.6219265142,	-47.8318612795,	19.0742065634,	-52.3410098996,	
    32.2488186667,	8.7112925773,	68.7336792115,	23.7944448682,	99.9050365463,	8.6093548114,	59.7174217811,	23.0796589837,	
    -113.0722961466,	3.5971633707,	-6.7890993972,	30.6764504710,	-41.1295367209,	-24.9164165484,	99.2386401122,	113.8333026527,	
    -38.9562599796,	-55.4108562109,	-94.4601804558,	-31.7511549793,	200.3462283262,	12.7517487160,	-42.3353937717,	-51.1991446233,	
    78.8520856510,	20.4131030912,	21.8102532347,	-51.7944815361,	-21.2191019005,	33.8300001131,	135.8377663961,	-31.0221091170,	
    65.7730407411,	82.5117419278,	27.7816244812,	-10.6724454248,	26.6179164033,	64.9214169340,	44.6475686302,	-29.0683019634,	
    2.0965746914,	-10.0085359932,	-29.9021362947,	-38.5046703557,	-23.5486473509,	-44.4560504617,	7.4417079380,	47.2393973843,	
    37.7344798725,	-13.6323296763,	-28.2713540400,	-12.2494841889,	-113.6616109440,	-4.4061813255,	-84.4155850685,	18.2000114801,	
    -37.4375420019,	-15.0025190330,	33.1826857536,	-7.7672966949,	-41.8570537108,	-61.9447815201,	-20.5430470077,	42.1225812423,	
    -4.9372231166,	80.1718433860,	-21.7502429381,	-107.1994683407,	39.0450370860,	-13.9605768571,	57.8271065756,	100.7288025395,	
    106.0257089013,	-94.5099462535,	-52.2425831475,	3.4251117300,	37.1163293092,	20.3088713026,	27.9957748777,	55.5881357120,	
    -49.9425573612,	-74.3122437274,	-45.4384442770,	28.0519415044,	-57.3995353506,	-34.0343398092,	39.4842857378,	-29.4934441942,	
    -42.2931922612,	75.5085698437,	-9.1579964746,	-88.0001960638,	32.2921191297,	130.2295801645,	-77.3690707106,	-26.5699179687,	
    -98.7746128367,	15.1111986863,	84.2856839075,	-91.3321816766,	75.0539365102,	-22.9577135979,	-58.2687890669,	-16.4158023440,	
    -143.1190919220,	45.6864012367,	-148.7549620241,	-87.1075640764,	-26.5968533502,	-69.7944158144,	-34.2978456494,	35.0769663698,	
    4.1465107386,	69.0864439105,	22.4789950234,	-48.0182401768,	-14.5783104039,	-61.0550243844,	-4.2380948973,	-194.8804104528,	
    123.0819765947,	48.2017401505,	78.9508457466,	-99.9736614294,	32.8340209984,	-1.0245301508,	-17.0041736706,	35.4641249127,	
    -33.3575407148,	192.9072183682,	-42.9604868802,	-51.0374996711,	77.1464797096,	66.0548981845,	-61.4282764621,	-114.3126571027,	
    21.1118181552,	85.5335633765,	27.8488718530,	-62.6421354515,	-57.3557048619,	41.6670106942,	16.8928119140,	-40.2432649132,	
    0.6390713008,	-10.1237727904,	52.7534146685,	2.9801643945,	-11.3804175086,	119.2039503951,	46.6809821778,	84.8768259311,	
    29.9865105951,	57.8288066379,	107.2625212828,	28.1456885969,	-120.3755566725,	-17.3802551503,	-40.0564653651,	56.8407045846,	
    1.6793816918,	-109.5072716396,	-52.8897837730,	85.9453300669,	-20.0298903469,	52.5871200627,	13.0362762617,	92.2325099999,	
    -6.5198193020,	-83.9036654607,	58.5211535567,	81.1131330707,	57.7324249784,	126.0368845782,	-79.8586002513,	-127.7584493863,	
    64.8736188900,	-10.6521288269,	-0.9851623286,	-92.3945133485,	7.5244215841,	40.5886593287,	18.6445609457,	19.1117310556,	
    26.5640714899,	22.8091685027,	94.3470412324,	61.6764800801,	10.8760679684,	-7.9240673383,	12.5919458396,	85.0254983280,	
    -15.7186492832,	30.3331627482,	-136.2555384486,	14.2342767573,	-52.2232864172,	-49.0105238845,	16.4028777072,	13.1934114315,	
    67.2005286948,	-11.5431941527,	-126.8761059118,	28.4325197274,	-5.2730565073,	-154.2913406142,	83.8362133106,	-13.0557850235,	
    -24.0425722731,	-9.3049739156,	-91.4408491189,	38.7967852392,	-54.4364475655,	-50.1728478153,	-91.7628978624,	-92.4046791871,	
    72.6594194204,	36.9149973552,	-89.5520370642,	-73.4541912166,	-83.1026853287,	55.8083893384,	-11.3360468605,	8.0892870502,	
    21.3963536134,	-27.2804196146,	-86.1680209134,	11.1581691823,	-68.2490961721,	63.5960852067,	-40.1782672381,	-50.7929323122,	
    2.4820154810,	35.6921504427,	-75.6795637705,	8.6054661804,	-31.1168448045,	109.0955889455,	-76.2488069978,	5.0199927782,	
    37.8749455521,	5.6982241556,	27.3294929004,	-120.2473221866,	7.8826650171,	111.0369524326,	-43.8497436507,	-66.7312430666,	
    97.7440071817,	49.1570048378,	-117.8025876335,	168.0477524482,	-55.9600221068,	11.1068434425,	14.0513599858,	-47.4087780504,	
    100.4504374216,	6.1074714956,	53.7678384486,	24.4635321166,	-6.0835375669,	-64.3592936645,	-25.7780083698,	-83.3530662624,	
    -124.9544432106,	37.5615380015,	-19.2986773913,	-110.0015552689,	121.7589202263,	4.3256928319,	-101.6571157133,	85.6785418597,	
    16.0474362836,	-31.9024530060,	-52.6323741801,	-3.4440544641,	77.7351607744,	-10.1741553840,	48.3997106271,	1.5020725442,	
    -0.2257709330,	68.9623795901,	9.4286729097,	-27.6379770488,	-3.9912724152,	44.9954087833,	-18.7057514605,	-14.7638693232,	
    -1.7397189655,	68.2217569488,	63.3439223434,	38.9512814941,	-25.6642624084,	54.1881119719,	-92.4999870174,	-11.5788876807,	
    69.0279357511,	55.8205676574,	-101.8852049100,	30.7429453237,	-58.7382928803,	89.3969596003,	-44.8903243228,	2.0422419096,	
    41.1330103123,	-88.6692130110,	25.4298182542,	0.8899898304,	-53.5428328048,	-11.5755725623,	-28.6132997670,	-13.0337245663,	
    52.8092078154,	0.0517964686,	-138.4959804685,	31.6788581756,	-16.6154597478,	156.3340569922,	93.3010192905,	32.6407669098,	
    112.1297440517,	-35.7144834638,	6.5534121327,	128.2382195529,	56.9609192462,	-52.8328776011,	-65.7950928061,	-13.3541979410,	
    34.2814367341,	26.0764152312,	52.6477198183,	-121.6672795964,	53.8959085384,	-64.8464505733,	-6.6989481273,	-164.9991018529,	
    -12.9977296783,	92.2198340788,	-58.9488062177,	-17.3136354080,	-15.0065268104,	82.2346850297,	-52.0081326057,	-31.8754548129,	
    -36.3987954967,	53.0154983421,	27.4015508471,	32.8268124997,	113.6916804444,	27.8095494681,	-55.1665416696,	-16.4156645469,	
    -42.1439424759,	38.5634363918,	-64.9312441199,	8.3884871895,	32.9516167667,	-0.9395063314,	58.4852381959,	101.7397916741,	
    -104.2729685077,	-14.9331020781,	64.4379817410,	-5.6149495442,	-69.4590669042,	128.5957740501,	61.9917796337,	0.5819416032,	
    -69.7790071374,	-1.0381159167,	20.1469541660,	13.3351412916,	-104.5227876095,	77.5294242919,	38.0641940199,	-56.7585742367,	
    -9.1765854459,	40.3713276531,	72.6358559436,	-14.4449566608,	40.7675499413,	-93.5568526062,	55.8238199978,	-57.5895140577,	
    -82.1737195067,	14.7561780278,	-155.1331660454,	-3.4741158421,	-90.9790829737,	-67.6576031648,	58.4505812875,	-127.2647404391,	
    -52.6551154593,	21.5600272148,	77.4232312163,	-100.1093952602,	50.2042564606,	11.9885332900,	34.2641380301,	-51.6644779651,	
    -14.4960161445,	67.8496081597,	25.8195812544,	-38.8690931971,	-116.1556251224,	-68.6610388123,	64.4060064748,	-4.5039590319,	
    45.4866635009,	60.6472857766,	121.0539185194,	4.8340889914,	-37.3668396220,	-52.4747123096,	7.6362446201,	-39.8862759852,	
    8.0139163506,	-19.7768070929,	55.9705429761,	-77.6639159836,	-9.0747973730,	87.1299271010,	-56.0307413158,	22.0261066362,	
    -21.4877846313,	73.7508019333,	90.2727567859,	-31.8064851485,	35.5698971534,	-123.1337229178,	-115.6888113061,	40.8859379019,	
    -45.9826093754,	-55.6481101801,	-131.3553753176,	30.0527360996,	21.6632646479,	98.0105924807,	-39.4117175619,	-101.5958309784,	
    2.4560883180,	47.0714688572,	-30.5516644873,	-123.2193558202,	-81.2276105808,	-35.2333787774,	131.7553150138,	74.1337100485,	
    -111.0162621392,	-50.1520236082,	-176.7180780270,	43.6099370000,	-99.0730647751,	100.6783161314,	1.5420581129,	2.5889162904,	
    97.2407277690,	5.5204254866,	72.0939017458,	-100.0077732933,	30.1572971400,	19.1994437619,	-83.8095901131,	-67.5983524523,	
    75.2270686194,	80.9252084407,	42.4611462166,	-75.6376932185,	-7.5820680566,	-47.2137370820,	13.3547714942,	-49.2227272764,	
    -101.2311839023,	-89.9953284490,	-59.5627585772,	3.5045401284,	87.8927289585,	-45.7826497344,	10.7894222301,	-34.2218214372,	
    19.0101005894,	-79.7412295513,	-40.7129535835,	34.9745871635,	98.5275860299,	-16.5088968676,	66.3460699225,	-133.5365249144,	
    -41.4407293928,	-15.3419046733,	88.7195803357,	5.1871004832,	-98.0467809656,	-14.1239743026,	-1.3510821103,	-38.6189020004,	
    114.8822422747,	65.5094003215,	88.0532368083,	-59.2540330178,	92.9429540023,	21.9133947331,	-50.7728654894,	-36.7011682133,	
    -16.9217654808,	-110.7749962658,	16.6126865137,	116.3641432033,	51.7192473353,	9.8619033750,	57.3047648863,	-21.0275512361,	
    66.8618463429,	68.4016463402,	13.1978892272,	36.9294559769,	79.3415169994,	-74.4235076906,	-105.9928928366,	3.5485737877,	
    35.3701917014,	11.0155135724,	-42.5279468110,	57.9138782373,	32.4492657117,	-2.5260836533,	8.2835364235,	-45.2229140182,	
    29.4655763679,	20.5830184405,	-92.7731928028,	-88.2155574314,	-13.0181590718,	-67.4752432987,	12.2964799268,	-134.7795554776,	
    132.5177768161,	86.4796490878,	-170.6768976365,	-53.7059277336,	23.6295211743,	100.0865623366,	134.6726479190,	-17.6813528616,	
    -67.3925719582,	-12.1986138778,	-58.6920640259,	-46.1769630250,	14.0012237071,	105.2386807000,	47.5923010830,	-13.0446195549,	
    21.4905427079,	89.4924853541,	-1.6294776664,	7.0507819885,	88.9962812504,	-14.3836298512,	-14.5755536250,	-158.3719830729,	
    -71.0421641105,	9.1510759791,	3.8541666430,	46.8853635172,	-115.4505016964,	112.1915084832,	60.0579773251,	-19.3568210670,	
    134.6457467896,	-127.7704101409,	96.1687814173,	139.4223376055,	-16.4889074247,	8.7407981479,	-31.8653460842,	-86.1989364296,	
    6.3138143769,	29.9691806857,	10.0215115097,	21.7539979367,	-10.0119096873,	-32.7662562735,	-46.7114278488,	-32.0468371287,	
    -104.9863919627,	164.6868132811,	14.2837511902,	103.8122395985,	-38.3195610630,	-66.2071289114,	-42.7348265210,	8.1247796770,	
    -44.7642634909,	-99.5977533202,	-62.5669299697,	-154.4713244845,	-54.2004565831,	-21.0505396466,	-7.2304668445,	-63.1457522254,	
    121.1292664630,	-41.2451342849,	-100.3661302819,	-79.7893865863,	2.9782522632,	28.1233518579,	-45.4712133921,	102.1080223649,	
    64.1668281113,	-103.7410276784,	106.7427715753,	79.6231477604,	20.5960195618,	42.6351844699,	-8.0432553021,	-20.9274320455,	
    44.7322739383,	-58.6239231825,	21.5430765926,	-32.7159508398,	56.5825012360,	-99.4275633192,	-102.9101109727,	-83.9315736318,	
    25.8630456141,	-52.7504372152,	29.5673565938,	48.9111232224,	41.5578130085,	-14.3606917295,	-2.2040972437,	94.4661907548,	
    132.7457583187,	55.3945646514,	-16.7731026022,	-46.5710214158,	-29.3542289267,	-14.2923094674,	23.0425873685,	-15.5814746488,	
    22.3570974017,	-42.0180359242,	-20.3430155274,	-68.6338886669,	-64.8088612108,	-24.2988048174,	-23.5299375491,	98.0364255786,	
    3.9778504115,	65.6849914578,	-1.5168129555,	-4.8287346639,	142.1453945317,	78.2378704371,	-57.3720730586,	-19.4585389336,	
    76.2735042603,	-43.9459949675,	6.9426433355,	-43.1451402122,	-18.0751403348,	-34.1054109171,	55.1204864738,	115.4516445351,	
    6.5333541873,	62.4906581904,	29.9692177776,	-33.2287635647,	-18.9268908378,	-63.0926292852,	-111.6323734820,	-10.8864814281,	
    14.4649132510,	-25.6871888082,	-33.4308400890,	23.9756688469,	52.4567038054,	12.8701945894,	-20.5116135858,	-17.4241576687,	
    -11.8606594870,	16.8816614097,	-18.7270784248,	-6.2425768906,	48.5175154819,	1.7426978337,	-99.3023967479,	38.5650914417,	
    -61.0127172140,	42.7784858845,	-7.2257854969,	2.2847466905,	-99.0066793854,	60.4060120207,	48.8064141188,	-72.4258965295,	
    -50.7390478551,	95.1299230407,	56.4763356354,	35.4471698843,	60.4632441624,	-95.6600449901,	55.9445226564,	-28.1942324306,	
    26.9826142327,	-71.4404566440,	15.9270065277,	-86.7110877229,	-80.6677402549,	0.5529947734,	-39.4989884635,	35.7914768080,	
    -22.6398243670,	-33.2598314085,	-25.7467291233,	16.6863716736,	80.3468995127,	-22.5068845945,	23.6096621616,	-99.4288845571,	
    29.0662266127,	3.1265642936,	133.4725188269,	10.5889496669,	78.4289320034,	46.4143031925,	97.1026760967,	-60.1768585008,	
    75.4045199491,	14.1399143092,	-87.6608741602,	96.8571208381,	36.1952990642,	119.9462706822,	51.7941617293,	-10.8814477399,	
    66.0010885597,	68.6769630212,	70.6032262575,	-78.6614013388,	-52.6711668148,	29.9772317807,	-67.0938602216,	-42.3207515671,	
    -0.0486165038,	-15.4758823937,	56.6129710458,	-54.2575866392,	111.9253009797,	-47.5236184222,	-95.6434531533,	24.9411667600,	
    35.5636297407,	-11.3487509511,	99.6377899302,	16.0125061627,	-35.8881400079,	111.1220549938,	-2.9395719970,	-41.6388550114,	
    -33.4638181727,	109.8808145106,	28.1021441950,	118.2701610217,	51.8151816796,	-19.5803207598,	-89.9262515893,	-26.6044307189,	
    40.7320823989,	-19.2602062235,	62.2560193625,	85.9346547334,	49.7871555519,	-20.0313162309,	-8.1831982988,	69.5820284092,	
    49.2993116756,	34.9185452172,	74.7523126024,	145.1939754190,	7.4232669832,	-4.5344572697,	34.0472547752,	41.4294110612,	
    -123.0758971920,	-43.7705297332,	121.2820069260,	0.5435048718,	77.7764299214,	59.6928983371,	-27.6522675298,	-7.1273383508,	
    26.7210269180,	4.4630452796,	-81.8607570684,	-26.3402136551,	-95.7197230242,	-7.3219091557,	-82.4289458596,	77.4381232638,	
    65.4006110025,	36.5844708644,	66.3796224839,	-11.0118557858,	61.4481921771,	8.0694380153,	59.4652425227,	-24.3765004167,	
    4.9649042432,	-28.5624154309,	-78.5623599502,	17.8514494843,	-20.9756518143,	-10.1916814040,	11.5732283207,	57.9552418906,	
    -45.7612949110,	-20.9482951666,	36.8160063004,	-45.0567155877,	63.7098701462,	6.5938197429,	46.9692949757,	-83.3299455774,	
    -88.7653437148,	118.8655843800,	93.1921951705,	-18.1354337452,	-40.1074391033,	44.0852297241,	-41.1588703642,	-105.1428083912,	
    -7.1420535313,	66.5491789931,	28.7643638361,	-71.3690563573,	50.9039393300,	93.8257368698,	22.3478174946,	-109.6001863096,	
    64.0649017243,	-29.4574274496,	-44.5473845748,	-132.8280128599,	-52.8587533053,	80.0084510351,	21.4678106815,	48.4383573310,	
    56.6158184924,	-72.0365616804,	12.9911383411,	162.8295288963,	55.8780535954,	73.1821757559,	-100.6826313435,	23.4262138290,	
    -0.5753332881,	-21.5175209047,	-138.1106268547,	-80.7925993001,	-28.1663114958,	0.9831816192,	30.7923417673,	-51.9827613979,	
    -10.8794388756,	54.1022652480,	11.1686073161,	-44.0592484786,	21.6987012718,	-42.2412255611,	-3.4936004646,	-51.6421714543,	
    15.8711886614,	-40.0043968804,	-6.1590232957,	-65.9457642489,	59.0569838977,	7.4295907490,	-12.6833895574,	-72.2928299923,	
    -199.7835511043,	-71.1580901042,	-12.8895530614,	13.8448156167,	27.4808788351,	-46.2542221592,	-3.5153348434,	-176.2019445127,	
    -48.6783165219,	70.2296726615,	111.7340160335,	-60.7655899218,	-138.1081385724,	-35.3974788626,	-65.7355628000,	57.9555341829,	
    13.4670930872,	-79.3318328665,	36.5016341422,	27.5574278118,	-35.4004898428,	-79.3903940148,	243.2421421265,	-8.0268453199,	
    44.0174931524,	68.8734465340,	-80.7502038529,	1.3409036386,	-86.0777878831,	37.1475406267,	18.1068167023,	-56.9153447361,	
    -19.5224115764,	-78.8474074897,	-20.0747255852,	4.5850719720,	-191.0686482737,	23.5318026769,	-32.6675253287,	27.3087304829,	
    31.4351407465,	19.6192337929,	-11.8866458644,	-48.4661089981,	-3.1226120347,	20.0138411382,	29.8813799560,	67.9558437137,	
    38.7174108080,	-13.3022284820,	27.1121047281,	-26.2954327750,	120.9542179193,	11.0555865630,	-34.5895364072,	73.4542523467,	
    -26.6956937208,	-108.0235037857,	-35.7355716826,	-69.8443555160,	33.3578766421,	26.3683815560,	97.2883332520,	133.5510498515,	
    35.5415284008,	-16.0495119378,	-19.5483270675,	93.9985201088,	27.7795159179,	-13.1059263368,	34.2311271533,	47.1466381795,	
    -36.4147469783,	10.4833119779,	-5.2292656110,	-25.0113244760,	-14.0549947152,	199.8348526048,	-43.2547698686,	98.4817969474,	
    37.0586206693,	33.2121561269,	-24.7170470026,	-37.1349105091,	-30.9578044903,	-7.4114930133,	-34.4807046142,	-27.7773696385,	
    29.2740921831,	-61.0686554741,	-32.4612619459,	6.7160769792,	3.1089599122,	12.2545595923,	62.6999428463,	30.5969686709,	
    11.1423411573,	-57.6502489731,	60.2408835918,	-67.7203861906,	-44.4518971003,	-5.1109945114,	5.6528645074,	-43.3456968092,	
    117.8609487802,	-24.2034537544,	-78.4496201847,	44.5294780988,	85.1475013837,	15.5247701555,	89.7512668950,	54.3013774517,	
    -186.8510627600,	-51.0482727175,	-9.0267702018,	48.0681416363,	-32.9759681266,	-42.4456615266,	36.2738833817,	14.1610476535,	
    -99.8207994579,	-11.5142692827,	50.1825860327,	0.3917737329,	63.3500370315,	111.2878444719,	91.6392406660,	17.6584451589,	
    -50.7899615175,	12.4221556654,	-86.5413087906,	48.0563389410,	29.1384649619,	83.5027000186,	7.5729436929,	22.2136423571,	
    -60.2741473997,	-170.4857658702,	17.0186844162,	136.3581532664,	31.5065683845,	-96.2326886411,	72.4014182257,	26.1414887396,	
    -57.2844089463,	-43.9781986370,	-95.6611720182,	-133.8830434822,	33.4938269182,	-23.9156927559,	35.5520154186,	-93.2468099373,	
    -6.2162527113,	4.5642492223,	-57.5722591446,	71.8064120226,	45.1768685505,	-9.5130102236,	110.5798720279,	-41.5641619544,	
    0.1835509076,	-49.9128593949,	98.0154257393,	-46.9365276597,	-66.0935141873,	73.1727792846,	41.3353795661,	-27.9960128980,	
    -44.2412816343,	46.9707404231,	12.3575979804,	-122.9770710291,	-11.9552135499,	31.4591712664,	-14.1931325058,	-6.8614191170,	
    -16.9763787814,	36.1520894392,	75.7352320923,	-99.5121191729,	17.8024156510,	72.7923924404,	38.2259409765,	1.9325379601,	
    -11.1978607868,	98.2703853998,	-38.0288299607,	-41.7008273041,	80.4517499854,	-116.8258848759,	30.7289872645,	-101.9012423077,	
    93.9831977796,	101.4530665010,	9.2763209169,	116.4425755502,	2.9739225298,	45.5019124654,	-64.2956140887,	105.7408745662,	
    -11.3657606620,	6.3069096678,	122.8709609828,	-6.3248578668,	-60.1760116205,	-35.9544630869,	-68.0834090495,	-34.8224305999,	
    -31.5069839788,	21.2614258718,	-23.5546199906,	-128.0293305211,	-182.3893947839,	-120.7110714918,	-65.8822590864,	-63.8215221762,	
    56.7670203795,	-61.2037205962,	3.8122259155,	1.0275735300,	-64.6391642695,	75.8652993596,	115.4068637021,	46.8849792653,	
    -39.5505124775,	33.1187321149,	25.3372286880,	-18.5375942960,	30.3953994229,	21.8836680766,	13.9924166006,	-109.7038947262,	
    -24.2899011732,	-52.7497505668,	35.3698361783,	34.1056231420,	-13.8686663216,	-1.7062295227,	-97.5362177027,	74.6544677369,	
    -78.3935767846,	35.6517853160,	51.3830818724,	-93.7778131463,	81.6700292143,	126.8070312922,	-28.4470816468,	-71.2638167545,	
    -55.2884800428,	9.0861240716,	-128.9083303383,	-16.3800803508,	34.5467745617,	28.9315662137,	84.3386694814,	-1.7523953786,	
    69.7727914393,	44.6546611575,	90.9897326057,	121.8059195607,	28.9429876729,	-14.8591127934,	29.2818722570,	-84.6318423838,	
    11.3290830564,	40.7084140001,	-50.5878424847,	68.2992258419,	-24.7150040711,	41.8365599450,	104.0111319954,	70.6981835472,	
    56.4709262168,	-20.5343182666,	-16.1886023808,	101.3482649415,	108.5356887852,	24.5240870510,	-146.5152615985,	-24.0194234128,	
    18.0331846295,	-5.1522407439,	4.9573388243,	-34.7877468646,	39.3333900199,	31.8580232326,	111.7915751739,	15.3919610203,	
    17.5179415363,	-22.2065299595,	31.9496951848,	-18.7368015481,	-78.3621490938,	45.9954796476,	77.7231064126,	21.7258618723,	
    23.3527631711,	-136.8686653828,	-22.5773174812,	33.6615614603,	4.8540113479,	3.9088571058,	-54.7099788715,	85.8089519875,	
    -86.1460475251,	-0.1247811474,	-146.1793416666,	124.6659345147,	-60.7858975441,	10.3154193265,	-29.5514280889,	9.4667237048,	
    -7.9550953683,	37.5451209024,	-27.1735194003,	46.8842847809,	41.9179936640,	-23.3158010522,	157.3009890625,	113.2843306932,	
    -104.1727731788,	123.3854503767,	-5.2055501860,	27.9879059133,	-13.4163698144,	52.2833141248,	-129.0969704337,	46.8881212895,	
    131.1080768010,	-19.0213767099,	155.5021671973,	20.3698150937,	37.2314029160,	40.8492644144,	-35.6880906860,	-31.7697839101,	
    -24.3255617048,	-26.5610341544,	11.6187963194,	-51.4990517524,	39.7825587179,	-54.6696763219,	-3.8497258220,	-70.2342476864,	
    4.9081928390,	-71.4654689380,	30.7344594349,	32.7496322701,	-90.9126087838,	-38.3652430128,	92.4042844207,	47.8082836295,	
    145.6802813070,	-18.7426859824,	17.6059584845,	36.4864322344,	-18.7252161480,	0.9615718128,	-100.1282552629,	-42.4349083923,	
    -14.3562238984,	-46.8134065357,	39.6360915881,	22.7361846189,	-3.2257803075,	37.2350125538,	115.6400099866,	-12.7275184486,	
    -96.1855573652,	-10.0276483356,	57.6455407419,	77.4560348751,	-22.1178137498,	-35.6022362191,	-68.4831367839,	2.8390215747,	
    -52.0573070842,	-93.4720169324,	-28.9154032611,	-76.6074307649,	-9.9420438435,	-6.1893105222,	29.9369590932,	74.7852614650,	
    -1.6201087045,	-17.3703711090,	-98.9790496449,	26.7869734481,	17.1602014711,	-15.6928367417,	-7.8035969135,	89.7887008279,	
    -70.6197502665,	-8.2854282454,	59.3778733341,	73.2639493915,	25.8370203675,	59.1628124401,	-24.8471900591,	-25.8194366580,	
    -6.0751044137,	-57.7489484697,	88.6706386657,	-84.8771863224,	-89.4840617668,	10.9763517990,	-54.8378810910,	41.3410088555,	
    66.6125927808,	-14.1311991812,	29.3005546497,	96.5047091289,	-3.3614374997,	-25.8108903749,	206.5074424684,	-61.4084159691,	
    -62.4923495769,	-13.1959183651,	-59.3730978039,	-12.7173171637,	16.2427076425,	43.4296534191,	-21.7657996669,	-28.1531280594,	
    -69.0302418588,	-86.4107750374,	17.1949881709,	-41.3078350297,	-57.6504646238,	-5.0909583836,	-8.1631298822,	1.3096980446,	
    -2.2508953688,	35.1942051704,	-3.9027768036,	-91.2713667132,	63.6694073039,	41.4248931898,	9.8384382954,	-96.0978983961,	
    66.1755919288,	-36.7372549691,	10.2307178666,	80.7031291631,	-38.2719834734,	39.2035878064,	-43.1259903655,	93.4819414373,	
    89.7247077937,	78.9891448344,	95.0983537363,	36.5774514331,	8.9972120390,	-8.5755002664,	-102.1337133375,	76.9830915294,	
    -46.7790015335,	51.0714648600,	29.5170917782,	23.9334813635,	5.2749838346,	-15.9842728433,	-1.3574532545,	-70.2729088611,	
    -15.8039920242,	15.5313565190,	-18.1312003682,	-8.0084433716,	-27.8087982433,	51.7334750530,	19.3370491919,	29.2520159480,	
    -68.6735151718,	8.0558008798,	-40.2210320066,	-40.9920576136,	7.8678303082,	-72.3041306508,	-10.2175986624,	-35.1356797035,	
    201.1586117629,	56.4352966867,	46.7221688254,	-11.9012413099,	-18.9833303926,	-86.5023414408,	-23.4675063576,	-55.5806400666,	
    153.4955981228,	-10.1092363214,	88.4029573110,	-65.9117133686,	-5.4919562765,	24.5837979674,	-33.5408574701,	-4.0004157187,	
    56.9848893304,	-105.2177018084,	3.4948685307,	-19.8452050090,	-7.2453079498,	102.6389582052,	-8.3246123264,	-73.0861922381,	
    0.9626940760,	-28.3612950785,	-11.1533678981,	44.2899763978,	-62.6677448146,	22.3906970985,	-13.3484872677,	67.0703918899,	
    42.4772156970,	-18.5244182335,	37.4759091463,	31.3496965213,	-61.4436264287,	52.0955155439,	59.1486887940,	170.4906735140,	
    46.0617455116,	40.1470772024,	-107.3976903570,	-105.4116725861,	56.8825181023,	58.5916397550,	-58.1729962485,	-60.5270235223,	
    -39.2885519005,	9.5965348817,	-25.4354894441,	-14.0981625889,	-52.7234757042,	-83.9105208881,	72.1797338834,	-134.9219073856,	
    9.6103094318,	9.6768962656,	26.7360474274,	41.7881752284,	-15.3952839007,	-0.1363655901,	-47.0864221556,	-8.2427253205,	
    -57.7373834528,	-55.9508702650,	-78.5284244100,	0.1655492302,	62.9160705153,	64.1068291282,	-2.9136214436,	-105.7842253662,	
    -45.8767944713,	-51.7074257000,	-98.8568902926,	64.1232083599,	71.1116077196,	-30.6630666091,	-58.6840707262,	-15.9383894413,	
    -78.6620829271,	60.7529890099,	154.2357488637,	41.3625348402,	120.2872442705,	-51.3125389772,	16.7881412988,	-70.4938171347,	
    -79.4147805796,	23.5182282020,	-81.0963234264,	-59.2244948022,	28.9135530940,	92.5951342446,	-96.6396527065,	-26.4777264554,	
    121.3094449527,	-34.5951012470,	-127.8255512216,	-92.7699064191,	-58.4398020189,	-117.7542292595,	31.0434596629,	21.5299289765,	
    -99.9447239591,	-16.0626333679,	6.0199864189,	82.4757175357,	22.5970205481,	73.5485760950,	35.7980568403,	72.6857884103,	
    28.8479981590,	-67.5538339177,	43.4071338656,	-25.1893024527,	4.6130159403,	-65.2605921685,	-91.8752363625,	22.5520067301,	
    -109.9093500045,	33.9399454761,	-13.9115156368,	-3.1879928935,	1.3920042271,	43.3324348308,	-33.3718525809,	-15.9282931008,	
    0.7677944075,	78.1072718708,	-1.1063828562,	-10.5413152425,	37.1290958861,	13.6823396336,	-3.4014039018,	89.5388534365,	
    37.7089705536,	64.0323076524,	44.7808982777,	-13.5604762388,	7.5118173888,	115.2300447558,	-9.1561273300,	-41.5332100116,	
    -17.0088418256,	71.2713927804,	68.0422816650,	54.9551164038,	106.8830646917,	-6.8316822423,	-66.7609967606,	-23.3894825625,	
    -67.4182747661,	-28.3219951260,	-15.9451114055,	-29.7266619746,	16.7419712545,	-20.5565859019,	-165.5656221846,	116.3242135199,	
    64.2626611081,	-8.1360214710,	-94.2273608282,	-62.9983557391,	64.1759043922,	36.5449254036,	-51.5697599431,	-5.0466305585,	
    -73.2700815931,	48.7300029897,	-35.5929303432,	-90.4816448914,	16.8187764590,	-27.9347950060,	80.7045416696,	-83.6514663068,	
    -58.4556594913,	3.2348973759,	52.8657910284,	85.7278577109,	37.4138218732,	82.0512145755,	76.4606241856,	-109.2162517858,	
    96.6683439683,	90.7633843052,	-53.1586977972,	34.4033331064,	44.2090456506,	80.1151111552,	2.7514790758,	-64.2623287852,	
    126.1409018754,	-30.2423240636,	-156.0079941574,	-2.8027393737,	64.2513542782,	69.8534581189,	-73.4708875363,	20.2217494242,	
    0.5864357659,	-104.6195300646,	-42.8322649072,	26.3037603855,	-40.7129474708,	-33.9844594811,	-26.3521525879,	109.6645932255,	
    -106.9356716414,	49.2118962107,	11.7512591870,	68.8969247665,	113.4583578600,	-83.3347276867,	-36.2485402256,	85.9855241461,	
    104.0814868325,	33.5770186573,	-1.9661285608,	-132.5696804701,	27.6753215958,	21.1243350017,	-28.0882593661,	35.2778527631,	
    18.9175154387,	83.6190957901,	-71.4962755318,	138.3285404575,	97.9134306607,	-56.8042150595,	-143.3089544841,	-2.7340225658,	
    17.5776154385,	-148.2352087417,	124.9211804787,	59.4231271286,	10.5947124378,	68.5288310273,	-67.2703544731,	-23.7935515786,	
    38.8787769309,	34.5294359419,	-73.4536038751,	2.7126504728,	49.6972438051,	62.7223593643,	49.8175933904,	-110.1534126143,	
    -14.6702420578,	-84.0773525862,	-92.6188033620,	-5.5698102323,	-47.9128909478,	46.7196485027,	-53.6444016449,	98.5014752828,	
    -94.7519348776,	14.1323076055,	-89.2719075396,	47.0296071172,	41.3919626390,	-39.1489616034,	-135.6499693540,	-10.9475781700,	
    92.7496269052,	37.4205820588,	-51.7237524182,	49.9460461012,	87.5396720347,	32.8710569742,	-32.8731769330,	-83.4249720632,	
    34.5762125072,	13.6808877416,	-26.3766683600,	-67.8728489559,	-29.6073750328,	-47.8030427727,	-149.0587954245,	-119.5774481626,	
    35.2806694964,	-24.3695409777,	48.7160766560,	8.8288204812,	-89.3855803242,	3.1835611015,	51.9474587643,	-41.8502161006,	
    -34.1035165420,	94.0854499359,	-84.2224914514,	59.1627371631,	-103.1905795588,	-18.6082417651,	36.3103092592,	63.1937125568,	
    -111.1986222065,	-32.0863426915,	-56.7330383564,	32.5073363806,	-7.1087996309,	-68.2226145792,	-157.6532604957,	45.2078386315,	
    -2.8603211008,	33.3371110420,	37.7846637198,	-18.6405663742,	-91.0982111740,	23.2221097945,	-24.3522827840,	78.9413600618,	
    62.8360928143,	-19.9242767252,	56.5032728402,	-5.5496240010,	8.6994906960,	83.5527376759,	-21.2346885874,	64.0836232315,	
    22.9623722574,	-87.9578765280,	1.3523030640,	176.4067098705,	67.9036978634,	7.2537723049,	-122.2309062335,	-63.8632909466,	
    -38.4903796734,	-16.2974411834,	2.3970826418,	64.3700072918,	-67.9197915888,	-116.4026668750,	67.5231031500,	34.6374455493,	
    4.1311157296,	-2.9105015532,	70.8086558293,	39.2725441796,	33.8256743917,	-3.5843642097,	116.7643833804,	20.1092238787,	
    -25.9766854190,	-51.9950492522,	3.5926636209,	-58.7583611171,	3.2768807331,	-83.5901878329,	68.7090363388,	31.4832422043,	
    72.9380572718,	-165.9742811160,	33.9362033271,	-10.9519428632,	13.0808211304,	15.6672709051,	31.7224492437,	-24.1934977704,	
    -111.0830116867,	11.6282084172,	-66.2259706857,	-1.9963673172,	30.0622960183,	53.3456859503,	-37.0919419160,	67.5944964290,	
    18.5935153812,	48.9664966150,	67.3157768914,	-160.7111991618,	-25.1223842933,	-47.4479071245,	-16.7582679230,	-13.6039270052,	
    1.7293472100,	-24.1741877419,	-76.9727398203,	-56.3783736939,	-66.9556303947,	-54.3511473684,	30.2542211582,	-66.8893229449,	
    -73.2990092912,	239.3981985262,	-64.2850340511,	89.9092075497,	-15.3525489059,	53.3827372899,	-14.3319916122,	-115.0721596412,	
    -50.4530123160,	44.0976786926,	52.2019557554,	72.6630207131,	27.5803572747,	33.4737730840,	-170.7640086205,	152.9204474548,	
    -44.5872734278,	-41.0667502536,	26.6175854758,	-13.0179143239,	40.8518134705,	23.2781614140,	22.8861340709,	165.4158655103,	
    45.0461105030,	-17.0077443894,	-2.3871329828,	-86.8854944700,	-38.5465304439,	51.8040803063,	-92.8924802068,	-113.2325293603,	
    51.3604041632,	-18.3429725256,	-42.5989033884,	-38.9445115750,	-85.8273183104,	-56.4224331649,	17.4997720376,	89.3766578841,	
    23.9239370283,	82.3838988229,	47.4013397563,	-28.0666334287,	77.6218433875,	-52.2133433307,	89.2938264737,	43.2058195424,	
    49.4518987655,	-5.6570623864,	19.8577713391,	-33.2615393471,	73.6654400011,	27.5602339563,	-47.1471825605,	-34.0693505588,	
    111.0944675938,	57.0173259682,	-63.4190502251,	46.5969999331,	49.3458328432,	-41.3853156260,	39.2494112424,	40.7148228670,	
    -20.3911372187,	31.8352000294,	-0.9980198147,	22.2804091174,	54.0978218332,	-82.3683192993,	85.9892355872,	-58.3154306688,	
    -104.2068911293,	91.0603181519,	32.9518095573,	20.8407188930,	34.7499759595,	81.9688480501,	-63.1013763435,	0.0064684915,	
    -24.5056101811,	69.9306176471,	-27.5369930597,	-39.0144381716,	-14.4923929902,	-54.3182594365,	-130.3292318388,	-48.8158919788,	
    53.2734036714,	-104.1048090944,	-70.0965204183,	3.6382745923,	83.6579656965,	23.1622465812,	126.4691310854,	102.9799547579,	
    70.8617976147,	-8.1455978101,	-28.4590640876,	108.1156467676,	-1.9738076313,	-75.4909376542,	57.5780163484,	45.3155422582,	
    -38.1742907476,	-52.1803902400,	-59.7016262432,	-23.3823853194,	-45.5457749841,	-10.5523915014,	-110.6271933849,	-32.0113288878,	
    -86.9215548382,	87.4068451718,	70.9885834348,	25.1206930472,	30.7108505789,	115.6076847444,	-40.5697084903,	-56.6781054555,	
    -31.4854227803,	-31.9552555012,	25.7938108182,	25.4540472201,	76.7058033375,	2.3905659773,	-5.9779298940,	-152.8056710400,	
    -51.7485397077,	28.1462240336,	33.9693389366,	-71.9881317816,	-105.0496130632,	64.2276458511,	96.2519735406,	48.6822690044,	
    -19.6594071488,	24.8884631741,	-33.0716823639,	-69.5612618256,	-25.2898319495,	98.8036926982,	-24.3703282453,	53.1789051370,	
    86.5743876344,	18.0109802577,	68.3663740236,	112.3369755598,	-45.4492280850,	-151.6437874688,	-38.2167192413,	24.2163999975,	
    -66.3294468430,	-150.1009914497,	-29.4992082835,	-92.1308610284,	-1.2762556067,	23.1500238372,	69.3063510487,	-69.0471660018,	
    42.5150200276,	120.6653379806,	-152.6729845687,	48.9591377076,	2.7191539126,	0.2888762146,	-3.0784673164,	32.5853754582,	
    -81.3351116851,	25.2072127071,	-36.3659441163,	-28.6250561447,	95.3073017008,	-75.7486406052,	65.1012680265,	-64.6031857772,	
    56.1240652498,	-10.8517181129,	-3.7575141784,	42.9554134355,	32.9784965739,	-25.0327158003,	-147.2361479829,	-122.4898965848,	
    -64.6526214445,	57.1527521244,	25.3983254376,	-74.5887309421,	105.2278400890,	118.4451948788,	-10.9195498541,	-45.2849091353,	
    79.1200975888,	-60.8806018590,	-12.2957628012,	-10.2289743666,	77.2465842566,	-19.1618580885,	-50.3947630673,	130.5843172047,	
    20.1829697245,	-24.4247513916,	71.3800655588,	-30.9467657000,	1.5373397590,	53.9054414421,	-87.7905799212,	58.1774557931,	
    -154.0660955458,	119.2331706772,	7.0800339615,	-83.0564977313,	-99.0630549412,	64.4241699198,	27.5103964537,	36.9348345670,	
    -10.4954521840,	-23.2759360131,	-167.1583158447,	-50.1929188975,	-17.1065117999,	-86.3978192131,	8.3733101608,	-19.6093068970,	
    37.0486109491,	45.4922144870,	176.0647013511,	-14.1950922727,	16.7968812286,	-84.3138225875,	-53.2207464331,	-14.8171496969,	
    65.2824157581,	93.3387940939,	-46.2740703075,	92.8129768305,	-57.1890439907,	27.2969064938,	-67.1547095718,	132.0520323271,	
    -80.7686358272,	31.4140691769,	-52.8148627904,	-54.8739580131,	-149.8514804755,	56.0153122854,	-71.3742949563,	36.6095599948,	
    42.3294500451,	1.2055515804,	-109.4906983981,	-71.9482696076,	-21.4390953534,	98.8949510272,	74.3069855376,	-35.1569830360,	
    -34.9626381657,	64.2761847423,	64.7596378221,	-28.4775450749,	20.1459803277,	-26.5247867780,	-32.4734659348,	-27.8310906478,	
    50.7956581065,	36.0746451268,	22.7531905225,	-13.9681530928,	49.5451440618,	-13.8510794385,	19.4999565108,	56.8774616945,	
    -11.9205397259,	-71.7174333027,	138.8034243907,	-37.8252215401,	-38.5743154556,	-22.5072374207,	12.6209402643,	69.3207345010,	
    70.3534390616,	71.5844311614,	4.0715727994,	25.4390606947,	-51.0777668722,	138.3617611366,	-34.2478029347,	-58.8492260984,	
    -108.6623124843,	58.3034938571,	-36.9304647333,	116.5902412201,	-24.4020501110,	-74.7544840602,	67.7889120207,	-9.1455389450,	
    -46.4456521441,	83.2551857934,	-113.9346066504,	46.2851467498,	-17.4102217179,	41.6989724702,	-23.8829078702,	76.1395799790,	
    -27.1608730178,	-133.8787483532,	-59.9242635982,	120.5266415560,	124.9797395465,	35.5722660007,	-20.2412573812,	20.5492611902,	
    -111.8745990845,	41.7389321101,	44.5758622786,	54.2189628306,	-44.4745944890,	-75.9761098966,	104.0472151578,	113.7219003284,	
    33.0330354214,	-6.0923562541,	-14.8744671800,	62.5024055272,	3.7922184446,	1.1256712478,	-30.2126827228,	-83.4988699637,	
    -103.7060854897,	-65.4982917403,	30.8897494352,	66.1124672663,	65.0983461952,	-52.5486436649,	-4.5556524541,	-26.5924272500,	
    -94.1546367179,	-0.3559369287,	-45.0649519841,	-68.1274094478,	-7.0521865275,	-5.6612786174,	-12.5790011432,	51.2524661231,	
    -3.6515125298,	92.9598974936,	-21.0468658542,	-40.8243392179,	-7.4342227950,	11.1119231703,	37.3371820746,	21.3179018153,	
    50.2932980480,	-24.1611515405,	-41.7851721122,	-24.8691439055,	-28.3180388219,	121.1894536511,	15.7968116384,	17.9498027226,	
    -55.3386005430,	-80.6689826830,	31.9394747713,	-28.1978017432,	-1.5538441529,	-4.0360096323,	73.9611531119,	17.7253526010,	
    -24.8578563772,	18.4583438017,	75.2580204243,	-13.6139802015,	24.6918362443,	-63.0552815767,	-4.0312608443,	-14.8879121339,	
    -2.8237511683,	-81.5024576341,	-4.2344562157,	107.1587476255,	-131.2910041645,	-25.6467586377,	0.4733397655,	62.8634326464,	
    63.1852609425,	16.5913941858,	-96.6896044528,	81.2969911064,	18.2956425408,	-81.6677471269,	-39.2708721333,	-34.3080597347,	
    22.5610412882,	57.2574226391,	77.9308780964,	-39.9342842346,	58.5581960994,	-5.7939281526,	104.9927182940,	-99.3837066580,	
    25.9917768621,	-32.1605915683,	-30.4589523848,	64.8295771021,	-28.2183758982,	-37.9771330859,	-178.0772548046,	84.2925125233,	
    45.4981954662,	49.2815212900,	-45.1224250038,	-5.9322404186,	-6.1309915876,	76.9070873365,	-11.5475730308,	18.2569564924,	
    -124.4953563688,	53.8646820493,	-40.0231506068,	-74.3908746450,	-63.2011642999,	-18.9826189881,	69.7917580387,	-34.8403308318,	
    -36.4625632706,	17.1934091336,	-20.8063613141,	-1.9067935434,	5.2259139474,	60.8368210348,	81.3087550974,	-42.6679999668,	
    -95.5963552311,	-115.2609753741,	11.1809831183,	-48.3640194531,	75.1073797772,	30.8228127170,	-15.0904157375,	11.0538529673,	
    107.4505154927,	-66.3486660110,	-32.0311111189,	38.4346222125,	8.9422998706,	-57.6098106212,	15.9132097612,	-132.1845158340,	
    36.1916704283,	-10.5055186124,	-87.5658217149,	107.8931306399,	96.0334082800,	53.7264664477,	-72.0623965686,	-1.9038197721,	
    26.1152808779,	119.6235796272,	48.3325601149,	117.6457486801,	28.0275495741,	-11.7030018715,	52.9236279862,	100.1176831736,	
    -83.2423151898,	7.5280868233,	-15.3686195277,	-5.3432329923,	-27.9181052724,	-64.4492860287,	129.7502751613,	-82.3246020383,	
    37.3256155504,	34.7298938660,	-57.0561320806,	-44.9581455455,	93.3481469867,	-54.3803550243,	26.4501204966,	18.8116878139,	
    -74.4902220818,	15.4659232518,	-49.1948332727,	34.0006040345,	56.7177639954,	-28.8367897421,	83.8692564278,	35.6745892475,	
    -45.7509262432,	30.3970223242,	106.1786129556,	-35.7843870107,	7.1339227808,	13.0894885560,	56.4666438735,	-23.8687514544,	
    -111.5694112759,	-58.7858061292,	-61.2783887765,	44.1738302093,	54.7407844064,	14.3538652267,	108.5956394164,	-22.3846808158,	
    2.5449431771,	70.3512724427,	29.5403015688,	-0.7212818796,	143.3497258886,	-17.2553350633,	-99.7681623907,	42.6913312311,	
    35.7338157369,	-54.6728371746,	-38.0299088541,	10.1471440532,	-124.7095236710,	-190.8743243033,	139.7543496645,	-42.2528776639,	
    39.0975372290,	27.8686903911,	22.7337255980,	42.7990612235,	-41.6771094483,	-23.0843729437,	49.7020046877,	11.0018909876,	
    -16.5079644797,	-158.2821637063,	42.1950179525,	-30.4282660128,	67.9797563487,	-53.8121334664,	52.8306609341,	-5.2861803454,	
    59.3808475761,	158.1836295178,	-26.8953096767,	78.8646320997,	-113.9365510474,	-37.1949934282,	53.6970193167,	-9.6523467804,	
    7.7358952669,	-74.6220593088,	107.4394203873,	17.2364088475,	-36.5357935724,	-23.9301386540,	17.8174243490,	14.1204969615,	
    -8.2599377000,	4.2743586584,	-46.4363395746,	-63.5670279031,	9.6872641411,	21.0630349930,	108.9834586896,	-124.7597975398,	
    29.4251821664,	23.8313097730,	-40.8359610210,	91.9520219869,	95.7936525792,	-109.5783337883,	-60.1100153384,	-19.9591228893,	
};

/*--------------------------------------------------------------------------------*/
/* FFT Lengths */
/*--------------------------------------------------------------------------------*/

/* 
  To change test parameter values add/remove values inside CURLY and update 
  the preceeding parameter to reflect the number of values inside CURLY. 
*/

ARR_DESC_DEFINE(uint16_t,
                transform_radix2_fftlens,
                7,
                CURLY(
                      16, 32, 64, 128, 256,
                      512, 1024/*, 2048 , 4096 */));

ARR_DESC_DEFINE(uint16_t,
                transform_radix4_fftlens,
                4,
                CURLY(
                      16, 64, 256, 1024/* , 4096 */));

ARR_DESC_DEFINE(uint16_t,
                transform_rfft_fftlens,
                6,
                CURLY(
                      32, 64, 128, 256,
                      512, 1024/*, 2048 , 4096, 8192*/));
                    
ARR_DESC_DEFINE(uint16_t,
                transform_dct_fftlens,
                3,
                CURLY(
                      128, 512, 2048/*, 8192*/));

ARR_DESC_DEFINE(uint16_t,
                transform_rfft_fast_fftlens,
                7,
                CURLY(
                      32, 64, 128, 256,
                      512, 1024, 2048));

/*--------------------------------------------------------------------------------*/
/* CFFT_F32 Structs */
/*--------------------------------------------------------------------------------*/

/* Uses radix2 lengths */
ARR_DESC_DEFINE(const arm_cfft_instance_f32 *,
                transform_cfft_f32_structs,
                5,
                CURLY(
                    &arm_cfft_sR_f32_len16,
                    &arm_cfft_sR_f32_len32,
                    &arm_cfft_sR_f32_len64,
                    &arm_cfft_sR_f32_len128,
                    &arm_cfft_sR_f32_len256/*,
                       &arm_cfft_sR_f32_len512, */
                    /* &arm_cfft_sR_f32_len1024, */
                    /* &arm_cfft_sR_f32_len2048, */
                    /* &arm_cfft_sR_f32_len4096 */
                    ));

/*--------------------------------------------------------------------------------*/
/* CFFT_Q31 Structs */
/*--------------------------------------------------------------------------------*/

/* Uses radix2 lengths */
ARR_DESC_DEFINE(const arm_cfft_instance_q31 *,
                transform_cfft_q31_structs,
                5,
                CURLY(
                    &arm_cfft_sR_q31_len16,
                    &arm_cfft_sR_q31_len32,
                    &arm_cfft_sR_q31_len64,
                    &arm_cfft_sR_q31_len128,
                    &arm_cfft_sR_q31_len256/*,
                       &arm_cfft_sR_q31_len512, */
                    /* &arm_cfft_sR_q31_len1024, */
                    /* &arm_cfft_sR_q31_len2048, */
                    /* &arm_cfft_sR_q31_len4096 */
                    ));

/*--------------------------------------------------------------------------------*/
/* CFFT_q15 Structs */
/*--------------------------------------------------------------------------------*/

/* Uses radix2 lengths */
ARR_DESC_DEFINE(const arm_cfft_instance_q15 *,
                transform_cfft_q15_structs,
                5,
                CURLY(
                    &arm_cfft_sR_q15_len16,
                    &arm_cfft_sR_q15_len32,
                    &arm_cfft_sR_q15_len64,
                    &arm_cfft_sR_q15_len128,
                    &arm_cfft_sR_q15_len256/*,
                       &arm_cfft_sR_q15_len512, */
                    /* &arm_cfft_sR_q15_len1024, */
                    /* &arm_cfft_sR_q15_len2048, */
                    /* &arm_cfft_sR_q15_len4096 */
                    ));
