/*!
 * \file           : sysdata.c
 * \brief          : Contains definition of SYS_DATA structure.
 *
 */

#include "sysdata.h"

volatile sys_data_t sys_data;

void SYS_DATA_Init(void)
{
	// Gertetyp angeben
#if (DEVICETYPE == 500)
	sys_data.s.parameter.device_type			= 510;
#elif (DEVICETYPE == 250)
	sys_data.s.parameter.device_type			= 511;
#elif (DEVICETYPE == 125)
	sys_data.s.parameter.device_type			= 512;
#else
#error "No valid device type"
#endif

	sys_data.s.values.lastTimeVbatEmpty = 0;// 400U * 3600U;
	sys_data.s.values.lastTimeVbatFull = 0;//400U * 3600U;
	sys_data.s.values.SoH = -1;

	sys_data.s.values.detectedCapacity = -1;//(int32_t)sys_data.s.parameter.cellCapacity;
	sys_data.s.values.detectedEnergy = -1; //(int32_t)sys_data.s.parameter.battEnergy;

	sys_data.s.values.esr = -1;
	sys_data.s.values.esr_fast = -1;

	sys_data.s.values.selfDischarge = -1;
	sys_data.s.values.selfDischargeAvg = -1;

	//sys_data.s.values.mWh_AutoMode = -sys_data.s.parameter.battEnergy;
	//sys_data.s.values.mAh_AutoMode = -sys_data.s.parameter.cellCapacity;

	sys_data.s.parameter.fw_revision_major     = 2;
	sys_data.s.parameter.fw_revision_minor     = 1;
	sys_data.s.parameter.fw_revision_revision  = 5;

	sys_data.s.values.batteryCurrentMax = INT32_MIN;
	sys_data.s.values.batteryCurrentMin = INT32_MAX;
	sys_data.s.values.shuntTemperatureMax = INT16_MIN;
	sys_data.s.values.shuntTemperatureMin = INT16_MAX;
	sys_data.s.values.batteryVoltageMax = INT16_MIN;
	sys_data.s.values.batteryVoltageMin = INT16_MAX;

	sys_data.s.values.adc_restarts = 0U;
}