/*!
 *	\file		wh_counter.h
 *	\author		ECS, Zhambolat Kazharov
 *	\brief		THis module contains functions to manage
 *				battery energy calculations.
 */

#ifndef __WH_COUNTER_H
#define __WH_COUNTER_H

#ifdef __cplusplus
extern "C" {
#endif

//--- INCLUDEs -----------------------------------------------------------------

#include <stdint.h>

//--- GLOBAL TYPE DEFS ---------------------------------------------------------

//--- GLOBAL DEFINES -----------------------------------------------------------

//--- GLOBAL VARIABLES PROTOTYPES ----------------------------------------------

//--- GLOBAL FUNKTIONS PROTOTYPEN ----------------------------------------------



void WH_COUNTER_Init(void);

/*!
 *	\brief	Calculates Wh periodically (1s)
 *
 *			Must be called every second
 *
 */
void WH_COUNTER_Exec(void);
/*!
 *	\brief	Returns Soc in m%
 *
 */
int32_t WH_COUNTER_GetSoCManual(void);
/*!
 *	\brief	Description
 *
 */
int32_t WH_COUNTER_GetSoCAuto(void);

/*!
 *	\brief	Description
 *
 */
int32_t WH_COUNTER_GetSoCAutoTemp(void);

/*!
 *	\brief	Description
 *
 */
void WH_COUNTER_SetToMax(void);
/*!
 *	\brief	Description
 *
 */
void WH_COUNTER_SetDetectedEnergy(void);

#ifdef __cplusplus
}
#endif

#endif