/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.h
  * @brief          : Header for main.c file.
  *                   This file contains the common defines of the application.
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2019 STMicroelectronics.
  * All rights reserved.</center></h2>
  *
  * This software component is licensed by ST under BSD 3-Clause license,
  * the "License"; You may not use this file except in compliance with the
  * License. You may obtain a copy of the License at:
  *                        opensource.org/licenses/BSD-3-Clause
  *
  ******************************************************************************
  */
/* USER CODE END Header */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __MAIN_H
#define __MAIN_H

#ifdef __cplusplus
extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "stm32g0xx_hal.h"


/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

/* USER CODE END Includes */

/* Exported types ------------------------------------------------------------*/
/* USER CODE BEGIN ET */

/* USER CODE END ET */

/* Exported constants --------------------------------------------------------*/
/* USER CODE BEGIN EC */

/* USER CODE END EC */

/* Exported macro ------------------------------------------------------------*/
/* USER CODE BEGIN EM */

/* USER CODE END EM */

/* Exported functions prototypes ---------------------------------------------*/
void Error_Handler(void);

/* USER CODE BEGIN EFP */

/* USER CODE END EFP */

/* Private defines -----------------------------------------------------------*/
#define ADC_DATA_READY_Pin GPIO_PIN_9
#define ADC_DATA_READY_GPIO_Port GPIOB
#define AIN_U_SHUNT_Pin GPIO_PIN_0
#define AIN_U_SHUNT_GPIO_Port GPIOA
//#define ADC_POWER_DOWN_Pin GPIO_PIN_4
//#define ADC_POWER_DOWN_GPIO_Port GPIOB
#define ADC_RESET_Pin GPIO_PIN_5
#define ADC_RESET_GPIO_Port GPIOB
#define ADC_START_CONV_Pin GPIO_PIN_12
#define ADC_START_CONV_GPIO_Port GPIOA
#define ADC_SPI1_NSS_Pin GPIO_PIN_15
#define ADC_SPI1_NSS_GPIO_Port GPIOA
#define ADC_SPI1_SCK_Pin GPIO_PIN_5
#define ADC_SPI1_SCK_GPIO_Port GPIOA
#define ADC_SPI1_MISO_Pin GPIO_PIN_6
#define ADC_SPI1_MISO_GPIO_Port GPIOA
#define ADC_SPI1_MOSI_Pin GPIO_PIN_7
#define ADC_SPI1_MOSI_GPIO_Port GPIOA
#define ADC_FAST_P_Pin GPIO_PIN_3
#define ADC_FAST_P_GPIO_Port GPIOA
#define ADC_FAST_N_Pin GPIO_PIN_4
#define ADC_FAST_N_GPIO_Port GPIOA
#define AIN_VREF_MEAS_Pin GPIO_PIN_2
#define AIN_VREF_MEAS_GPIO_Port GPIOA
#define TEMP_SENSOR_Pin GPIO_PIN_2
#define TEMP_SENSOR_GPIO_Port GPIOB
#define OVP_ENABLE_Pin GPIO_PIN_8
#define OVP_ENABLE_GPIO_Port GPIOA
#define LVP_ENABLE_Pin GPIO_PIN_9
#define LVP_ENABLE_GPIO_Port GPIOA
#define BUTTON_Pin GPIO_PIN_6
#define BUTTON_GPIO_Port GPIOC
#define LED_FUNCTION_Pin GPIO_PIN_10
#define LED_FUNCTION_GPIO_Port GPIOA
#define LED_ERROR_Pin GPIO_PIN_11
#define LED_ERROR_GPIO_Port GPIOA
#define RS485_R_Pin GPIO_PIN_6
#define RS485_R_GPIO_Port GPIOB
#define RS485_D_Pin GPIO_PIN_7
#define RS485_D_GPIO_Port GPIOB
#define AUX_EN_Pin GPIO_PIN_8
#define AUX_EN_GPIO_Port GPIOB
/* USER CODE BEGIN Private defines */
#define LVP_SENSE_MEAS_Pin GPIO_PIN_1
#define LVP_SENSE_MEAS_GPIO_Port GPIOB
#define OVP_SENSE_MEAS_Pin GPIO_PIN_0
#define OVP_SENSE_MEAS_GPIO_Port GPIOB


#define AIN_U_BATTERY_PLUS_Pin GPIO_PIN_1
#define AIN_U_BATTERY_PLUS_GPIO_Port GPIOA
#define AIN_U_BATTERY_MINUS_Pin GPIO_PIN_2
#define AIN_U_BATTERY_MINUS_GPIO_Port GPIOA

// mögliche Kommandos für das Command Register
#define COMMAND_STORE_CONFIG								1
#define COMMAND_FULL_RESTORE								2
#define COMMAND_FACTORY_RESTORE								3
#define COMMAND_RESTORE_LAST_SAVED_VALUES					4
#define COMMAND_RESTART										6
#define COMMAND_BATTERY_CURRENT_OFFSET_CAL					7
#define COMMAND_BATTERY_CURRENT_OFFSET_COMMONMODE_CAL		8
#define COMMAND_BATTERY_CURRENT_OFFSET_TEMP_CAL				9
#define COMMAND_BATTERY_CURRENT_GAIN_CAL					10
#define COMMAND_BATTERY_CURRENT_GAIN_TEMP_SHUNT_CAL			11
//#define COMMAND_BATTERY_CURRENT_GAIN_TEMP_CHIP_CAL		12
#define COMMAND_STORE_WITH_SERIAL_NUMBER					1234
#define COMMAND_SET_RDP_LEVEL0								1010
#define COMMAND_SET_RDP_LEVEL1								1011
#define COMMAND_SET_RDP_LEVEL1_AND_BOOTSEL					1012

enum SOC_CALC_MODE{
  SOC_CALC_MODE_AH_RATED,
  SOC_CALC_MODE_AH_AUTO,
  SOC_CALC_MODE_WH_RATED,
  SOC_CALC_MODE_WH_AUTO,
  SOC_CALC_MODE_WH_AUTO_TEMP,
};

typedef union error_message_t
{
	char msg[sizeof(uint64_t)];
	uint64_t number;
} error_message_t;

// Defines um printf auszuschalten
//#define PRINT_BATTERY_CURRENT
//#define PRINT_BATTERY_VOLTAGE
//#define PRINT_SHUNT_TEMPERATURE
//
//#define PRINT_STM32G0_SHUNTVOLTAGE
//#define PRINT_STM32G0_CHIPTEMPERATURE
//#define PRINT_STM32G0_VREF_MEASURE

//#define PRINT_FREQUENCY_MEASURE_RESULT

// Funktionen einkommentieren
#define DO_HSI16_CALIBRATION
//#define MCO_TEST_FUNCTION
//#define CHECK_CHANGED_FREQUENCY
/* USER CODE END Private defines */

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H */

/************************ (C) COPYRIGHT STMicroelectronics *****END OF FILE****/