/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file           : main.c
  * @brief          : Main program body
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2025 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */
/* USER CODE END Header */
/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "adc.h"
#include "dma.h"
#include "fdcan.h"
#include "i2c.h"
#include "spi.h"
#include "usart.h"
#include "usb.h"
#include "gpio.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */
#include <stdio.h>
#include "sysdata.h"
#include "wh_counter.h"
#include "ah_counter.h"
#include "eeprom.h"
#include "modbus.h"
#include "chip_temperature.h"
/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/

/* USER CODE BEGIN PV */
modbus_t modbusData;
#define ADCCONVERTEDVALUES_BUFFER_SIZE 2
__IO uint32_t adc12Data[ADCCONVERTEDVALUES_BUFFER_SIZE] __attribute__((section(".RAM1")));
__IO uint32_t adc1Data[1] __attribute__((section(".RAM1")));
__IO uint32_t adc2Data[1] __attribute__((section(".RAM1")));
__IO uint32_t adc3Data[3] __attribute__((section(".RAM1")));
__IO uint32_t adc4Data[1] __attribute__((section(".RAM1")));
__IO uint32_t adc5Data[4] __attribute__((section(".RAM1")));
int silentmode =0;
/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
void SystemClock_Config(void);
/* USER CODE BEGIN PFP */

/* USER CODE END PFP */

/* Private user code ---------------------------------------------------------*/
/* USER CODE BEGIN 0 */

/* USER CODE END 0 */

/**
  * @brief  The application entry point.
  * @retval int
  */
int main(void)
{

  /* USER CODE BEGIN 1 */
    uint8_t firstStartCatcher;
  /* USER CODE END 1 */

  /* MCU Configuration--------------------------------------------------------*/

  /* Reset of all peripherals, Initializes the Flash interface and the Systick. */
  HAL_Init();

  /* USER CODE BEGIN Init */

  /* USER CODE END Init */

  /* Configure the system clock */
  SystemClock_Config();

  /* USER CODE BEGIN SysInit */

  /* USER CODE END SysInit */

  /* Initialize all configured peripherals */
  MX_GPIO_Init();
  MX_DMA_Init();
  MX_ADC1_Init();
  MX_ADC2_Init();
  MX_ADC3_Init();
  MX_ADC4_Init();
  MX_ADC5_Init();
  MX_FDCAN2_Init();
  MX_FDCAN3_Init();
  MX_I2C3_Init();
  MX_I2C4_Init();
  MX_SPI3_Init();
  MX_USART1_UART_Init();
  MX_USART2_UART_Init();
  MX_USB_PCD_Init();
  /* USER CODE BEGIN 2 */
  printf("Test debug io\r\n");
  SYS_DATA_Init();
  WH_COUNTER_Init();
  AH_COUNTER_Init();


  startType_t startType = EEPROM_isFirstStart();

  switch(startType)
  {
	  case FIRST_START_AFTER_ERASE:					EEPROM_fullRestore(&sys_data);		  break;
	  case FIRST_START_AFTER_COMPARTIBLE_UPDATE:	EEPROM_readConfig(&sys_data);		  break;
	  case FIRST_START_AFTER_INCOMPARTIBLE_UPDATE:	EEPROM_factoryRestore(&sys_data, 0);  break;  // Preserving calibration and settings
	  case FIRST_START_ERROR:						EEPROM_fullRestore(&sys_data);		  break;
  }

  if(HAL_GPIO_ReadPin(GPIO_INPUT_BTN_MODE_GPIO_Port, GPIO_INPUT_BTN_MODE_Pin) == GPIO_PIN_RESET)
  {
    HAL_Delay(50);
    if(HAL_GPIO_ReadPin(GPIO_INPUT_BTN_MODE_GPIO_Port, GPIO_INPUT_BTN_MODE_Pin) == GPIO_PIN_RESET)
    {
      printf("factory restore...\n");
      EEPROM_factoryRestore(&sys_data, 1);
    }
  }

    // Modbus Initialisierung
  mbInit(&modbusData, sys_data.s.parameter.baudrate, sys_data.s.parameter.parityMode, sys_data.s.parameter.stopBit, &huart2);

    // STM32G0 Chiptemperatur Kalibrierung
  CHIP_TEMPERATURE_Calibration(/*&sys_data*/);

  HAL_ADCEx_Calibration_Start(&hadc1, ADC_DIFFERENTIAL_ENDED);
  HAL_ADCEx_Calibration_Start(&hadc2, ADC_DIFFERENTIAL_ENDED);
  HAL_ADCEx_Calibration_Start(&hadc3, ADC_SINGLE_ENDED);
  HAL_ADCEx_Calibration_Start(&hadc4, ADC_DIFFERENTIAL_ENDED);
  HAL_ADCEx_Calibration_Start(&hadc5, ADC_SINGLE_ENDED);



  //SET_BIT(hadc2.Instance->CFGR, ADC_CFGR_DMAEN); //Enable DMA transfer for ADC slave (ADC12_CCR.MDMA = 0b00 -> MDMA mode disabled)
  //HAL_DMA_Start(hadc2.DMA_Handle,(uint32_t)&hadc2.Instance->DR, (uint32_t)adc2Data,1); //Start ADC slave DMA 
  //SET_BIT(hadc1.Instance->CFGR, ADC_CFGR_DMAEN); //Enable DMA transfer for ADC master (ADC12_CCR.MDMA = 0b00 -> MDMA mode disabled)
  
    //HAL_ADC_Start_DMA(&hadc2, (uint32_t*)adc2Data, 1);
  if (HAL_ADCEx_MultiModeStart_DMA(&hadc1,(uint32_t *)adc12Data,ADCCONVERTEDVALUES_BUFFER_SIZE))  //Start ADC interleaved mode
  {
     /* Start Error */
     Error_Handler();
  }

  if (HAL_ADC_Start_DMA(&hadc5, (uint32_t *) adc5Data , 4))
  {
     /* Start Error */
     Error_Handler();
  }

  /* USER CODE END 2 */

  /* Infinite loop */
  /* USER CODE BEGIN WHILE */
  while (1)
  {
    /* USER CODE END WHILE */

    /* USER CODE BEGIN 3 */
	// Modbus Kommunikation
	HAL_Delay(1000);
	printf("data12d1=%d,data12d2=%d,data5=%d\r\n", adc12Data[0], adc12Data[1], adc5Data[2]);
    if (mbGetFrameComplete(&modbusData) == true)
    {
      if (mbSlaveCheckModbusRtuQuery(&modbusData) == RESPOND_TO_QUERY)
      {
          if (silentmode == 0)
          {
            mbSlaveProcessRtuQuery(&modbusData);
          }
      }
      else
      {
        huart1.RxState = HAL_UART_STATE_BUSY_RX;
      }
    }

  }
  /* USER CODE END 3 */
}

/**
  * @brief System Clock Configuration
  * @retval None
  */
void SystemClock_Config(void)
{
  RCC_OscInitTypeDef RCC_OscInitStruct = {0};
  RCC_ClkInitTypeDef RCC_ClkInitStruct = {0};

  /** Configure the main internal regulator output voltage
  */
  HAL_PWREx_ControlVoltageScaling(PWR_REGULATOR_VOLTAGE_SCALE1);

  /** Initializes the RCC Oscillators according to the specified parameters
  * in the RCC_OscInitTypeDef structure.
  */
  RCC_OscInitStruct.OscillatorType = RCC_OSCILLATORTYPE_HSI48|RCC_OSCILLATORTYPE_HSE;
  RCC_OscInitStruct.HSEState = RCC_HSE_ON;
  RCC_OscInitStruct.HSI48State = RCC_HSI48_ON;
  RCC_OscInitStruct.PLL.PLLState = RCC_PLL_ON;
  RCC_OscInitStruct.PLL.PLLSource = RCC_PLLSOURCE_HSE;
  RCC_OscInitStruct.PLL.PLLM = RCC_PLLM_DIV2;
  RCC_OscInitStruct.PLL.PLLN = 16;
  RCC_OscInitStruct.PLL.PLLP = RCC_PLLP_DIV2;
  RCC_OscInitStruct.PLL.PLLQ = RCC_PLLQ_DIV2;
  RCC_OscInitStruct.PLL.PLLR = RCC_PLLR_DIV2;
  if (HAL_RCC_OscConfig(&RCC_OscInitStruct) != HAL_OK)
  {
    Error_Handler();
  }

  /** Initializes the CPU, AHB and APB buses clocks
  */
  RCC_ClkInitStruct.ClockType = RCC_CLOCKTYPE_HCLK|RCC_CLOCKTYPE_SYSCLK
                              |RCC_CLOCKTYPE_PCLK1|RCC_CLOCKTYPE_PCLK2;
  RCC_ClkInitStruct.SYSCLKSource = RCC_SYSCLKSOURCE_PLLCLK;
  RCC_ClkInitStruct.AHBCLKDivider = RCC_SYSCLK_DIV1;
  RCC_ClkInitStruct.APB1CLKDivider = RCC_HCLK_DIV1;
  RCC_ClkInitStruct.APB2CLKDivider = RCC_HCLK_DIV1;

  if (HAL_RCC_ClockConfig(&RCC_ClkInitStruct, FLASH_LATENCY_3) != HAL_OK)
  {
    Error_Handler();
  }
}

/* USER CODE BEGIN 4 */


/* USER CODE END 4 */

/**
  * @brief  This function is executed in case of error occurrence.
  * @retval None
  */
void Error_Handler(void)
{
  /* USER CODE BEGIN Error_Handler_Debug */
  /* User can add his own implementation to report the HAL error return state */
  __disable_irq();
  printf("error handler!\r\n");
  while (1)
  {
  }
  /* USER CODE END Error_Handler_Debug */
}
#ifdef USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t *file, uint32_t line)
{
  /* USER CODE BEGIN 6 */
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */
	 printf("Wrong parameters value: file %s on line %d\r\n", file, line);
  /* USER CODE END 6 */
}
#endif /* USE_FULL_ASSERT */
