/**
  ******************************************************************************
  * @file    Project/STM32L0_Internal_RC_Oscillators_Calibration/Inc/hsi16.h
  * @author  MCD Application Team
  * @version V0.1.0
  * @date    17-December-2014
  * @brief   Header for hsi16.c
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT 2014 STMicroelectronics</center></h2>
  *
  * Licensed under MCD-ST Liberty SW License Agreement V2, (the "License");
  * You may not use this file except in compliance with the License.
  * You may obtain a copy of the License at:
  *
  *        http://www.st.com/software_license_agreement_liberty_v2
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an "AS IS" BASIS,
  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  *
  ******************************************************************************
  */

/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __HSI_MEASUREMENT_H
#define __HSI_MEASUREMENT_H

/* Includes ------------------------------------------------------------------*/
#include "stdint.h"
#include "stm32g0xx.h"
/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */
void 				HSI16_MeasurementInit(void);
uint32_t 		HSI16_FreqMeasure(void);
uint32_t	 	HSI16_CalibrateMinError(void);
ErrorStatus HSI16_CalibrateFixedError(uint32_t MaxAllowedError, uint32_t* Freq);
ErrorStatus HSI16_CalibrateCurve(uint32_t* Freq);
void 				HSI16_GetCurve(void);
void frequencyErrorTest(void);

#endif /* __HSI_MEASUREMENT_H */

/******************* (C) COPYRIGHT 2014 STMicroelectronics *****END OF FILE****/
