/******************************************************************************
*
* @file    chipTemperature.c
* @author  ECS, Joseph Zimmer
* @version V1.0.0
* @date    24-04-2019
* @brief
*
******************************************************************************/

//	--- INCLUDES -----------------------------------------------------------------
#include <stdio.h>
//#include <stdlib.h>
#include "chip_temperature.h"

//	--- EXTERNE VARIABLEN --------------------------------------------------------

//	--- LOKALE DEFINES - bitte hier dokumentieren --------------------------------

//	--- LOKALE TYPE DEFS - bitte hier dokumentieren-------------------------------

//	--- DEFINITIONEN GLOBALER VARIABLEN - Bitte in Header dokumentieren ----------

//	--- LOKALE VARIABLEN - bitte hier dokumentieren ------------------------------
uint32_t calTemperatureSensor30Value;  // Kalibrierungswert für den Temperatursensor auf dem STM32G0 (Werksmäßig im SCB Bereich gespeichert wird beim Programmstart ausgelesen)
                                                 // Daten Temperaturanzeige µProzessor

//	--- LOKALE FUNKTIONS PROTOTYPEN ----------------------------------------------

void calc_temp_compensation(void);


//	--- LOKALE FUNKTIONEN - bitte hier dokumentieren -----------------------------

/*
* @brief
* @param	kein
* @retval	kein
*/

//	--- GLOBALE FUNKTIONEN - bitte in Header dokumentieren------------------------
void CHIP_TEMPERATURE_Calibration(void)
{
  uint16_t * pCalibrationData;
  float calibrationData30;
  float calibrationData130;

  // lade Temperatur Kalibrierungswert (Wert bei 30°C)
  pCalibrationData = (uint16_t *)TEMPSENSOR_CAL1_ADDR;
  calibrationData30  = * pCalibrationData;

  //Berechnung Spannung in mV bei CAL Punk 30°C
  //Kalbibrierung wurde mit 12 Bit und 3000mV Vref durchgeführt
  calibrationData30 = calibrationData30 / 4096;
  calTemperatureSensor30Value = calibrationData30 * 3000 ;      // jetzt haben wir die Kalibrierungsspannung in mVolt bei 30°C;
}

int CHIP_TEMPERATURE_Exec(uint32_t chiptemperature)
{
    int32_t temp;
    //Aktuelle Spannung am Temp Sensor
    temp = (3300 * (uint32_t)chiptemperature) / 65536;


    temp = temp - (calTemperatureSensor30Value);

    temp = temp / 2.530; //2,53mV/°C
    temp = temp + 25; //30000 da Erste Kalibrierpunkt bei 25°C --> 25
	return temp;
    //Durch 10 teilen, damit es in 16 Bit signed modbus register passt
}

//------------------------------------------------------------------------------



