#include "fan.h"
#include "tim.h"
static unsigned lastSpeed;

void FAN_SetSpeed(unsigned speed)
{
	const unsigned MAX_RPM = 100U;											// 100.0%

	if (speed > MAX_RPM) speed = MAX_RPM;

	lastSpeed = speed;

	const unsigned MAX_PWM = __HAL_TIM_GET_AUTORELOAD(&htim17) + 1U;
	//printf("%u", MAX_PWM);
	const unsigned newPWM = (MAX_PWM * speed/ MAX_RPM);

	__HAL_TIM_SET_COMPARE(&htim17, TIM_CHANNEL_1, newPWM);
}

//-----------------------------------------------------------------------------

unsigned FAN_GetLastSpeed(void)
{
	return lastSpeed;
}
