#include <stdio.h>
#include "button.h"
#include "main.h"

#define LONG_PRESS_TIME 5000
#define MIN_PRESS_TIME  10

button_state_t buttonState;
uint32_t longPressCounterButtonOn;
uint32_t longPressCounterButtonOff;


// Diese funktion muss regelmäßig aufgerufen werden um die Taster abzufragen.
// 1ms
button_state_t BUTTON_Exec(void)
{

  if (HAL_GPIO_ReadPin(GPIO_INPUT_BTN_ON_GPIO_Port, GPIO_INPUT_BTN_ON_Pin) == GPIO_PIN_SET)
  {
    //Taste On wird gedrückt
    longPressCounterButtonOn++;
  }


  if (longPressCounterButtonOn > LONG_PRESS_TIME)
  {    

    if (buttonState != BUTTON_MANUAL_ON)
    {
      printf("BUTTON: Auto Mode Manual On\n");
      buttonState = BUTTON_MANUAL_ON;
    }
  }
  else if ( (longPressCounterButtonOn > MIN_PRESS_TIME) && (HAL_GPIO_ReadPin(GPIO_INPUT_BTN_ON_GPIO_Port, GPIO_INPUT_BTN_ON_Pin) == GPIO_PIN_RESET))
  {
    //Taste On wurde for 10m gesdrückt und losgelassen
    if (buttonState != BUTTON_AUTO)
    {
      printf("BUTTON: Auto Mode\n");
      buttonState = BUTTON_AUTO;
    }
  }



  if (HAL_GPIO_ReadPin(GPIO_INPUT_BTN_ON_GPIO_Port, GPIO_INPUT_BTN_ON_Pin) == GPIO_PIN_RESET)
  {
    longPressCounterButtonOn = 0;
  }


  // ------ Taste OFF -----
  if (HAL_GPIO_ReadPin(GPIO_INPUT_BTN_OFF_GPIO_Port, GPIO_INPUT_BTN_OFF_Pin) == GPIO_PIN_SET)
  {
    //Taste Off wird gedrückt
    longPressCounterButtonOff++;
    if (longPressCounterButtonOff > MIN_PRESS_TIME)
    {
      if (buttonState != BUTTON_OFF) 
      {
        printf("BUTTON: Off Mode\n");
        buttonState = BUTTON_OFF;
      }
    }
  }
  else
  {
    longPressCounterButtonOff = 0;
  }

  return buttonState;

}


button_state_t BUTTON_GetMode(void)
{
  return buttonState;
}

void BUTTON_SetModeOff(void)
{
  buttonState = BUTTON_OFF;
}

void BUTTON_SetModeAuto(void)
{
  buttonState = BUTTON_AUTO;
}