// Keine LVP und OVP Überwachung aber Fault wird geprüft!
// Falls nicht benötigt, nicht anschließen ?! Ist Low active mit PullUp
// Dieser Modus ist als Hauptschaltermodus ohne BMS gedacht. Z.B. für Bleibatterien
// Oder als Hauptschalter mit Fremd BMS



#include "stdio.h"
#include "mode_mainswitch.h"
#include "button.h"
#include "relais.h"
#include "main.h"
#include "leds.h"
#include "buzzer.h"


typedef enum MAINSWITCH_State_enum 
{
  MAINSWITCH_OFF, 
  MAINSWITCH_ON,
  MAINSWITCH_MANUAL_ON, 
  MAINSWITCH_ERROR
} MAINSWITCH_state_t;


static MAINSWITCH_state_t smState;


void MAINSWITCH_SM_Off(void)
{
  int faultInput;

  if (HAL_GPIO_ReadPin(GPIO_INPUT_FAULT_GPIO_Port, GPIO_INPUT_FAULT_Pin) == GPIO_PIN_RESET)       
  {
    faultInput = 1;
  }
  else
  {
    faultInput = 0;
  }
  


  //Prüfe auf Wechsel des Modus AUTO / SM ON
  if (BUTTON_GetMode() == BUTTON_AUTO)
  {
    if (faultInput == 0)
    {
      RELAIS_SetPuls();
      BUZZER_Beep(BUZZER_ON_TIME_CONFIRM);
      LEDS_GN_Blink_Start(LED_GN_ON_TIME_ON_MODE, LED_GN_OFF_TIME);
      printf("NEW_STATE: MAINSWITCH_ON\n");
      smState = MAINSWITCH_ON;

    }
    else
    {
      //Wechsel nicht möglich. Fehler Eingang aktiv
      BUZZER_Beep(BUZZER_ON_TIME_REJECT);
      BUTTON_SetModeOff();
      LEDS_RT_BlinkCode_Start(BLINK_CODE_ERROR_FAULT_INPUT, LED_RT_ON_TIME_WARN_FAULT_INPUT, LED_GN_OFF_TIME, LED_GN_OFF_TIME *5); //Fehler Anzeigen
      printf("NEW_STATE: MAINSWITCH_ERROR\n");
      smState = MAINSWITCH_ERROR;
    }
  }

  //Prüfe auf Wechsel in MANUAL ON Mode
  //Keine Fehlerüberprüfungen. In diesem Modus werdem alle Alarme ignoriert.
  if (BUTTON_GetMode() == BUTTON_MANUAL_ON)
  {
      
      RELAIS_SetPuls();
      BUZZER_Alarm_Start(BUZZER_ON_TIME_ALARM_MANUAL_MODE, BUZZER_OFF_TIME);
      LEDS_GN_On();
      LEDS_RT_BlinkCode_Start(BLINK_CODE_WARN_MANUAL, LED_RT_ON_TIME_WARN_MANUAL_MODE, LED_GN_OFF_TIME, LED_GN_OFF_TIME *5); //Fehler Anzeigen
      printf("NEW_STATE: MAINSWITCH_MANUAL_ON\n");
      smState = MAINSWITCH_MANUAL_ON;
  }



}

void MAINSWITCH_SM_On(void)
{
  int faultInput;
  if (HAL_GPIO_ReadPin(GPIO_INPUT_FAULT_GPIO_Port, GPIO_INPUT_FAULT_Pin) == GPIO_PIN_RESET)       
  {
    faultInput = 1;
  }
  else
  {
    faultInput = 0;
  }
  

  // Prüfe Wechsel in off mode
  if (BUTTON_GetMode() == BUTTON_OFF)
  {
    //Ausschalten muss immer möglich sein
    RELAIS_ResetPuls();
    BUZZER_Beep(BUZZER_ON_TIME_CONFIRM); //Bestätigung
    LEDS_GN_Off();
    LEDS_RT_Off();
    printf("NEW_STATE: MAINSWITCH_OFF\n");
    smState = MAINSWITCH_OFF;
  }

  //Prüfe auf Fehlermode
  if (faultInput == 1)
  {
    RELAIS_ResetPuls();
    BUZZER_Beep(BUZZER_ON_TIME_REJECT); //Warnung
    LEDS_GN_Off();
    LEDS_RT_BlinkCode_Start(BLINK_CODE_ERROR_FAULT_INPUT, LED_RT_ON_TIME_WARN_FAULT_INPUT, LED_GN_OFF_TIME, LED_GN_OFF_TIME *5); //Fehler Anzeigen
    BUTTON_SetModeOff(); //Damit nicht von alleine wieder eingeschaltet wird
    printf("NEW_STATE: MAINSWITCH_ERROR\n");
    smState = MAINSWITCH_ERROR;
  }


}

void MAINSWITCH_SM_ManualOn(void)
{
  // Prüfe Wechsel in off mode
  if (BUTTON_GetMode() == BUTTON_OFF)
  {
    //Ausschalten muss immer möglich sein
    RELAIS_ResetPuls();
    BUZZER_Alarm_Stop();
    LEDS_GN_Off();
    LEDS_RT_Off();
    printf("NEW_STATE: MAINSWITCH_OFF\n");
    smState = MAINSWITCH_OFF;
  }

}

void MAINSWITCH_SM_Error(void)
{
  int faultInput;

  if (HAL_GPIO_ReadPin(GPIO_INPUT_FAULT_GPIO_Port, GPIO_INPUT_FAULT_Pin) == GPIO_PIN_RESET)       
  {
    faultInput = 1;
  }
  else
  {
    faultInput = 0;
  }
  

  //Prüfe auf Wechsel des Modus AUTO / SM ON
  if (BUTTON_GetMode() == BUTTON_AUTO)
  {
    if (faultInput == 0)
    {
      RELAIS_SetPuls();
      BUZZER_Beep(BUZZER_ON_TIME_CONFIRM);
      LEDS_GN_Blink_Start(LED_GN_ON_TIME_ON_MODE, LED_GN_OFF_TIME);
      LEDS_RT_Off(); //Fehler löschen
      printf("NEW_STATE: MAINSWITCH_ON\n");
      smState = MAINSWITCH_ON;
    }
    else
    {
      //Wechsel nicht möglich. Fehler Eingang aktiv
      BUZZER_Beep(BUZZER_ON_TIME_REJECT);
      BUTTON_SetModeOff();
    }
  }

  //Prüfe auf Wechsel in MANUAL ON Mode
  //Keine Fehlerüberprüfungen. In diesem Modus werdem alle Alarme ignoriert.
  if (BUTTON_GetMode() == BUTTON_MANUAL_ON)
  {
      
      RELAIS_SetPuls();
      BUZZER_Alarm_Start(BUZZER_ON_TIME_ALARM_MANUAL_MODE, BUZZER_OFF_TIME);
      LEDS_GN_On();
      LEDS_RT_Off();
      LEDS_RT_BlinkCode_Start(BLINK_CODE_WARN_MANUAL, LED_RT_ON_TIME_WARN_MANUAL_MODE, LED_GN_OFF_TIME, LED_GN_OFF_TIME *5); //Fehler Anzeigen
      printf("NEW_STATE: MAINSWITCH_MANUAL_ON\n");
      smState = MAINSWITCH_MANUAL_ON;
  }



}



void MODE_MAINSWITCH_Exec(void)
{

  

  switch (smState)
  {
    case MAINSWITCH_OFF:
      MAINSWITCH_SM_Off();
    break;

    case MAINSWITCH_ON:
      MAINSWITCH_SM_On();
    break;

    case MAINSWITCH_MANUAL_ON:
      MAINSWITCH_SM_ManualOn();
    break;

    case MAINSWITCH_ERROR:
      MAINSWITCH_SM_Error();
    break;

    default:
    break;
  }
}


