#include "main.h"
#include "buzzer.h"

unsigned int onTimeCounter;
unsigned int offTimeCounter;
unsigned int onTime;
unsigned int offTime;
unsigned int alarmMode;



void BUZZER_Exec(void)
{

  if (onTimeCounter > 0)
  {
    onTimeCounter--;
    if (onTimeCounter == 0)
    {
      HAL_GPIO_WritePin(GPIO_OUTPUT_BUZZER_GPIO_Port, GPIO_OUTPUT_BUZZER_Pin, GPIO_PIN_RESET);

      if (alarmMode == 1) offTimeCounter = offTime;
    }
  }

  if (offTimeCounter > 0)
  {
    offTimeCounter--;
    if (offTimeCounter == 0)
    {
      HAL_GPIO_WritePin(GPIO_OUTPUT_BUZZER_GPIO_Port, GPIO_OUTPUT_BUZZER_Pin, GPIO_PIN_SET);
      onTimeCounter = onTime;
    }
  }
}



void BUZZER_Beep(unsigned int time)
{
  HAL_GPIO_WritePin(GPIO_OUTPUT_BUZZER_GPIO_Port, GPIO_OUTPUT_BUZZER_Pin, GPIO_PIN_SET);
  onTimeCounter = time;

}

void BUZZER_Alarm_Start(unsigned int on, unsigned int off )
{
  onTime = on;
  offTime = off;
  alarmMode = 1;

  HAL_GPIO_WritePin(GPIO_OUTPUT_BUZZER_GPIO_Port, GPIO_OUTPUT_BUZZER_Pin, GPIO_PIN_SET);
  onTimeCounter = on;

}

void BUZZER_Alarm_Stop(void)
{
  HAL_GPIO_WritePin(GPIO_OUTPUT_BUZZER_GPIO_Port, GPIO_OUTPUT_BUZZER_Pin, GPIO_PIN_RESET);
  alarmMode = 0;
  offTimeCounter = 0;
  onTimeCounter = 0;

}