
// Dieser Modus ist ein Hauptschaltermodus mit Secondary Protection 
// Secondary Protection löst aus, wenn OVP und LVP wegfällt.
// OVP und LVP fällt wegbei:
// - Sehr tiefe Entladung
// - Sehr hohe Spannung
// - Übertemperatur
// - je nach Liproeinstellung möglicherweise auch wenn sowohl Untertemperaturschutz für Ladung und für Last erreicht ist
// - je nach Liproeinstellung möglicherweise auch wenn sowohl Überttemperaturschutz für Ladung und für Last erreicht ist
// - Die letzten beiden Positionen können vielleicht ungewollt sein.

// OVP UND LVP Signal gleichzeitig:
// Es wurde eine Verzögerung von ca. 30 Sekunden implementiert. So kann noch problemlos ein Testjumper auf die Lipro gesteckt werden und die 
// einzelnennen Funktionen zu prüfen. Außerdem ist es eventuell für die Prametrierung hilfreich, wenn nicht sofort ausgeht
// Auch wäre es hilfreich um zum Beispiel die Ursache über Modbus abfragen heruas zu bekommen

// 
// Fault Input:
// Hier ohne Verzögerung um schnell auf kurzschluss reagieren zu können
// Ansonsten wie Modus 0



#include "stdio.h"
#include "mode_lvp.h"
#include "button.h"
#include "relais.h"
#include "main.h"
#include "leds.h"
#include "buzzer.h"



typedef enum LVP_State_enum 
{
  LVP_OFF, 
  LVP_ON,
  LVP_MANUAL_ON, 
  LVP_ERROR
} LVP_state_t;


static LVP_state_t smState;


static void LVP_SM_Off(void)
{
  int faultInput;
  int lvpInput;

  if (HAL_GPIO_ReadPin(GPIO_INPUT_FAULT_GPIO_Port, GPIO_INPUT_FAULT_Pin) == GPIO_PIN_RESET)       
  {
    faultInput = 1;
  }
  else
  {
    faultInput = 0;
  }

  if (HAL_GPIO_ReadPin(GPIO_INPUT_LVP_GPIO_Port, GPIO_INPUT_LVP_Pin) == GPIO_PIN_SET)
  {
    lvpInput = 1;
  }else {
    lvpInput = 0;
  }

  


  //Prüfe auf Wechsel des Modus AUTO / SM ON
  if (BUTTON_GetMode() == BUTTON_AUTO)
  {
    if (faultInput == 0) 
    {
      RELAIS_SetPuls();
      BUZZER_Beep(BUZZER_ON_TIME_CONFIRM);
      LEDS_GN_Blink_Start(LED_GN_ON_TIME_ON_MODE, LED_GN_OFF_TIME);
      printf("NEW_STATE: SECONDARYPROTECTION_ON\n");
      smState = LVP_ON;

    }
    else   
    {
      //Wechsel nicht möglich. Fehler Eingang aktiv
      BUZZER_Beep(BUZZER_ON_TIME_REJECT);
      BUTTON_SetModeOff();
      //LEDS_RT_Blink_Start(LED_RT_ON_TIME_WARN_FAULT_INPUT, LED_GN_OFF_TIME); //Fehler Anzeigen
	  LEDS_RT_BlinkCode_Start(BLINK_CODE_ERROR_FAULT_INPUT, LED_RT_ON_TIME_WARN_FAULT_INPUT, LED_RT_OFF_TIME, LED_RT_OFF_TIME *5); //Fehler Anzeigen
      printf("NEW_STATE: SECONDARYPROTECTION_ERROR\n");
      smState =LVP_ERROR;
    }
  }


  //Prüfe auf Wechsel in MANUAL ON Mode
  //Keine Fehlerüberprüfungen. In diesem Modus werdem alle Alarme ignoriert.
  if (BUTTON_GetMode() == BUTTON_MANUAL_ON)
  {
      
      RELAIS_SetPuls();
      BUZZER_Alarm_Start(BUZZER_ON_TIME_ALARM_MANUAL_MODE, BUZZER_OFF_TIME);
      LEDS_GN_On();
      LEDS_RT_BlinkCode_Start(BLINK_CODE_WARN_MANUAL, LED_RT_ON_TIME_WARN_MANUAL_MODE, LED_RT_OFF_TIME, LED_RT_OFF_TIME * 5); //Fehler Anzeigen
      printf("NEW_STATE: SECONDARYPROTECTION_MANUAL_ON\n");
      smState = LVP_MANUAL_ON;
  }



}

static void LVP_SM_On(void)
{
  int faultInput = 0;
  int lvpInput = 0;
  static int lvpInputTimeCounter = 0;
  static int oldtime;

  if (HAL_GPIO_ReadPin(GPIO_INPUT_FAULT_GPIO_Port, GPIO_INPUT_FAULT_Pin) == GPIO_PIN_RESET)       
  {
    faultInput = 1;
  }
  else
  {
    faultInput = 0;
  }
  
  if (HAL_GPIO_ReadPin(GPIO_INPUT_LVP_GPIO_Port, GPIO_INPUT_LVP_Pin) == GPIO_PIN_RESET)
  {
    if (HAL_GetTick() != oldtime)
    {
      lvpInputTimeCounter++;
      if (lvpInputTimeCounter > 30000)
      {
        lvpInput = 0;
        lvpInputTimeCounter=0;
      }
      oldtime = HAL_GetTick();
    }
  }
  else 
  {
    lvpInputTimeCounter = 0;
    lvpInput = 1;
  }

  

  // Prüfe Wechsel in off mode
  if (BUTTON_GetMode() == BUTTON_OFF)
  {
    //Ausschalten muss immer möglich sein
    RELAIS_ResetPuls();
    BUZZER_Beep(BUZZER_ON_TIME_CONFIRM); //Bestätigung
    LEDS_GN_Off();
    LEDS_RT_Off();
    printf("NEW_STATE: SECONDARYPROTECTION_OFF\n");
    smState = LVP_OFF;
  }

  //Prüfe auf Fehlermode
  if (faultInput == 1)
  {
    RELAIS_ResetPuls();
    BUZZER_Beep(BUZZER_ON_TIME_REJECT); //Warnung
    LEDS_GN_Off();
    LEDS_RT_BlinkCode_Start(BLINK_CODE_ERROR_FAULT_INPUT, LED_RT_ON_TIME_WARN_FAULT_INPUT, LED_RT_OFF_TIME, LED_RT_OFF_TIME *5); //Fehler Anzeigen
    BUTTON_SetModeOff(); //Damit nicht von alleine wieder eingeschaltet wird
    printf("FAULT INPUT EVENT DETECTED!\n");
    printf("NEW_STATE: SECONDARYPROTECTION_ERROR\n");
    smState = LVP_ERROR;
  }

  if ((lvpInput == 0) && ( RELAIS_GetState() == 1))
  {
    RELAIS_ResetPuls();
    BUZZER_Beep(BUZZER_ON_TIME_REJECT); //Warnung
    LEDS_GN_Off();
    BUTTON_SetModeOff(); //Damit nicht von alleine wieder eingeschaltet wird
    printf("LVP FALLING EVENT DETECTED!\n");
    printf("NEW_STATE: LVP OFF\n");
  }


  //Einkommentieren für auto Reconnect
  //if ((lvpInput == 1) && ( RELAIS_GetState() == 0))
  //{
  //  RELAIS_SetPuls();
  //  BUZZER_Beep(BUZZER_ON_TIME_CONFIRM); //Warnung
  //  LEDS_GN_Blink_Start(LED_GN_ON_TIME_ON_MODE, LED_GN_OFF_TIME);
  //  BUTTON_SetModeOff(); //Damit nicht von alleine wieder eingeschaltet wird
  //  printf("BMS SECONDARY PROTECTION FAULT EVENT DETECTED (LVP & OVP )!\n");
  //  printf("NEW_STATE: SECONDARYPROTECTION_ERROR\n");
  //}


}

static void LVP_SM_ManualOn(void)
{
  // Prüfe Wechsel in off mode
  if (BUTTON_GetMode() == BUTTON_OFF)
  {
    //Ausschalten muss immer möglich sein
    RELAIS_ResetPuls();
    BUZZER_Alarm_Stop();
    LEDS_GN_Off();
    LEDS_RT_Off();
    printf("NEW_STATE: LVP_OFF\n");
    smState = LVP_OFF;
  }

}

static void LVP_SM_Error(void)
{
  int faultInput;
  int lvpAndOvpInput;

  if (HAL_GPIO_ReadPin(GPIO_INPUT_FAULT_GPIO_Port, GPIO_INPUT_FAULT_Pin) == GPIO_PIN_RESET)       
  {
    faultInput = 1;
  }
  else
  {
    faultInput = 0;
  }



  //Prüfe auf Wechsel des Modus AUTO / SM ON
  if (BUTTON_GetMode() == BUTTON_AUTO)
  {
    if (faultInput == 0) 
    {
      RELAIS_SetPuls();
      BUZZER_Beep(BUZZER_ON_TIME_CONFIRM);
      LEDS_GN_Blink_Start(LED_GN_ON_TIME_ON_MODE, LED_GN_OFF_TIME);
      LEDS_RT_Off(); //Fehler löschen
      printf("NEW_STATE: LVP_ON\n");
      smState = LVP_ON;
    }
    else
    {
      //Wechsel nicht möglich. Fehler Eingang weiterhin aktiv
      BUZZER_Beep(BUZZER_ON_TIME_REJECT);
      BUTTON_SetModeOff();
    }
  }

  //Prüfe auf Wechsel in MANUAL ON Mode
  //Keine Fehlerüberprüfungen. In diesem Modus werdem alle Alarme ignoriert.
  if (BUTTON_GetMode() == BUTTON_MANUAL_ON)
  {
      
      RELAIS_SetPuls();
      BUZZER_Alarm_Start(BUZZER_ON_TIME_ALARM_MANUAL_MODE, BUZZER_OFF_TIME);
      LEDS_GN_On();
      LEDS_RT_Off();
      LEDS_RT_BlinkCode_Start(BLINK_CODE_WARN_MANUAL, LED_RT_ON_TIME_WARN_MANUAL_MODE, LED_RT_OFF_TIME, LED_RT_OFF_TIME *5); //Fehler Anzeigen
      printf("NEW_STATE: SECONDARYPROTECTION_MANUAL_ON\n");
      smState = LVP_MANUAL_ON;
  }



}



void MODE_LVP_Exec(void)
{

  

  switch (smState)
  {
    case LVP_OFF:
      LVP_SM_Off();
    break;

    case LVP_ON:
      LVP_SM_On();
    break;

    case LVP_MANUAL_ON:
      LVP_SM_ManualOn();
    break;

    case LVP_ERROR:
      LVP_SM_Error();
    break;

    default:
    break;
  }
}


