/******************************************************************************
*
* @file    chipTemperature.c
* @author  ECS, Joseph Zimmer
* @version V1.0.0
* @date    24-04-2019
* @brief
*
******************************************************************************/

//	--- INCLUDES -----------------------------------------------------------------
#include <stdio.h>
//#include <stdlib.h>
#include "chip_temperature.h"

//	--- EXTERNE VARIABLEN --------------------------------------------------------

//	--- LOKALE DEFINES - bitte hier dokumentieren --------------------------------

//	--- LOKALE TYPE DEFS - bitte hier dokumentieren-------------------------------

//	--- DEFINITIONEN GLOBALER VARIABLEN - Bitte in Header dokumentieren ----------

//	--- LOKALE VARIABLEN - bitte hier dokumentieren ------------------------------
uint32_t calTemperatureSensor30Value;  // Kalibrierungswert für den Temperatursensor auf dem STM32G0 (Werksmäßig im SCB Bereich gespeichert wird beim Programmstart ausgelesen)
uint32_t calTemperatureSensor130Value; // Kalibrierungswert für den Temperatursensor auf dem STM32G0 (Werksmäßig im SCB Bereich gespeichert wird beim Programmstart ausgelesen)
uint32_t calTemperatureSensorDiff;     // Differenz calTemperatureSensor130Value und calTemperatureSensor30Value wird für die Kalibrierung des internen Temperatursensors bentigt
                                                              // Daten Temperaturanzeige µProzessor

//	--- LOKALE FUNKTIONS PROTOTYPEN ----------------------------------------------

void calc_temp_compensation(void);
int16_t y(int16_t x1, int16_t y1, int16_t x2, int16_t y2, int16_t x);

//	--- LOKALE FUNKTIONEN - bitte hier dokumentieren -----------------------------

/*
* @brief
* @param	kein
* @retval	kein
*/

//	--- GLOBALE FUNKTIONEN - bitte in Header dokumentieren------------------------
void CHIP_TEMPERATURE_Calibration(void)
{
  uint16_t * pCalibrationData;
  float calibrationData30;
  float calibrationData130;

  // lade Temperatur Kalibrierungswert (Wert bei 30°C)
  pCalibrationData = (uint16_t *)TEMPSENSOR_CAL1_ADDR;
  calibrationData30  = * pCalibrationData;


  //Berechnung Spannung in mV bei CAL Punk 30°C
  //Kalbibrierung wurde mit 12 Bit und 3000mV Vref durchgeführt
  calibrationData30 = calibrationData30 / 4096;
  calTemperatureSensor30Value = calibrationData30 * 3000 ;      // jetzt haben wir die Kalibrierungsspannung in mVolt bei 30°C;

  //pCalibrationData = (uint16_t *)TEMPSENSOR_CAL2_ADDR;
  //calibrationData130  = * pCalibrationData;
  calibrationData130  = calibrationData30 + 343;

  //Berechnung Spannung in mV bei CAL Punk 130°C
  //Kalbibrierung wurde mit 12 Bit und 3000mV Vref durchgeführt
  calibrationData130 = calibrationData130 / 4096;
  calTemperatureSensor130Value = calibrationData130 * 3000;      // jetzt haben wir die Kalibrierungsspannung in mV bei 130°C;

  // Spannungsdifferenz bei 100 Kelvin Temperatureunterschied
  calTemperatureSensorDiff = (calTemperatureSensor130Value - calTemperatureSensor30Value);
}

void CHIP_TEMPERATURE_Exec(uint32_t chiptemperature)
{
    int32_t voltage;
    //Aktuelle Spannung am Temp Sensor
    voltage = (3300 * (uint32_t)chiptemperature) / 65536;


    voltage = voltage - (calTemperatureSensor30Value);

    voltage = voltage / 2.530; //2,53mV/°C
    voltage = voltage + 25; //30000 da Erste Kalibrierpunkt bei 25°C --> 25

    //Durch 10 teilen, damit es in 16 Bit signed modbus register passt


	
}

//------------------------------------------------------------------------------



