#include <stdio.h>

#include "main.h"
#include "dac.h"
#include "dma.h"
#include "precharge.h"

#define DELAYS_NUM			43U

extern void (*MOSFETS_Management)(void);
extern void DoNothing(void);

static void (*ReturnFunctionPtr)(void);

//------------------------------------------------------------------------------

void SetReturnFunction(void (*WhereToReturnControl)(void))
{
	if (NULL != WhereToReturnControl) ReturnFunctionPtr = WhereToReturnControl;
}

//------------------------------------------------------------------------------

#ifdef USE_RAM_FUNC
__RAM_FUNC void PreChargeStage(void)
#else
		   void PreChargeStage(void)
#endif
{
	static int stage = 0;
	static int cnt = 0;
	static int mal = 0;
								//    DAC = 0  DAC = 3V
	const int delay_µs[DELAYS_NUM] = {	50,	  	   2,	  // 0, 1	  - 6710µs is MAX @320kHz
										50,	  	   2,	  // 2, 3
										50,	  	   2, 	  // 4, 5
										50,	  	   2, 	  // 6, 7
										50,	  	   2, 	  // 9, 9
										50,	  	   2, 	  // 10, 11
										50,	  	   2, 	  // 12, 13
										50,	  	   2, 	  // 14, 15
										50,	  	   2, 	  // 16, 17
										50,	  	   2, 	  // 18, 19
										50,	  	   2, 	  // 20, 21
										50,	  	   2, 	  // 22, 23
										50,	  	   2, 	  // 24, 25
										50,	  	   2, 	  // 26, 27
										50,	  	   2, 	  // 28, 29
										50,	  	   2, 	  // 30, 31
										50,	  	   2, 	  // 32, 33
										50,	  	   2, 	  // 34, 35
										50,	  	   2, 	  // 36, 37
										50,	  	   2, 	  // 38, 39
										50,	  	   2, 	  // 40, 41
										50};			  // 42
	const int delay_cnt[DELAYS_NUM] = { (delay_µs[ 0] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[ 1] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[ 2] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[ 3] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[ 4] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[ 5] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[ 6] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[ 7] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[ 8] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[ 9] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[10] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[11] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[12] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[13] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[14] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[15] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[16] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[17] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[18] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[19] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[20] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[21] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[22] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[23] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[24] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[25] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[26] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[27] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[28] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[29] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[30] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[31] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[32] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[33] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[34] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[35] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[36] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[37] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[38] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[39] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[40] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[41] * CURRENT_INTEGRAL_FREQ) / 1000000U,
										(delay_µs[42] * CURRENT_INTEGRAL_FREQ) / 1000000U
									  };
	 
	switch(stage)
	{
		case 0:
			// Setting new values for DAC
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[0])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 1:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[1])
			{
				cnt = 0;
				stage++;
			}
			break;

		/*case 2:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[2])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 3:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[3])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 4:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[4])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 5:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[5])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 6:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[6])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 7:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[7])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 8:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[8])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 9:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[9])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 10:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[10])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 11:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[11])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 12:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[12])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 13:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[13])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 14:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[14])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 15:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[15])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 16:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[16])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 17:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[17])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 18:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[18])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 19:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[19])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 20:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[20])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 21:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[21])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 22:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[22])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 23:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[23])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 24:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[24])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 25:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[25])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 26:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[26])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 27:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[27])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 28:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[28])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 29:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[29])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 30:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[30])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 31:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[31])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 32:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[32])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 33:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[33])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 34:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[34])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 35:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[35])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 36:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[36])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 37:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[37])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 38:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[38])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 39:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[39])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 40:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[40])
			{
				cnt = 0;
				stage++;
			}
			break;

		case 41:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_3V;

			if (cnt++ >= delay_cnt[41])
			{
				cnt = 0;
				stage++;
			}
			break;*/

		case 2:
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_A_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;
			*(__IO uint32_t *)((uint32_t)DAC_HANDLE.Instance + DAC_CH_B_ALIGNMENT(DAC_ALIGN_12B_R)) = DAC_0V;

			if (cnt++ >= delay_cnt[3])
			{
				cnt = 0;
				stage = 0;
				
				if (mal++ >= 1600 - 1)	  // approx 95ms
				{
					mal = 0;
					HAL_NVIC_DisableIRQ(ADC_DMA_IRQ);
					if (NULL != ReturnFunctionPtr) MOSFETS_Management = ReturnFunctionPtr;
					else MOSFETS_Management = &DoNothing;
					HAL_NVIC_EnableIRQ(ADC_DMA_IRQ);
				}
			}
			break;
	}
}

//------------------------------------------------------------------------------