/**
  ******************************************************************************
  * @file    output.h
  * @author  ECS - Falko Jahn
  * @version V1.0.0
  * @date    29 Jan 2021
  * @brief   LVP OVP Ausgang 
  *
  *          Beschreibung          
  *          Dieses Modul enthlt die Funktionen zum steuern der Ausgnge:
  *          LVP
  *          OVP
  ******************************************************************************
  */ 
#ifndef __OUTPUT_H
#define __OUTPUT_H


//--- INCLUDEs -----------------------------------------------------------------

//--- GLOBALE TYPE DEFS --------------------------------------------------------       
    
//--- GLOBALE DEFINES ----------------------------------------------------------

//--- GLOBALE VARIABLEN PROTOTYPEN ---------------------------------------------
    
//--- GLOBALE FUNKTIONS PROTOTYPEN ---------------------------------------------
/**
  * @brief  OVP- Overvoltage Protection aktvieren
  *
  *         Beschreibung:
  *         Der Ausgang und die LED werden abgeschalten um so das Laden zu verhindern
  * @param  Keine
  *              
  * @retval Kein
  */
void OUTPUT_OVP_Enable(void);

/**
  * @brief  LVP- Low Voltage Protection aktvieren
  *
  *         Beschreibung:
  *         Der Ausgang und die LED werden abgeschalten um so das Entladen zu verhindern
  * @param  Keine
  *              
  * @retval Kein
  */
void OUTPUT_LVP_Enable(void);

/**
  * @brief  OVP- Overvoltage Protection deaktvieren
  *
  *         Beschreibung:
  *         Der Ausgang und die LED werden eingeschaltet um so das Laden zu erlauben
  * @param  Keine
  *              
  * @retval Kein
  */
void OUTPUT_OVP_Disable(void);

/**
  * @brief  LVP- Low Voltage Protection deaktvieren
  *
  *         Beschreibung:
  *         Der Ausgang und die LED werden eingeschaltet um so das Entladen zu erlauben
  * @param  Keine
  *              
  * @retval Kein
  */
void OUTPUT_LVP_Disable(void);


#endif