#ifndef __MAIN_H__
#define __MAIN_H__

// Bootloader commands

#define CMD_INIT                                  0x7F
#define CMD_ACK                                   0x79
#define CMD_NACK                                  0x1F
#define CMD_GET                                   0x00
#define CMD_GETID                                 0x02
#define CMD_GET_VER_RPS                           0x01
#define CMD_READ_MEMORY                           0x11
#define CMD_GO                                    0x21
#define CMD_WRITE_MEMORY                          0x31
#define CMD_ERASE                                 0x43
#define CMD_EXT_ERASE                             0x44
#define CMD_WRITE_PROTECT                         0x63
#define CMD_WRITE_UNPROTECT                       0x73
#define CMD_READOUT_PROTECT                       0x82
#define CMD_READOUT_UNPROTECT                     0x92

// Bootloader compartibility version number: 1.1
#define BOOTLOADER_VERSION                        0x11

#define FLASH_PAGE_SIZE                           (2*1024)    /*!< FLASH Page Size, 2 KBytes */
#define FLASH_PAGE_NUMBER                         64

#define BOOTLOADER_PROGRAM_SIZE			  (12*1024)  // 12K

#define BOOTLOADER_LAST_PAGE			  ((BOOTLOADER_PROGRAM_SIZE/FLASH_PAGE_SIZE)-1)

#define MAIN_APP_START_ADDRESS			  (FLASH_BASE + (FLASH_PAGE_SIZE * (BOOTLOADER_LAST_PAGE + 1)))
#define MAIN_APP_PARAM_PAGE_NUM			  2   // Amount of reserved pages at the end of the main program for storing some parameters

#ifdef DEBUG
    #define BOOTLOADER_TIME_TO_WAIT		  10000	  // 10s
#else
    #define BOOTLOADER_TIME_TO_WAIT		  5000	  // 5s
#endif

#define KEY1			                  0x45670123U
#define KEY2			                  0xCDEF89ABU
#define OPTKEY1			                  0x08192A3BU
#define OPTKEY2			                  0x4C5D6E7FU

#define BLUE_LED_PERIOD                           75U
#define BLUE_LED_PORT                             GPIOD
#define RED_LED_PORT                              GPIOD
#define BLUE_LED_PIN				  2
#define RED_LED_PIN				  3

#define UART					  USART1
#define UART_PORT                                 GPIOA
#define UART_RX_PIN                               10
#define UART_TX_PIN                               9
#define UART_TX_EN_PIN                            12
#define UART_RX_ALT_FUNC_NUM			  1
#define UART_TX_ALT_FUNC_NUM			  1
#define UART_TXEN_ALT_FUNC_NUM			  1

// Do not EDIT - START
#define GPIOx_BSRR(mask, pin)                     PRE_GPIOx_BSRR(mask, pin)
#define PRE_GPIOx_BSRR(mask, pin)		  mask##pin
#define GPIOx_MODER(mask, pin)			  PRE_GPIOx_MODER(mask, pin)
#define PRE_GPIOx_MODER(mask, pin)		  mask##pin
#define GPIOx_MODER_Pos(mask, pin)		  PRE_GPIOx_MODER_Pos(mask, pin)
#define PRE_GPIOx_MODER_Pos(mask, pin)            mask##pin##_Pos
#define GPIO_AFRH_AFSEL(mask, pin)		  PRE_GPIO_AFRH_AFSEL(mask, pin)
#define PRE_GPIO_AFRH_AFSEL(mask, pin)		  mask##pin
#define GPIO_AFRL_AFSEL(mask, pin)		  PRE_GPIO_AFRL_AFSEL(mask, pin)
#define PRE_GPIO_AFRL_AFSEL(mask, pin)		  mask##pin
#define GPIO_AFRH_AFSEL_Pos(mask, pin)		  PRE_GPIO_AFRH_AFSEL_Pos(mask, pin)
#define PRE_GPIO_AFRH_AFSEL_Pos(mask, pin)	  mask##pin##_Pos
#define GPIO_AFRL_AFSEL_Pos(mask, pin)		  PRE_GPIO_AFRL_AFSEL_Pos(mask, pin)
#define PRE_GPIO_AFRL_AFSEL_Pos(mask, pin)	  mask##pin##_Pos
#define GPIOx_PUPDR(mask, pin)			  PRE_GPIOx_PUPDR(mask, pin)
#define PRE_GPIOx_PUPDR(mask, pin)		  mask##pin
#define GPIOx_PUPDR_Pos(mask, pin)		  PRE_GPIOx_PUPDR_Pos(mask, pin)
#define PRE_GPIOx_PUPDR_Pos(mask, pin)		  mask##pin##_Pos
#define GPIOx_ODR(mask, pin)                      PRE_GPIOx_ODR(mask, pin)
#define PRE_GPIOx_ODR(mask, pin)                  mask##pin
#define GPIOx_BRR(mask, pin)                      PRE_GPIOx_BRR(mask, pin)
#define PRE_GPIOx_BRR(mask, pin)		  mask##pin
// Do not EDIT - END

#define SWD_PORT                                  GPIOA
#define SWD_PIN_MSK                               GPIO_IDR_ID13
                                          
#define CRC_LEN                                   4

#endif