/**
  ******************************************************************************
  * @file    meas.h
  * @author  ECS - Falko Jahn
  * @version V1.0.0
  * @date    30-Jan-2021
  * @brief   MEAS Modul Treiber
  *
  *          Beschreibung          
  *          Dieses Modul enthlt die Funktionen zur Messung von
  *          Zelltemperatur, Zellspannung, ausgleichsstrom
  *
  *          Achtung:   
  *          Hinweis1 
  *          Hinweis2
  ******************************************************************************
  */ 
#ifndef __MEAS_H
#define __MEAS_H


//--- INCLUDEs -----------------------------------------------------------------

//--- GLOBALE TYPE DEFS --------------------------------------------------------       
    
//--- GLOBALE DEFINES ----------------------------------------------------------

//--- GLOBALE VARIABLEN PROTOTYPEN ---------------------------------------------
    
//--- GLOBALE FUNKTIONS PROTOTYPEN ---------------------------------------------
/**
  * @brief  Init Funktion
  *
  *         Beschreibung:
  *         Startet die ADC Messungen.
  *         Ergebnisse werden per DMA in die System Daten Struktur gespeichert.
  *
  * @param  Keine
  *              
  * @retval Kein
  */
void MEAS_Init(void);


/**
  * @brief  Execute Funktion
  *
  *         Beschreibung:
  *         Prft die Ergebnisse der ADC Wandlungen, Speichert Min und Max Werte  *         
  *
  * @param  Keine
  *              
  * @retval Kein
  */
void MEAS_Exec(void);


#endif