/**
  ******************************************************************************
  * @file    sysdata.c
  * @author  ECS, Zed Kazharov
  * @version V1.0.0
  * @date    10-Feb-2023
  * @brief   SYSTEM DATEN Modul 
  *          Beschreibung in Header
  ******************************************************************************
  */ 

// --- INCLUDES ----------------------------------------------------------------
#include "sysdata.h"
#include "modbus.h"

//--- GGF. EXTERNE VARIABLEN ---------------------------------------------------  

//--- LOKALE DEFINES - bitte hier dokumentieren --------------------------------


//--- LOKALE TYPE DEFS - bitte hier dokumentieren-------------------------------

//--- DEFINATIONEN GLOBALER VARIABLEN - Bitte in Header dokumentieren ----------
sys_data_t sysData;


//--- LOKALE VARIABLEN - bitte hier dokumentieren ------------------------------


//--- LOKALE FUNKTIONS PROTOTYPEN ---------------------------------------------- 


//--- LOKALE FUNKTIONEN - bitte hier dokumentieren -----------------------------


//--- GLOBALE FUNKTIONEN - bitte in Header dokumentieren------------------------

accessMode_t accessModeTable[MAX_ADRESS+1] = {
  ACCESS_MODE_READ_ONLY,          //0   DEVICE_TYPE_ID
  ACCESS_MODE_READ_ONLY,          //1   RESERVIERT
  ACCESS_MODE_WRITE_PROTECTABLE,  //2   SN1 
  ACCESS_MODE_WRITE_PROTECTABLE,  //3   SN2 
  ACCESS_MODE_READ_ONLY,          //4   FW 
  ACCESS_MODE_READ_ONLY,          //5   FW 
  ACCESS_MODE_READ_ONLY,          //6   FW 
  ACCESS_MODE_READ_ONLY,          //7   RESERVIERT
  ACCESS_MODE_WRITE_PROTECTABLE,  //8   BAUDRATE  
  ACCESS_MODE_WRITE_PROTECTABLE,  //9   BAUDRATE
  ACCESS_MODE_WRITE_PROTECTABLE,  //10  PARITY MODE 
  ACCESS_MODE_WRITE_PROTECTABLE,  //11  STOPP_BITS
  ACCESS_MODE_READ_WRITE,         //12  SLAVE_ADRESS
  ACCESS_MODE_READ_WRITE,         //13  CMD
  ACCESS_MODE_READ_ONLY,          //14  RESERVED
  ACCESS_MODE_READ_ONLY,          //15  RESERVED
  ACCESS_MODE_READ_ONLY,          //16  RESERVED
  ACCESS_MODE_READ_ONLY,          //17  RESERVED
  ACCESS_MODE_READ_ONLY,          //18  RESERVED
  ACCESS_MODE_READ_ONLY,          //19  RESERVED
  ACCESS_MODE_WRITE_PROTECTABLE,  //20  OVP ALARM
  ACCESS_MODE_WRITE_PROTECTABLE,  //21  LVP ALARM
  ACCESS_MODE_WRITE_PROTECTABLE,  //22  OVP START
  ACCESS_MODE_WRITE_PROTECTABLE,  //23  OVP STOP
  ACCESS_MODE_WRITE_PROTECTABLE,  //24  LVP START
  ACCESS_MODE_WRITE_PROTECTABLE,  //25  LVP STOP
  ACCESS_MODE_WRITE_PROTECTABLE,  //26  V SHUTDOWN START
  ACCESS_MODE_WRITE_PROTECTABLE,  //27  V SHUTDOWN STOP
  ACCESS_MODE_WRITE_PROTECTABLE,  //28  OT SHUTDOWN START
  ACCESS_MODE_WRITE_PROTECTABLE,  //29  OT SHUTDOWN STOP
  ACCESS_MODE_WRITE_PROTECTABLE,  //30  UTP CHARGE VSHUTDOWN START
  ACCESS_MODE_WRITE_PROTECTABLE,  //31  UTP CHARGE SHUTDOWN STOP
  ACCESS_MODE_WRITE_PROTECTABLE,  //32  UTP LOAD VSHUTDOWN START
  ACCESS_MODE_WRITE_PROTECTABLE,  //33  UTP LOAD SHUTDOWN STOP
  ACCESS_MODE_WRITE_PROTECTABLE,  //34  LVP TIME
  ACCESS_MODE_WRITE_PROTECTABLE,  //35  DEFAULT BAL VOLTAGE
  ACCESS_MODE_WRITE_PROTECTABLE,  //36  REF TEMP
  ACCESS_MODE_WRITE_PROTECTABLE,  //37  OVP ALARM TEMPCO
  ACCESS_MODE_WRITE_PROTECTABLE,  //38  LVP ALARM TEMPCO
  ACCESS_MODE_WRITE_PROTECTABLE,  //39  OVP START TEMPCO
  ACCESS_MODE_WRITE_PROTECTABLE,  //40  OVP STOPP TEMPCO
  ACCESS_MODE_WRITE_PROTECTABLE,  //41  LVP START TEMPCO
  ACCESS_MODE_WRITE_PROTECTABLE,  //42  LVP START TEMPCO
  ACCESS_MODE_WRITE_PROTECTABLE,  //43  V SHUTDOWN START TEMPCO
  ACCESS_MODE_WRITE_PROTECTABLE,  //44  V SHUTDOWN STOP TEMPCO
  ACCESS_MODE_WRITE_PROTECTABLE,  //45  BALANCER VOLTAGE TEMPCO
  ACCESS_MODE_READ_WRITE,         //46  Balancer voltage remote
  ACCESS_MODE_READ_ONLY,          //47  WRITE LOCKED
  ACCESS_MODE_READ_ONLY,          //48  KEY ACCEPTED
  ACCESS_MODE_READ_WRITE,         //49  LOCK KEY
  ACCESS_MODE_WRITE_PROTECTABLE,  //50  NEW LOCK KEY

  //Alle anderen sind 0 , also automatisch auf read only
};




void SYSDATA_Init()
{
  sysData.s.deviceTypeId           = 103; //100: LiPro 1-x, 101: LiPro1-x active , 102 ist LiPro 1-x V2
  sysData.s.fwMajor     = 1;
  sysData.s.fwMinor     = 0;
  sysData.s.fwRevision  = 3;
  sysData.s.minVoltage = MIN_VOLTAGE_DEFAULT;
  sysData.s.maxVoltage = MAX_VOLTAGE_DEFAULT;
  sysData.s.minTemperature = MIN_TEMPERATURE_DEFAULT;
  sysData.s.maxTemperature = MAX_TEMPERATURE_DEFAULT;

}
