#include <cstdint>

#include "beeper_task.h"
#include "main.h"
#include "task.h"

static constexpr uint16_t delay_ms = 500U;

static constexpr GPIO_PinState BUZZER_ON = GPIO_PIN_SET;
static constexpr GPIO_PinState BUZZER_OFF = GPIO_PIN_RESET;

QueueHandle_t beeperQueue;
static beeper_msg_t bm;

void beeperTaskStart(void* argument)
{
	UNUSED(argument);

	while (1)
	{
		BaseType_t res = xQueueReceive(beeperQueue, &bm, portMAX_DELAY);
		if (res == pdPASS)
		{
			for (auto i = 0U; i < bm.beeper_repeat_cnt; i++)
			{
				HAL_GPIO_WritePin(BUZZER_GPIO_Port, BUZZER_Pin, BUZZER_ON);
				vTaskDelay(bm.beeper_on_time);
				HAL_GPIO_WritePin(BUZZER_GPIO_Port, BUZZER_Pin, BUZZER_OFF);
				vTaskDelay(bm.beeper_off_time);
			}
		}
	}
}