/*
 * bme280.c
 *
 * Created: 08.01.2024 09:51:51
 *  Author: ecs
 */

#include <string.h>

#include "bme280.h"

static BME280_S32_t t_fine;
static BME280_S64_t Var1, Var2;

//-----------------------------------------------------------------------------

/*uint8_t BME280_ReadDeviceID(TWI_Master_t* twi)
{
	// Output buffer must contain only one byte, the ID itself - 0xD0
	if (1 == twi->bytesRead) return twi->readData[0];
	return 0;
}

//-----------------------------------------------------------------------------

uint8_t BME280_ReadDeviceStatus(TWI_Master_t* twi)
{
	if (1 == twi->bytesRead) return twi->readData[0];
	return 0;
}

//-----------------------------------------------------------------------------

uint32_t BME280_ReadPress(TWI_Master_t* twi)
{
	if (8 == twi->bytesRead)
	{
		uint32_t press = (((uint32_t)twi->readData[0]) << 12) + (((uint32_t)twi->readData[1]) << 4) + (((uint32_t)twi->readData[2]) & 0xF);
		return press;
	}
	return 0;
}

//-----------------------------------------------------------------------------

uint32_t BME280_ReadTemp(TWI_Master_t* twi)
{
	if (8 == twi->bytesRead)
	{
		uint32_t temp = (((uint32_t)twi->readData[3]) << 12) + (((uint32_t)twi->readData[4]) << 4) + (((uint32_t)twi->readData[5]) & 0xF);
		return temp;
	}
	return 0;
}

//-----------------------------------------------------------------------------

uint16_t BME280_ReadHum(TWI_Master_t* twi)
{
	if (8 == twi->bytesRead)
	{
		uint16_t hum = (((uint16_t)twi->readData[6]) << 8) + ((uint16_t)twi->readData[7]);
		return hum;
	}
	return 0;
}

//-----------------------------------------------------------------------------

int BME280_Calib00_25(TWI_Master_t* twi, BME280_Calib_0_t* digs)
{
	if (sizeof(BME280_Calib_0_t) == twi->bytesRead)
	{
		memcpy(digs, (void*)twi->readData, sizeof(BME280_Calib_0_t));
		return 0;
	}
	return 1;
}

//-----------------------------------------------------------------------------

int BME280_Calib26_32(TWI_Master_t* twi, BME280_Calib_1_t* digs)
{
	if (sizeof(BME280_Calib_1_t) == twi->bytesRead)
	{
		digs->dig_H2 = (int16_t)((((uint16_t)twi->readData[1]) << 8) + (uint16_t)twi->readData[0]);
		digs->dig_H3 = twi->readData[2];
		digs->dig_H4 = (int16_t)((((uint16_t)twi->readData[3]) << 4) + (((uint16_t)twi->readData[4]) & 0xF));
		digs->dig_H5 = (int16_t)((((uint16_t)twi->readData[6]) << 4) + (((uint16_t)twi->readData[5]) >> 4));
		digs->dig_H6 = (int8_t)twi->readData[7];
		return 0;
	}
	return 1;
}

//-----------------------------------------------------------------------------

BME280_S32_t BME280_compensate_T(BME280_S32_t adc_T, BME280_Calib_0_t* digs)
{
	BME280_S32_t var1, var2, T;

	var1 = ((((adc_T / 8U) - ((BME280_S32_t)digs->dig_T1 << 1))) * ((BME280_S32_t)digs->dig_T2)) >> 11;
	var2 = (((((adc_T >> 4) - ((BME280_S32_t)digs->dig_T1)) * ((adc_T) - ((BME280_S32_t)digs->dig_T1))) >> 12) * ((BME280_S32_t)digs->dig_T3)) >> 14;
	t_fine = var1 + var2;
	T = (t_fine * 5 + 128) >> 8;

	return T;
}

//-----------------------------------------------------------------------------

void BME280_compensate_P_step1(BME280_Calib_0_t* digs)
{
	BME280_S64_t var1, var2;

	var1 = ((BME280_S64_t)t_fine) - 128000;
	var2 = var1 * var1 * (BME280_S64_t)digs->dig_P6;
	var2 = var2 + ((var1 * (BME280_S64_t)digs->dig_P5) << 17U);
	var2 = var2 + (((BME280_S64_t)digs->dig_P4) << 35U);
	var1 = ((var1 * var1 * (BME280_S64_t)digs->dig_P3) >> 8U) + ((var1 * (BME280_S64_t)digs->dig_P2) << 12U);
	var1 = (((((BME280_S64_t)1) << 47U) + var1)) * ((BME280_S64_t)digs->dig_P1) >> 33U;

	Var1 = var1;
	Var2 = var2;
}

//-----------------------------------------------------------------------------

BME280_U32_t BME280_compensate_P_step2(BME280_S32_t adc_P, BME280_Calib_0_t* digs)
{
	if (Var1 == 0U) return 0U;

	BME280_S64_t var1, var2, P;

	var1 = Var1;
	var2 = Var2;

	P = (BME280_S32_t)((BME280_U32_t)1 << 20U) - adc_P;
	P = (((P << 31U) - var2) * 3125) / var1;
	var1 = (((BME280_S64_t)digs->dig_P9) * (P >> 13U) * (P >> 13)) >> 25U;
	var2 = (((BME280_S64_t)digs->dig_P8) * P) >> 19U;
	P = ((P + var1 + var2) >> 8U) + (((BME280_S64_t)digs->dig_P7) << 4U);

	return (BME280_U32_t)P;
}

//-----------------------------------------------------------------------------

BME280_U32_t BME280_compensate_H(BME280_S32_t adc_H, BME280_Calib_0_t* dig0s, BME280_Calib_1_t* dig1s)
{
	BME280_S32_t v_x1_u32r;

	v_x1_u32r = (t_fine - ((BME280_S32_t)76800));
	v_x1_u32r = (((((adc_H << 14U) - (((BME280_S32_t)dig1s->dig_H4) << 20U) - (((BME280_S32_t)dig1s->dig_H5) * v_x1_u32r)) + ((BME280_S32_t)16384)) >> 15U) * (((((((v_x1_u32r * ((BME280_S32_t)dig1s->dig_H6)) >> 10U) * (((v_x1_u32r * ((BME280_S32_t)dig1s->dig_H3)) >> 11) + ((BME280_S32_t)32768))) >> 10) + ((BME280_S32_t)2097152)) * ((BME280_S32_t)dig1s->dig_H2) + 8192) >> 14U));

	//v_x1_u32r = (((((adc_H << 14U) - (dig_H4 << 20U) - (dig_H5 * v_x1_u32r)) + 16384) >> 15U) * (((((((v_x1_u32r * dig_H6) >> 10U) * (((v_x1_u32r * dig_H3) >> 11) + 32768)) >> 10) + 2097152) * dig_H2 + 8192) >> 14U));

	v_x1_u32r = (v_x1_u32r - (((((v_x1_u32r >> 15U) * (v_x1_u32r >> 15U)) >> 7U) * ((BME280_S32_t)dig0s->dig_H1)) >> 4U));
	v_x1_u32r = (v_x1_u32r < 0 ? 0: v_x1_u32r);
	v_x1_u32r = (v_x1_u32r > 419430400 ? 419430400: v_x1_u32r);

	return (BME280_U32_t)(v_x1_u32r >> 12U);
}
*/
//-----------------------------------------------------------------------------
