/*
 * bme280.h
 *
 * Created: 05.01.2024 11:06:53
 *  Author: ecs
 */


#ifndef BME280_H_
#define BME280_H_

#include <stdint.h>

#define BME280_CHIP_ID						0x60
#define BME680_CHIP_ID						0x61
#define BMP280_CHIP_ID						0x58

#define BME280_STATUS_MEAS_MSK				0x08
#define BME280_STATUS_MEAS_POS				3U
#define BME280_STATUS_IMUPD_MSK				0x01
#define BME280_STATUS_IMUPD_POS				0U

#define BME280_CTRL_HUM_MSK					0x07
#define BME280_CTRL_HUM_POS					0U
#define BME280_CTRL_HUM_OVSMP_OFF			0U
#define BME280_CTRL_HUM_OVSMP_X1			1U
#define BME280_CTRL_HUM_OVSMP_X2			2U
#define BME280_CTRL_HUM_OVSMP_X4			3U
#define BME280_CTRL_HUM_OVSMP_X8			4U
#define BME280_CTRL_HUM_OVSMP_X16			5U	// 5,6,7

#define BME280_CTRL_MEAS_OSRS_T_MSK			0x07
#define BME280_CTRL_MEAS_OSRS_T_POS			5U
#define BME280_CTRL_MEAS_OSRS_T_OVSMP_OFF	0U
#define BME280_CTRL_MEAS_OSRS_T_OVSMP_X1	1U
#define BME280_CTRL_MEAS_OSRS_T_OVSMP_X2	2U
#define BME280_CTRL_MEAS_OSRS_T_OVSMP_X4	3U
#define BME280_CTRL_MEAS_OSRS_T_OVSMP_X8	4U
#define BME280_CTRL_MEAS_OSRS_T_OVSMP_X16	5U	// 5,6,7

#define BME280_CTRL_MEAS_OSRS_P_MSK			0x07
#define BME280_CTRL_MEAS_OSRS_P_POS			2U
#define BME280_CTRL_MEAS_OSRS_P_OVSMP_OFF	0U
#define BME280_CTRL_MEAS_OSRS_P_OVSMP_X1	1U
#define BME280_CTRL_MEAS_OSRS_P_OVSMP_X2	2U
#define BME280_CTRL_MEAS_OSRS_P_OVSMP_X4	3U
#define BME280_CTRL_MEAS_OSRS_P_OVSMP_X8	4U
#define BME280_CTRL_MEAS_OSRS_P_OVSMP_X16	5U	// 5,6,7

#define BME280_CTRL_MEAS_MODE_MSK			0x03
#define BME280_CTRL_MEAS_MODE_POS			0U
#define BME280_CTRL_MEAS_MODE_SLEEP			0U
#define BME280_CTRL_MEAS_MODE_FORCED		1U	// or 2
#define BME280_CTRL_MEAS_MODE_NORMAL		3U

#define BME280_CONFIG_STANDBY_DUR_MSK		0x07
#define BME280_CONFIG_STANDBY_DUR_POS		5U
#define BME280_CONFIG_STANDBY_DUR_0_5_MS	0U
#define BME280_CONFIG_STANDBY_DUR_62_5_MS	1U
#define BME280_CONFIG_STANDBY_DUR_125_MS	2U
#define BME280_CONFIG_STANDBY_DUR_250_MS	3U
#define BME280_CONFIG_STANDBY_DUR_500_MS	4U
#define BME280_CONFIG_STANDBY_DUR_1000_MS	5U
#define BME280_CONFIG_STANDBY_DUR_10_MS		6U
#define BME280_CONFIG_STANDBY_DUR_20_MS		7U

#define BME280_CONFIG_IIR_MSK				0x07
#define BME280_CONFIG_IIR_POS				2U
#define BME280_CONFIG_IIR_FILTER_OFF		0U
#define BME280_CONFIG_IIR_FILTER_X2			1U
#define BME280_CONFIG_IIR_FILTER_X4			2U
#define BME280_CONFIG_IIR_FILTER_X8			3U
#define BME280_CONFIG_IIR_FILTER_X16		4U	// or 5,6,7

#define BME280_CONFIG_SPI_3_PIN_MSK			0x01
#define BME280_CONFIG_SPI_3_PIN_POS			0U
#define BME280_CONFIG_SPI_3_PIN_ENABLE		1U
#define BME280_CONFIG_SPI_3_PIN_DISABLE		0U

typedef int32_t BME280_S32_t;
typedef uint32_t BME280_U32_t;
typedef int64_t BME280_S64_t;
typedef uint16_t BME280_U16_t;

typedef enum BME280_REG_enum
{
	BME280_REG_calib00		= 0x88,
	BME280_REG_calib01		= 0x89,
	BME280_REG_calib02		= 0x8A,
	BME280_REG_calib03		= 0x8B,
	BME280_REG_calib04		= 0x8C,
	BME280_REG_calib05		= 0x8D,
	BME280_REG_calib06		= 0x8E,
	BME280_REG_calib07		= 0x8F,
	BME280_REG_calib08		= 0x90,
	BME280_REG_calib09		= 0x91,
	BME280_REG_calib10		= 0x92,
	BME280_REG_calib11		= 0x93,
	BME280_REG_calib12		= 0x94,
	BME280_REG_calib13		= 0x95,
	BME280_REG_calib14		= 0x96,
	BME280_REG_calib15		= 0x97,
	BME280_REG_calib16		= 0x98,
	BME280_REG_calib17		= 0x99,
	BME280_REG_calib18		= 0x9A,
	BME280_REG_calib19		= 0x9B,
	BME280_REG_calib20		= 0x9C,
	BME280_REG_calib21		= 0x9D,
	BME280_REG_calib22		= 0x9E,
	BME280_REG_calib23		= 0x9F,
	BME280_REG_calib24		= 0xA0,
	BME280_REG_calib25		= 0xA1,

	BME280_REG_id			= 0xD0,

	BME280_REG_reset		= 0xE0,

	BME280_REG_calib26		= 0xE1,
	BME280_REG_calib27		= 0xE2,
	BME280_REG_calib28		= 0xE3,
	BME280_REG_calib29		= 0xE4,
	BME280_REG_calib30		= 0xE5,
	BME280_REG_calib31		= 0xE6,
	BME280_REG_calib32		= 0xE7,
	BME280_REG_calib33		= 0xE8,
	BME280_REG_calib34		= 0xE9,
	BME280_REG_calib35		= 0xEA,
	BME280_REG_calib36		= 0xEB,
	BME280_REG_calib37		= 0xEC,
	BME280_REG_calib38		= 0xED,
	BME280_REG_calib39		= 0xEE,
	BME280_REG_calib40		= 0xEF,
	BME280_REG_calib41		= 0xF0,

	BME280_REG_ctrl_hum		= 0xF2,
	BME280_REG_status		= 0xF3,
	BME280_REG_ctrl_meas	= 0xF4,
	BME280_REG_config		= 0xF5,
	BME280_REG_press_msb	= 0xF7,
	BME280_REG_press_lsb	= 0xF8,
	BME280_REG_press_xlsb	= 0xF9,
	BME280_REG_temp_msb		= 0xFA,
	BME280_REG_temp_lsb		= 0xFB,
	BME280_REG_temp_xlsb	= 0xFC,
	BME280_REG_hum_msb		= 0xFD,
	BME280_REG_hume_lsb		= 0xFE,

} BME280_REG_t;

typedef struct BME280_Calib_0
{
	uint16_t	dig_T1;			// 0x88,0x89
	int16_t		dig_T2;			// 0x8A,0x8B
	int16_t		dig_T3;			// 0x8C,0x8D
	uint16_t	dig_P1;			// 0x8E,0x8F
	int16_t		dig_P2;			// 0x90,0x91
	int16_t		dig_P3;			// 0x92,0x93
	int16_t		dig_P4;			// 0x94,0x95
	int16_t		dig_P5;			// 0x96,0x97
	int16_t		dig_P6;			// 0x98,0x99
	int16_t		dig_P7;			// 0x9A,0x9B
	int16_t		dig_P8;			// 0x9C,0x9D
	int16_t		dig_P9;			// 0x9E,0x9F
	uint8_t		reserved_0;		// 0xA0
	uint8_t		dig_H1;			// 0xA1
}
BME280_Calib_0_t;

typedef struct BME280_Calib_1
{
	int16_t	dig_H2;
	uint8_t	dig_H3;
	int16_t	dig_H4;
	int8_t	dig_H5;
	int8_t	dig_H6;
}
BME280_Calib_1_t;

/*uint8_t			BME280_ReadDeviceID(TWI_Master_t* twi);
uint8_t			BME280_ReadDeviceStatus(TWI_Master_t* twi);
uint32_t		BME280_ReadPress(TWI_Master_t* twi);
uint32_t		BME280_ReadTemp(TWI_Master_t* twi);
uint16_t		BME280_ReadHum(TWI_Master_t* twi);
int				BME280_Calib00_25(TWI_Master_t* twi, BME280_Calib_0_t* digs);
int				BME280_Calib26_32(TWI_Master_t* twi, BME280_Calib_1_t* digs);
BME280_S32_t	BME280_compensate_T(BME280_S32_t adc_T, BME280_Calib_0_t* digs);
void			BME280_compensate_P_step1(BME280_Calib_0_t* digs);
BME280_U32_t	BME280_compensate_P_step2(BME280_S32_t adc_P, BME280_Calib_0_t* digs);
BME280_U32_t	BME280_compensate_H(BME280_S32_t adc_H, BME280_Calib_0_t* dig0s, BME280_Calib_1_t* dig1s);*/

#endif /* BME280_H_ */
