#include <cstdint>

#include "onewire_task.h"
#include "main.h"
#include "task.h"
#include "tim.h"

static constexpr uint16_t delay_ms = 5000U;


QueueHandle_t onewireQueue;
static onewire_msg_t owm;

inline void onewireDelay(uint16_t us);

void onewireTaskStart(void* argument)
{
	UNUSED(argument);

	onewireDelay(75);

	while (1)
	{
		/*BaseType_t res = xQueueReceive(beeperQueue, &bm, portMAX_DELAY);
		if (res == pdPASS)
		{
			for (auto i = 0U; i < bm.beeper_repeat_cnt; i++)
			{
				HAL_GPIO_WritePin(BUZZER_GPIO_Port, BUZZER_Pin, BUZZER_ON);
				vTaskDelay(bm.beeper_on_time);
				HAL_GPIO_WritePin(BUZZER_GPIO_Port, BUZZER_Pin, BUZZER_OFF);
				vTaskDelay(bm.beeper_off_time);
			}
		}*/
		vTaskDelay(delay_ms);
	}
}

//------------------------------------------------------------------------------

uint8_t DS18B20_Start(void)
{
	uint8_t Response = 0;
	Set_Pin_Output(ONE, DS18B20_PIN);   // set the pin as output
	HAL_GPIO_WritePin (DS18B20_PORT, DS18B20_PIN, 0);  // pull the pin low
	delay (480);   // delay according to datasheet

	Set_Pin_Input(DS18B20_PORT, DS18B20_PIN);    // set the pin as input
}

//------------------------------------------------------------------------------

inline void onewireDelay(uint16_t us)
{
    __HAL_TIM_SET_COUNTER(&htim6, 0);
	__HAL_TIM_ENABLE(&htim6);
    while (__HAL_TIM_GET_COUNTER(&htim6) < us);
	__HAL_TIM_DISABLE(&htim6);
}