#ifndef __SYS_DATA_H
#define __SYS_DATA_H

#include <cstdint>

#include "charge_controller.h"
#include "street_light.h"
#include "gps.h"

#define CONCAT(a, b) CONCAT_INNER(a, b)											// These three macros
#define CONCAT_INNER(a, b) a ## b												// generate unique variables
#define UNIQUE_NAME(base) CONCAT(base, __COUNTER__)								// according to template "baseX", like "base1", "base2" and etc.

//---------- Constants ---------------------------------------------------------

inline constexpr unsigned MAX_LIPRO_CELLS = 16U;								// FÜR SPEICHERUNG AUF SD KARTE, damit Anzahl der Felder immer gleich ist und Reservierung Speicher für Lipro Daten, Achtung eine Änderung verschiebt MODBUS Adressen!!!
inline constexpr unsigned MAX_LOG_MESSAGES = 10U;
inline constexpr unsigned MAX_TEMP_SENSOR_ID_SIZE = 8U;

//---------- Enums -------------------------------------------------------------

typedef enum soc_displaymode_enum
{
	SOC_DISPLAYMODE_VOLTAGE_BASED,			//0
	SOC_DISPLAYMODE_AH_COUNTER_BASED		//!

} soc_displaymode_t;

typedef enum ext_input_mode
{
	EXT_INPUT_MODE_DISABLED,
	EXT_INPUT_CELL_OVP,
	EXT_INPUT_CELL_UVP,
	EXT_INPUT_CURRENT_LIM,
	EXT_INPUT_MOTION_DETECTOR,
	EXT_INPUT_ALARM,
	EXT_INPUT_CURRENT_OUT_SENSOR_100A,
	EXT_INPUT_CURRENT_OUT_SENSOR_200A,
	EXT_INPUT_CURRENT_OUT_SENSOR_400A,
	EXT_INPUT_CURRENT_IN_SENSOR_100A,
	EXT_INPUT_CURRENT_IN_SENSOR_200A,
	EXT_INPUT_CURRENT_IN_SENSOR_400A,
	EXT_INPUT_ISOMETER_ALARM,
	EXT_INPUT_ISOMETER_SHUTOFF
} ext_input_mode_t;

typedef enum mb_error_codes_enum
{
	MB_ERROR_NOTHING = 0,			// 0
	MB_ERROR_TIMEOUT,				// 1
	MB_ERROR_CRC,					// 2
	MB_ERROR_SLAVE_ADRESS,			// 3
	MB_ERROR_FUNCTION_CODE,			// 4
	MB_ERROR_BYTE_COUNT,			// 5
	MB_ERROR_START_ADRESS,			// 6
} mb_error_codes_t;

typedef enum output_state_enum
{
	OUTPUT_USER_OFF,
	OUTPUT_USER_ON,
	OUTPUT_REMOTE_ON,
	OUTPUT_REMOTE_OFF,
	OUTPUT_SL_ON,
	OUTPUT_SL_OFF,
	OUTPUT_DEEP_DISCHARGE_PROTECTION,
	OUTPUT_CELL_DEEP_DISCHARGE_PROTECTION,
	OUTPUT_OVER_CURRENT_PROTECTION,
	OUTPUT_ISOMETER_SHUTOFF
} output_state_t;

//---------- Typedefs ----------------------------------------------------------

typedef union bword
{
	uint16_t	w;
	int16_t		sw;
	uint8_t		lb;
	int8_t		slb;
	uint8_t		b[2];
	int8_t		sb[2];
} bword_t;

typedef struct ext_output_config
{
	uint8_t	  ext_output_mode;			// 1
	int8_t	  inverted;					// 1
	int16_t	  v_high;					// 2
	int16_t	  v_low;					// 3
	uint16_t  hold_time;				// 4
} ext_output_config_t;
//8Byte, 4 Register

typedef struct ext_input_config
{
	ext_input_mode_t  ext_input_mode; 	// 1
	bool			  inverted;			// 1
	uint8_t			  i_lim_min;		// 2
	uint8_t			  reserved;			// 2
	uint16_t		  v_high;			// 3
	uint16_t		  v_low;			// 4
} ext_input_config_t;
  //12Bytes , 6Register

typedef struct
{
	uint8_t on_time;					// 1
	uint8_t off_time;					// 1
} ext_output_aux_config_t;
  //2Byte, 1 Register

typedef struct
{
	bword_t	  device_id;
	bword_t	  sn;
	bword_t	  cell_voltage;
	bword_t	  cell_temp;
	uint8_t	  pwm;
	uint8_t	  mode;
	bool	  lvp_protection;
	bool	  ovp_protection;
	bool	  temp_protection;
	bool	  dummy;
} lipro_data_t;
  // gesamt 14 Bytes --7Register


//! Struktur zur Aufnahme der RTC Zeit/Datum
//! signed damit atoi korrekt funktioniert
typedef struct
{
	int8_t year;
	int8_t month;
	int8_t day;
	int8_t hour;
	int8_t minute;
	int8_t second;
} time_t;

typedef struct
{
	time_t	  log_time;
	uint16_t  message;
} log_t;



typedef struct
{
	//STATISCHE GERÄTE INFORMATIONEN
	uint8_t					device_type[2];					//0
	uint8_t					fw_revision[2];					//1
	uint8_t					id[12];							//2-7
	uint8_t					UNIQUE_NAME(reserved)[2];		//8
	uint16_t				cell_absorption_exit_current;	//9

	//BASIS DATEN AUSGEWÄHLTE ZELLE GELADEN AUS TABELLE
	batt_type_t				cell_type;						//10l		LiFEPO4, LIFEYPO4, PB
	uint8_t					cell_current_limit;				//10h		in c/x
	uint8_t					cell_equalize_interval;			//11l		in Tagen
	uint8_t					cell_reserved0;					//11h
	uint16_t				cell_absorption_time;			//12
	uint16_t				cell_float_exit_time;			//13
	uint16_t				cell_equalize_time;				//14
	float					cell_absorption_voltage;		//15,16
	float					cell_absorption_exit_voltage;	//17,18
	float					cell_float_voltage;				//19,20
	float					cell_float_exit_voltage;		//21,22
	float					cell_equalize_voltage;			//23,24
	float					cell_cut_off_voltage;			//25,26
	float					cell_cut_off_recovery_voltage;	//27,28
	float					cell_temp_coefficient;			//29,30
	uint8_t					cell_peukert_exponent;			//31l
	uint8_t					cell_cef;						//31h
	uint8_t					cell_lvp_ccf;					//32l

	//BATT PARAMETER EINGESTELLT IM BATT BASIS MENÜ
	soc_displaymode_t		batt_soc_displaymode;			//32h
	uint8_t 				batt_cell_type_number;			//33l		ausgewählter Batterie Typ Nr
	uint8_t 				batt_cells;						//33h		Batterie Zellen
	uint16_t				batt_capacity; 					//34		in A/h
	uint8_t					batt_cut_off_delay;				//35l

	//Equalize
	bool					start_equalize;					//35h
	uint8_t					equalize_reserved1[2];			//36

	//MPP Parameter
	uint8_t					mpp_mode;						//37l
	uint8_t					mpp_voltage;					//37h

	//LOKALBUS PARAMETER
	uint8_t					lb_slave_adress;				//38l
	uint8_t					lb_mode;						//38h
	uint8_t					lb_baudrate_mode;				//39l
	uint8_t					lb_parity_mode;					//39h
	uint8_t					lb_stopbit_mode;				//40l
	int8_t					lb_number_of_gc;				//40h
	uint8_t					lb_bms_current;					//41l
	uint8_t					lb_data_forwarding;				//41h
	uint8_t					lb_reserved[2];					//42

	//STREETLIGHT PARAMETER
	bool					sl_midnight_detection;			//43l
	uint8_t					sl_led_power_full;				//43h
	uint8_t					sl_led_power_red;				//44l
	uint8_t					sl_volt_on;						//44h
	uint8_t					sl_volt_off;					//45l
	uint8_t					sl_time_red_start_hours;		//45h
	uint8_t					sl_time_red_stop_hours;			//46l
	uint8_t					sl_time_red_start_minutes;		//46h
	uint8_t					sl_time_red_stop_minutes;		//47l
	uint8_t					sl_dim_speed;					//47h
	uint16_t				sl_led_time_motion;				//48
	sl_mode_t				sl_mode;						//49l
	uint8_t					sl_reserved1[3];				//49h,50

	//GSM PARAMETER
#ifdef GREEN_CONTROLLER_140_30
	bool					gsm_module_enabled;				//51l RAM Variable GPS/GSM Modul enabled/disabled
	bool					gsm_reserved;					//51h
	uint16_t				gsm_heartbeat_intervall_time;	//52
	uint8_t					gsm_reserved1[14];				//53-59
	char 					apn_name[MAX_STRING_SIZE];		//60-84			RAM Variable APN NAME
	char 					apn_user[MAX_STRING_SIZE];		//85-109		RAM Variable APN Benutzer Name
	char 					apn_pw[MAX_STRING_SIZE];		//110-134		RAM Variable APN Passwort
	char 					server_name[MAX_STRING_SIZE];	//135-159		RAM Variable Server Name als DNS Name
	char 					server_port[MAX_STRING_SIZE];	//160-184		RAM Variable Server Port
#elif defined GREEN_CONTROLLER_75_40
	bool					res_gsm_module_enabled;				//51l RAM Variable GPS/GSM Modul enabled/disabled			//GSM/GPS Modul entfällt
	bool					res_gsm_reserved;					//51h														//GSM/GPS Modul entfällt
	uint16_t				res_gsm_heartbeat_intervall_time;	//52														//GSM/GPS Modul entfällt
	uint8_t					res_gsm_reserved1[14];				//53-59														//GSM/GPS Modul entfällt
	char 					res_apn_name[MAX_STRING_SIZE];		//60-84			RAM Variable APN NAME						//GSM/GPS Modul entfällt
	char 					res_apn_user[MAX_STRING_SIZE];		//85-109		RAM Variable APN Benutzer Name				//GSM/GPS Modul entfällt
	char 					res_apn_pw[MAX_STRING_SIZE];		//110-134		RAM Variable APN Passwort					//GSM/GPS Modul entfällt
	char 					res_server_name[MAX_STRING_SIZE];	//135-159		RAM Variable Server Name als DNS Name		//GSM/GPS Modul entfällt
	char 					res_server_port[MAX_STRING_SIZE];	//160-184		RAM Variable Server Port					//GSM/GPS Modul entfällt
#endif
	//INPUT UND OUTPUT CONFIG PARAMETER
	ext_output_config_t		ext_output_config[4];			//185+16
	ext_input_config_t		ext_input_config[4];			//201+16		Konfiguration der Eingänge
	ext_output_aux_config_t ext_output_aux_config[4];		//217+4
	uint16_t				reserved6[4];					//221+4

	//SMS Parameter
#ifdef GREEN_CONTROLLER_140_30
	uint8_t					sms_alarm_level;				//225l
	uint8_t					reserved2[3];					//225h, 226
	char					phone_number[MAX_PHONE_NUMBER_SIZE];	//227-244
#elif defined GREEN_CONTROLLER_75_40
	uint8_t					res_sms_alarm_level;				//225l														//GSM Modul nicht vorhanden
	uint8_t					res_reserved2[3];					//225h, 226													//GSM Modul nicht vorhanden
	char					res_phone_number[MAX_PHONE_NUMBER_SIZE];	//227-244											//GSM Modul nicht vorhanden
#endif
	// System
	uint16_t				cmd;							//245
	uint16_t				debug_mode;						//246

	//Parameter Reserve
	ext_output_config_t		main_output_config;				//247+4
	//Neu limit
	float                   cell_v_limit_high;		     	//251-252
	uint8_t					buzzerEnabled;					//253l
	mb_error_codes_t		error_bms_communication;		//253


	// ES FOLGEN SICH ZUR LAUFZEIT ÄNDERNDE VARIABLEN

	int16_t					last_cut_off_ah;				//254
	// GSM Data
#ifdef GREEN_CONTROLLER_140_30
	gsm_mode_t				current_gsm_mode;				//255l
	bool					tcp_connection_online;			//255h			Ist True wenn Verbindung zum Server steht, schaltet zurück wenn Verbindung (automatisch) beendet wurde
	bool					internet_online;				//256l
	uint8_t					gsm_tx_bytes;					//256h
	uint8_t					myIP[4];						//257,258
	time_t					gsm_time;						//259,260,261
	uint8_t					modbus_gsm_data[256];			//262+128
#elif defined GREEN_CONTROLLER_75_40
	uint8_t					res_reserved8;						//255l			//alt: GSM mode
	bool					res_tcp_connection_online;			//255h			Ist True wenn Verbindung zum Server steht, schaltet zurück wenn Verbindung (automatisch) beendet wurde
	bool					res_internet_online;				//256l
	uint8_t					res_gsm_tx_bytes;					//256h
	uint8_t					res_myIP[4];						//257,258
	time_t					res_gsm_time;						//259,260,261
	uint8_t					res_modbus_gsm_data[256];			//262+128
#endif
	// LIPRO DATEN
	lipro_data_t			lipro_data[MAX_LIPRO_CELLS];	//390+112 = 502 // ACHTUNG LIPRO START ADRESS DEFINE ANPASSEN BEI ÄNDERUNG!!!!!

	// BERECHNETE BATTERIE SYSTEM SETPOINTS
	uint16_t				batt_current_limit;				//502
	float					batt_absorption_voltage;		//503,504
	float					batt_absorption_exit_voltage;	//505,506
	float					batt_float_voltage;				//507,508
	float					batt_float_exit_voltage;		//509,510
	float					batt_equalize_voltage;			//511,512
	float					batt_cut_off_voltage;			//513,514
	float					batt_cut_off_recovery_voltage;	//515,516 ---> ADRESSEN KORRIGIEREN

	//SYSTEM STREETLIGHT
	sl_mode_t				sl_reserved2;					//517l
	uint8_t					sl_current_led_pwm;				//517h
	bool					sl_low_batt_mode;				//518l
	bool					sl_reserved12;					//518h

	// WICHTIGE PARAMTER die geloggt werden müssen
	bool					error_master;					//519l
	bool					error_hv_input;					//519h
	uint8_t					error_hv_batt;					//520l
	bool					error_temp_int;					//520h - Interne Spannung zu hoch
	bool					error_lvp_batt;					//521l
	bool					error_lvp_cell;					//521h
	bool					error_uvp_batt;					//522l - Batteriespannung zu gering oder sense Kabel nicht angeschlossen
	bool					error_ovp_cell;					//522h
	bool					error_temp_batt;				//523l
	bool					warn_i_lim_active;				//523h
	mb_error_codes_t		error_gc_communication;			//524l -
	uint8_t					errorcode_temp_sensor_batt;		//524h
	uint8_t					reset_status;					//525l
	bool					bms_system_warning;				//525h :Neu in V3.20 vorher reserved
	uint8_t					i_lim_ext;						//526l -berehneter Strombegrenzungswert bei Stuerung via external input
	uint8_t					error_sense;					//526h
	uint8_t					diversion_pwm_out;				//527l
	uint8_t					reserved1;						//527h
	uint8_t					reserved4;						//528l
	output_state_t			output_state;					//528h
	charger_mode_t			charger_state;					//529l
	uint8_t					external_alarm;					//529h
	uint16_t				mpp_pwm;						//530 - MPP Punkt als PWM Wert
	uint16_t				act_pwm;						//531 - Aktuelle PWM
	uint16_t				p_input;						//532
	uint16_t				p_ouput;						//533
	uint16_t				abs_equalize_hold_counter;		//534 - Zählt die Minuten in der Absorption Phase, wird auch im Equalize Modus verwendet
	uint16_t				float_exit_counter;				//535 - Zählt die Minuten die die Erhaltungsladespannung nicht erreicht werden kann
	int16_t					internal_temp;					//536
	int16_t					batt_temperature;				//537
	float					u_external_inputs[4];			//538,539,540,541,542,543,544,545
	float					u_batt;							//546,547
	float					u_input;						//548,549
	float					u_buck;							//550,551
	float					i_batt_in_internal_mw;			//552,553
	float					i_out_internal;					//554,555
	float					i_batt;							//556,557
#ifdef GREEN_CONTROLLER_140_30
	float					longitude;						//558,559
	float					latitude;						//560,561
	float					altitude;						//562,563
#elif defined GREEN_CONTROLLER_75_40
	float					res_longitude;					//558,559
	float					res_latitude;					//560,561
	float					res_altitude;					//562,563
#endif
	float					counter_batt_ah;				//564,565 - Ah Zähler
	uint32_t				counter_p_in;					//566,567 - !!!! KEIN INIT AB HIER !!!!
	uint32_t				counter_p_out;					//568,569
	uint32_t				counter_p_in_last_day;			//570,571
	uint32_t				counter_p_out_last_Day;			//572,573
	uint32_t				counter_p_in_total;				//574,575
	uint32_t				counter_p_out_total;			//576,577
	lokal_time_t 			lokal_time;						//578,579,580,581
	log_t					logs[MAX_LOG_MESSAGES];			// jeweils 4 Register, 8 Bytes Array zum Aufnehmen der Log Nachrichten --80 Byte von 582 bis 621
#ifdef GREEN_CONTROLLER_140_30
	char					gps_signal_state;				//622l Status der Signal intergrität ---- Ab hier neu in Neu in V2 -----
	char					gps_valid;						//622h
	uint8_t					gps_num_satelites;				//623l
	uint8_t					gps_last_packet_type;			//623h
#elif defined GREEN_CONTROLLER_75_40
	char					res_gps_signal_state;			//622l Status der Signal intergrität ---- Ab hier neu in Neu in V2 -----
	char					res_gps_valid;					//622h
	uint8_t					res_gps_num_satelites;			//623l
	uint8_t					res_gps_last_packet_type;		//623h
#endif
	uint8_t					external_output_states[4];		//624,625
	float					v_in_scale_faktor;				//626,627
	float					v_batt_scale_faktor_1;			//628,629
#ifdef GREEN_CONTROLLER_140_30
	float					v_batt_scale_faktor_2;			//630,631
#elif defined GREEN_CONTROLLER_75_40
	float					reserved7;						//630,631 v_batt_scale_faktor_2 entfällt
#endif
	float					i_in_scale_faktor;				//632,633
	float					i_out_scale_faktor;				//634,635
#ifdef GREEN_CONTROLLER_140_30
	uint8_t					gsm_rssi;						//636l
	uint8_t					gsm_ber;						//636h
#elif defined GREEN_CONTROLLER_75_40
	uint8_t					res_gsm_rssi;					//636l
	uint8_t					res_gsm_ber;					//636h
#endif
	float					i_batt_in_internal_fast;		//637,638
	int16_t					soc;							//639
	uint16_t				fw_sub_revision;				//640
	bool					error_isometer_alarm;    		//641l
	bool					error_isometer_shutoff;			//641h
	uint8_t					internal_temp_sensor_id[MAX_TEMP_SENSOR_ID_SIZE]; 		// 642 - 645
	uint16_t				error_internal_temp_sensor;		//646
	int16_t					sensors_found;					//647
	int16_t					batt_temp_sensor_number;		//648
	int16_t					internal_temp_sensor_number;	//649
	float					u_external_inputs_fast[4];		//650,651 652,653 654,655 656,657
	float					i_out_internal_fast;			//658,659
	float					i_batt_fast;					//660,661
	float					u_input_fast;					//662,663

	uint8_t					BMx_sensor_id;					// 664 - LO
	bool					BMx_DewPointAlarm;				// 664 - HI
	int16_t					BMx_Temperature;				// 665
	uint16_t				BMx_Pressure;					// 666
	uint16_t				BMx_Humidity;					// 667
	int16_t					BMx_DewPoint;					// 668
	uint8_t					BMx_step;						// 669 - LO
	uint8_t					BMx_reserved;					// 669 - HI

	uint8_t					remote_bus_baudrate;			// 670 - LO
	uint8_t					remote_bus_parity;				// 670 - HI
	uint8_t					remote_bus_stopbits;			// 671 - LO
	uint8_t					reserved8;						// 671 - HI

	//int16_t				ubatt_offset;					// 672			Debugging. Later can be deleted.
	//uint16_t				adc_offset;						// 673			Debugging. Later can be deleted.
	//uint16_t				current_out_offset;				// 674			Debugging. Later can be deleted.
	//uint16_t				mem_address;					// 675			Debugging. Later can be deleted.
	//uint16_t				mem_value;						// 676			Debugging. Later can be deleted.

	uint16_t				output_off_on_timeout_s;		// 672			Seconds

}sys_data_struct_t;


typedef union sys_data_union
{
		sys_data_struct_t	s;
		bword_t mb[sizeof(sys_data_struct_t) / 2];
} sys_data_t;

#ifdef __cplusplus
extern "C"
{
#endif

void sys_data_init(void);

#ifdef __cplusplus
} // extern "C"
#endif

#endif // __SYS_DATA_H
