/* USER CODE BEGIN Header */
/**
  ******************************************************************************
  * @file    app_netxduo.c
  * @author  MCD Application Team
  * @brief   NetXDuo applicative file
  ******************************************************************************
  * @attention
  *
  * Copyright (c) 2020-2021 STMicroelectronics.
  * All rights reserved.
  *
  * This software is licensed under terms that can be found in the LICENSE file
  * in the root directory of this software component.
  * If no LICENSE file comes with this software, it is provided AS-IS.
  *
  ******************************************************************************
  */

/* USER CODE END Header */

/* Includes ------------------------------------------------------------------*/
#include "app_netxduo.h"

/* Private includes ----------------------------------------------------------*/
/* USER CODE BEGIN Includes */

/* USER CODE END Includes */

/* Private typedef -----------------------------------------------------------*/
/* USER CODE BEGIN PTD */

/* USER CODE END PTD */

/* Private define ------------------------------------------------------------*/
/* USER CODE BEGIN PD */

#define IP_HELPER_THREAD_STACK_SIZE			  (512U)
#define NX_PACKET_POOL_SIZE					  (1024U)

/* USER CODE END PD */

/* Private macro -------------------------------------------------------------*/
/* USER CODE BEGIN PM */

/* USER CODE END PM */

/* Private variables ---------------------------------------------------------*/
/* USER CODE BEGIN PV */

NX_IP ip;
static CHAR ipName[] = "Eth";
static CHAR ip_helper_thread_stack[IP_HELPER_THREAD_STACK_SIZE]					__attribute__((section(".DTCM_RAM")));
static CHAR nx_packet_pool_memory[NX_PACKET_POOL_SIZE]							__attribute__((section(".DTCM_RAM"), aligned(4)));
static NX_PACKET_POOL pool;

/* USER CODE END PV */

/* Private function prototypes -----------------------------------------------*/
/* USER CODE BEGIN PFP */

VOID ip_network_driver(NX_IP_DRIVER *ipDrv);

/* USER CODE END PFP */

/**
  * @brief  Application NetXDuo Initialization.
  * @param memory_ptr: memory pointer
  * @retval int
  */
UINT MX_NetXDuo_Init(VOID *memory_ptr)
{
  UINT ret = NX_SUCCESS;

  TX_BYTE_POOL *byte_pool = (TX_BYTE_POOL*)memory_ptr;

  /* USER CODE BEGIN MX_NetXDuo_MEM_POOL */
  (void)byte_pool;
  /* USER CODE END MX_NetXDuo_MEM_POOL */

  /* USER CODE BEGIN 0 */

  nx_system_initialize();

  UINT r = nx_packet_pool_create(&pool, "NX packet pool", 512, nx_packet_pool_memory, NX_PACKET_POOL_SIZE);
  //printf("Result = %u\n", r);

  r = nx_ip_create(&ip, ipName, IP_ADDRESS(192, 168, 1, 177), 0xFFFFFFFF, &pool, ip_network_driver, ip_helper_thread_stack, IP_HELPER_THREAD_STACK_SIZE, 1);
  //printf("Result = %u\n", r);

  /* USER CODE END 0 */

  /* USER CODE BEGIN MX_NetXDuo_Init */

  /* USER CODE END MX_NetXDuo_Init */

  return ret;
}

/* USER CODE BEGIN 1 */

VOID ip_network_driver(NX_IP_DRIVER *ipDrv)
{
	printf("Network Driver is working!\n");
}

/* USER CODE END 1 */
