#include <cstdio>

#include "main.h"
#include "keys_thread.h"

static const char* const TAG = "KEYS";
static uint16_t delay_ms = 2000U;

//------------------------------------------------------------------------------

VOID scanKeysThread(ULONG initial_input)
{
	(void)initial_input;

	HAL_GPIO_WritePin(POWER_4V_EN_GPIO_Port, POWER_4V_EN_Pin, GPIO_PIN_SET);
	HAL_GPIO_WritePin(POWER_5V_EN_GPIO_Port, POWER_5V_EN_Pin, GPIO_PIN_SET);
	HAL_GPIO_WritePin(POWER_10V_EN_GPIO_Port, POWER_10V_EN_Pin, GPIO_PIN_SET);

	for (auto i = 0U; i < 5; i++)
	{
		HAL_GPIO_WritePin(BUZZER_GPIO_Port, BUZZER_Pin, GPIO_PIN_SET);
		tx_thread_sleep(10U);
		HAL_GPIO_WritePin(BUZZER_GPIO_Port, BUZZER_Pin, GPIO_PIN_RESET);
		tx_thread_sleep(100U);
	}

	while(1)
	{
		HAL_GPIO_TogglePin(RX1_LED_GPIO_Port, RX1_LED_Pin);
		//HAL_GPIO_WritePin(RX1_LED_GPIO_Port, RX1_LED_Pin, GPIO_PIN_RESET);
		//HAL_GPIO_WritePin(RX2_LED_GPIO_Port, RX2_LED_Pin, GPIO_PIN_RESET);

		tx_thread_sleep(delay_ms);

		//HAL_GPIO_WritePin(RX1_LED_GPIO_Port, RX1_LED_Pin, GPIO_PIN_SET);
		//HAL_GPIO_WritePin(RX2_LED_GPIO_Port, RX2_LED_Pin, GPIO_PIN_SET);

		// Calculating worse stack allocation
		TX_THREAD* current_thread = tx_thread_identify();
		printf("%s: Stack size: %lu, used: %u, free: %u\n", TAG, current_thread->tx_thread_stack_size,
			   (uint8_t*)current_thread->tx_thread_stack_ptr - (uint8_t*)current_thread->tx_thread_stack_start,
			   (uint8_t*)current_thread->tx_thread_stack_end - (uint8_t*)current_thread->tx_thread_stack_ptr);

		if (HAL_GPIO_ReadPin(SD_DETECT_GPIO_Port, SD_DETECT_Pin) == GPIO_PIN_RESET) printf("SD card present\n");
		else if (HAL_GPIO_ReadPin(SD_DETECT_GPIO_Port, SD_DETECT_Pin) == GPIO_PIN_SET) printf("SD card not present\n");
	}
}

//------------------------------------------------------------------------------
