#include <cstdint>
#include <cstdio>

#include "main.h"
#include "fan_task.h"
#include "task.h"
#include "tim.h"

static const char* const TAG = "FAN";
static constexpr uint16_t delay_ms = 5000U;

//------------------------------------------------------------------------------

void fanTaskStart(void* argument)
{
	UNUSED(argument);

	vTaskDelay(2000U);

	//HAL_GPIO_WritePin(PWM_DISPLAY_LIGHT_GPIO_Port, PWM_DISPLAY_LIGHT_Pin, GPIO_PIN_SET);
	//HAL_GPIO_WritePin(RST_DISPLAY_GPIO_Port, RST_DISPLAY_Pin, GPIO_PIN_SET);

	if (HAL_TIM_PWM_Start(&FAN_PWM_TIMER_HANDLE, FAN_PWM_TIMER_CHANNEL) != HAL_OK) Error_Handler();
	//if (HAL_TIMEx_PWMN_Start(&htim3, TIM_CHANNEL_2) != HAL_OK) Error_Handler();

	uint32_t min_pulse = __HAL_TIM_GET_COMPARE(&FAN_PWM_TIMER_HANDLE, FAN_PWM_TIMER_CHANNEL);
	constexpr decltype(min_pulse) max_pulse = 600U;
	constexpr uint32_t d = 20U;

	for (auto i = min_pulse; i <= max_pulse; i++)
	{
		//__HAL_TIM_SET_COMPARE(&FAN_PWM_TIMER_HANDLE, FAN_PWM_TIMER_CHANNEL, i);
		FAN_PWM_TIMER_HANDLE.Instance->CCR2 = i;
		vTaskDelay(pdMS_TO_TICKS(d));
	}

	while(1)
	{
		vTaskDelay(delay_ms);

		//printThreadStackInfo(TAG);
	}
}

//------------------------------------------------------------------------------
